/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.BackgroundSyncThread;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageBackgroundSyncThread;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageContainer;
import com.sendbird.syncmanager.MessageFilter;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.List;

class MessageSynchronizer {
    private static final String TAG = MessageSynchronizer.class.getSimpleName();
    private static final int MESSAGE_QUERY_INITIAL_RESULT_SIZE = 30;
    private MessageBackgroundSyncThread mNextThread;
    private MessageBackgroundSyncThread mPrevThread;
    private boolean mIsSyncedOnce = false;
    private BaseChannel mChannel;
    private MessageFilter mFilter;
    private long mViewpointTimestamp;
    private int mRetryCounter = 0;
    private MessageBackgroundSyncEventListener mPrevEventListener;
    private MessageBackgroundSyncEventListener mNextEventListener;
    private BackgroundSyncThread.SyncState mSyncState = BackgroundSyncThread.SyncState.INIT;

    MessageSynchronizer(BaseChannel channel, MessageFilter filter, long viewpointTimestamp) {
        this.mChannel = channel;
        this.mFilter = filter;
        this.mViewpointTimestamp = viewpointTimestamp;
    }

    BackgroundSyncThread.SyncState getSyncState(boolean isNext) {
        MessageBackgroundSyncThread thread;
        MessageBackgroundSyncThread messageBackgroundSyncThread = thread = isNext ? this.mNextThread : this.mPrevThread;
        if (thread == null) {
            return this.mSyncState;
        }
        return thread.getSyncState();
    }

    boolean isSyncFinished(boolean isNext) {
        if (isNext) {
            if (this.mNextThread == null) {
                return false;
            }
            return this.mNextThread.getSyncState() == BackgroundSyncThread.SyncState.FINISHED;
        }
        if (this.mPrevThread == null) {
            return false;
        }
        return this.mPrevThread.getSyncState() == BackgroundSyncThread.SyncState.FINISHED;
    }

    void start() {
        Logger.i(TAG, "start()");
        new Thread(new Runnable(){

            @Override
            public void run() {
                MessageChunk chunk = MessageManager.getInstance().getMessageChunkContainer().getChunkByTimestamp(MessageSynchronizer.this.mChannel.getUrl(), MessageSynchronizer.this.mFilter, MessageSynchronizer.this.mViewpointTimestamp, false);
                if (chunk == null) {
                    MessageSynchronizer.this.mRetryCounter = 0;
                    MessageSynchronizer.this.mChannel.getPreviousAndNextMessagesByTimestamp(MessageSynchronizer.this.mViewpointTimestamp, 30, 30, false, MessageSynchronizer.this.mFilter.getMessageTypeFilter(), MessageSynchronizer.this.mFilter.getCustomType(), MessageSynchronizer.this.mFilter.getSenderUserIds(), true, new BaseChannel.GetMessagesHandler(){

                        public void onResult(final List<BaseMessage> list, final SendBirdException e) {
                            Logger.d(TAG, "getPreviousAndNextMessagesByTimestamp. list size = " + (list == null ? "null" : Integer.valueOf(list.size())) + ", e = " + e);
                            final 1 retryHandler = this;
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    if (e != null) {
                                        if (MessageSynchronizer.this.mRetryCounter < 3) {
                                            MessageSynchronizer.this.mRetryCounter++;
                                            MessageSynchronizer.this.mChannel.getPreviousAndNextMessagesByTimestamp(MessageSynchronizer.this.mViewpointTimestamp, 30, 30, false, MessageSynchronizer.this.mFilter.getMessageTypeFilter(), MessageSynchronizer.this.mFilter.getCustomType(), MessageSynchronizer.this.mFilter.getSenderUserIds(), true, retryHandler);
                                        } else {
                                            MessageSynchronizer.this.mSyncState = BackgroundSyncThread.SyncState.PAUSED;
                                        }
                                        e.printStackTrace();
                                        return;
                                    }
                                    MessageSynchronizer.this.mIsSyncedOnce = true;
                                    if (list == null || list.size() == 0) {
                                        MessageSynchronizer.this.onSynced(true, null);
                                        MessageSynchronizer.this.onSynced(false, null);
                                        MessageSynchronizer.this.startPrev(null, false);
                                        MessageSynchronizer.this.startNext(null, false);
                                    } else {
                                        MessageManager.getInstance().getMessageContainer().upsertSucceededMessages(list, true, new MessageContainer.UpsertMessageHandler(){

                                            @Override
                                            public void onResult(List<BaseMessage> insertedMessages, List<BaseMessage> updatedMessages, SendBirdException e) {
                                                Logger.d(TAG, "upsertSucceededMessages. insertedMessage list size = " + insertedMessages.size() + " updatedMessage list size = " + updatedMessages.size() + ", e = " + e);
                                                long startAt = ((BaseMessage)list.get(0)).getCreatedAt();
                                                long endAt = ((BaseMessage)list.get(list.size() - 1)).getCreatedAt();
                                                final MessageChunk newChunk = new MessageChunk(MessageSynchronizer.this.mChannel.getUrl(), startAt, endAt, MessageSynchronizer.this.mFilter);
                                                MessageManager.getInstance().getMessageChunkContainer().mergeIntersectedChunks(newChunk, new CompletionHandler(){

                                                    @Override
                                                    public void onCompleted(SendBirdException e) {
                                                        Logger.d(TAG, "mergeIntersectedChunks. e = " + e);
                                                        MessageSynchronizer.this.onSynced(true, e);
                                                        MessageSynchronizer.this.onSynced(false, e);
                                                        boolean isApiCallRequired = list.size() >= 15;
                                                        MessageSynchronizer.this.startPrev(newChunk, isApiCallRequired);
                                                        MessageSynchronizer.this.startNext(newChunk, isApiCallRequired);
                                                    }
                                                });
                                            }
                                        });
                                    }
                                }
                            }).start();
                        }
                    });
                } else {
                    MessageSynchronizer.this.mIsSyncedOnce = true;
                    MessageSynchronizer.this.startPrev(chunk, true);
                    MessageSynchronizer.this.startNext(chunk, true);
                }
            }
        }).start();
    }

    void stop() {
        if (this.mNextThread != null) {
            this.mNextThread.stopSync();
            this.mNextThread = null;
        }
        if (this.mPrevThread != null) {
            this.mPrevThread.stopSync();
            this.mPrevThread = null;
        }
        this.mNextEventListener = null;
        this.mPrevEventListener = null;
        this.mSyncState = BackgroundSyncThread.SyncState.PAUSED;
    }

    private void startNext(MessageChunk chunk, boolean isApiCallRequired) {
        if (this.mNextThread == null) {
            this.mNextThread = new MessageBackgroundSyncThread(this.mChannel, chunk, true, isApiCallRequired);
            this.mNextThread.setEventListener(new MessageBackgroundSyncEventListener(){

                @Override
                public void onSynced(SendBirdException e) {
                    MessageSynchronizer.this.onSynced(true, e);
                }
            });
            this.mNextThread.start();
        }
    }

    private void startPrev(MessageChunk chunk, boolean isApiCallRequired) {
        if (this.mPrevThread == null) {
            this.mPrevThread = new MessageBackgroundSyncThread(this.mChannel, chunk, false, isApiCallRequired);
            this.mPrevThread.setEventListener(new MessageBackgroundSyncEventListener(){

                @Override
                public void onSynced(SendBirdException e) {
                    MessageSynchronizer.this.onSynced(false, e);
                }
            });
            this.mPrevThread.start();
        }
    }

    void subscribe(boolean isNext, MessageBackgroundSyncEventListener listener) {
        if (isNext) {
            this.mNextEventListener = listener;
        } else {
            this.mPrevEventListener = listener;
        }
    }

    boolean isSyncedOnce() {
        return this.mIsSyncedOnce;
    }

    private void onSynced(boolean isNext, SendBirdException e) {
        if (isNext) {
            if (this.mNextEventListener != null) {
                this.mNextEventListener.onSynced(e);
                this.mNextEventListener = null;
            }
        } else if (this.mPrevEventListener != null) {
            this.mPrevEventListener.onSynced(e);
            this.mPrevEventListener = null;
        }
    }

    static interface MessageBackgroundSyncEventListener {
        public void onSynced(SendBirdException var1);
    }
}

