/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelListQuery;
import com.sendbird.android.Member;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.ChannelChangeLogSync;
import com.sendbird.syncmanager.ChannelContainer;
import com.sendbird.syncmanager.ChannelEventAction;
import com.sendbird.syncmanager.ChannelManager;
import com.sendbird.syncmanager.ChannelSynchronizer;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.SendBirdSyncManager;
import com.sendbird.syncmanager.SyncManagerError;
import com.sendbird.syncmanager.SyncManagerUtils;
import com.sendbird.syncmanager.handler.ChannelCollectionHandler;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ChannelCollection {
    private static final String TAG = ChannelCollection.class.getSimpleName();
    private GroupChannelListQuery mQuery;
    private ChannelCollectionHandler mCollectionHandler;
    private List<GroupChannel> mChannels = new ArrayList<GroupChannel>();
    private Map<String, String> mOffsetMap = new ConcurrentHashMap<String, String>();
    private String mOffset = "";
    private ExecutorService mExecutorService;
    private boolean mIsLoading = false;
    private boolean mIsCollectionRemoved = false;
    private Comparator<GroupChannel> mChannelComparator = new Comparator<GroupChannel>(){

        @Override
        public int compare(GroupChannel c1, GroupChannel c2) {
            return ChannelCollection.this.compareTo(c1, c2, ChannelCollection.this.mQuery.getOrder());
        }
    };
    private ChannelChangeLogSync.ChannelChangeLogSubscriber mSubscriber = new ChannelChangeLogSync.ChannelChangeLogSubscriber(){

        @Override
        public void onSynced(List<GroupChannel> updatedChannels, List<String> deletedChannelUrls) {
            ChannelCollection.this.upsertChannels(updatedChannels);
            ChannelCollection.this.removeChannelUrls(deletedChannelUrls);
        }
    };
    private String name = "";

    public ChannelCollection(GroupChannelListQuery query) {
        this.mQuery = query;
        this.mExecutorService = Executors.newSingleThreadExecutor();
        ChannelManager.getInstance().addChannelCollection(this);
        ChannelSynchronizer.getInstance().startSync(this.mQuery);
        ChannelChangeLogSync.getInstance().subscribe(this.mSubscriber);
        ChannelChangeLogSync.getInstance().start(false);
    }

    public void setCollectionHandler(ChannelCollectionHandler handler) {
        this.mCollectionHandler = handler;
    }

    public GroupChannelListQuery getQuery() {
        return this.mQuery;
    }

    public void remove() {
        Logger.d(TAG, "remove()");
        this.mIsCollectionRemoved = true;
        ChannelManager.getInstance().removeChannelCollection(this);
        ChannelChangeLogSync.getInstance().unsubscribe(this.mSubscriber);
        this.mExecutorService.shutdownNow();
        ChannelSynchronizer.getInstance().stopSync(this.mQuery);
    }

    public synchronized void fetch(final CompletionHandler handler) {
        Logger.d(TAG, "fetch()");
        if (this.mIsLoading) {
            Logger.d(TAG, "Loading is already in progress. Finish fetch");
            SendBirdSyncManager.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onCompleted(SyncManagerError.getException(810200));
                    }
                }
            });
            return;
        }
        this.mIsLoading = true;
        this.fetch(this.mQuery.getLimit(), handler);
    }

    void pauseSync() {
    }

    void resumeSync() {
    }

    void upsertChannel(final GroupChannel channel) {
        Logger.d(TAG, "upsertChannel.");
        if (channel == null) {
            return;
        }
        ChannelManager.getInstance().getContainer().getGroupChannelListQuery(this.mQuery.getCustomTypesFilter(), this.mQuery.isIncludeEmpty(), this.mQuery.getOrder(), new ChannelContainer.GetGroupChannelListQueryHandler(){

            @Override
            public void onResult(final GroupChannelListQuery query, final String savePoint, SendBirdException e) {
                ChannelCollection.this.runOnSingleThreadPool(new Runnable(){

                    @Override
                    public void run() {
                        List filteredChannels = ChannelCollection.this.filterChannels(Collections.singletonList(channel));
                        if (filteredChannels.size() == 0) {
                            return;
                        }
                        if (query != null && !query.hasNext() && (savePoint == null || savePoint.isEmpty()) && ChannelCollection.this.mChannels.size() == 0) {
                            ChannelCollection.this.mChannels.add(channel);
                            String offset = SyncManagerUtils.getOffset(channel, ChannelCollection.this.mQuery);
                            ChannelCollection.this.mOffset = offset;
                            ChannelCollection.this.mOffsetMap.put(channel.getUrl(), offset);
                            ChannelCollection.this.onChannelEvent(filteredChannels, ChannelEventAction.INSERT);
                        } else {
                            ChannelCollection.this.diffWithCurrentChannels(filteredChannels);
                        }
                    }
                });
            }
        });
    }

    void upsertChannels(final List<GroupChannel> channels) {
        if (channels == null || channels.size() == 0) {
            return;
        }
        Logger.d(TAG, "upsertChannels. size = " + channels.size());
        ChannelManager.getInstance().getContainer().getGroupChannelListQuery(this.mQuery.getCustomTypesFilter(), this.mQuery.isIncludeEmpty(), this.mQuery.getOrder(), new ChannelContainer.GetGroupChannelListQueryHandler(){

            @Override
            public void onResult(GroupChannelListQuery query, String savePoint, SendBirdException e) {
                ChannelCollection.this.runOnSingleThreadPool(new Runnable(){

                    @Override
                    public void run() {
                        List filteredChannels = ChannelCollection.this.filterChannels(channels);
                        if (filteredChannels.size() == 0) {
                            return;
                        }
                        ChannelCollection.this.diffWithCurrentChannels(filteredChannels);
                    }
                });
            }
        });
    }

    void removeChannelUrls(final List<String> channelUrls) {
        Logger.d(TAG, "removeChannelUrls. size = " + channelUrls.size());
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                ArrayList<GroupChannel> removedChannels = new ArrayList<GroupChannel>();
                Iterator it = ChannelCollection.this.mChannels.iterator();
                block0: while (it.hasNext()) {
                    GroupChannel channel = (GroupChannel)it.next();
                    for (String channelUrl : channelUrls) {
                        if (!channel.getUrl().equals(channelUrl)) continue;
                        removedChannels.add(channel);
                        it.remove();
                        continue block0;
                    }
                }
                ChannelCollection.this.onChannelEvent(removedChannels, ChannelEventAction.REMOVE);
            }
        });
    }

    private void fetch(final int limit, final CompletionHandler handler) {
        Logger.d(TAG, this.getName() + " fetch() limit = " + limit);
        ChannelManager.getInstance().getContainer().getGroupChannelListQuery(this.mQuery.getCustomTypesFilter(), this.mQuery.isIncludeEmpty(), this.mQuery.getOrder(), new ChannelContainer.GetGroupChannelListQueryHandler(){

            @Override
            public void onResult(final GroupChannelListQuery query, final String savePoint, SendBirdException e) {
                ChannelCollection.this.runOnSingleThreadPool(new Runnable(){

                    @Override
                    public void run() {
                        long startTs = System.currentTimeMillis();
                        List channels = ChannelCollection.this.filterChannels(ChannelManager.getInstance().getContainer().getChannels());
                        Collections.sort(channels, ChannelCollection.this.mChannelComparator);
                        ArrayList<GroupChannel> fetchedChannels = new ArrayList<GroupChannel>();
                        GroupChannel lastChannel = ChannelCollection.this.mChannels.size() == 0 ? null : (GroupChannel)ChannelCollection.this.mChannels.get(ChannelCollection.this.mChannels.size() - 1);
                        boolean isLastChannelFound = lastChannel == null;
                        for (GroupChannel channel : channels) {
                            if (!isLastChannelFound) {
                                if (!channel.getUrl().equals(lastChannel.getUrl())) continue;
                                isLastChannelFound = true;
                                continue;
                            }
                            if (query != null && query.hasNext() && ChannelCollection.this.isOutOfSavePoint(channel, savePoint)) continue;
                            fetchedChannels.add(channel);
                            if (fetchedChannels.size() < ChannelCollection.this.mQuery.getLimit()) continue;
                            break;
                        }
                        for (GroupChannel groupChannel : fetchedChannels) {
                            String offset = SyncManagerUtils.getOffset(groupChannel, ChannelCollection.this.mQuery);
                            ChannelCollection.this.mOffsetMap.put(groupChannel.getUrl(), offset);
                        }
                        ChannelCollection.this.mChannels.addAll(fetchedChannels);
                        if (ChannelCollection.this.mChannels.size() > 0) {
                            ChannelCollection.this.mOffset = SyncManagerUtils.getOffset((GroupChannel)ChannelCollection.this.mChannels.get(ChannelCollection.this.mChannels.size() - 1), ChannelCollection.this.mQuery);
                        }
                        ChannelCollection.this.onChannelEvent(fetchedChannels, ChannelEventAction.INSERT);
                        if (fetchedChannels.size() < limit) {
                            int insufficientChannelCount = limit - fetchedChannels.size();
                            ChannelSynchronizer.getInstance().subscribe(ChannelCollection.this, new ChannelSynchronizerEventListenerImpl(insufficientChannelCount));
                        }
                        ChannelCollection.this.mIsLoading = false;
                        if (handler != null) {
                            handler.onCompleted(null);
                        }
                    }
                });
            }
        });
    }

    private void diffWithCurrentChannels(List<GroupChannel> channels) {
        ArrayList<GroupChannel> insertedChannels = new ArrayList<GroupChannel>();
        ArrayList<GroupChannel> updatedChannels = new ArrayList<GroupChannel>();
        ArrayList<GroupChannel> removedChannels = new ArrayList<GroupChannel>();
        ArrayList<GroupChannel> movedChannels = new ArrayList<GroupChannel>();
        this.updateChannels(channels);
        for (GroupChannel channel : channels) {
            String offset = SyncManagerUtils.getOffset(channel, this.mQuery);
            if (this.mOffsetMap.containsKey(channel.getUrl())) {
                if (this.isOutOfOffset(channel)) {
                    removedChannels.add(channel);
                    this.mOffsetMap.remove(channel.getUrl());
                    this.removeFetchedChannel(channel);
                    continue;
                }
                if (offset.equals(this.mOffsetMap.get(channel.getUrl()))) {
                    updatedChannels.add(channel);
                    continue;
                }
                movedChannels.add(channel);
                this.mOffsetMap.put(channel.getUrl(), offset);
                continue;
            }
            if (this.isOutOfOffset(channel)) continue;
            insertedChannels.add(channel);
            this.mOffsetMap.put(channel.getUrl(), offset);
            this.mChannels.add(channel);
        }
        Collections.sort(this.mChannels, this.mChannelComparator);
        this.onChannelEvent(insertedChannels, ChannelEventAction.INSERT);
        this.onChannelEvent(removedChannels, ChannelEventAction.REMOVE);
        this.onChannelEvent(movedChannels, ChannelEventAction.MOVE);
        this.onChannelEvent(updatedChannels, ChannelEventAction.UPDATE);
    }

    private void updateChannels(List<GroupChannel> newChannels) {
        if (newChannels == null) {
            return;
        }
        block0: for (GroupChannel newChannel : newChannels) {
            if (newChannel == null) continue;
            for (int index = 0; index < this.mChannels.size(); ++index) {
                GroupChannel oldChannel = this.mChannels.get(index);
                if (oldChannel == null || !newChannel.getUrl().equals(oldChannel.getUrl())) continue;
                this.mChannels.set(index, newChannel);
                continue block0;
            }
        }
    }

    protected GroupChannel getChannel(String channelUrl) {
        GroupChannel groupChannel = null;
        if (channelUrl != null && this.mChannels != null) {
            for (GroupChannel channel : this.mChannels) {
                if (channel == null || !channel.getUrl().equals(channelUrl)) continue;
                groupChannel = channel;
                break;
            }
        }
        return groupChannel;
    }

    private void runOnSingleThreadPool(Runnable runnable) {
        if (!this.mExecutorService.isShutdown() && !this.mIsCollectionRemoved) {
            this.mExecutorService.execute(runnable);
        }
    }

    private boolean isOutOfSavePoint(GroupChannel channel, String savePoint) {
        if (savePoint == null || savePoint.isEmpty()) {
            return false;
        }
        return this.compareTo(channel, savePoint, this.mQuery.getOrder()) > 0;
    }

    private boolean isOutOfOffset(GroupChannel channel) {
        if (this.mOffset == null || this.mOffset.isEmpty()) {
            return true;
        }
        return this.compareTo(channel, this.mOffset, this.mQuery.getOrder()) > 0;
    }

    private void removeFetchedChannel(GroupChannel channel) {
        for (int i = 0; i < this.mChannels.size(); ++i) {
            if (!channel.getUrl().equals(this.mChannels.get(i).getUrl())) continue;
            this.mChannels.remove(i);
            return;
        }
    }

    private int findIndexOfChannel(GroupChannel channel) {
        if (this.mChannels.size() == 0) {
            return 0;
        }
        int index = this.mChannels.size();
        for (int i = 0; i < this.mChannels.size(); ++i) {
            GroupChannel c = this.mChannels.get(i);
            if (c.getUrl().equals(channel.getUrl())) {
                return i;
            }
            if (this.compareTo(channel, c, this.mQuery.getOrder()) >= 0) continue;
            return i;
        }
        return index;
    }

    private int getIndexOfChannel(GroupChannel channel) {
        if (this.mChannels == null || this.mChannels.size() == 0) {
            return -1;
        }
        for (int i = 0; i < this.mChannels.size(); ++i) {
            if (!this.mChannels.get(i).getUrl().equals(channel.getUrl())) continue;
            return i;
        }
        return -1;
    }

    private int compareTo(GroupChannel c1, GroupChannel c2, GroupChannelListQuery.Order order) {
        switch (order) {
            case CHRONOLOGICAL: {
                if (c1.getCreatedAt() > c2.getCreatedAt()) {
                    return -1;
                }
                if (c1.getCreatedAt() < c2.getCreatedAt()) {
                    return 1;
                }
                return 0;
            }
            case LATEST_LAST_MESSAGE: {
                long createdAt2;
                BaseMessage m1 = c1.getLastMessage();
                BaseMessage m2 = c2.getLastMessage();
                long createdAt1 = m1 != null ? m1.getCreatedAt() : c1.getCreatedAt();
                long l = createdAt2 = m2 != null ? m2.getCreatedAt() : c2.getCreatedAt();
                if (createdAt1 > createdAt2) {
                    return -1;
                }
                if (createdAt1 < createdAt2) {
                    return 1;
                }
                return 0;
            }
            case CHANNEL_NAME_ALPHABETICAL: {
                return c1.getName().compareTo(c2.getName());
            }
        }
        return 0;
    }

    private int compareTo(GroupChannel channel, String savePoint, GroupChannelListQuery.Order order) {
        switch (order) {
            case CHRONOLOGICAL: {
                long createdAt = Long.valueOf(savePoint);
                if (channel.getCreatedAt() > createdAt) {
                    return -1;
                }
                if (channel.getCreatedAt() < createdAt) {
                    return 1;
                }
                return 0;
            }
            case LATEST_LAST_MESSAGE: {
                long createdAt1 = channel.getLastMessage() == null ? channel.getCreatedAt() : channel.getLastMessage().getCreatedAt();
                long createdAt2 = Long.valueOf(savePoint);
                if (createdAt1 > createdAt2) {
                    return -1;
                }
                if (createdAt1 < createdAt2) {
                    return 1;
                }
                return 0;
            }
            case CHANNEL_NAME_ALPHABETICAL: {
                return channel.getName().compareTo(savePoint);
            }
        }
        return 0;
    }

    private void onChannelEvent(final List<GroupChannel> list, final ChannelEventAction action) {
        if (list == null || list.size() == 0) {
            return;
        }
        Logger.d(TAG, "onChannelEvent. list size = " + list.size() + ", action = " + (Object)((Object)action));
        SendBirdSyncManager.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (ChannelCollection.this.mCollectionHandler != null) {
                    ChannelCollection.this.mCollectionHandler.onChannelEvent(ChannelCollection.this, list, action);
                }
            }
        });
    }

    private List<GroupChannel> filterChannels(List<GroupChannel> channels) {
        ArrayList<GroupChannel> filteredChannels = new ArrayList<GroupChannel>();
        for (GroupChannel groupChannel : channels) {
            String nicknameContainsFilter;
            List userIdsIncludeFilter;
            List userIdsExactFilters;
            String customTypeStartsWith;
            if (!this.mQuery.isIncludeEmpty() && groupChannel.getLastMessage() == null || this.mQuery.getSuperChannelFilter() == GroupChannelListQuery.SuperChannelFilter.SUPER_CHANNEL_ONLY && !groupChannel.isSuper() || this.mQuery.getSuperChannelFilter() == GroupChannelListQuery.SuperChannelFilter.NONSUPER_CHANNEL_ONLY && groupChannel.isSuper() || this.mQuery.getPublicChannelFilter() == GroupChannelListQuery.PublicChannelFilter.PUBLIC && !groupChannel.isPublic() || this.mQuery.getPublicChannelFilter() == GroupChannelListQuery.PublicChannelFilter.PRIVATE && groupChannel.isPublic()) continue;
            List channelUrlsFilter = this.mQuery.getChannelUrlsFilter();
            if (channelUrlsFilter != null) {
                boolean isExists = false;
                for (String url : channelUrlsFilter) {
                    if (!groupChannel.getUrl().contains(url)) continue;
                    isExists = true;
                    break;
                }
                if (!isExists) continue;
            }
            if ((customTypeStartsWith = this.mQuery.getCustomTypeStartsWithFilter()) != null && !groupChannel.getCustomType().startsWith(customTypeStartsWith)) continue;
            List customTypes = this.mQuery.getCustomTypesFilter();
            if (customTypes != null) {
                boolean isExists = false;
                for (Object customType : customTypes) {
                    if (!groupChannel.getCustomType().equals(customType)) continue;
                    isExists = true;
                    break;
                }
                if (!isExists) continue;
            }
            if ((userIdsExactFilters = this.mQuery.getUserIdsExactFilter()) != null) {
                Object customType;
                if (groupChannel.getMembers().size() != userIdsExactFilters.size()) continue;
                boolean isMembersExactlyIn = true;
                customType = groupChannel.getMembers().iterator();
                while (customType.hasNext()) {
                    Member member = (Member)customType.next();
                    boolean isExists = false;
                    for (String userId : userIdsExactFilters) {
                        if (!userId.equals(member.getUserId())) continue;
                        isExists = true;
                        break;
                    }
                    if (isExists) continue;
                    isMembersExactlyIn = false;
                    break;
                }
                if (!isMembersExactlyIn) continue;
            }
            if ((userIdsIncludeFilter = this.mQuery.getUserIdsIncludeFilter()) != null) {
                int isMembersInclude = 0;
                block5: for (String userIdFilter : userIdsIncludeFilter) {
                    for (Member member : groupChannel.getMembers()) {
                        if (!member.getUserId().equals(userIdFilter)) continue;
                        ++isMembersInclude;
                        continue block5;
                    }
                }
                if (this.mQuery.getUserIdsIncludeFilterQueryType() == GroupChannelListQuery.QueryType.AND && isMembersInclude < userIdsIncludeFilter.size() || this.mQuery.getUserIdsIncludeFilterQueryType() == GroupChannelListQuery.QueryType.OR && isMembersInclude == 0) continue;
            }
            if ((nicknameContainsFilter = this.mQuery.getNicknameContainsFilter()) != null) {
                boolean isExists = false;
                for (Member member : groupChannel.getMembers()) {
                    if (!member.getNickname().contains(nicknameContainsFilter)) continue;
                    isExists = true;
                    break;
                }
                if (!isExists) continue;
            }
            if (this.mQuery.getChannelNameContainsFilter() != null && !groupChannel.getName().contains(this.mQuery.getChannelNameContainsFilter()) || this.mQuery.getMemberStateFilter() != GroupChannelListQuery.MemberStateFilter.ALL && (this.mQuery.getMemberStateFilter() == GroupChannelListQuery.MemberStateFilter.JOINED ? !groupChannel.getMyMemberState().equals((Object)Member.MemberState.JOINED) : groupChannel.getMyMemberState() != Member.MemberState.INVITED)) continue;
            filteredChannels.add(groupChannel);
        }
        return filteredChannels;
    }

    String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    private class ChannelSynchronizerEventListenerImpl
    implements ChannelSynchronizer.ChannelSynchronizerEventListener {
        private int mInsufficientChannelCount;

        ChannelSynchronizerEventListenerImpl(int insufficientChannelCount) {
            this.mInsufficientChannelCount = insufficientChannelCount;
        }

        @Override
        public void onSynced(SendBirdException e) {
            Logger.d(TAG, ChannelCollection.this.getName() + " onSynced. insufficientChannelCount = " + this.mInsufficientChannelCount);
            ChannelCollection.this.fetch(this.mInsufficientChannelCount, null);
        }
    }
}

