/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.support.annotation.NonNull;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.BackgroundSyncThread;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageContainer;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.MessageSynchronizer;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.List;
import java.util.concurrent.CountDownLatch;

class MessageBackgroundSyncThread
extends BackgroundSyncThread {
    private static final String TAG = MessageBackgroundSyncThread.class.getSimpleName();
    private static final int MESSAGE_QUERY_RESULT_SIZE = 100;
    private BaseChannel mChannel;
    private MessageChunk mChunk;
    private boolean mIsNext;
    private MessageSynchronizer.MessageBackgroundSyncEventListener mEventListener;
    private int mRetryCounter = 0;
    private boolean mIsApiCallRequired;

    MessageBackgroundSyncThread(@NonNull BaseChannel channel, MessageChunk chunk, boolean isNext, boolean isApiCallRequired) {
        this.mChannel = channel;
        this.mChunk = chunk;
        this.mIsNext = isNext;
        this.mIsApiCallRequired = isApiCallRequired;
    }

    void setEventListener(MessageSynchronizer.MessageBackgroundSyncEventListener listener) {
        this.mEventListener = listener;
    }

    void stopSync() {
        this.mEventListener = null;
        this.mSyncState = BackgroundSyncThread.SyncState.PAUSED;
    }

    @Override
    public void run() {
        Logger.d(TAG, "run(). channelUrl = " + this.mChannel.getUrl() + ", isNext = " + this.mIsNext);
        this.mSyncState = BackgroundSyncThread.SyncState.RUNNING;
        if (!this.mIsApiCallRequired) {
            this.mSyncState = BackgroundSyncThread.SyncState.FINISHED;
        }
        while (this.mSyncState != BackgroundSyncThread.SyncState.FINISHED && this.mSyncState != BackgroundSyncThread.SyncState.PAUSED) {
            this.mRetryCounter = 0;
            final CountDownLatch loopLatch = new CountDownLatch(1);
            final long timestamp = this.mIsNext ? this.mChunk.getEndAt() : this.mChunk.getStartAt();
            this.getMessagesByTimestamp(timestamp, new BaseChannel.GetMessagesHandler(){

                public void onResult(final List<BaseMessage> list, final SendBirdException e) {
                    Logger.d(TAG, "getSucceededMessagesByTimestamp. list size = " + (list == null ? "null" : Integer.valueOf(list.size())) + ", e = " + e);
                    final 1 retryHandler = this;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (e != null) {
                                if (MessageBackgroundSyncThread.this.mRetryCounter < 3) {
                                    MessageBackgroundSyncThread.this.mRetryCounter++;
                                    MessageBackgroundSyncThread.this.getMessagesByTimestamp(timestamp, retryHandler);
                                } else {
                                    MessageBackgroundSyncThread.this.mSyncState = BackgroundSyncThread.SyncState.PAUSED;
                                    loopLatch.countDown();
                                }
                                return;
                            }
                            if (list.size() <= 1) {
                                MessageBackgroundSyncThread.this.mSyncState = BackgroundSyncThread.SyncState.FINISHED;
                                if (MessageBackgroundSyncThread.this.mIsNext) {
                                    MessageBackgroundSyncThread.this.mChunk.setEndSynced(true);
                                } else {
                                    MessageBackgroundSyncThread.this.mChunk.setStartSynced(true);
                                }
                                MessageManager.getInstance().getMessageChunkContainer().upsertChunk(MessageBackgroundSyncThread.this.mChunk, new CompletionHandler(){

                                    @Override
                                    public void onCompleted(SendBirdException e) {
                                        MessageBackgroundSyncThread.this.onSynced(e);
                                        loopLatch.countDown();
                                    }
                                });
                            } else {
                                MessageManager.getInstance().getMessageContainer().upsertSucceededMessages(list, true, new MessageContainer.UpsertMessageHandler(){

                                    @Override
                                    public void onResult(List<BaseMessage> insertedMessages, List<BaseMessage> updatedMessages, SendBirdException e) {
                                        long startAt = ((BaseMessage)list.get(0)).getCreatedAt();
                                        long endAt = ((BaseMessage)list.get(list.size() - 1)).getCreatedAt();
                                        MessageChunk newChunk = new MessageChunk(MessageBackgroundSyncThread.this.mChannel.getUrl(), startAt, endAt, MessageBackgroundSyncThread.this.mChunk.getFilter());
                                        MessageBackgroundSyncThread.this.mChunk.merge(newChunk);
                                        MessageManager.getInstance().getMessageChunkContainer().mergeIntersectedChunks(MessageBackgroundSyncThread.this.mChunk, new CompletionHandler(){

                                            @Override
                                            public void onCompleted(SendBirdException e) {
                                                MessageBackgroundSyncThread.this.onSynced(e);
                                                loopLatch.countDown();
                                            }
                                        });
                                    }
                                });
                            }
                        }
                    }).start();
                }
            });
            try {
                loopLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Logger.d(TAG, "sync finished. channel url = " + this.mChannel.getUrl() + ", isNext = " + this.mIsNext);
    }

    private void onSynced(SendBirdException e) {
        if (this.mEventListener != null) {
            this.mEventListener.onSynced(e);
        }
    }

    private void getMessagesByTimestamp(long ts, BaseChannel.GetMessagesHandler handler) {
        if (this.mIsNext) {
            this.mChannel.getNextMessagesByTimestamp(ts, true, 100, false, this.mChunk.getFilter().getMessageTypeFilter(), this.mChunk.getFilter().getCustomType(), this.mChunk.getFilter().getSenderUserIds(), handler);
        } else {
            this.mChannel.getPreviousMessagesByTimestamp(ts, true, 100, false, this.mChunk.getFilter().getMessageTypeFilter(), this.mChunk.getFilter().getCustomType(), this.mChunk.getFilter().getSenderUserIds(), handler);
        }
    }
}

