/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager.log;

import com.sendbird.syncmanager.log.Tag;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

class LoggerConfig {
    private int printLoggerLevel;
    private Tag defaultTag;
    private String stackPrefix;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS", Locale.US);
    private Set<String> ignoreStackSet;
    static final int DEV = 0;
    static final int VERBOSE = 2;
    static final int DEBUG = 3;
    static final int INFO = 4;
    static final int WARN = 5;
    static final int ERROR = 6;
    static final int ASSERT = 7;

    LoggerConfig() {
    }

    private String getTraceInfo() {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        return this.getTraceInfo(stacks);
    }

    private String getTraceInfo(StackTraceElement[] stacks) {
        StackTraceElement stack = null;
        String loggerName = this.getClass().getCanonicalName();
        boolean startTracking = false;
        for (StackTraceElement stack1 : stacks) {
            String className = stack1.getClassName();
            if (className.equalsIgnoreCase(loggerName)) {
                startTracking = true;
            }
            if (!startTracking || className.startsWith(loggerName) || this.ignoreStackSet.contains(className)) continue;
            stack = stack1;
            break;
        }
        if (stack == null) {
            return null;
        }
        String[] klass = stack.getClassName().split("\\.");
        String method = stack.getMethodName();
        int line = stack.getLineNumber();
        return String.format(Locale.US, "[%s %s:%s():%d]", this.dateFormat.format(System.currentTimeMillis()), klass[klass.length - 1], method, line);
    }

    Tag getDefaultTag() {
        return this.defaultTag;
    }

    private String getMessageWithTrace(String message) {
        String traceInfo = this.getTraceInfo();
        return String.format("%s %s", traceInfo == null ? "" : traceInfo, message);
    }

    boolean isPrintLoggable(int level) {
        return level >= this.printLoggerLevel;
    }

    String getMessage(boolean withStack, String msg) {
        return withStack ? this.getMessageWithTrace(msg) : msg;
    }

    static class Builder {
        private int printLoggerLevel = 0;
        private Tag defaultTag = Tag.DEFAULT;
        private String stackPrefix;
        private Set<String> ignoreStackSet = new HashSet<String>();

        Builder() {
        }

        Builder setDefaultTag(Tag tag) {
            this.defaultTag = tag;
            return this;
        }

        Builder setPrintLoggerLevel(int level) {
            this.printLoggerLevel = level;
            return this;
        }

        Builder setIgnoreSet(Set<String> set) {
            if (set == null) {
                return this;
            }
            this.ignoreStackSet = set;
            return this;
        }

        Builder setStackPrefix(String prefix) {
            this.stackPrefix = prefix;
            return this;
        }

        LoggerConfig build() {
            LoggerConfig loggerConfig = new LoggerConfig();
            loggerConfig.defaultTag = this.defaultTag;
            loggerConfig.printLoggerLevel = this.printLoggerLevel;
            loggerConfig.stackPrefix = this.stackPrefix;
            loggerConfig.ignoreStackSet = this.ignoreStackSet;
            return loggerConfig;
        }
    }
}

