/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseMessage;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.Consumer;
import com.sendbird.syncmanager.DBJobTask;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.MessageCollection;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.PendingMessageWrapper;
import com.sendbird.syncmanager.PmManager;
import com.sendbird.syncmanager.SendBirdSyncManager;
import com.sendbird.syncmanager.SyncManagerDb;
import com.sendbird.syncmanager.SyncManagerUtils;
import com.sendbird.syncmanager.handler.CompletionHandler;
import com.sendbird.syncmanager.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class PendingMessageManagerImpl
implements PmManager {
    private static final int WRITE_DELAY_SEC = 3;
    private final Semaphore dbSema = new Semaphore(1, true);
    private final Object executorLock = new Object();
    private final Object dbExecutorLock = new Object();
    private final ExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final ScheduledExecutorService dbExecutor = Executors.newSingleThreadScheduledExecutor();
    private final Map<String, PendingMessageWrapper> pmFromCurrentSession = new HashMap<String, PendingMessageWrapper>();
    private final Map<String, PendingMessageWrapper> allPendingMessages = new HashMap<String, PendingMessageWrapper>();
    private final Map<String, PendingMessageWrapper> messagesNotYetWrittenToDb = new HashMap<String, PendingMessageWrapper>();
    private final Map<String, ScheduledFuture<?>> futures = new HashMap();
    private final MessageCollection collection;
    static final Map<String, String> resolutionLog = new HashMap<String, String>();
    private final AtomicBoolean channelRemoved = new AtomicBoolean(false);
    private boolean sendAllEvents = false;

    private void acquireDbLock() {
        try {
            this.dbSema.acquire();
        }
        catch (InterruptedException e) {
            Logger.e(e);
        }
    }

    private void releaseDbLock() {
        this.dbSema.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postToExecutor(Runnable task) {
        Object object = this.executorLock;
        synchronized (object) {
            if (this.executor.isShutdown()) {
                return;
            }
            this.executor.submit(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownExecutor() {
        Object object = this.executorLock;
        synchronized (object) {
            this.executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownDbExecutor() {
        Object object = this.dbExecutorLock;
        synchronized (object) {
            this.dbExecutor.shutdown();
        }
    }

    PendingMessageManagerImpl(final MessageCollection collection) {
        Logger.d("create");
        this.collection = collection;
        this.postToExecutor(new Runnable(){

            @Override
            public void run() {
                SyncManagerDb.addTaskAndGet(new DBJobTask<List<PendingMessageWrapper>>(){

                    @Override
                    public List<PendingMessageWrapper> call(String userId) throws SendBirdException {
                        PendingMessageManagerImpl.this.acquireDbLock();
                        return DatabaseController.getInstance().getPendingMessages(userId, collection.getChannelUrl());
                    }

                    @Override
                    public void onResult(List<PendingMessageWrapper> result, SendBirdException e) {
                        if (null != e) {
                            Logger.e(e);
                            PendingMessageManagerImpl.this.releaseDbLock();
                            return;
                        }
                        for (PendingMessageWrapper wrapper : result) {
                            PendingMessageManagerImpl.this.allPendingMessages.put(wrapper.getRequestId(), wrapper);
                        }
                        Logger.d("loaded pending messages =" + PendingMessageManagerImpl.wrappersAsString(PendingMessageManagerImpl.this.allPendingMessages.values()));
                        PendingMessageManagerImpl.this.releaseDbLock();
                    }
                });
            }
        });
    }

    @Override
    public void sendAllEvents(final CompletionHandler handler) {
        Logger.d("sendAllEvents");
        this.postToExecutor(new Runnable(){

            @Override
            public void run() {
                PendingMessageManagerImpl.this.sendAllEvents = true;
                ArrayList<BaseMessage> allMessages = new ArrayList<BaseMessage>(PendingMessageManagerImpl.this.allPendingMessages.size());
                for (PendingMessageWrapper message : PendingMessageManagerImpl.this.allPendingMessages.values()) {
                    allMessages.add(message.getPendingMessage());
                }
                MessageManager.getInstance().broadcastPendingMessagesFetched(PendingMessageManagerImpl.this.collection.getChannelUrl(), allMessages);
                handler.onCompleted(null);
            }
        });
    }

    @Override
    public void destroy() {
        Logger.d("destroy");
        this.postToExecutor(new Runnable(){

            @Override
            public void run() {
                PendingMessageManagerImpl.this.allPendingMessages.clear();
                for (Map.Entry entry : PendingMessageManagerImpl.this.futures.entrySet()) {
                    boolean writtenToDB = !((ScheduledFuture)entry.getValue()).cancel(false);
                    if (!writtenToDB) continue;
                    PendingMessageManagerImpl.this.messagesNotYetWrittenToDb.remove(entry.getKey());
                }
                PendingMessageManagerImpl.this.futures.clear();
                PendingMessageManagerImpl.this.pmFromCurrentSession.clear();
                if (PendingMessageManagerImpl.this.messagesNotYetWrittenToDb.isEmpty()) {
                    return;
                }
                SyncManagerDb.addTask(new DBJobTask<Void>(){

                    @Override
                    public Void call(String userId) throws SendBirdException {
                        PendingMessageManagerImpl.this.acquireDbLock();
                        if (PendingMessageManagerImpl.this.channelRemoved.get()) {
                            PendingMessageManagerImpl.this.releaseDbLock();
                            return null;
                        }
                        DatabaseController.getInstance().insertPendingMessages(userId, PendingMessageManagerImpl.this.messagesNotYetWrittenToDb.values());
                        return null;
                    }

                    @Override
                    public void onResult(Void result, SendBirdException e) {
                        PendingMessageManagerImpl.this.messagesNotYetWrittenToDb.clear();
                        PendingMessageManagerImpl.this.releaseDbLock();
                    }
                });
                PendingMessageManagerImpl.this.shutdownExecutor();
                PendingMessageManagerImpl.this.shutdownDbExecutor();
            }
        });
    }

    @Override
    public void add(final List<BaseMessage> chunkMessages, final BaseMessage pendingMessage, final Runnable onAdded) {
        Logger.d("chunkMessages: " + SyncManagerUtils.asString(chunkMessages) + ", pendingMessage=" + pendingMessage.getMessage() + ", raw=" + pendingMessage);
        this.postToExecutor(new Runnable(){

            @Override
            public void run() {
                if (PendingMessageManagerImpl.this.sendAllEvents && PendingMessageManagerImpl.this.allPendingMessages.containsKey(pendingMessage.getRequestId())) {
                    Logger.d("message already in set: " + pendingMessage.getRequestId());
                    return;
                }
                final PendingMessageWrapper wrapper = new PendingMessageWrapper(pendingMessage, chunkMessages);
                Logger.d("new wrapper=" + wrapper);
                if (!PendingMessageManagerImpl.this.sendAllEvents && PendingMessageManagerImpl.this.pmFromCurrentSession.containsKey(pendingMessage.getRequestId())) {
                    Logger.d("message already in currentSession: " + PendingMessageManagerImpl.wrappersAsString(PendingMessageManagerImpl.this.pmFromCurrentSession.values()));
                    return;
                }
                if (!PendingMessageManagerImpl.this.sendAllEvents) {
                    PendingMessageManagerImpl.this.pmFromCurrentSession.put(wrapper.getRequestId(), wrapper);
                }
                PendingMessageManagerImpl.this.allPendingMessages.put(wrapper.getRequestId(), wrapper);
                PendingMessageManagerImpl.this.messagesNotYetWrittenToDb.put(wrapper.getRequestId(), wrapper);
                onAdded.run();
                PendingMessageManagerImpl.this.delayDbOperation(pendingMessage, new DBJobTask<Boolean>(){

                    @Override
                    public Boolean call(String userId) throws SendBirdException {
                        PendingMessageManagerImpl.this.acquireDbLock();
                        if (PendingMessageManagerImpl.this.channelRemoved.get()) {
                            PendingMessageManagerImpl.this.releaseDbLock();
                            return Boolean.FALSE;
                        }
                        return DatabaseController.getInstance().insertPendingMessage(userId, wrapper);
                    }

                    @Override
                    public void onResult(final Boolean result, final SendBirdException e) {
                        PendingMessageManagerImpl.this.postToExecutor(new Runnable(){

                            @Override
                            public void run() {
                                PendingMessageManagerImpl.this.futures.remove(wrapper.getRequestId());
                                if (null != e) {
                                    Logger.e(e);
                                } else if (Boolean.TRUE == result) {
                                    PendingMessageManagerImpl.this.messagesNotYetWrittenToDb.remove(wrapper.getRequestId());
                                }
                                PendingMessageManagerImpl.this.releaseDbLock();
                            }
                        });
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayDbOperation(BaseMessage pendingMessage, final DBJobTask<?> task) {
        Object object = this.dbExecutorLock;
        synchronized (object) {
            if (this.dbExecutor.isShutdown()) {
                return;
            }
            ScheduledFuture<?> future = this.dbExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    SyncManagerDb.addTask(task);
                }
            }, 3L, TimeUnit.SECONDS);
            this.futures.put(pendingMessage.getRequestId(), future);
        }
    }

    @Override
    public void remove(final BaseMessage pendingMessage, final Consumer<BaseMessage> onRemoved) {
        Logger.d("remove");
        this.postToExecutor(new Runnable(){

            @Override
            public void run() {
                Logger.d("remove single w/ collection");
                ScheduledFuture future = (ScheduledFuture)PendingMessageManagerImpl.this.futures.remove(pendingMessage.getRequestId());
                boolean cancelled = null != future ? future.cancel(false) : false;
                PendingMessageManagerImpl.this.removeInternal(pendingMessage, cancelled, onRemoved);
            }
        });
    }

    private void removeInternal(final BaseMessage pendingMessage, boolean cancelled, final Consumer<BaseMessage> onRemoved) {
        Logger.d("removeInternal multiple w/ collection");
        final PendingMessageWrapper removed = this.allPendingMessages.remove(pendingMessage.getRequestId());
        this.messagesNotYetWrittenToDb.remove(pendingMessage.getRequestId());
        if (null == removed) {
            Logger.d("no such message in set: " + pendingMessage.getRequestId());
            onRemoved.accept(null);
            return;
        }
        if (cancelled) {
            onRemoved.accept(removed.getPendingMessage());
            return;
        }
        SyncManagerDb.addTask(new DBJobTask<Boolean>(){

            @Override
            public Boolean call(String userId) throws SendBirdException {
                PendingMessageManagerImpl.this.acquireDbLock();
                return DatabaseController.getInstance().removePendingMessage(userId, pendingMessage);
            }

            @Override
            public void onResult(Boolean result, SendBirdException e) {
                if (Boolean.TRUE == result && null != onRemoved) {
                    onRemoved.accept(removed.getPendingMessage());
                } else {
                    onRemoved.accept(null);
                }
                PendingMessageManagerImpl.this.releaseDbLock();
            }
        });
    }

    @Override
    public void removeMultiple(final Collection<? extends BaseMessage> deleteTarget, final Consumer<? super List<BaseMessage>> onRemoved) {
        this.postToExecutor(new Runnable(){

            @Override
            public void run() {
                PendingMessageManagerImpl.this.removeMultipleInternal(deleteTarget, onRemoved);
            }
        });
    }

    private void removeMultipleInternal(Collection<? extends BaseMessage> deleteTarget, final Consumer<? super List<BaseMessage>> onRemoved) {
        Logger.d("remove multiple w/ collection");
        HashSet<? extends BaseMessage> dbDeleteTarget = new HashSet<BaseMessage>(deleteTarget);
        for (BaseMessage baseMessage : deleteTarget) {
            boolean cancelled;
            ScheduledFuture<?> scheduledFuture = this.futures.remove(baseMessage.getRequestId());
            if (null == scheduledFuture || !(cancelled = scheduledFuture.cancel(false))) continue;
            dbDeleteTarget.remove(baseMessage);
        }
        final HashSet<String> requestIds = new HashSet<String>();
        for (BaseMessage baseMessage : deleteTarget) {
            requestIds.add(baseMessage.getRequestId());
        }
        final ArrayList<BaseMessage> arrayList = new ArrayList<BaseMessage>();
        for (String requestId : requestIds) {
            if (!this.allPendingMessages.containsKey(requestId)) continue;
            arrayList.add(this.allPendingMessages.get(requestId).getPendingMessage());
        }
        this.allPendingMessages.keySet().removeAll(requestIds);
        this.messagesNotYetWrittenToDb.keySet().removeAll(requestIds);
        if (dbDeleteTarget.isEmpty()) {
            if (null != onRemoved) {
                onRemoved.accept(arrayList);
            }
            return;
        }
        SyncManagerDb.addTask(new DBJobTask<Boolean>(){

            @Override
            public Boolean call(String userId) throws SendBirdException {
                PendingMessageManagerImpl.this.acquireDbLock();
                return DatabaseController.getInstance().removePendingMessages(userId, PendingMessageManagerImpl.this.collection.getChannelUrl(), requestIds);
            }

            @Override
            public void onResult(Boolean result, SendBirdException e) {
                if (Boolean.TRUE == result && null != onRemoved) {
                    onRemoved.accept(arrayList);
                }
                PendingMessageManagerImpl.this.releaseDbLock();
            }
        });
    }

    @Override
    public void clear(final MessageCollection collection, final Consumer<? super Collection<BaseMessage>> onCleared) {
        Logger.d("clear");
        this.postToExecutor(new Runnable(){

            @Override
            public void run() {
                Iterator iterator = PendingMessageManagerImpl.this.futures.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    ((ScheduledFuture)entry.getValue()).cancel(false);
                    iterator.remove();
                }
                final HashSet<BaseMessage> copyBaseMessage = new HashSet<BaseMessage>();
                final HashSet<String> copyRequestId = new HashSet<String>();
                for (PendingMessageWrapper wrapper : PendingMessageManagerImpl.this.allPendingMessages.values()) {
                    copyBaseMessage.add(wrapper.getPendingMessage());
                    copyRequestId.add(wrapper.getRequestId());
                }
                PendingMessageManagerImpl.this.allPendingMessages.clear();
                PendingMessageManagerImpl.this.messagesNotYetWrittenToDb.clear();
                PendingMessageManagerImpl.this.pmFromCurrentSession.clear();
                if (copyBaseMessage.isEmpty()) {
                    if (null != onCleared) {
                        onCleared.accept(Collections.emptySet());
                    }
                    return;
                }
                SyncManagerDb.addTask(new DBJobTask<Boolean>(){

                    @Override
                    public Boolean call(String userId) throws SendBirdException {
                        PendingMessageManagerImpl.this.acquireDbLock();
                        return DatabaseController.getInstance().removePendingMessages(userId, collection.getChannelUrl(), copyRequestId);
                    }

                    @Override
                    public void onResult(Boolean result, SendBirdException e) {
                        if (null != e) {
                            Logger.e(e);
                            PendingMessageManagerImpl.this.releaseDbLock();
                            return;
                        }
                        if (Boolean.TRUE == result && null != onCleared) {
                            onCleared.accept(copyBaseMessage);
                        }
                        PendingMessageManagerImpl.this.releaseDbLock();
                    }
                });
            }
        });
    }

    @Override
    public void onChunkUpserted(final List<? extends BaseMessage> chunkMessages, final PmManager.SyncFinished syncFinished) {
        this.postToExecutor(new Runnable(){

            @Override
            public void run() {
                Logger.d("onChunkUpserted: chunkMessages=" + SyncManagerUtils.asString(chunkMessages) + ", syncFinished=" + (Object)((Object)syncFinished));
                if (chunkMessages.isEmpty()) {
                    Logger.e("empty chunk in onChunkUpdated.");
                    return;
                }
                if (PendingMessageManagerImpl.this.allPendingMessages.isEmpty()) {
                    Logger.d("allPendingMessages.isEmpty");
                    return;
                }
                long chunkStartAt = PendingMessageManagerImpl.getChunkStartAt(chunkMessages, syncFinished);
                long chunkEndAt = PendingMessageManagerImpl.getChunkEndAt(chunkMessages, syncFinished);
                Resolution resolution = PendingMessageManagerImpl.tryResolve(PendingMessageManagerImpl.this.allPendingMessages.values(), chunkMessages, chunkStartAt, chunkEndAt);
                PendingMessageManagerImpl.this.removeAndSendEvents(resolution);
            }
        });
    }

    @Override
    public void onEmptyChunkCreated(final long timestamp, final PmManager.SyncFinished syncFinished) {
        this.postToExecutor(new Runnable(){

            @Override
            public void run() {
                Logger.d("onEmptyChunkCreated: syncFinished=" + (Object)((Object)syncFinished));
                if (PendingMessageManagerImpl.this.allPendingMessages.isEmpty()) {
                    return;
                }
                long chunkStartAt = PendingMessageManagerImpl.getChunkStartAt(timestamp, syncFinished);
                long chunkEndAt = PendingMessageManagerImpl.getChunkEndAt(timestamp, syncFinished);
                Resolution resolution = PendingMessageManagerImpl.tryResolve(PendingMessageManagerImpl.this.allPendingMessages.values(), Collections.emptySet(), chunkStartAt, chunkEndAt);
                PendingMessageManagerImpl.this.removeAndSendEvents(resolution);
            }
        });
    }

    private void removeAndSendEvents(final Resolution resolution) {
        int totalSize = resolution.succeeded.size() + resolution.failed.size();
        if (0 == totalSize) {
            return;
        }
        final HashMap<String, BaseMessage> merged = new HashMap<String, BaseMessage>(totalSize);
        merged.putAll(resolution.succeeded);
        merged.putAll(resolution.failed);
        this.removeMultipleInternal(merged.values(), (Consumer<? super List<BaseMessage>>)new Consumer<List<BaseMessage>>(){

            @Override
            public void accept(List<BaseMessage> unused) {
                MessageManager messageManager = MessageManager.getInstance();
                if (!PendingMessageManagerImpl.this.sendAllEvents) {
                    merged.keySet().retainAll(PendingMessageManagerImpl.this.pmFromCurrentSession.keySet());
                }
                if (!merged.isEmpty()) {
                    messageManager.broadcastPendingMessagesDeleted(PendingMessageManagerImpl.this.collection.getChannelUrl(), merged.values());
                }
                if (!resolution.failed.isEmpty()) {
                    messageManager.broadcastPendingMessagesFailed(PendingMessageManagerImpl.this.collection.getChannelUrl(), resolution.failed.values());
                }
            }
        });
    }

    private static Resolution tryResolve(Collection<PendingMessageWrapper> searchTarget, Collection<? extends BaseMessage> chunkMessages, long chunkStartAt, long chunkEndAt) {
        Logger.d("searchTarget=" + PendingMessageManagerImpl.wrappersAsString(searchTarget) + ", chunkMessages=" + SyncManagerUtils.asString(chunkMessages));
        HashMap<String, BaseMessage> succeeded = new HashMap<String, BaseMessage>();
        HashMap<String, BaseMessage> failed = new HashMap<String, BaseMessage>();
        for (PendingMessageWrapper wrapper : searchTarget) {
            if (!wrapper.hasOverlapWith(chunkStartAt, chunkEndAt)) continue;
            if (PendingMessageManagerImpl.contains(chunkMessages, wrapper)) {
                succeeded.put(wrapper.getRequestId(), wrapper.getPendingMessage());
                continue;
            }
            if (chunkStartAt > wrapper.getStartAt() || wrapper.getEndAt() > chunkEndAt) continue;
            byte[] serialized = wrapper.getPendingMessage().serialize();
            BaseMessage failedMessage = BaseMessage.buildFromSerializedData((byte[])serialized, (BaseMessage.SendingStatus)BaseMessage.SendingStatus.FAILED);
            failed.put(wrapper.getRequestId(), failedMessage);
        }
        Logger.d("succeeded=" + SyncManagerUtils.asString(succeeded.values()));
        Logger.d("failed=" + SyncManagerUtils.asString(failed.values()));
        Logger.d(resolutionLog.toString());
        return new Resolution(succeeded, failed);
    }

    private static long getChunkStartAt(List<? extends BaseMessage> chunk, PmManager.SyncFinished syncFinished) {
        Logger.d("syncFinished=" + (Object)((Object)syncFinished));
        if (PmManager.SyncFinished.PREV == syncFinished || PmManager.SyncFinished.BOTH == syncFinished) {
            return Long.MIN_VALUE;
        }
        return chunk.get(0).getCreatedAt();
    }

    private static long getChunkStartAt(long timestamp, PmManager.SyncFinished syncFinished) {
        if (PmManager.SyncFinished.PREV == syncFinished || PmManager.SyncFinished.BOTH == syncFinished) {
            return Long.MIN_VALUE;
        }
        return timestamp;
    }

    private static long getChunkEndAt(List<? extends BaseMessage> chunk, PmManager.SyncFinished syncFinished) {
        if (PmManager.SyncFinished.NEXT == syncFinished || PmManager.SyncFinished.BOTH == syncFinished) {
            return Long.MAX_VALUE;
        }
        return chunk.get(chunk.size() - 1).getCreatedAt();
    }

    private static long getChunkEndAt(long timestamp, PmManager.SyncFinished syncFinished) {
        if (PmManager.SyncFinished.NEXT == syncFinished || PmManager.SyncFinished.BOTH == syncFinished) {
            return Long.MAX_VALUE;
        }
        return timestamp;
    }

    private static String getType(long chunkStartAt, long chunkEndAt, PendingMessageWrapper wrapper) {
        Logger.d("chunkStartAt=" + chunkStartAt + ", chunkEndAt=" + chunkEndAt + ", pmStart=" + wrapper.getStartAt() + ", pmEnd=" + wrapper.getEndAt());
        if (Long.MIN_VALUE == chunkStartAt && Long.MAX_VALUE == chunkEndAt) {
            return "allComplete";
        }
        if (Long.MIN_VALUE == chunkStartAt) {
            return "prevComplete";
        }
        if (Long.MAX_VALUE == chunkEndAt) {
            return "nextComplete";
        }
        if (!wrapper.hasOverlapWith(chunkStartAt, chunkEndAt)) {
            return "no overlap";
        }
        if (chunkStartAt <= wrapper.getStartAt() && wrapper.getEndAt() <= chunkEndAt) {
            return "pmInChunk";
        }
        if (wrapper.getStartAt() <= chunkStartAt && chunkEndAt <= wrapper.getEndAt()) {
            return "chunkInPm";
        }
        if (chunkStartAt <= wrapper.getStartAt() && chunkEndAt <= wrapper.getEndAt()) {
            return "overlapAtPmStart";
        }
        if (wrapper.getStartAt() <= chunkStartAt && wrapper.getEndAt() <= chunkEndAt) {
            return "overlapAtPmEnd";
        }
        throw new IllegalStateException("chunkStartAt=" + chunkEndAt + ", chunkEndAt=" + chunkEndAt + ", wrapper=" + wrapper);
    }

    private static String wrappersAsString(Collection<PendingMessageWrapper> messages) {
        if (messages.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (PendingMessageWrapper message : messages) {
            sb.append(message.getPendingMessage().getMessage()).append(", ");
        }
        if (sb.length() > 2) {
            sb.delete(sb.length() - 2, sb.length() - 1);
        }
        return sb.toString();
    }

    private static boolean contains(Iterable<? extends BaseMessage> chunkMessages, PendingMessageWrapper wrapper) {
        Logger.d("contains: target=" + wrapper.getRequestId());
        for (BaseMessage baseMessage : chunkMessages) {
            Logger.d("\tcompare with:" + SyncManagerUtils.getRequestId(baseMessage));
            if (!SyncManagerUtils.getRequestId(baseMessage).equals(wrapper.getRequestId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onChannelRemoved() {
        Logger.d("onChannelRemoved");
        this.shutdownDbExecutor();
        this.channelRemoved.set(true);
        this.postToExecutor(new Runnable(){

            @Override
            public void run() {
                PendingMessageManagerImpl.this.allPendingMessages.clear();
                PendingMessageManagerImpl.this.messagesNotYetWrittenToDb.clear();
                PendingMessageManagerImpl.this.pmFromCurrentSession.clear();
                PendingMessageManagerImpl.this.futures.clear();
                for (ScheduledFuture future : PendingMessageManagerImpl.this.futures.values()) {
                    future.cancel(false);
                }
                try {
                    DatabaseController.getInstance().removeAllPendingMessagesForChannel(SendBirdSyncManager.getInstance().getUserId(), PendingMessageManagerImpl.this.collection.getChannelUrl());
                }
                catch (SendBirdException e) {
                    Logger.e(e);
                }
            }
        });
        this.shutdownExecutor();
    }

    private static class Resolution {
        final Map<String, BaseMessage> succeeded;
        final Map<String, BaseMessage> failed;

        Resolution(Map<String, BaseMessage> succeeded, Map<String, BaseMessage> failed) {
            this.succeeded = succeeded;
            this.failed = failed;
        }
    }
}

