/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Pair;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelListQuery;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.PendingMessageWrapper;
import com.sendbird.syncmanager.SendBirdSyncManager;
import com.sendbird.syncmanager.SyncManagerError;
import com.sendbird.syncmanager.SyncManagerUtils;
import com.sendbird.syncmanager.log.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DatabaseController
extends SQLiteOpenHelper {
    private static DatabaseController sInstance;
    private static final String DATABASE_NAME = "sync_manager.db";
    private static final int DATABASE_VERSION = 6;

    private DatabaseController(Context context) {
        super(context, DATABASE_NAME, null, 6);
    }

    static DatabaseController getInstance() {
        if (sInstance == null) {
            throw new RuntimeException("DatabaseController hans't been initialized. Try DatabaseController.init first");
        }
        return sInstance;
    }

    static synchronized void init(Context context) {
        if (sInstance == null) {
            sInstance = new DatabaseController(context);
        }
    }

    static void deinit() {
        sInstance = null;
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS group_channel (channel_url TEXT, user_id TEXT, created_at INTEGER, serialized_data BLOB, PRIMARY KEY (channel_url, user_id))");
        db.execSQL("CREATE TABLE IF NOT EXISTS message (message_id INTEGER, user_id TEXT, created_at INTEGER, updated_at INTEGER, channel_url TEXT, request_id TEXT, serialized_data BLOB, is_deleted INTEGER, is_visible INTEGER,PRIMARY KEY (message_id, user_id))");
        db.execSQL("CREATE TABLE IF NOT EXISTS failed_message (user_id TEXT, request_id TEXT, created_at INTEGER, updated_at INTEGER, channel_url TEXT, serialized_data BLOB, PRIMARY KEY (request_id, user_id))");
        db.execSQL("CREATE TABLE IF NOT EXISTS pending_message (user_id TEXT, request_id TEXT, channel_url TEXT, serialized_data BLOB, start_at INTEGER, end_at INTEGER, PRIMARY KEY (request_id, user_id))");
        db.execSQL("CREATE TABLE IF NOT EXISTS message_chunk (chunk_id TEXT, user_id TEXT, channel_url TEXT, start_at INTEGER, end_at INTEGER, filter TEXT, start_synced INTEGER DEFAULT 0, end_synced INTEGER DEFAULT 0, PRIMARY KEY (chunk_id, user_id))");
        db.execSQL("CREATE TABLE IF NOT EXISTS group_channel_list_query (user_id TEXT, custom_types TEXT, include_empty INTEGER, channel_order INTEGER, save_point TEXT, serialized_data BLOB, PRIMARY KEY (user_id, channel_order, custom_types, include_empty))");
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Logger.d("onUpgrade. oldVersion = " + oldVersion + ", newVersion = " + newVersion);
        if (oldVersion < 2) {
            this.upgradeToVersion2(db);
        }
        if (oldVersion < 3) {
            this.upgradeToVersion3(db);
        }
        if (oldVersion < 4) {
            this.upgradeToVersion4(db);
        }
        if (oldVersion < 5) {
            this.upgradeToVersion5(db);
        }
        if (oldVersion < 6) {
            this.upgradeToVersion6(db);
        }
        Logger.d("onUpgrade. finished.");
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeToVersion2(SQLiteDatabase db) {
        Logger.d("upgradeToVersion2");
        String ALTER_GROUP_CHANNEL_TABLE = "ALTER TABLE group_channel ADD COLUMN created_at INTEGER DEFAULT 0;";
        String ALTER_MESSAGE_TABLE = "ALTER TABLE message ADD COLUMN updated_at INTEGER DEFAULT 0;";
        db.execSQL(ALTER_GROUP_CHANNEL_TABLE);
        db.execSQL(ALTER_MESSAGE_TABLE);
        try (Cursor groupChannelCursor = null;){
            groupChannelCursor = db.query("group_channel", null, null, null, null, null, null);
            if (groupChannelCursor != null && groupChannelCursor.getCount() > 0) {
                while (groupChannelCursor.moveToNext()) {
                    String userId = groupChannelCursor.getString(groupChannelCursor.getColumnIndex("user_id"));
                    byte[] serializedData = groupChannelCursor.getBlob(groupChannelCursor.getColumnIndex("serialized_data"));
                    GroupChannel groupChannel = (GroupChannel)GroupChannel.buildFromSerializedData((byte[])serializedData);
                    ContentValues values = new ContentValues();
                    values.put("created_at", Long.valueOf(groupChannel.getCreatedAt()));
                    values.put("serialized_data", groupChannel.serialize());
                    String selection = "channel_url = ? AND user_id = ?";
                    String[] selectionArgs = new String[]{groupChannel.getUrl(), userId};
                    db.update("group_channel", values, selection, selectionArgs);
                }
            }
        }
        try (Cursor succeededMessageCursor = null;){
            succeededMessageCursor = db.query("message", null, null, null, null, null, null);
            if (succeededMessageCursor != null && succeededMessageCursor.getCount() > 0) {
                while (succeededMessageCursor.moveToNext()) {
                    String userId = succeededMessageCursor.getString(succeededMessageCursor.getColumnIndex("user_id"));
                    byte[] serializedData = succeededMessageCursor.getBlob(succeededMessageCursor.getColumnIndex("serialized_data"));
                    BaseMessage message = BaseMessage.buildFromSerializedData((byte[])serializedData);
                    ContentValues values = new ContentValues();
                    values.put("updated_at", Long.valueOf(message.getUpdatedAt()));
                    String selection = "message_id = ? AND user_id = ?";
                    String[] selectionArgs = new String[]{String.valueOf(message.getMessageId()), userId};
                    db.update("message", values, selection, selectionArgs);
                }
            }
        }
    }

    private void upgradeToVersion3(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS group_channel_list_query (user_id TEXT, custom_types TEXT, include_empty INTEGER, channel_order INTEGER, save_point TEXT, serialized_data BLOB, PRIMARY KEY (user_id, channel_order, custom_types, include_empty))");
    }

    private void upgradeToVersion4(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS failed_message (user_id TEXT, request_id TEXT, created_at INTEGER, updated_at INTEGER, channel_url TEXT, serialized_data BLOB, PRIMARY KEY (request_id, user_id))");
    }

    private void upgradeToVersion5(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS pending_message (user_id TEXT, request_id TEXT, channel_url TEXT, serialized_data BLOB, start_at INTEGER, end_at INTEGER, PRIMARY KEY (request_id, user_id))");
    }

    private void upgradeToVersion6(SQLiteDatabase db) {
        db.execSQL("ALTER TABLE message ADD request_id TEXT;");
        db.execSQL("CREATE INDEX request_id ON message (request_id);");
    }

    List<GroupChannel> getAllChannels(String userId) throws SendBirdException {
        Logger.d("getAllChannels. userId = " + userId);
        try (Cursor cursor = null;){
            cursor = this.getAllChannelsFromDb(userId);
            if (cursor == null || cursor.getCount() == 0) {
                ArrayList<GroupChannel> arrayList = new ArrayList<GroupChannel>();
                return arrayList;
            }
            ArrayList<GroupChannel> channels = new ArrayList<GroupChannel>();
            while (cursor.moveToNext()) {
                BaseChannel baseChannel;
                byte[] serializedData = cursor.getBlob(cursor.getColumnIndex("serialized_data"));
                if (serializedData == null || !((baseChannel = BaseChannel.buildFromSerializedData((byte[])serializedData)) instanceof GroupChannel)) continue;
                channels.add((GroupChannel)baseChannel);
            }
            ArrayList<GroupChannel> arrayList = channels;
            return arrayList;
        }
    }

    GroupChannel getChannel(String userId, String channelUrl) throws SendBirdException {
        Logger.d("getChannel. userId = " + userId + " , channelUrl = " + channelUrl);
        try (Cursor cursor = null;){
            cursor = this.getChannelFromDb(userId, channelUrl);
            if (cursor == null || cursor.getCount() == 0) {
                GroupChannel groupChannel = null;
                return groupChannel;
            }
            cursor.moveToNext();
            byte[] serializedData = cursor.getBlob(cursor.getColumnIndex("serialized_data"));
            GroupChannel groupChannel = (GroupChannel)BaseChannel.buildFromSerializedData((byte[])serializedData);
            return groupChannel;
        }
    }

    Pair<List<GroupChannel>, List<GroupChannel>> upsertChannels(String userId, List<GroupChannel> channels) throws SendBirdException {
        Logger.d("upsertChannels. userId = " + userId + " , channel list size = " + channels.size());
        try {
            ArrayList<GroupChannel> insertedChannels = new ArrayList<GroupChannel>();
            ArrayList<GroupChannel> updatedChannels = new ArrayList<GroupChannel>();
            for (GroupChannel channel : channels) {
                long rowId = this.insertChannelToDb(userId, channel);
                if (rowId == -1L) {
                    int nAffectedRow = this.updateChannelToDb(userId, channel);
                    if (nAffectedRow <= 0) continue;
                    updatedChannels.add(channel);
                    continue;
                }
                insertedChannels.add(channel);
            }
            return new Pair(insertedChannels, updatedChannels);
        }
        catch (Exception e) {
            Logger.d(e);
            throw SyncManagerError.getException(810001, e);
        }
    }

    void deleteChannel(String userId, String channelUrl) throws SendBirdException {
        Logger.d("deleteChannel. userId = " + userId + " , channel url = " + channelUrl);
        try {
            this.deleteChannelFromDb(userId, channelUrl);
        }
        catch (Exception e) {
            Logger.d(e);
            throw SyncManagerError.getException(810001, e);
        }
    }

    void deleteChannels(String userId, List<String> channelUrls) throws SendBirdException {
        Logger.d("deleteChannels. userId = " + userId + " , channel url list size = " + channelUrls.size());
        try {
            for (String channelUrl : channelUrls) {
                this.deleteChannelFromDb(userId, channelUrl);
            }
        }
        catch (Exception e) {
            Logger.d(e);
            throw SyncManagerError.getException(810001, e);
        }
    }

    private synchronized Cursor getAllChannelsFromDb(String userId) {
        SQLiteDatabase db = this.getReadableDatabase();
        String selection = "user_id = ?";
        String[] selectionArgs = new String[]{userId};
        return db.query("group_channel", null, selection, selectionArgs, null, null, null);
    }

    private synchronized Cursor getChannelFromDb(String userId, String channelUrl) {
        SQLiteDatabase db = this.getReadableDatabase();
        String selection = "channel_url = ? AND user_id = ?";
        String[] selectionArgs = new String[]{channelUrl, userId};
        return db.query("group_channel", null, selection, selectionArgs, null, null, null, "1");
    }

    private synchronized long insertChannelToDb(String userId, GroupChannel channel) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("user_id", userId);
        values.put("channel_url", channel.getUrl());
        values.put("created_at", Long.valueOf(channel.getCreatedAt()));
        values.put("serialized_data", channel.serialize());
        try {
            return db.insertOrThrow("group_channel", null, values);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private synchronized int updateChannelToDb(String userId, GroupChannel channel) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("created_at", Long.valueOf(channel.getCreatedAt()));
        values.put("serialized_data", channel.serialize());
        String selection = "channel_url = ? AND user_id = ?";
        String[] selectionArgs = new String[]{channel.getUrl(), userId};
        return db.update("group_channel", values, selection, selectionArgs);
    }

    private synchronized int deleteChannelFromDb(String userId, String channelUrl) {
        SQLiteDatabase db = this.getWritableDatabase();
        String selection = "channel_url = ? AND user_id = ?";
        String[] selectionArgs = new String[]{channelUrl, userId};
        return db.delete("group_channel", selection, selectionArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized BaseMessage getSucceededMessageByMessageId(String messageId, String userId) {
        SQLiteDatabase db = this.getWritableDatabase();
        String selection = "message_id= ? AND user_id = ?";
        String[] selectionArgs = new String[]{messageId, userId};
        String[] columns = new String[]{"serialized_data"};
        Cursor cursor = null;
        try {
            cursor = db.query("message", columns, "message_id= ? AND user_id = ?", selectionArgs, null, null, null, "1");
            if (null == cursor || 0 == cursor.getCount()) {
                BaseMessage baseMessage = null;
                return baseMessage;
            }
            cursor.moveToNext();
            byte[] serializedData = cursor.getBlob(cursor.getColumnIndex("serialized_data"));
            if (null != serializedData) {
                BaseMessage baseMessage = BaseMessage.buildFromSerializedData((byte[])serializedData);
                return baseMessage;
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized BaseMessage getMessageByRequestId(BaseMessage.SendingStatus sendingStatus, String requestId, String userId) {
        SQLiteDatabase db = this.getWritableDatabase();
        Pair<String, String> query = DatabaseController.getQuery(sendingStatus);
        if (null == query) {
            return null;
        }
        String tableName = BaseMessage.SendingStatus.SUCCEEDED == sendingStatus ? "message" : (BaseMessage.SendingStatus.FAILED == sendingStatus ? "failed_message" : "pending_message");
        String queryString = (String)query.first;
        String columnName = (String)query.second;
        String selection = queryString;
        String[] selectionArgs = new String[]{requestId, userId};
        String[] columns = new String[]{columnName};
        Cursor cursor = null;
        try {
            cursor = db.query(tableName, columns, selection, selectionArgs, null, null, null, "1");
            if (null == cursor || 0 == cursor.getCount()) {
                BaseMessage baseMessage = null;
                return baseMessage;
            }
            cursor.moveToNext();
            byte[] serializedData = cursor.getBlob(cursor.getColumnIndex("serialized_data"));
            if (null != serializedData) {
                BaseMessage baseMessage = BaseMessage.buildFromSerializedData((byte[])serializedData);
                return baseMessage;
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return null;
    }

    private static Pair<String, String> getQuery(BaseMessage.SendingStatus sendingStatus) {
        String column;
        String userId;
        String requestId;
        if (BaseMessage.SendingStatus.PENDING != sendingStatus && BaseMessage.SendingStatus.FAILED != sendingStatus && BaseMessage.SendingStatus.SUCCEEDED != sendingStatus) {
            Logger.e("Unexpected sending status: %s", sendingStatus);
            return null;
        }
        if (BaseMessage.SendingStatus.PENDING == sendingStatus) {
            requestId = "request_id";
            userId = "user_id";
            column = "serialized_data";
        } else if (BaseMessage.SendingStatus.FAILED == sendingStatus) {
            requestId = "request_id";
            userId = "user_id";
            column = "serialized_data";
        } else {
            requestId = "request_id";
            userId = "user_id";
            column = "serialized_data";
        }
        String selection = requestId + "= ? AND " + userId + " = ?";
        return new Pair((Object)selection, (Object)column);
    }

    List<BaseMessage> getMessagesByChunk(String userId, MessageChunk chunk) throws SendBirdException {
        Logger.d("getMessagesByChunk. userId = " + userId + " , channelUrl = " + chunk.getChannelUrl());
        ArrayList<BaseMessage> messages = new ArrayList<BaseMessage>();
        try (Cursor cursor = null;){
            Object serializedData;
            cursor = this.getMessagesBetweenTimestampFromDb(userId, chunk.getChannelUrl(), chunk.getStartAt(), chunk.getEndAt());
            if (cursor == null || cursor.getCount() == 0) {
                ArrayList<BaseMessage> arrayList = messages;
                return arrayList;
            }
            while (cursor.moveToNext()) {
                serializedData = cursor.getBlob(cursor.getColumnIndex("serialized_data"));
                if (serializedData == null) continue;
                messages.add(BaseMessage.buildFromSerializedData((byte[])serializedData));
            }
            serializedData = messages;
            return serializedData;
        }
    }

    List<BaseMessage> getSucceededMessagesByTimestamp(String userId, String channelUrl, long ts, boolean isNext) throws SendBirdException {
        Logger.d("getSucceededMessagesByTimestamp. userId = " + userId + " , channelUrl = " + channelUrl);
        ArrayList<BaseMessage> messages = new ArrayList<BaseMessage>();
        try (Cursor cursor = null;){
            Object serializedData;
            cursor = this.getSucceededMessagesByTimestampFromDb(userId, channelUrl, ts, isNext);
            if (cursor == null || cursor.getCount() == 0) {
                ArrayList<BaseMessage> arrayList = messages;
                return arrayList;
            }
            while (cursor.moveToNext()) {
                serializedData = cursor.getBlob(cursor.getColumnIndex("serialized_data"));
                if (serializedData == null) continue;
                messages.add(BaseMessage.buildFromSerializedData((byte[])serializedData));
            }
            serializedData = messages;
            return serializedData;
        }
    }

    BaseMessage getPreviousSucceededMessageByTimestamp(String userId, String channelUrl, long ts) throws SendBirdException {
        Logger.d("getPreviousSucceededMessageByTimestamp. userId = " + userId + ", channelUrl = " + channelUrl);
        BaseMessage message = null;
        try (Cursor cursor = null;){
            cursor = this.getPreviousSucceededMessageByTimestampFromDb(userId, channelUrl, ts);
            if (cursor == null || cursor.getCount() == 0) {
                BaseMessage baseMessage = null;
                return baseMessage;
            }
            cursor.moveToNext();
            byte[] serializedData = cursor.getBlob(cursor.getColumnIndex("serialized_data"));
            if (serializedData != null) {
                message = BaseMessage.buildFromSerializedData((byte[])serializedData);
            }
            BaseMessage baseMessage = message;
            return baseMessage;
        }
    }

    Pair<List<BaseMessage>, List<BaseMessage>> upsertSucceededMessages(String userId, List<BaseMessage> messages, boolean isVisible) throws SendBirdException {
        Logger.d("upsertSucceededMessages. userId = " + userId + " , message list size = " + messages.size() + " , isVisible = " + isVisible);
        try {
            ArrayList<BaseMessage> insertedMessages = new ArrayList<BaseMessage>();
            ArrayList<BaseMessage> updatedMessages = new ArrayList<BaseMessage>();
            for (BaseMessage message : messages) {
                if (message.getMessageId() == 0L) continue;
                long rowId = this.insertSucceededMessageToDb(userId, message, isVisible);
                if (rowId == -1L) {
                    int nAffectedRow = this.updateSucceededMessageToDb(userId, message, isVisible);
                    if (nAffectedRow <= 0) continue;
                    updatedMessages.add(message);
                    continue;
                }
                insertedMessages.add(message);
            }
            Logger.d("upsertSucceededMessages. insertedMessage list size = " + insertedMessages.size() + " updatedMessage list size = " + updatedMessages.size());
            return new Pair(insertedMessages, updatedMessages);
        }
        catch (Exception e) {
            Logger.d(e);
            throw SyncManagerError.getException(810001, e);
        }
    }

    List<BaseMessage> removeSucceededMessages(String userId, List<Long> messageIds) throws SendBirdException {
        Logger.d("removeSucceededMessages. userId = " + userId + " , message list size = " + messageIds.size());
        try {
            ArrayList<BaseMessage> deletedMessages = new ArrayList<BaseMessage>();
            for (Long messageId : messageIds) {
                BaseMessage deletedMessage;
                if (messageId == 0L || (deletedMessage = this.removeSucceededMessageFromDb(userId, messageId)) == null) continue;
                deletedMessages.add(deletedMessage);
            }
            return deletedMessages;
        }
        catch (Exception e) {
            Logger.d(e);
            throw SyncManagerError.getException(810001, e);
        }
    }

    List<BaseMessage> getFailedMessages(String userId, String channelUrl) throws SendBirdException {
        Logger.d("getFailedMessages. userId = " + userId + " , channelUrl = " + channelUrl);
        try (Cursor cursor = null;){
            cursor = this.getFailedMessagesFromDb(userId, channelUrl);
            if (cursor == null || cursor.getCount() == 0) {
                ArrayList<BaseMessage> arrayList = new ArrayList<BaseMessage>();
                return arrayList;
            }
            ArrayList<BaseMessage> messages = new ArrayList<BaseMessage>();
            while (cursor.moveToNext()) {
                byte[] serializedData = cursor.getBlob(cursor.getColumnIndex("serialized_data"));
                if (serializedData == null) continue;
                messages.add(BaseMessage.buildFromSerializedData((byte[])serializedData));
            }
            ArrayList<BaseMessage> arrayList = messages;
            return arrayList;
        }
    }

    Pair<List<BaseMessage>, List<BaseMessage>> upsertFailedMessages(String userId, Iterable<? extends BaseMessage> messages) throws SendBirdException {
        Logger.d("upsertFailedMessages. userId = " + userId + " , messages : " + messages);
        try {
            ArrayList<BaseMessage> insertedMessages = new ArrayList<BaseMessage>();
            ArrayList<BaseMessage> updatedMessages = new ArrayList<BaseMessage>();
            for (BaseMessage baseMessage : messages) {
                if (baseMessage == null || baseMessage.getMessageId() > 0L) continue;
                long rowId = this.insertFailedMessageToDb(userId, baseMessage);
                if (rowId == -1L) {
                    int nAffectedRow = this.updateFailedMessageToDb(userId, baseMessage);
                    if (nAffectedRow <= 0) continue;
                    updatedMessages.add(baseMessage);
                    continue;
                }
                insertedMessages.add(baseMessage);
            }
            return new Pair(insertedMessages, updatedMessages);
        }
        catch (RuntimeException e) {
            Logger.d(e);
            throw SyncManagerError.getException(810001, e);
        }
    }

    void removeFailedMessages(String userId, List<String> requestIds) throws SendBirdException {
        Logger.d("removeFailedMessages. userId = " + userId + " , message list size = " + requestIds.size());
        try {
            for (String requestId : requestIds) {
                if (requestId.isEmpty()) continue;
                this.removeFailedMessageFromDb(userId, requestId);
            }
        }
        catch (Exception e) {
            Logger.d(e);
            throw SyncManagerError.getException(810001, e);
        }
    }

    Pair<Map<String, List<String>>, Long> removeExpiredFailedMessages(String userId) throws SendBirdException {
        Logger.d("removeExpiredFailedMessages. userId = " + userId);
        int retentionDays = SendBirdSyncManager.getInstance().getOptions().getFailedMessageRetentionDays();
        Cursor removedMessagesCursor = null;
        Cursor cursor = null;
        try {
            HashMap removedMessageMap = new HashMap();
            long expirationTime = System.currentTimeMillis() - (long)retentionDays * 86400000L;
            removedMessagesCursor = this.getExpiredFailedMessageFromDb(userId, expirationTime);
            Logger.e("cursor : " + removedMessagesCursor);
            if (removedMessagesCursor == null || removedMessagesCursor.getCount() == 0) {
                Pair pair = new Pair(removedMessageMap, (Object)System.currentTimeMillis());
                return pair;
            }
            while (removedMessagesCursor.moveToNext()) {
                String requestId = removedMessagesCursor.getString(removedMessagesCursor.getColumnIndex("request_id"));
                String channelUrl = removedMessagesCursor.getString(removedMessagesCursor.getColumnIndex("channel_url"));
                if (!removedMessageMap.containsKey(channelUrl)) {
                    removedMessageMap.put(channelUrl, new ArrayList());
                }
                ((List)removedMessageMap.get(channelUrl)).add(requestId);
            }
            this.removeExpiredFailedMessagesFromDb(userId, expirationTime);
            cursor = this.getOldestFailedMessageFromDb(userId);
            long oldestFailedMessageTs = System.currentTimeMillis();
            if (cursor != null && cursor.getCount() > 0 && cursor.moveToNext()) {
                oldestFailedMessageTs = cursor.getLong(cursor.getColumnIndex("created_at"));
            }
            Pair pair = new Pair(removedMessageMap, (Object)oldestFailedMessageTs);
            return pair;
        }
        catch (Exception e) {
            Logger.d(e);
            throw SyncManagerError.getException(810001, e);
        }
        finally {
            if (removedMessagesCursor != null) {
                removedMessagesCursor.close();
            }
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    void removeAllMessagesInChannels(String userId, List<String> channelUrls) throws SendBirdException {
        Logger.d("removeAllMessagesInChannel. userId = " + userId + ", channelUrl = " + channelUrls);
        if (channelUrls == null || channelUrls.isEmpty()) {
            return;
        }
        try {
            for (String channelUrl : Collections.unmodifiableCollection(channelUrls)) {
                this.removeAllMessagesInChannelFromDb(channelUrl);
            }
        }
        catch (Exception e) {
            Logger.d(e);
            throw SyncManagerError.getException(810001, e);
        }
    }

    List<String> removeExceedingMaxCountFailedMessages(String userId, String channelUrl) throws SendBirdException {
        Logger.d("removeExceedingMaxCountFailedMessages. userId = " + userId + ", channelUrl = " + channelUrl);
        try (Cursor cursor = null;){
            String requestId;
            int count;
            int maxCount = SendBirdSyncManager.getInstance().getOptions().getMaxFailedMessageCountPerChannel();
            long failedMessageCount = this.getFailedMessageCount(userId, channelUrl);
            ArrayList<String> removedRequestIds = new ArrayList<String>();
            if (failedMessageCount > (long)maxCount && (cursor = this.getOldestFailedMessageOfChannelFromDb(userId, channelUrl, failedMessageCount - (long)maxCount)) != null && cursor.moveToNext() && (count = this.removeFailedMessageFromDb(userId, requestId = cursor.getString(cursor.getColumnIndex("request_id")))) > 0) {
                removedRequestIds.add(requestId);
            }
            ArrayList<String> arrayList = removedRequestIds;
            return arrayList;
        }
    }

    void removeMessagesBeforeMessageOffset(String userId, String channelUrl, long messageOffset) throws SendBirdException {
        Logger.d("removeMessagesBeforeMessageOffset. userId = " + userId + ", channelUrl = " + channelUrl + ", messageOffset : " + messageOffset);
        try {
            this.removeAllMessagesInChannelBeforeOffsetFromDb(userId, channelUrl, messageOffset);
        }
        catch (Exception e) {
            Logger.d(e);
            throw SyncManagerError.getException(810001, e);
        }
    }

    private synchronized Cursor getMessagesBetweenTimestampFromDb(String userId, String channelUrl, long startAt, long endAt) {
        SQLiteDatabase db = this.getReadableDatabase();
        String selection = "channel_url = ? AND user_id = ? AND created_at >= ? AND created_at <= ? AND is_deleted = 0 AND is_visible = 1";
        String[] selectionArgs = new String[]{channelUrl, userId, String.valueOf(startAt), String.valueOf(endAt)};
        return db.query("message", null, selection, selectionArgs, null, null, "created_at ASC");
    }

    private synchronized Cursor getSucceededMessagesByTimestampFromDb(String userId, String channelUrl, long ts, boolean isNext) {
        SQLiteDatabase db = this.getReadableDatabase();
        String selection = "channel_url = ? AND user_id = ? AND is_deleted = 0 AND is_visible = 1 AND " + (isNext ? "created_at >= ?" : "created_at <= ?");
        String[] selectionArgs = new String[]{channelUrl, userId, String.valueOf(ts)};
        return db.query("message", null, selection, selectionArgs, null, null, "created_at ASC");
    }

    private synchronized Cursor getPreviousSucceededMessageByTimestampFromDb(String userId, String channelUrl, long ts) {
        SQLiteDatabase db = this.getReadableDatabase();
        String selection = "channel_url = ? AND user_id = ? AND is_deleted = 0 AND is_visible = 1 AND created_at <= ?";
        String[] selectionArgs = new String[]{channelUrl, userId, String.valueOf(ts)};
        return db.query("message", null, selection, selectionArgs, null, null, "created_at DESC", "1");
    }

    private synchronized long insertSucceededMessageToDb(String userId, BaseMessage message, boolean isVisible) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("channel_url", message.getChannelUrl());
        values.put("user_id", userId);
        values.put("message_id", Long.valueOf(message.getMessageId()));
        values.put("created_at", Long.valueOf(message.getCreatedAt()));
        values.put("updated_at", Long.valueOf(message.getUpdatedAt()));
        values.put("serialized_data", message.serialize());
        values.put("is_deleted", Integer.valueOf(0));
        values.put("is_visible", Integer.valueOf(isVisible ? 1 : 0));
        values.put("request_id", message.getRequestId());
        try {
            return db.insertOrThrow("message", null, values);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private synchronized int updateSucceededMessageToDb(String userId, BaseMessage message, boolean isVisible) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("channel_url", message.getChannelUrl());
        values.put("message_id", Long.valueOf(message.getMessageId()));
        values.put("created_at", Long.valueOf(message.getCreatedAt()));
        values.put("updated_at", Long.valueOf(message.getUpdatedAt()));
        values.put("serialized_data", message.serialize());
        values.put("request_id", message.getRequestId());
        if (isVisible) {
            values.put("is_visible", Integer.valueOf(1));
        }
        String selection = "message_id = ? AND user_id = ? AND updated_at <= ?";
        String[] selectionArgs = new String[]{String.valueOf(message.getMessageId()), userId, String.valueOf(message.getUpdatedAt())};
        return db.update("message", values, selection, selectionArgs);
    }

    private synchronized BaseMessage removeSucceededMessageFromDb(String userId, Long messageId) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("is_deleted", Integer.valueOf(1));
        String selection = "message_id = ? AND user_id = ?";
        String[] selectionArgs = new String[]{String.valueOf(messageId), userId};
        db.update("message", values, selection, selectionArgs);
        BaseMessage baseMessage = null;
        Cursor cursor = db.query("message", null, selection, selectionArgs, null, null, "created_at ASC");
        if (cursor != null) {
            cursor.moveToNext();
            byte[] serializedData = cursor.getBlob(cursor.getColumnIndex("serialized_data"));
            baseMessage = BaseMessage.buildFromSerializedData((byte[])serializedData);
            cursor.close();
        }
        return baseMessage;
    }

    private synchronized Cursor getFailedMessagesFromDb(String userId, String channelUrl) {
        SQLiteDatabase db = this.getReadableDatabase();
        String selection = "channel_url = ? AND user_id = ?";
        String[] selectionArgs = new String[]{channelUrl, userId};
        return db.query("failed_message", null, selection, selectionArgs, null, null, "created_at ASC");
    }

    private synchronized Cursor getOldestFailedMessageOfChannelFromDb(String userId, String channelUrl, long count) {
        SQLiteDatabase db = this.getReadableDatabase();
        String selection = "channel_url = ? AND user_id = ?";
        String[] selectionArgs = new String[]{channelUrl, userId};
        return db.query("failed_message", null, selection, selectionArgs, null, null, "created_at ASC", String.valueOf(count));
    }

    private synchronized Cursor getOldestFailedMessageFromDb(String userId) {
        SQLiteDatabase db = this.getReadableDatabase();
        String selection = "user_id = ?";
        String[] selectionArgs = new String[]{userId};
        return db.query("failed_message", null, selection, selectionArgs, null, null, "created_at ASC", "1");
    }

    private synchronized long getFailedMessageCount(String userId, String channelUrl) {
        SQLiteDatabase db = this.getReadableDatabase();
        String selection = "channel_url = ? AND user_id = ?";
        String[] selectionArgs = new String[]{channelUrl, userId};
        return DatabaseUtils.queryNumEntries((SQLiteDatabase)db, (String)"failed_message", (String)selection, (String[])selectionArgs);
    }

    private synchronized Cursor getExpiredFailedMessageFromDb(String userId, long expirationTs) {
        SQLiteDatabase db = this.getWritableDatabase();
        String selection = "user_id = ? AND created_at < ?";
        String[] selectionArgs = new String[]{userId, String.valueOf(expirationTs)};
        return db.query("failed_message", null, selection, selectionArgs, null, null, "created_at ASC");
    }

    private synchronized long insertFailedMessageToDb(String userId, BaseMessage message) {
        String requestId = SyncManagerUtils.getRequestId(message);
        if (requestId.isEmpty()) {
            return 0L;
        }
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("channel_url", message.getChannelUrl());
        values.put("user_id", userId);
        values.put("request_id", requestId);
        values.put("created_at", Long.valueOf(message.getCreatedAt()));
        values.put("updated_at", Long.valueOf(message.getUpdatedAt()));
        values.put("serialized_data", message.serialize());
        try {
            return db.insertOrThrow("failed_message", null, values);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    void removeSucceededMessagesAndChunksFromDB() {
        SQLiteDatabase db = this.getWritableDatabase();
        db.delete("message", null, null);
        db.delete("message_chunk", null, null);
    }

    int removeAllMessagesInChannelFromDb(String channelUrl) {
        SQLiteDatabase db = this.getWritableDatabase();
        String failedSelection = "channel_url = ?";
        String[] failedSelectionArgs = new String[]{channelUrl};
        int failedDeletedRowCount = db.delete("failed_message", failedSelection, failedSelectionArgs);
        String succeededSelection = "channel_url = ?";
        String[] succeededSelectionArgs = new String[]{channelUrl};
        int succeededDeletedRowCount = db.delete("message", succeededSelection, succeededSelectionArgs);
        String pendingSelection = "channel_url = ?";
        String[] pendingSelectionArgs = new String[]{channelUrl};
        int pendingDeletedRowCount = db.delete("pending_message", pendingSelection, pendingSelectionArgs);
        return failedDeletedRowCount + succeededDeletedRowCount + pendingDeletedRowCount;
    }

    int removeAllMessagesInChannelBeforeOffsetFromDb(String userId, String channelUrl, long offset) {
        SQLiteDatabase db = this.getWritableDatabase();
        String succeededSelection = "channel_url = ? AND user_id = ? AND created_at <= ?";
        String[] succeededSelectionArgs = new String[]{channelUrl, userId, String.valueOf(offset)};
        return db.delete("message", succeededSelection, succeededSelectionArgs);
    }

    private synchronized int updateFailedMessageToDb(String userId, BaseMessage message) {
        String requestId = SyncManagerUtils.getRequestId(message);
        if (requestId.isEmpty()) {
            return 0;
        }
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("channel_url", message.getChannelUrl());
        values.put("request_id", requestId);
        values.put("created_at", Long.valueOf(message.getCreatedAt()));
        values.put("updated_at", Long.valueOf(message.getUpdatedAt()));
        values.put("serialized_data", message.serialize());
        String selection = "request_id = ? AND user_id = ? AND updated_at <= ?";
        String[] selectionArgs = new String[]{requestId, userId, String.valueOf(message.getUpdatedAt())};
        return db.update("failed_message", values, selection, selectionArgs);
    }

    private synchronized int removeFailedMessageFromDb(String userId, String requestId) {
        SQLiteDatabase db = this.getWritableDatabase();
        String selection = "request_id = ? AND user_id = ?";
        String[] selectionArgs = new String[]{requestId, userId};
        return db.delete("failed_message", selection, selectionArgs);
    }

    private synchronized int removeExpiredFailedMessagesFromDb(String userId, long expirationTs) {
        SQLiteDatabase db = this.getWritableDatabase();
        String selection = "user_id = ? AND created_at < ?";
        String[] selectionArgs = new String[]{userId, String.valueOf(expirationTs)};
        return db.delete("failed_message", selection, selectionArgs);
    }

    private synchronized boolean updatePendingMessageEndAt(String userId, String channelUrl) throws SendBirdException {
        String selection = "end_at = ? AND channel_url = ? AND user_id = ?";
        String[] selectionArgs = new String[]{String.valueOf(Long.MAX_VALUE), channelUrl, userId};
        try {
            SQLiteDatabase db = this.getWritableDatabase();
            ContentValues values = new ContentValues();
            values.put("end_at", Long.valueOf(SendBird.getLastConnectedAt()));
            db.update("pending_message", values, "end_at = ? AND channel_url = ? AND user_id = ?", selectionArgs);
        }
        catch (SQLException e) {
            Logger.e(e);
            throw SyncManagerError.getException(810001, e);
        }
        return true;
    }

    final synchronized List<PendingMessageWrapper> getPendingMessages(String userId, String channelUrl) throws SendBirdException {
        this.updatePendingMessageEndAt(userId, channelUrl);
        String selection = "channel_url = ? AND user_id = ?";
        String[] selectionArgs = new String[]{channelUrl, userId};
        String[] columns = new String[]{"request_id", "serialized_data", "start_at", "end_at"};
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.getReadableDatabase();
            cursor = db.query("pending_message", columns, "channel_url = ? AND user_id = ?", selectionArgs, null, null, null);
            if (null == cursor || 0 == cursor.getCount()) {
                List<PendingMessageWrapper> list = Collections.emptyList();
                return list;
            }
            ArrayList<PendingMessageWrapper> messages = new ArrayList<PendingMessageWrapper>(cursor.getCount());
            while (cursor.moveToNext()) {
                PendingMessageWrapper wrapper = PendingMessageWrapper.from(cursor);
                if (null == wrapper) continue;
                messages.add(wrapper);
            }
            ArrayList<PendingMessageWrapper> arrayList = messages;
            return arrayList;
        }
        catch (SQLException e) {
            Logger.e(e);
            throw SyncManagerError.getException(810001, e);
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
    }

    final synchronized Boolean insertPendingMessage(String userId, PendingMessageWrapper wrapper) throws SendBirdException {
        BaseMessage message = wrapper.getPendingMessage();
        ContentValues values = new ContentValues();
        values.put("user_id", userId);
        values.put("channel_url", message.getChannelUrl());
        values.put("request_id", message.getRequestId());
        values.put("serialized_data", message.serialize());
        values.put("start_at", Long.valueOf(wrapper.getStartAt()));
        values.put("end_at", Long.valueOf(wrapper.getEndAt()));
        try {
            SQLiteDatabase db = this.getWritableDatabase();
            db.insertOrThrow("pending_message", null, values);
        }
        catch (SQLException e) {
            Logger.e(e);
            throw SyncManagerError.getException(810001, e);
        }
        return Boolean.TRUE;
    }

    final synchronized boolean insertPendingMessages(String userId, Iterable<PendingMessageWrapper> wrappers) throws SendBirdException {
        SQLiteDatabase db = null;
        try {
            db = this.getWritableDatabase();
            ContentValues values = new ContentValues();
            db.beginTransaction();
            for (PendingMessageWrapper wrapper : wrappers) {
                BaseMessage message = wrapper.getPendingMessage();
                values.clear();
                values.put("user_id", userId);
                values.put("channel_url", message.getChannelUrl());
                values.put("request_id", message.getRequestId());
                values.put("serialized_data", message.serialize());
                values.put("start_at", Long.valueOf(wrapper.getStartAt()));
                values.put("end_at", Long.valueOf(wrapper.getEndAt()));
                db.insertOrThrow("pending_message", null, values);
            }
            db.setTransactionSuccessful();
        }
        catch (SQLException e) {
            Logger.e(e);
            throw SyncManagerError.getException(810001, e);
        }
        finally {
            if (db != null) {
                db.endTransaction();
            }
        }
        return true;
    }

    final synchronized Boolean removePendingMessage(String userId, BaseMessage message) throws SendBirdException {
        String[] selectionArgs = new String[]{message.getRequestId(), message.getChannelUrl(), userId};
        try {
            SQLiteDatabase db = this.getWritableDatabase();
            String selection = "request_id = ? AND channel_url = ? AND user_id = ?";
            db.delete("pending_message", "request_id = ? AND channel_url = ? AND user_id = ?", selectionArgs);
        }
        catch (SQLException e) {
            Logger.e(e);
            throw SyncManagerError.getException(810001, e);
        }
        return Boolean.TRUE;
    }

    final synchronized Boolean removePendingMessages(String userId, String channelUrl, Iterable<String> requestIds) throws SendBirdException {
        SQLiteDatabase db = null;
        try {
            db = this.getWritableDatabase();
            db.beginTransaction();
            String selection = "request_id = ? AND channel_url = ? AND user_id = ?";
            for (String requestId : requestIds) {
                String[] selectionArgs = new String[]{requestId, channelUrl, userId};
                db.delete("pending_message", "request_id = ? AND channel_url = ? AND user_id = ?", selectionArgs);
            }
            db.setTransactionSuccessful();
        }
        catch (SQLException e) {
            Logger.e(e);
            throw SyncManagerError.getException(810001, e);
        }
        finally {
            if (null != db) {
                db.endTransaction();
            }
        }
        return Boolean.TRUE;
    }

    final synchronized void removeAllPendingMessagesForChannel(String userId, String channelUrl) throws SendBirdException {
        Logger.d("removeAllPendingMessagesForChannel: channelUrl=" + channelUrl);
        try {
            SQLiteDatabase db = this.getWritableDatabase();
            String[] selectionArgs = new String[]{channelUrl, userId};
            String selection = "channel_url = ? AND user_id = ?";
            int deleted = db.delete("pending_message", "channel_url = ? AND user_id = ?", selectionArgs);
            Logger.d("deleted=" + deleted);
        }
        catch (SQLException e) {
            Logger.e(e);
            throw SyncManagerError.getException(810001, e);
        }
    }

    final synchronized long removeAllPendingMessages() throws SendBirdException {
        try {
            SQLiteDatabase db = this.getReadableDatabase();
            return db.delete("pending_message", null, null);
        }
        catch (SQLException e) {
            Logger.e(e);
            throw SyncManagerError.getException(810001, e);
        }
    }

    final synchronized long getPendingMessageCount() throws SendBirdException {
        try {
            SQLiteDatabase db = this.getReadableDatabase();
            return DatabaseUtils.queryNumEntries((SQLiteDatabase)db, (String)"pending_message");
        }
        catch (SQLException e) {
            Logger.e(e);
            throw SyncManagerError.getException(810001, e);
        }
    }

    List<MessageChunk> getAllMessageChunks(String userId) throws SendBirdException {
        Logger.d("getAllMessageChunks. userId = " + userId);
        try (Cursor cursor = null;){
            cursor = this.getAllMessageChunksFromDb(userId);
            if (cursor == null || cursor.getCount() == 0) {
                ArrayList<MessageChunk> arrayList = new ArrayList<MessageChunk>();
                return arrayList;
            }
            ArrayList<MessageChunk> messageChunks = new ArrayList<MessageChunk>();
            while (cursor.moveToNext()) {
                messageChunks.add(MessageChunk.newInstance(cursor));
            }
            ArrayList<MessageChunk> arrayList = messageChunks;
            return arrayList;
        }
    }

    void upsertChunk(String userId, MessageChunk chunk) throws SendBirdException {
        Logger.d("upsertChunk. userId = " + userId + " , channelUrl = " + chunk.getChannelUrl());
        try {
            long rowId = this.insertChunkToDb(userId, chunk);
            if (rowId == -1L) {
                this.updateChunkToDb(userId, chunk);
            }
        }
        catch (Exception e) {
            Logger.d(e);
            throw SyncManagerError.getException(810001, e);
        }
    }

    void deleteChunks(String userId, List<MessageChunk> chunks) throws SendBirdException {
        Logger.d("deleteChunks. userId = " + userId + " , chunk list size = " + chunks.size());
        try {
            int nAffectedRow = 0;
            for (MessageChunk chunk : chunks) {
                Logger.d("deleting chunk : " + chunk.getChannelUrl() + ", startat : " + chunk.getStartAt() + ", endat: " + chunk.getEndAt());
                nAffectedRow += this.deleteChunkFromDb(userId, chunk);
            }
            Logger.d("deleteChunks. deletedCount : " + nAffectedRow);
        }
        catch (Exception e) {
            Logger.d(e);
            throw SyncManagerError.getException(810001, e);
        }
    }

    private synchronized Cursor getAllMessageChunksFromDb(String userId) {
        SQLiteDatabase db = this.getReadableDatabase();
        String selection = "user_id = ?";
        String[] selectionArgs = new String[]{userId};
        return db.query("message_chunk", null, selection, selectionArgs, null, null, null);
    }

    private synchronized long insertChunkToDb(String userId, MessageChunk chunk) {
        SQLiteDatabase db = this.getWritableDatabase();
        try {
            return db.insertOrThrow("message_chunk", null, chunk.toContentValues(userId));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private synchronized int updateChunkToDb(String userId, MessageChunk chunk) {
        SQLiteDatabase db = this.getWritableDatabase();
        String selection = "chunk_id = ? AND user_id = ?";
        String[] selectionArgs = new String[]{chunk.getChunkId(), userId};
        return db.update("message_chunk", chunk.toContentValues(userId), selection, selectionArgs);
    }

    private synchronized int deleteChunkFromDb(String userId, MessageChunk chunk) {
        SQLiteDatabase db = this.getWritableDatabase();
        String selection = "chunk_id = ? AND user_id = ?";
        String[] selectionArgs = new String[]{chunk.getChunkId(), userId};
        return db.delete("message_chunk", selection, selectionArgs);
    }

    Pair<GroupChannelListQuery, String> getGroupChannelListQuery(String userId, List<String> customTypes, boolean includeEmpty, GroupChannelListQuery.Order order) throws SendBirdException {
        Logger.d("getGroupChannelListQueryFromDb. customTypes = " + customTypes + ", includeEmpty = " + includeEmpty);
        try (Cursor cursor = null;){
            cursor = this.getGroupChannelListQueryFromDb(userId, customTypes, includeEmpty, order);
            if (cursor == null || cursor.getCount() == 0) {
                Pair pair = new Pair(null, null);
                return pair;
            }
            if (cursor.moveToNext()) {
                byte[] serializedData = cursor.getBlob(cursor.getColumnIndex("serialized_data"));
                String savePoint = cursor.getString(cursor.getColumnIndex("save_point"));
                GroupChannelListQuery query = GroupChannelListQuery.buildFromSerializedData((byte[])serializedData);
                Pair pair = new Pair((Object)query, (Object)savePoint);
                return pair;
            }
            Pair<GroupChannelListQuery, String> serializedData = null;
            return serializedData;
        }
    }

    void upsertGroupChannelListQuery(String userId, GroupChannelListQuery query, String savePoint) throws SendBirdException {
        try {
            long rowId = this.insertGroupChannelListQueryToDb(userId, query, savePoint);
            if (rowId == -1L) {
                this.updateGroupChannelListToDb(userId, query, savePoint);
            }
        }
        catch (Exception e) {
            Logger.d(e);
            throw SyncManagerError.getException(810001, e);
        }
    }

    private synchronized Cursor getGroupChannelListQueryFromDb(String userId, List<String> customTypes, boolean includeEmpty, GroupChannelListQuery.Order order) {
        SQLiteDatabase db = this.getReadableDatabase();
        String selection = "user_id = ? AND custom_types = ? AND include_empty = ? AND channel_order = ?";
        String[] selectionArgs = new String[]{userId, SyncManagerUtils.concatenateCustomTypes(customTypes), String.valueOf(includeEmpty ? 1 : 0), String.valueOf(SyncManagerUtils.orderToCode(order))};
        return db.query("group_channel_list_query", null, selection, selectionArgs, null, null, null);
    }

    private synchronized long insertGroupChannelListQueryToDb(String userId, GroupChannelListQuery query, String savePoint) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("user_id", userId);
        values.put("custom_types", SyncManagerUtils.concatenateCustomTypes(query.getCustomTypesFilter()));
        values.put("include_empty", Integer.valueOf(query.isIncludeEmpty() ? 1 : 0));
        values.put("channel_order", Integer.valueOf(SyncManagerUtils.orderToCode(query.getOrder())));
        values.put("serialized_data", query.serialize());
        values.put("save_point", savePoint);
        try {
            return db.insertOrThrow("group_channel_list_query", null, values);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private synchronized int updateGroupChannelListToDb(String userId, GroupChannelListQuery query, String savePoint) {
        SQLiteDatabase db = this.getWritableDatabase();
        String customTypes = SyncManagerUtils.concatenateCustomTypes(query.getCustomTypesFilter());
        ContentValues values = new ContentValues();
        values.put("user_id", userId);
        values.put("custom_types", SyncManagerUtils.concatenateCustomTypes(query.getCustomTypesFilter()));
        values.put("include_empty", Integer.valueOf(query.isIncludeEmpty() ? 1 : 0));
        values.put("channel_order", Integer.valueOf(SyncManagerUtils.orderToCode(query.getOrder())));
        values.put("serialized_data", query.serialize());
        values.put("save_point", savePoint);
        String selection = "user_id = ? AND custom_types = ? AND include_empty = ?";
        String[] selectionArgs = new String[]{userId, customTypes, String.valueOf(query.isIncludeEmpty() ? 1 : 0)};
        return db.update("group_channel_list_query", values, selection, selectionArgs);
    }

    private synchronized int deleteGroupChannelListQueryFromDb(String userId, List<String> customTypes, boolean includeEmpty) {
        SQLiteDatabase db = this.getWritableDatabase();
        String selection = "user_id = ? AND custom_types = ? AND include_empty = ?";
        String[] selectionArgs = new String[]{userId, SyncManagerUtils.concatenateCustomTypes(customTypes), String.valueOf(includeEmpty ? 1 : 0)};
        return db.delete("group_channel_list_query", selection, selectionArgs);
    }

    synchronized void clearCache() {
        SQLiteDatabase db = this.getWritableDatabase();
        db.delete("group_channel", null, null);
        db.delete("message", null, null);
        db.delete("message_chunk", null, null);
        db.delete("group_channel_list_query", null, null);
        db.delete("failed_message", null, null);
        db.delete("pending_message", null, null);
    }

    synchronized void clearCache(String userId) {
        SQLiteDatabase db = this.getWritableDatabase();
        String[] selectionArgs = new String[]{userId};
        String groupChannelTableSelection = "user_id = ?";
        String messageTableSelection = "user_id = ?";
        String chunkTableSelection = "user_id = ?";
        String queryTableSelection = "user_id = ?";
        String failedMessageTableSelection = "user_id = ?";
        String pendingMessageTableSelection = "user_id = ?";
        db.delete("group_channel", "user_id = ?", selectionArgs);
        db.delete("message", "user_id = ?", selectionArgs);
        db.delete("message_chunk", "user_id = ?", selectionArgs);
        db.delete("group_channel_list_query", "user_id = ?", selectionArgs);
        db.delete("failed_message", "user_id = ?", selectionArgs);
        db.delete("pending_message", "user_id = ?", selectionArgs);
    }
}

