/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.util.Pair;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.DBJobTask;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.FailedMessageEventActionReason;
import com.sendbird.syncmanager.FailedMessageQueue;
import com.sendbird.syncmanager.MessageFilter;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.SendBirdSyncManager;
import com.sendbird.syncmanager.SyncManagerDb;
import com.sendbird.syncmanager.SyncManagerUtils;
import com.sendbird.syncmanager.log.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

class FailedMessageDispatcher {
    private static FailedMessageDispatcher sInstance;
    private Map<String, FailedMessageQueue> mQueueMap = new ConcurrentHashMap<String, FailedMessageQueue>();
    private long mOldestFailedMessageTs = 0L;
    private Timer mFailedMessageRetentionChecker;

    private FailedMessageDispatcher() {
    }

    static FailedMessageDispatcher getInstance() {
        if (sInstance == null) {
            sInstance = new FailedMessageDispatcher();
        }
        return sInstance;
    }

    List<BaseMessage> getMessages(String channelUrl) {
        FailedMessageQueue fmq = this.mQueueMap.get(channelUrl);
        if (fmq != null) {
            return new ArrayList<BaseMessage>(fmq.getMessages());
        }
        return new ArrayList<BaseMessage>();
    }

    List<BaseMessage> loadFailedMessages(String userId, String channelUrl, MessageFilter messageFilter) throws SendBirdException {
        List<BaseMessage> messages = DatabaseController.getInstance().getFailedMessages(userId, channelUrl);
        FailedMessageQueue fmq = this.mQueueMap.get(channelUrl);
        if (fmq != null) {
            fmq.appendMessages(messages);
        }
        Iterator<BaseMessage> iterator = messages.iterator();
        while (iterator.hasNext()) {
            BaseMessage message = iterator.next();
            if (messageFilter.isValidMessage(message)) continue;
            iterator.remove();
        }
        return messages;
    }

    Pair<List<BaseMessage>, List<BaseMessage>> upsertMessages(String userId, String channelUrl, Iterable<? extends BaseMessage> messages) throws SendBirdException {
        Logger.i("message : " + messages, new Object[0]);
        Pair<List<BaseMessage>, List<BaseMessage>> result = DatabaseController.getInstance().upsertFailedMessages(userId, messages);
        List insertedMessages = (List)result.first;
        FailedMessageQueue fmq = this.mQueueMap.get(channelUrl);
        if (fmq != null) {
            fmq.appendMessages(insertedMessages);
        }
        return result;
    }

    List<String> removeMessages(String userId, BaseMessage message) throws SendBirdException {
        Logger.i("message : " + message, new Object[0]);
        ArrayList<String> requestIds = new ArrayList<String>();
        String requestId = SyncManagerUtils.getRequestId(message);
        if (requestId != null && !requestId.isEmpty()) {
            requestIds.add(requestId);
        }
        DatabaseController.getInstance().removeFailedMessages(userId, requestIds);
        FailedMessageQueue fmq = this.mQueueMap.get(message.getChannelUrl());
        if (fmq != null) {
            fmq.removeMessages(requestIds);
        }
        return requestIds;
    }

    void removeExpiredMessages(String userId) throws SendBirdException {
        Logger.i("removeExpiredMessages", new Object[0]);
        Pair<Map<String, List<String>>, Long> result = DatabaseController.getInstance().removeExpiredFailedMessages(userId);
        Map removedRequestIds = (Map)result.first;
        Long oldestFailedMessageTs = (Long)result.second;
        if (oldestFailedMessageTs != null) {
            this.mOldestFailedMessageTs = oldestFailedMessageTs;
        }
        if (removedRequestIds != null) {
            for (Map.Entry entry : removedRequestIds.entrySet()) {
                String channelUrl = (String)entry.getKey();
                List requestIds = (List)entry.getValue();
                FailedMessageQueue fmq = this.mQueueMap.get(channelUrl);
                if (fmq != null) {
                    fmq.removeMessages(requestIds);
                }
                MessageManager.getInstance().broadcastFailedMessagesDeleted(channelUrl, requestIds, FailedMessageEventActionReason.REMOVE_RETENTION_EXPIRED);
            }
        }
    }

    List<String> removeExceedingMaxCount(String userId, String channelUrl) throws SendBirdException {
        List<String> removedRequestIds = DatabaseController.getInstance().removeExceedingMaxCountFailedMessages(userId, channelUrl);
        FailedMessageQueue fmq = this.mQueueMap.get(channelUrl);
        if (fmq != null) {
            fmq.removeMessages(removedRequestIds);
        }
        return removedRequestIds;
    }

    void pause() {
        this.stopFailedMessageRetentionChecker();
        this.pauseAllQueues();
    }

    void createQueue(GroupChannel channel) {
        FailedMessageQueue fmq = this.mQueueMap.get(channel.getUrl());
        if (fmq != null) {
            fmq.increaseCount();
        } else {
            this.mQueueMap.put(channel.getUrl(), new FailedMessageQueue(channel));
        }
    }

    FailedMessageQueue removeQueue(String channelUrl) {
        FailedMessageQueue fmq = this.mQueueMap.get(channelUrl);
        if (fmq != null) {
            fmq.decreaseCount();
            if (fmq.getCollectionReferenceCount() == 0) {
                FailedMessageQueue queue = this.mQueueMap.remove(channelUrl);
                if (queue != null) {
                    queue.pauseResending();
                }
                return queue;
            }
        }
        return null;
    }

    void clearCache() {
        this.pauseAllQueues();
        this.mQueueMap.clear();
    }

    void startFailedMessageRetentionChecker() {
        long retentionTimerInterval = SendBirdSyncManager.TEST_MODE ? 5000L : 43200000L;
        this.stopFailedMessageRetentionChecker();
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                int retentionDays = SendBirdSyncManager.getInstance().getOptions().getFailedMessageRetentionDays();
                long expirationTs = System.currentTimeMillis() - (long)retentionDays * 86400000L;
                if (expirationTs > FailedMessageDispatcher.this.mOldestFailedMessageTs) {
                    SyncManagerDb.addTaskAndGet(new DBJobTask<Void>(){

                        @Override
                        public Void call(String userId) throws Exception {
                            FailedMessageDispatcher.getInstance().removeExpiredMessages(userId);
                            return null;
                        }
                    });
                }
            }
        }, 0L, retentionTimerInterval);
        this.mFailedMessageRetentionChecker = timer;
    }

    private void stopFailedMessageRetentionChecker() {
        if (this.mFailedMessageRetentionChecker != null) {
            this.mFailedMessageRetentionChecker.cancel();
        }
        this.mFailedMessageRetentionChecker = null;
    }

    void resumeAllQueues() {
        Logger.d("queue map size : " + this.mQueueMap.values().size());
        for (FailedMessageQueue queue : this.mQueueMap.values()) {
            if (queue == null) continue;
            queue.resumeResending();
        }
    }

    private void pauseAllQueues() {
        for (FailedMessageQueue queue : this.mQueueMap.values()) {
            if (queue == null) continue;
            queue.pauseResending();
        }
    }
}

