/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.provider.BaseColumns;

final class DatabaseContract {
    static final String CREATE_CHANNEL_TABLE = "CREATE TABLE IF NOT EXISTS group_channel (channel_url TEXT, user_id TEXT, created_at INTEGER, serialized_data BLOB, PRIMARY KEY (channel_url, user_id))";
    static final String CREATE_SUCCEEDED_MESSAGE_TABLE = "CREATE TABLE IF NOT EXISTS message (message_id INTEGER, user_id TEXT, created_at INTEGER, updated_at INTEGER, channel_url TEXT, request_id TEXT, serialized_data BLOB, is_deleted INTEGER, is_visible INTEGER,PRIMARY KEY (message_id, user_id))";
    static final String CREATE_FAILED_MESSAGE_TABLE = "CREATE TABLE IF NOT EXISTS failed_message (user_id TEXT, request_id TEXT, created_at INTEGER, updated_at INTEGER, channel_url TEXT, serialized_data BLOB, PRIMARY KEY (request_id, user_id))";
    static final String CREATE_PENDING_MESSAGE_TABLE = "CREATE TABLE IF NOT EXISTS pending_message (user_id TEXT, request_id TEXT, channel_url TEXT, serialized_data BLOB, start_at INTEGER, end_at INTEGER, PRIMARY KEY (request_id, user_id))";
    static final String CREATE_CHUNK_TABLE = "CREATE TABLE IF NOT EXISTS message_chunk (chunk_id TEXT, user_id TEXT, channel_url TEXT, start_at INTEGER, end_at INTEGER, filter TEXT, start_synced INTEGER DEFAULT 0, end_synced INTEGER DEFAULT 0, PRIMARY KEY (chunk_id, user_id))";
    static final String CREATE_QUERY_TABLE = "CREATE TABLE IF NOT EXISTS group_channel_list_query (user_id TEXT, custom_types TEXT, include_empty INTEGER, channel_order INTEGER, save_point TEXT, serialized_data BLOB, PRIMARY KEY (user_id, channel_order, custom_types, include_empty))";

    private DatabaseContract() {
    }

    static class QueryEntry
    implements BaseColumns {
        static final String TABLE_NAME = "group_channel_list_query";
        static final String COLUMN_NAME_USER_ID = "user_id";
        static final String COLUMN_NAME_CUSTOM_TYPES = "custom_types";
        static final String COLUMN_NAME_INCLUDE_EMPTY = "include_empty";
        static final String COLUMN_NAME_ORDER = "channel_order";
        static final String COLUMN_NAME_SAVE_POINT = "save_point";
        static final String COLUMN_NAME_SERIALIZED_DATA = "serialized_data";

        QueryEntry() {
        }
    }

    static class MessageChunkEntry
    implements BaseColumns {
        static final String TABLE_NAME = "message_chunk";
        static final String COLUMN_NAME_USER_ID = "user_id";
        static final String COLUMN_NAME_CHANNEL_URL = "channel_url";
        static final String COLUMN_NAME_CHUNK_ID = "chunk_id";
        static final String COLUMN_NAME_START_AT = "start_at";
        static final String COLUMN_NAME_END_AT = "end_at";
        static final String COLUMN_NAME_FILTER = "filter";
        static final String COLUMN_NAME_START_SYNCED = "start_synced";
        static final String COLUMN_NAME_END_SYNCED = "end_synced";

        MessageChunkEntry() {
        }
    }

    static class PendingMessageEntry
    implements BaseColumns {
        static final String TABLE_NAME = "pending_message";
        static final String COLUMN_NAME_USER_ID = "user_id";
        static final String COLUMN_NAME_CHANNEL_URL = "channel_url";
        static final String COLUMN_NAME_REQUEST_ID = "request_id";
        static final String COLUMN_NAME_SERIALIZED_DATA = "serialized_data";
        static final String COLUMN_NAME_START_AT = "start_at";
        static final String COLUMN_NAME_END_AT = "end_at";

        PendingMessageEntry() {
        }
    }

    static class FailedMessageEntry
    implements BaseColumns {
        static final String TABLE_NAME = "failed_message";
        static final String COLUMN_NAME_USER_ID = "user_id";
        static final String COLUMN_NAME_CHANNEL_URL = "channel_url";
        static final String COLUMN_NAME_REQUEST_ID = "request_id";
        static final String COLUMN_NAME_CREATED_AT = "created_at";
        static final String COLUMN_NAME_UPDATED_AT = "updated_at";
        static final String COLUMN_NAME_SERIALIZED_DATA = "serialized_data";

        FailedMessageEntry() {
        }
    }

    static class SucceededMessageEntry
    implements BaseColumns {
        static final String TABLE_NAME = "message";
        static final String COLUMN_NAME_USER_ID = "user_id";
        static final String COLUMN_NAME_CHANNEL_URL = "channel_url";
        static final String COLUMN_NAME_REQUEST_ID = "request_id";
        static final String COLUMN_NAME_MESSAGE_ID = "message_id";
        static final String COLUMN_NAME_CREATED_AT = "created_at";
        static final String COLUMN_NAME_UPDATED_AT = "updated_at";
        static final String COLUMN_NAME_SERIALIZED_DATA = "serialized_data";
        static final String COLUMN_NAME_IS_DELETED = "is_deleted";
        static final String COLUMN_NAME_IS_VISIBLE = "is_visible";

        SucceededMessageEntry() {
        }
    }

    static class GroupChannelEntry
    implements BaseColumns {
        static final String TABLE_NAME = "group_channel";
        static final String COLUMN_NAME_USER_ID = "user_id";
        static final String COLUMN_NAME_CREATED_AT = "created_at";
        static final String COLUMN_NAME_CHANNEL_URL = "channel_url";
        static final String COLUMN_NAME_SERIALIZED_DATA = "serialized_data";

        GroupChannelEntry() {
        }
    }
}

