/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.BackgroundSyncThread;
import com.sendbird.syncmanager.DBJobTask;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.MessageBackgroundSyncThread;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageFilter;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.PmManager;
import com.sendbird.syncmanager.SyncManagerDb;
import com.sendbird.syncmanager.log.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

class MessageSynchronizer {
    static final int MESSAGE_QUERY_INITIAL_RESULT_SIZE = 30;
    private MessageBackgroundSyncThread mNextThread;
    private MessageBackgroundSyncThread mPrevThread;
    private final AtomicBoolean syncedOnce = new AtomicBoolean();
    private final BaseChannel mChannel;
    private final MessageFilter mFilter;
    private final long mViewpointTimestamp;
    private int mRetryCounter = 0;
    private final List<MessageBackgroundSyncEventListener> mPrevEventListeners = new ArrayList<MessageBackgroundSyncEventListener>();
    private final List<MessageBackgroundSyncEventListener> mNextEventListeners = new ArrayList<MessageBackgroundSyncEventListener>();
    private BackgroundSyncThread.SyncState mSyncState = BackgroundSyncThread.SyncState.INIT;

    MessageSynchronizer(BaseChannel channel, MessageFilter filter, long viewpointTimestamp) {
        this.mChannel = channel;
        this.mFilter = filter;
        this.mViewpointTimestamp = viewpointTimestamp;
    }

    BackgroundSyncThread.SyncState getSyncState(boolean isNext) {
        MessageBackgroundSyncThread thread = isNext ? this.mNextThread : this.mPrevThread;
        Logger.d("next : " + isNext + ", thread : " + (Object)((Object)(thread == null ? null : thread.getSyncState())));
        if (thread == null) {
            return this.mSyncState;
        }
        return thread.getSyncState();
    }

    synchronized void start() {
        Logger.i("start(). syncState : " + (Object)((Object)this.mSyncState) + ", next syncState : " + (Object)((Object)this.getSyncState(true)) + ", prev syncState : " + (Object)((Object)this.getSyncState(false)), new Object[0]);
        if (this.mSyncState == BackgroundSyncThread.SyncState.RUNNING || this.getSyncState(true) == BackgroundSyncThread.SyncState.RUNNING || this.getSyncState(false) == BackgroundSyncThread.SyncState.RUNNING) {
            Logger.d("RUNNING ALREADY");
            return;
        }
        this.stopNext();
        this.stopPrev();
        this.mSyncState = BackgroundSyncThread.SyncState.RUNNING;
        new Thread(new Runnable(){

            @Override
            public void run() {
                MessageChunk chunk = MessageManager.getInstance().getMessageChunkContainer().getCurrentChunk(MessageSynchronizer.this.mChannel.getUrl(), MessageSynchronizer.this.mFilter, MessageSynchronizer.this.mViewpointTimestamp, MessageSynchronizer.this.syncedOnce.get(), false);
                Logger.d("current chunk : " + chunk);
                if (chunk == null) {
                    MessageSynchronizer.this.mRetryCounter = 0;
                    MessageSynchronizer.this.mChannel.getPreviousAndNextMessagesByTimestamp(MessageSynchronizer.this.mViewpointTimestamp, 30, 30, false, MessageSynchronizer.this.mFilter.getMessageTypeFilter(), MessageSynchronizer.this.mFilter.getCustomType(), MessageSynchronizer.this.mFilter.getSenderUserIds(), true, new BaseChannel.GetMessagesHandler(){

                        public void onResult(final List<BaseMessage> list, final SendBirdException e) {
                            Logger.d("getPreviousAndNextMessagesByTimestamp. list size = " + (list == null ? "null" : Integer.valueOf(list.size())) + ", e = " + (Object)((Object)e));
                            final 1 retryHandler = this;
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    if (e != null) {
                                        Logger.d("retryCounter : " + MessageSynchronizer.this.mRetryCounter);
                                        if (MessageSynchronizer.this.mRetryCounter < 3) {
                                            MessageSynchronizer.this.mRetryCounter++;
                                            MessageSynchronizer.this.mChannel.getPreviousAndNextMessagesByTimestamp(MessageSynchronizer.this.mViewpointTimestamp, 30, 30, false, MessageSynchronizer.this.mFilter.getMessageTypeFilter(), MessageSynchronizer.this.mFilter.getCustomType(), MessageSynchronizer.this.mFilter.getSenderUserIds(), true, retryHandler);
                                        } else {
                                            MessageSynchronizer.this.mSyncState = BackgroundSyncThread.SyncState.PAUSED;
                                            MessageSynchronizer.this.onSyncedAndWait(true, BackgroundSyncThread.SyncState.PAUSED, e);
                                            MessageSynchronizer.this.onSyncedAndWait(false, BackgroundSyncThread.SyncState.PAUSED, e);
                                        }
                                        MessageSynchronizer.this.syncedOnce.set(false);
                                        e.printStackTrace();
                                        return;
                                    }
                                    if (list == null || list.size() == 0) {
                                        MessageSynchronizer.this.startPrev(null, false);
                                        MessageSynchronizer.this.startNext(null, false);
                                        MessageSynchronizer.this.mSyncState = BackgroundSyncThread.SyncState.FINISHED;
                                        MessageSynchronizer.this.onSyncedAndWait(true, BackgroundSyncThread.SyncState.FINISHED, null);
                                        MessageSynchronizer.this.onSyncedAndWait(false, BackgroundSyncThread.SyncState.FINISHED, null);
                                        if (null != list && list.isEmpty()) {
                                            MessageManager.getInstance().broadcastEmptyChunk(MessageSynchronizer.this.mViewpointTimestamp, MessageSynchronizer.this.mChannel.getUrl(), MessageSynchronizer.this.mFilter, PmManager.SyncFinished.BOTH);
                                        }
                                    } else {
                                        final boolean isApiCallRequired = list.size() >= 30;
                                        final long startAt = ((BaseMessage)list.get(0)).getCreatedAt();
                                        final long endAt = ((BaseMessage)list.get(list.size() - 1)).getCreatedAt();
                                        SyncManagerDb.addTask(new DBJobTask<MessageChunk>(){

                                            @Override
                                            public MessageChunk call(String userId) throws Exception {
                                                DatabaseController.getInstance().upsertSucceededMessages(userId, list, true);
                                                MessageChunk newChunk = new MessageChunk(MessageSynchronizer.this.mChannel.getUrl(), startAt, endAt, MessageSynchronizer.this.mFilter);
                                                newChunk.setStartSynced(!isApiCallRequired);
                                                newChunk.setEndSynced(!isApiCallRequired);
                                                Logger.d(newChunk.toString());
                                                MessageManager.getInstance().getMessageChunkContainer().mergeIntersectedChunks(userId, newChunk, list);
                                                return newChunk;
                                            }

                                            @Override
                                            public void onResult(MessageChunk newChunk, SendBirdException e) {
                                                MessageSynchronizer.this.syncedOnce.set(newChunk != null);
                                                if (newChunk != null) {
                                                    Logger.d("newChunk : " + newChunk + ", apiRequired ; " + isApiCallRequired);
                                                    MessageSynchronizer.this.startPrev(newChunk, isApiCallRequired);
                                                    MessageSynchronizer.this.startNext(newChunk, isApiCallRequired);
                                                    MessageSynchronizer.this.mSyncState = BackgroundSyncThread.SyncState.FINISHED;
                                                    MessageSynchronizer.this.onSyncedAndWait(true, isApiCallRequired ? BackgroundSyncThread.SyncState.RUNNING : BackgroundSyncThread.SyncState.FINISHED, e);
                                                    MessageSynchronizer.this.onSyncedAndWait(false, isApiCallRequired ? BackgroundSyncThread.SyncState.RUNNING : BackgroundSyncThread.SyncState.FINISHED, e);
                                                }
                                            }
                                        });
                                    }
                                }
                            }).start();
                        }
                    });
                } else {
                    MessageSynchronizer.this.syncedOnce.set(true);
                    MessageSynchronizer.this.startPrev(chunk, true);
                    MessageSynchronizer.this.startNext(chunk, true);
                    MessageSynchronizer.this.mSyncState = BackgroundSyncThread.SyncState.FINISHED;
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        List<MessageBackgroundSyncEventListener> list = this.mNextEventListeners;
        synchronized (list) {
            this.mNextEventListeners.clear();
        }
        list = this.mPrevEventListeners;
        synchronized (list) {
            this.mPrevEventListeners.clear();
        }
        this.stopNext();
        this.stopPrev();
        this.mSyncState = BackgroundSyncThread.SyncState.PAUSED;
    }

    private synchronized void startNext(MessageChunk chunk, boolean isApiCallRequired) {
        Logger.d("startNext, apiRequired : " + isApiCallRequired);
        if (this.mNextThread == null) {
            this.mNextThread = new MessageBackgroundSyncThread(this.mChannel, chunk, true, isApiCallRequired);
            this.mNextThread.setEventListener(new MessageBackgroundSyncEventListener(){

                @Override
                public void onSyncAndWait(BackgroundSyncThread.SyncState syncState, SendBirdException e) {
                    MessageSynchronizer.this.onSyncedAndWait(true, syncState, e);
                }
            });
        }
        if (isApiCallRequired) {
            try {
                this.mNextThread.start();
            }
            catch (IllegalThreadStateException e) {
                Logger.d(e);
            }
        } else {
            this.mNextThread.setSyncState(BackgroundSyncThread.SyncState.FINISHED);
        }
    }

    private synchronized void startPrev(MessageChunk chunk, boolean isApiCallRequired) {
        Logger.d("startPrev, apiRequired : " + isApiCallRequired);
        if (this.mPrevThread == null) {
            this.mPrevThread = new MessageBackgroundSyncThread(this.mChannel, chunk, false, isApiCallRequired);
            this.mPrevThread.setEventListener(new MessageBackgroundSyncEventListener(){

                @Override
                public void onSyncAndWait(BackgroundSyncThread.SyncState syncState, SendBirdException e) {
                    MessageSynchronizer.this.onSyncedAndWait(false, syncState, e);
                }
            });
        }
        if (isApiCallRequired) {
            try {
                this.mPrevThread.start();
            }
            catch (IllegalThreadStateException e) {
                Logger.d(e);
            }
        } else {
            this.mPrevThread.setSyncState(BackgroundSyncThread.SyncState.FINISHED);
        }
    }

    private synchronized void stopNext() {
        Logger.d("thread : " + this.mNextThread);
        if (this.mNextThread != null) {
            this.mNextThread.stopSync();
            this.mNextThread = null;
        }
    }

    private synchronized void stopPrev() {
        Logger.d("thread : " + this.mPrevThread);
        if (this.mPrevThread != null) {
            this.mPrevThread.stopSync();
            this.mPrevThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subscribe(boolean isNext, MessageBackgroundSyncEventListener listener) {
        Logger.d("subscribe. isNext : " + isNext);
        if (isNext) {
            List<MessageBackgroundSyncEventListener> list = this.mNextEventListeners;
            synchronized (list) {
                if (!this.mNextEventListeners.contains(listener)) {
                    this.mNextEventListeners.add(listener);
                }
            }
        }
        List<MessageBackgroundSyncEventListener> list = this.mPrevEventListeners;
        synchronized (list) {
            if (!this.mPrevEventListeners.contains(listener)) {
                this.mPrevEventListeners.add(listener);
            }
        }
    }

    boolean isSyncedOnce() {
        return this.syncedOnce.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void onSyncedAndWait(boolean isNext, BackgroundSyncThread.SyncState syncState, SendBirdException e) {
        Object object;
        Logger.d("onSynced. isNext : " + isNext + ", syncState : " + (Object)((Object)syncState) + ", e : " + (Object)((Object)e) + ", next : " + this.mNextEventListeners.size() + ", prev : " + this.mPrevEventListeners.size());
        ArrayList<MessageBackgroundSyncEventListener> tempListeners = null;
        if (isNext) {
            object = this.mNextEventListeners;
            synchronized (object) {
                if (!this.mNextEventListeners.isEmpty()) {
                    tempListeners = new ArrayList<MessageBackgroundSyncEventListener>(this.mNextEventListeners);
                    this.mNextEventListeners.clear();
                }
            }
        }
        object = this.mPrevEventListeners;
        synchronized (object) {
            if (!this.mPrevEventListeners.isEmpty()) {
                tempListeners = new ArrayList<MessageBackgroundSyncEventListener>(this.mPrevEventListeners);
                this.mPrevEventListeners.clear();
            }
        }
        if (tempListeners != null) {
            for (MessageBackgroundSyncEventListener eventListener : tempListeners) {
                eventListener.onSyncAndWait(syncState, e);
            }
        }
    }

    BaseChannel getChannel() {
        return this.mChannel;
    }

    MessageFilter getFilter() {
        return this.mFilter;
    }

    long getViewpointTimestamp() {
        return this.mViewpointTimestamp;
    }

    public String toString() {
        return "MessageSynchronizer{mNextThread=" + this.mNextThread + ", mPrevThread=" + this.mPrevThread + ", mChannel=" + this.mChannel + ", mFilter=" + this.mFilter + ", mViewpointTimestamp=" + this.mViewpointTimestamp + ", mRetryCounter=" + this.mRetryCounter + ", mPrevEventListeners=" + this.mPrevEventListeners + ", mNextEventListeners=" + this.mNextEventListeners + ", mSyncState=" + (Object)((Object)this.mSyncState) + '}';
    }

    static interface MessageBackgroundSyncEventListener {
        public void onSyncAndWait(BackgroundSyncThread.SyncState var1, SendBirdException var2);
    }
}

