/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.AdminMessage;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.UserMessage;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import com.sendbird.android.shadow.com.google.gson.JsonSyntaxException;
import com.sendbird.syncmanager.HashUtils;
import java.util.ArrayList;
import java.util.List;

public class MessageFilter {
    private BaseChannel.MessageTypeFilter mMessageTypeFilter;
    private String mCustomType;
    private List<String> mSenderUserIds;

    public MessageFilter(BaseChannel.MessageTypeFilter messageTypeFilter, String customType, List<String> senderUserIds) {
        this.mMessageTypeFilter = messageTypeFilter;
        this.mCustomType = customType;
        this.mSenderUserIds = senderUserIds;
        if (this.mCustomType == null) {
            this.mCustomType = "";
        }
        if (this.mSenderUserIds == null) {
            this.mSenderUserIds = new ArrayList<String>();
        }
    }

    MessageFilter(String json) {
        JsonParser parser = new JsonParser();
        try {
            JsonObject obj = parser.parse(json).getAsJsonObject();
            this.mMessageTypeFilter = this.toMessageTypeFilter(obj.get("message_type_filter").getAsString());
            this.mCustomType = obj.get("custom_type").getAsString();
            this.mSenderUserIds = new ArrayList<String>();
            JsonArray array = obj.get("senderUserIds").getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                this.mSenderUserIds.add(array.get(i).getAsString());
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public BaseChannel.MessageTypeFilter getMessageTypeFilter() {
        return this.mMessageTypeFilter;
    }

    public String getCustomType() {
        return this.mCustomType;
    }

    public List<String> getSenderUserIds() {
        return this.mSenderUserIds;
    }

    private String getMessageTypeFilterAsString() {
        switch (this.mMessageTypeFilter) {
            case ALL: {
                return "all";
            }
            case FILE: {
                return "file";
            }
            case ADMIN: {
                return "admin";
            }
            case USER: {
                return "user";
            }
        }
        return "all";
    }

    private BaseChannel.MessageTypeFilter toMessageTypeFilter(String messageTypeFilter) {
        switch (messageTypeFilter) {
            case "all": {
                return BaseChannel.MessageTypeFilter.ALL;
            }
            case "file": {
                return BaseChannel.MessageTypeFilter.FILE;
            }
            case "admin": {
                return BaseChannel.MessageTypeFilter.ADMIN;
            }
            case "user": {
                return BaseChannel.MessageTypeFilter.USER;
            }
        }
        return BaseChannel.MessageTypeFilter.ALL;
    }

    String toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("message_type_filter", this.getMessageTypeFilterAsString());
        jsonObject.addProperty("custom_type", this.mCustomType);
        JsonArray jsonArray = new JsonArray();
        if (this.mSenderUserIds != null) {
            for (String senderUserId : this.mSenderUserIds) {
                jsonArray.add(senderUserId);
            }
        }
        jsonObject.add("senderUserIds", (JsonElement)jsonArray);
        return jsonObject.toString();
    }

    public int hashCode() {
        return HashUtils.generateHashCode(this.mMessageTypeFilter, this.mCustomType, this.mSenderUserIds);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MessageFilter)) {
            return false;
        }
        MessageFilter other = (MessageFilter)obj;
        if (this.mMessageTypeFilter != other.getMessageTypeFilter()) {
            return false;
        }
        if (!this.mCustomType.equals(other.getCustomType())) {
            return false;
        }
        if (this.mSenderUserIds.size() != other.getSenderUserIds().size()) {
            return false;
        }
        for (String senderUserId : this.mSenderUserIds) {
            if (other.getSenderUserIds().contains(senderUserId)) continue;
            return false;
        }
        return true;
    }

    boolean isParent() {
        return !(this.mMessageTypeFilter != BaseChannel.MessageTypeFilter.ALL || this.mCustomType != null && !this.mCustomType.isEmpty() || this.mSenderUserIds != null && !this.mSenderUserIds.isEmpty());
    }

    boolean isValidMessage(BaseMessage message) {
        if (this.mCustomType != null && !this.mCustomType.isEmpty() && !this.mCustomType.equals(message.getCustomType())) {
            return false;
        }
        if (this.mSenderUserIds != null && this.mSenderUserIds.size() != 0) {
            String senderId;
            String string = message instanceof UserMessage ? ((UserMessage)message).getSender().getUserId() : (senderId = message instanceof FileMessage ? ((FileMessage)message).getSender().getUserId() : null);
            if (senderId != null) {
                boolean isSenderExists = false;
                for (String sender : this.mSenderUserIds) {
                    if (!sender.equals(senderId)) continue;
                    isSenderExists = true;
                    break;
                }
                if (!isSenderExists) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return !(this.mMessageTypeFilter == BaseChannel.MessageTypeFilter.USER && !(message instanceof UserMessage) || this.mMessageTypeFilter == BaseChannel.MessageTypeFilter.FILE && !(message instanceof FileMessage)) && (this.mMessageTypeFilter != BaseChannel.MessageTypeFilter.ADMIN || message instanceof AdminMessage);
    }
}

