/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.util.Pair;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.ChannelManager;
import com.sendbird.syncmanager.DBJobTask;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.SharedPreferencesManager;
import com.sendbird.syncmanager.SyncManagerDb;
import com.sendbird.syncmanager.log.Logger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CountDownLatch;

class ChannelChangeLogSync {
    private static ChannelChangeLogSync sInstance;
    private final List<ChannelChangeLogSubscriber> mSubscribers = new ArrayList<ChannelChangeLogSubscriber>();
    private ChannelChangeLogSyncThread mThread;
    private boolean mIsSyncFinished = false;

    private ChannelChangeLogSync() {
    }

    static ChannelChangeLogSync getInstance() {
        if (sInstance == null) {
            sInstance = new ChannelChangeLogSync();
        }
        return sInstance;
    }

    void clear() {
        this.mIsSyncFinished = false;
        this.mSubscribers.clear();
        if (this.mThread != null) {
            this.mThread.stopSync();
            this.mThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subscribe(ChannelChangeLogSubscriber subscriber) {
        List<ChannelChangeLogSubscriber> list = this.mSubscribers;
        synchronized (list) {
            if (this.mSubscribers.contains(subscriber)) {
                return;
            }
            this.mSubscribers.add(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsubscribe(ChannelChangeLogSubscriber subscriber) {
        List<ChannelChangeLogSubscriber> list = this.mSubscribers;
        synchronized (list) {
            this.mSubscribers.remove(subscriber);
        }
    }

    void start(boolean forcedResume) {
        if (!forcedResume && this.mIsSyncFinished) {
            return;
        }
        if (this.mThread == null) {
            this.mThread = new ChannelChangeLogSyncThread();
            this.mThread.start();
        }
    }

    void stop() {
        if (this.mThread != null) {
            this.mThread.stopSync();
            this.mThread = null;
        }
    }

    static interface ChannelChangeLogSubscriber {
        public void onSynced(List<GroupChannel> var1, List<String> var2);
    }

    class ChannelChangeLogSyncThread
    extends Thread {
        boolean mIsStopped = false;

        ChannelChangeLogSyncThread() {
        }

        @Override
        public void run() {
            Logger.d("ChannelChangeLogSyncThread run()");
            while (!this.mIsStopped) {
                final CountDownLatch lock = new CountDownLatch(1);
                String token = SharedPreferencesManager.getInstance().getChannelChangeLogToken();
                SendBird.GetMyGroupChannelChangeLogsHandler handler = new SendBird.GetMyGroupChannelChangeLogsHandler(){

                    public void onResult(final List<GroupChannel> upsertedChannels, final List<String> deletedChannelUrls, boolean hasMore, final String token, SendBirdException e) {
                        Logger.d("ChannelChangeLogSyncThread onResult(). updatedChannels = " + (upsertedChannels == null ? "null" : Integer.valueOf(upsertedChannels.size())) + ", deletedChannelUrls = " + (deletedChannelUrls == null ? "null" : Integer.valueOf(deletedChannelUrls.size())) + ", hasMore = " + hasMore + ", token = " + token + ", e = " + e);
                        if (e != null) {
                            ChannelChangeLogSyncThread.this.mIsStopped = true;
                            lock.countDown();
                            return;
                        }
                        if (!hasMore) {
                            ChannelChangeLogSync.this.mIsSyncFinished = true;
                            ChannelChangeLogSyncThread.this.mIsStopped = true;
                        }
                        SyncManagerDb.addTask(new DBJobTask<List<GroupChannel>>(){

                            @Override
                            public List<GroupChannel> call(String userId) throws Exception {
                                if (upsertedChannels != null) {
                                    for (GroupChannel updatedChannel : upsertedChannels) {
                                        ChannelManager.getInstance().checkMessageOffset(userId, updatedChannel);
                                    }
                                }
                                List updatedChannels = null;
                                if (upsertedChannels != null) {
                                    Pair<List<GroupChannel>, List<GroupChannel>> upsertChannels = ChannelManager.getInstance().getContainer().upsertChannels(userId, upsertedChannels);
                                    updatedChannels = upsertChannels == null ? null : (List)upsertChannels.second;
                                }
                                ChannelManager.getInstance().getContainer().removeChannelUrls(userId, deletedChannelUrls);
                                DatabaseController.getInstance().removeAllMessagesInChannels(userId, deletedChannelUrls);
                                return updatedChannels;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void onResult(List<GroupChannel> updatedChannels, SendBirdException e) {
                                if (e == null) {
                                    SharedPreferencesManager.getInstance().setChannelChangeLogToken(token);
                                    List list = ChannelChangeLogSync.this.mSubscribers;
                                    synchronized (list) {
                                        for (ChannelChangeLogSubscriber subscriber : ChannelChangeLogSync.this.mSubscribers) {
                                            subscriber.onSynced(upsertedChannels, deletedChannelUrls);
                                        }
                                    }
                                    if (updatedChannels != null) {
                                        MessageManager.getInstance().broadcastChannelUpdated(updatedChannels);
                                    }
                                    MessageManager.getInstance().broadcastChannelRemoved(deletedChannelUrls);
                                }
                                lock.countDown();
                            }
                        });
                    }
                };
                if (token == null) {
                    long localTimestamp = Calendar.getInstance().getTimeInMillis();
                    SendBird.getMyGroupChannelChangeLogsByTimestamp((long)localTimestamp, null, (boolean)true, (SendBird.GetMyGroupChannelChangeLogsHandler)handler);
                } else {
                    SendBird.getMyGroupChannelChangeLogsByToken((String)token, null, (boolean)true, (SendBird.GetMyGroupChannelChangeLogsHandler)handler);
                }
                try {
                    lock.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        void stopSync() {
            this.mIsStopped = true;
        }
    }
}

