/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.text.TextUtils;
import com.sendbird.syncmanager.DBJobTask;
import com.sendbird.syncmanager.NewTaskQueue;
import com.sendbird.syncmanager.SendBirdSyncManager;
import com.sendbird.syncmanager.SyncManagerError;
import com.sendbird.syncmanager.log.Logger;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

class SyncManagerDb {
    private final NewTaskQueue dbTaskQueue = new NewTaskQueue(Executors.newFixedThreadPool(10));

    public static SyncManagerDb getInstance() {
        return SyncManagerDbHolder.INSTANCE;
    }

    private SyncManagerDb() {
    }

    static <T> Future<T> addTask(DBJobTask<T> task) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (TextUtils.isEmpty((CharSequence)userId)) {
            task.onResult(null, SyncManagerError.getException(810100));
            return null;
        }
        return SyncManagerDb.getInstance().dbTaskQueue.addTask(task.getCallable(userId));
    }

    static <T> T addTaskAndGet(DBJobTask<T> task) {
        try {
            Future<T> future = SyncManagerDb.addTask(task);
            if (future != null) {
                return future.get();
            }
        }
        catch (Exception e) {
            Logger.d(e);
        }
        return null;
    }

    private static class SyncManagerDbHolder {
        private static final SyncManagerDb INSTANCE = new SyncManagerDb();

        private SyncManagerDbHolder() {
        }
    }
}

