/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseMessage;
import com.sendbird.syncmanager.Consumer;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageCollection;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.Collection;
import java.util.List;

interface PmManager {
    public void sendAllEvents(CompletionHandler var1);

    public void destroy();

    public void add(List<BaseMessage> var1, BaseMessage var2, Runnable var3);

    public void remove(BaseMessage var1, Consumer<BaseMessage> var2);

    public void removeMultiple(Collection<? extends BaseMessage> var1, Consumer<? super List<BaseMessage>> var2);

    public void clear(MessageCollection var1, Consumer<? super Collection<BaseMessage>> var2);

    public void onChunkUpserted(List<? extends BaseMessage> var1, SyncFinished var2);

    public void onEmptyChunkCreated(long var1, SyncFinished var3);

    public void onChannelRemoved();

    public static enum SyncFinished {
        PREV,
        NEXT,
        BOTH,
        NONE;


        static SyncFinished from(MessageChunk messageChunk) {
            if (messageChunk.isFromDB) {
                return NONE;
            }
            if (messageChunk.isStartSynced() && messageChunk.isEndSynced()) {
                return BOTH;
            }
            if (messageChunk.isStartSynced()) {
                return PREV;
            }
            if (messageChunk.isEndSynced()) {
                return NEXT;
            }
            return NONE;
        }
    }
}

