/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.database.Cursor;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.SendBird;
import com.sendbird.syncmanager.HashUtils;
import com.sendbird.syncmanager.SyncManagerUtils;
import java.util.List;

final class PendingMessageWrapper {
    private final BaseMessage pendingMessage;
    private final long startAt;
    private final long endAt;
    private final int hashCode = HashUtils.generateHashCode(this.getRequestId(), this.getStartAt(), this.getEndAt());

    PendingMessageWrapper(BaseMessage pendingMessage, List<BaseMessage> chunkMessages) {
        this.pendingMessage = pendingMessage;
        if (chunkMessages.isEmpty()) {
            this.startAt = SendBird.getLastConnectedAt();
        } else {
            BaseMessage last = chunkMessages.get(chunkMessages.size() - 1);
            this.startAt = Math.max(SendBird.getLastConnectedAt(), last.getCreatedAt());
        }
        this.endAt = Long.MAX_VALUE;
    }

    static PendingMessageWrapper from(Cursor cursor) {
        byte[] serializedData = cursor.getBlob(cursor.getColumnIndex("serialized_data"));
        if (null == serializedData) {
            return null;
        }
        BaseMessage baseMessage = BaseMessage.buildFromSerializedData((byte[])serializedData);
        long startAt = cursor.getLong(cursor.getColumnIndex("start_at"));
        long endAt = cursor.getLong(cursor.getColumnIndex("end_at"));
        return new PendingMessageWrapper(baseMessage, startAt, endAt);
    }

    private PendingMessageWrapper(BaseMessage pendingMessage, long startAt, long endAt) {
        this.pendingMessage = pendingMessage;
        this.startAt = startAt;
        this.endAt = endAt;
    }

    String getRequestId() {
        return SyncManagerUtils.getRequestId(this.pendingMessage);
    }

    boolean hasOverlapWith(long chunkStartAt, long chunkEndAt) {
        return chunkStartAt <= this.getEndAt() && this.getStartAt() <= chunkEndAt;
    }

    BaseMessage getPendingMessage() {
        return this.pendingMessage;
    }

    long getStartAt() {
        return this.startAt;
    }

    long getEndAt() {
        return this.endAt;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PendingMessageWrapper)) {
            return false;
        }
        PendingMessageWrapper other = (PendingMessageWrapper)obj;
        return this.getStartAt() == other.getStartAt() && this.getEndAt() == other.getEndAt() && SyncManagerUtils.equals(this.getRequestId(), other.getRequestId());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "PendingMessageWrapper{message=" + this.pendingMessage.getMessage() + ", startAt=" + this.startAt + ", endAt=" + this.endAt + ", pendingMessage=" + this.pendingMessage + '}';
    }
}

