/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public final class NewTaskQueue {
    private final ExecutorService executorService;

    public NewTaskQueue(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public <T> Future<T> addTask(Callable<T> callable) {
        if (!this.isEnable()) {
            throw new RuntimeException("Task has been terminated");
        }
        return this.executorService.submit(callable);
    }

    public void shutdown() {
        if (this.isEnable()) {
            this.executorService.shutdown();
        }
    }

    public List<Runnable> shutdownNow() {
        if (this.isEnable()) {
            return this.executorService.shutdownNow();
        }
        return Collections.emptyList();
    }

    public boolean isEnable() {
        return this.executorService != null && !this.executorService.isShutdown() && !this.executorService.isTerminated();
    }
}

