/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseMessage;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageFilter;
import com.sendbird.syncmanager.log.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class MessageContainer {
    MessageContainer() {
    }

    List<BaseMessage> getMessagesInChunk(String userId, MessageChunk chunk, long ts, boolean isNext, int limit, boolean isInclusive) throws SendBirdException {
        Logger.d("getMessagesInChunk(). chunkId = " + chunk.getChunkId() + ", ts = " + ts + ", inclusive : " + isInclusive + ", isNext = " + isNext);
        ArrayList<BaseMessage> result = new ArrayList<BaseMessage>();
        List<BaseMessage> messages = DatabaseController.getInstance().getMessagesByChunk(userId, chunk);
        if (isNext) {
            for (int i = 0; i < messages.size(); ++i) {
                BaseMessage message = messages.get(i);
                if (message.getCreatedAt() <= ts && (!isInclusive || message.getCreatedAt() != ts) || !chunk.isMessageInChunk(message)) continue;
                if (result.size() >= limit && message.getCreatedAt() != ts) {
                    BaseMessage previousMessage;
                    BaseMessage baseMessage = previousMessage = result.isEmpty() ? null : (BaseMessage)result.get(result.size() - 1);
                    if (previousMessage == null || previousMessage.getCreatedAt() != message.getCreatedAt()) break;
                }
                result.add(message);
            }
        } else {
            for (int i = messages.size() - 1; i >= 0; --i) {
                BaseMessage message = messages.get(i);
                if (message.getCreatedAt() >= ts && (!isInclusive || message.getCreatedAt() != ts) || !chunk.isMessageInChunk(message)) continue;
                if (result.size() >= limit && message.getCreatedAt() != ts) {
                    BaseMessage nextMessage;
                    BaseMessage baseMessage = nextMessage = result.isEmpty() ? null : (BaseMessage)result.get(result.size() - 1);
                    if (nextMessage == null || nextMessage.getCreatedAt() != message.getCreatedAt()) break;
                }
                result.add(message);
            }
            Collections.reverse(result);
        }
        return result;
    }

    List<BaseMessage> getSucceededMessagesByTimestamp(String userId, String channelUrl, long ts, MessageFilter filter, int limit, boolean isNext, boolean isInclusive) throws SendBirdException {
        Logger.d("getSucceededMessagesByTimestamp(). ts = " + ts + ", isNext = " + isNext);
        ArrayList<BaseMessage> result = new ArrayList<BaseMessage>();
        List<BaseMessage> messages = DatabaseController.getInstance().getSucceededMessagesByTimestamp(userId, channelUrl, ts, isNext);
        if (isNext) {
            for (int i = 0; i < messages.size(); ++i) {
                BaseMessage message = messages.get(i);
                if (message.getCreatedAt() <= ts && (!isInclusive || message.getCreatedAt() != ts) || !filter.isValidMessage(message)) continue;
                if (result.size() >= limit && message.getCreatedAt() != ts) {
                    BaseMessage previousMessage;
                    BaseMessage baseMessage = previousMessage = result.isEmpty() ? null : (BaseMessage)result.get(result.size() - 1);
                    if (previousMessage == null || previousMessage.getCreatedAt() != message.getCreatedAt()) break;
                }
                result.add(message);
            }
        } else {
            for (int i = messages.size() - 1; i >= 0; --i) {
                BaseMessage message = messages.get(i);
                if (message.getCreatedAt() >= ts && (!isInclusive || message.getCreatedAt() != ts) || !filter.isValidMessage(message)) continue;
                if (result.size() >= limit && message.getCreatedAt() != ts) {
                    BaseMessage nextMessage;
                    BaseMessage baseMessage = nextMessage = result.isEmpty() ? null : (BaseMessage)result.get(result.size() - 1);
                    if (nextMessage == null || nextMessage.getCreatedAt() != message.getCreatedAt()) break;
                }
                result.add(message);
            }
            Collections.reverse(result);
        }
        return result;
    }
}

