/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.util.Pair;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.Sender;
import com.sendbird.android.User;
import com.sendbird.android.UserMessage;
import com.sendbird.syncmanager.BackgroundSyncThread;
import com.sendbird.syncmanager.ChannelManager;
import com.sendbird.syncmanager.Consumer;
import com.sendbird.syncmanager.DBJobTask;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.FailedMessageDispatcher;
import com.sendbird.syncmanager.FailedMessageEventActionReason;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageEventAction;
import com.sendbird.syncmanager.MessageFilter;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.MessageSynchronizer;
import com.sendbird.syncmanager.PendingMessageManagerImpl;
import com.sendbird.syncmanager.PmManager;
import com.sendbird.syncmanager.SendBirdSyncManager;
import com.sendbird.syncmanager.SharedPreferencesManager;
import com.sendbird.syncmanager.SyncManagerDb;
import com.sendbird.syncmanager.SyncManagerError;
import com.sendbird.syncmanager.SyncManagerUtils;
import com.sendbird.syncmanager.handler.CompletionHandler;
import com.sendbird.syncmanager.handler.FetchCompletionHandler;
import com.sendbird.syncmanager.handler.MessageCollectionCreateHandler;
import com.sendbird.syncmanager.handler.MessageCollectionHandler;
import com.sendbird.syncmanager.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

public class MessageCollection {
    private GroupChannel mChannel;
    private MessageFilter mFilter;
    private long mViewpointTimestamp;
    private int mLimit = 20;
    private List<BaseMessage> chunkMessageList;
    private List<BaseMessage> tempMessageList;
    private PmManager mPendingMessageManager;
    private List<BaseMessage> mFailedMessages;
    private MessageCollectionHandler mMessageCollectionHandler;
    private ExecutorService mExecutorService;
    private MessageSynchronizer mSynchronizer;
    private boolean mIsNextLoading = false;
    private boolean mIsPrevLoading = false;
    private boolean mIsApplyingChangeLog = false;
    private boolean mIsCollectionRemoved = false;
    private final Object mFailedMessagesLock = new Object();

    public MessageCollection(GroupChannel channel, MessageFilter filter, long viewpointTimestamp) {
        this.mChannel = channel;
        this.mFilter = filter;
        this.mViewpointTimestamp = viewpointTimestamp;
        this.chunkMessageList = new ArrayList<BaseMessage>();
        this.tempMessageList = new ArrayList<BaseMessage>();
        this.mFailedMessages = new ArrayList<BaseMessage>();
        this.mSynchronizer = new MessageSynchronizer((BaseChannel)channel, filter, viewpointTimestamp);
        this.mExecutorService = Executors.newSingleThreadExecutor();
        this.mPendingMessageManager = new PendingMessageManagerImpl(this);
        MessageManager.getInstance().addMessageCollection(this);
        FailedMessageDispatcher.getInstance().createQueue(this.mChannel);
        this.resumeSync();
    }

    public static void create(final String channelUrl, final MessageFilter filter, final long viewpointTimestamp, final MessageCollectionCreateHandler handler) {
        Logger.d("create(). channelUrl = " + channelUrl + ", filter = " + filter + ", viewpointTimestamp = " + viewpointTimestamp);
        SyncManagerDb.addTask(new DBJobTask<GroupChannel>(){

            @Override
            public GroupChannel call(String userId) throws Exception {
                return ChannelManager.getInstance().getContainer().getChannel(userId, channelUrl);
            }

            @Override
            public void onResult(final GroupChannel channel, SendBirdException e) {
                if (channel == null) {
                    Logger.d("create(). failed to get local channel");
                    ChannelManager.getChannel(channelUrl, new GroupChannel.GroupChannelGetHandler(){

                        public void onResult(final GroupChannel groupChannel, final SendBirdException e) {
                            if (e != null) {
                                SendBirdSyncManager.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (handler != null) {
                                            handler.onResult(null, e);
                                        }
                                    }
                                });
                                return;
                            }
                            SendBirdSyncManager.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (handler != null) {
                                        handler.onResult(new MessageCollection(groupChannel, filter, viewpointTimestamp), null);
                                    }
                                }
                            });
                        }
                    });
                } else {
                    SendBirdSyncManager.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (handler != null) {
                                handler.onResult(new MessageCollection(channel, filter, viewpointTimestamp), null);
                            }
                        }
                    });
                }
            }
        });
    }

    public void remove() {
        Logger.d("remove(), channel url = " + this.mChannel.getUrl());
        MessageManager.getInstance().removeMessageCollection(this);
        this.removeInternal();
    }

    void removeInternal() {
        this.mIsCollectionRemoved = true;
        FailedMessageDispatcher.getInstance().removeQueue(this.mChannel.getUrl());
        this.mSynchronizer.stop();
        this.mExecutorService.shutdownNow();
        this.mPendingMessageManager.destroy();
        this.setCollectionHandler(null);
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public void setCollectionHandler(MessageCollectionHandler handler) {
        this.mMessageCollectionHandler = handler;
    }

    public void fetch(final Direction direction, final CompletionHandler handler) {
        Logger.d("fetch(). direction = " + (Object)((Object)direction));
        this.fetchSucceededMessages(direction, new FetchCompletionHandler(){

            @Override
            public void onCompleted(boolean hasMore, SendBirdException e) {
                Logger.d("fetch onCompleted(). direction = " + (Object)((Object)direction) + ", hasMore : " + hasMore);
                if (handler != null) {
                    handler.onCompleted(e);
                }
            }
        });
    }

    public void fetchSucceededMessages(final Direction direction, final FetchCompletionHandler handler) {
        Logger.d("direction : " + (Object)((Object)direction) + ", nextLoading : " + this.mIsNextLoading + ", prevLoading : " + this.mIsPrevLoading);
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                if (direction == Direction.PREVIOUS) {
                    if (MessageCollection.this.mIsPrevLoading) {
                        SendBirdSyncManager.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                if (handler != null) {
                                    handler.onCompleted(false, SyncManagerError.getException(810200));
                                }
                            }
                        });
                        return;
                    }
                    MessageCollection.this.mIsPrevLoading = true;
                    MessageCollection.this.load(false, MessageCollection.this.mLimit, MessageCollection.this.mSynchronizer.getSyncState(false), handler);
                } else if (direction == Direction.NEXT) {
                    if (MessageCollection.this.mIsNextLoading) {
                        SendBirdSyncManager.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                if (handler != null) {
                                    handler.onCompleted(false, SyncManagerError.getException(810200));
                                }
                            }
                        });
                        return;
                    }
                    MessageCollection.this.mIsNextLoading = true;
                    MessageCollection.this.load(true, MessageCollection.this.mLimit, MessageCollection.this.mSynchronizer.getSyncState(true), handler);
                }
            }
        });
    }

    public void fetchAllNextMessages(final FetchCompletionHandler completionHandler) {
        Logger.d("fetchAllNextMessages()");
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                if (MessageCollection.this.mIsNextLoading) {
                    SendBirdSyncManager.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (completionHandler != null) {
                                completionHandler.onCompleted(false, SyncManagerError.getException(810200));
                            }
                        }
                    });
                    return;
                }
                MessageCollection.this.mIsNextLoading = true;
                MessageCollection.this.load(true, Integer.MAX_VALUE, MessageCollection.this.mSynchronizer.getSyncState(true), completionHandler);
            }
        });
    }

    public void fetchFailedMessages(final CompletionHandler handler) {
        Logger.d("fetchFailedMessages().");
        SyncManagerDb.addTask(new DBJobTask<Pair<List<BaseMessage>, List<BaseMessage>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Pair<List<BaseMessage>, List<BaseMessage>> call(String userId) throws Exception {
                List<BaseMessage> failedMessages = FailedMessageDispatcher.getInstance().loadFailedMessages(userId, MessageCollection.this.mChannel.getUrl(), MessageCollection.this.mFilter);
                Logger.d("fetchedFailedMessages : " + (failedMessages == null ? -1 : failedMessages.size()));
                if (failedMessages != null && failedMessages.size() > 0) {
                    ArrayList<BaseMessage> insertedFailedMessageList = new ArrayList<BaseMessage>(failedMessages);
                    ArrayList<BaseMessage> deletedFailedMessageList = new ArrayList<BaseMessage>();
                    Object object = MessageCollection.this.mFailedMessagesLock;
                    synchronized (object) {
                        Iterator fmIt = MessageCollection.this.mFailedMessages.iterator();
                        while (fmIt.hasNext()) {
                            BaseMessage prevFailedMessage = (BaseMessage)fmIt.next();
                            String prevRequestId = SyncManagerUtils.getRequestId(prevFailedMessage);
                            boolean found = false;
                            Iterator it = insertedFailedMessageList.iterator();
                            while (it.hasNext()) {
                                BaseMessage insertedFailedMessage = (BaseMessage)it.next();
                                if (prevRequestId.length() <= 0 || !prevRequestId.equals(SyncManagerUtils.getRequestId(insertedFailedMessage))) continue;
                                it.remove();
                                found = true;
                                break;
                            }
                            if (found) continue;
                            deletedFailedMessageList.add(prevFailedMessage);
                            fmIt.remove();
                        }
                        MessageCollection.this.mFailedMessages.addAll(insertedFailedMessageList);
                    }
                    return new Pair(insertedFailedMessageList, deletedFailedMessageList);
                }
                return null;
            }

            @Override
            public void onResult(Pair<List<BaseMessage>, List<BaseMessage>> result, final SendBirdException e) {
                if (result != null) {
                    List insertedFailedMessages = (List)result.first;
                    List deletedFailedMessages = (List)result.second;
                    MessageCollection.this.onFailedMessageEvent(deletedFailedMessages, MessageEventAction.REMOVE, FailedMessageEventActionReason.REMOVE_UNKNOWN);
                    MessageCollection.this.onFailedMessageEvent(insertedFailedMessages, MessageEventAction.INSERT, null);
                }
                SendBirdSyncManager.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (handler != null) {
                            handler.onCompleted(e);
                        }
                    }
                });
            }
        });
    }

    public void fetchPendingMessages(CompletionHandler handler) {
        this.mPendingMessageManager.sendAllEvents(handler);
    }

    public void resetViewpointTimestamp(long viewpointTimestamp) {
        Logger.d("resetViewpointTimestamp(). viewpointTimestamp = " + viewpointTimestamp);
        this.mViewpointTimestamp = viewpointTimestamp;
        this.mSynchronizer.stop();
        this.mSynchronizer = new MessageSynchronizer((BaseChannel)this.mChannel, this.mFilter, this.mViewpointTimestamp);
        this.mSynchronizer.start();
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                MessageCollection.this.tempMessageList.clear();
                MessageCollection.this.chunkMessageList.clear();
            }
        });
        this.onMessageEvent(new ArrayList<BaseMessage>(), MessageEventAction.CLEAR);
        this.onSucceededMessageEvent(new ArrayList<BaseMessage>(), MessageEventAction.CLEAR);
    }

    public synchronized void appendMessage(final BaseMessage message) {
        if (message == null) {
            Logger.d("appendMessage(). given message is null");
            return;
        }
        if (!this.isMyMessage(message)) {
            Logger.d("appendMessage(). given message is not my message");
            return;
        }
        Logger.d("appendMessage(). message id = " + message.getMessageId());
        if (message.getMessageId() == 0L) {
            if (message instanceof UserMessage) {
                if (((UserMessage)message).getRequestState() == UserMessage.RequestState.PENDING) {
                    if (!this.containsFailedMessage(message)) {
                        this.addPendingMessage(message);
                    }
                } else if (((UserMessage)message).getRequestState() == UserMessage.RequestState.FAILED) {
                    this.appendFailedMessage(message);
                }
            } else {
                this.addPendingMessage(message);
            }
        } else {
            this.removePendingMessage(message, new Runnable(){

                @Override
                public void run() {
                    SyncManagerDb.addTaskAndGet(new DBJobTask<List<String>>(){

                        @Override
                        public List<String> call(String userId) throws Exception {
                            List<String> requestIds = FailedMessageDispatcher.getInstance().removeMessages(userId, message);
                            DatabaseController.getInstance().upsertSucceededMessages(userId, Collections.singletonList(message), true);
                            return requestIds;
                        }

                        @Override
                        public void onResult(List<String> requestIds, SendBirdException e) {
                            MessageManager.getInstance().broadcastFailedMessagesDeleted(message.getChannelUrl(), requestIds, FailedMessageEventActionReason.REMOVE_RESEND_SUCCEEDED);
                            MessageManager.getInstance().broadcastSucceededMessageInserted(message.getChannelUrl(), message);
                        }
                    });
                }
            });
        }
    }

    void appendFailedMessage(final BaseMessage message) {
        if (this.containsFailedMessage(message)) {
            return;
        }
        this.removePendingMessage(message, new Runnable(){

            @Override
            public void run() {
                SyncManagerDb.addTaskAndGet(new DBJobTask<Pair<Pair<List<BaseMessage>, List<BaseMessage>>, List<String>>>(){

                    @Override
                    public Pair<Pair<List<BaseMessage>, List<BaseMessage>>, List<String>> call(String userId) throws Exception {
                        Pair<List<BaseMessage>, List<BaseMessage>> result = FailedMessageDispatcher.getInstance().upsertMessages(userId, message.getChannelUrl(), Arrays.asList(message));
                        List<String> removedRequestIds = FailedMessageDispatcher.getInstance().removeExceedingMaxCount(userId, message.getChannelUrl());
                        return new Pair(result, removedRequestIds);
                    }

                    @Override
                    public void onResult(Pair<Pair<List<BaseMessage>, List<BaseMessage>>, List<String>> result, SendBirdException e) {
                        if (result != null) {
                            Pair upsertedMessages = (Pair)result.first;
                            List removedRequestIds = (List)result.second;
                            MessageManager.getInstance().broadcastFailedMessagesInserted(message.getChannelUrl(), (List)upsertedMessages.first);
                            MessageManager.getInstance().broadcastFailedMessagesUpdated(message.getChannelUrl(), (List)upsertedMessages.second, FailedMessageEventActionReason.NONE);
                            MessageManager.getInstance().broadcastFailedMessagesDeleted(message.getChannelUrl(), removedRequestIds, FailedMessageEventActionReason.REMOVE_EXCEEDED_MAX_COUNT);
                        }
                    }
                });
            }
        });
    }

    void onPendingMessagesFailed(final Collection<BaseMessage> messages) {
        Collection<BaseMessage> newFailedMessages = this.getNewFailedMessages(messages);
        if (newFailedMessages.isEmpty()) {
            return;
        }
        SyncManagerDb.addTaskAndGet(new DBJobTask<Pair<Pair<List<BaseMessage>, List<BaseMessage>>, List<String>>>(){

            @Override
            public Pair<Pair<List<BaseMessage>, List<BaseMessage>>, List<String>> call(String userId) throws Exception {
                Pair<List<BaseMessage>, List<BaseMessage>> result = FailedMessageDispatcher.getInstance().upsertMessages(userId, MessageCollection.this.getChannelUrl(), messages);
                List<String> removedRequestIds = FailedMessageDispatcher.getInstance().removeExceedingMaxCount(userId, MessageCollection.this.getChannelUrl());
                return new Pair(result, removedRequestIds);
            }

            @Override
            public void onResult(Pair<Pair<List<BaseMessage>, List<BaseMessage>>, List<String>> result, SendBirdException e) {
                if (result != null) {
                    Pair upsertedMessages = (Pair)result.first;
                    List removedRequestIds = (List)result.second;
                    MessageManager.getInstance().broadcastFailedMessagesInserted(MessageCollection.this.getChannelUrl(), (List)upsertedMessages.first);
                    MessageManager.getInstance().broadcastFailedMessagesUpdated(MessageCollection.this.getChannelUrl(), (List)upsertedMessages.second, FailedMessageEventActionReason.NONE);
                    MessageManager.getInstance().broadcastFailedMessagesDeleted(MessageCollection.this.getChannelUrl(), removedRequestIds, FailedMessageEventActionReason.REMOVE_EXCEEDED_MAX_COUNT);
                }
            }
        });
    }

    public void updateMessage(final BaseMessage message) {
        if (message == null) {
            Logger.d("updateMessage(). given message is null");
            return;
        }
        if (!this.isMyMessage(message)) {
            Logger.d("deleteMessage(). given message is not my message");
            return;
        }
        Logger.d("updateMessage. message id = " + message.getMessageId());
        if (message.getMessageId() == 0L) {
            return;
        }
        SyncManagerDb.addTaskAndGet(new DBJobTask<Void>(){

            @Override
            public Void call(String userId) throws Exception {
                DatabaseController.getInstance().upsertSucceededMessages(userId, Collections.singletonList(message), true);
                return null;
            }

            @Override
            public void onResult(Void result, SendBirdException e) {
                MessageManager.getInstance().broadcastSucceededMessageUpdated(message.getChannelUrl(), new ArrayList<BaseMessage>(Collections.singletonList(message)));
            }
        });
    }

    public void deleteMessage(final BaseMessage message) {
        if (message == null) {
            Logger.d("deleteMessage(). given message is null");
            return;
        }
        if (!this.isMyMessage(message)) {
            Logger.d("deleteMessage(). given message is not my message");
            return;
        }
        Logger.d("deleteMessage. message id = " + message.getMessageId());
        if (message.getMessageId() == 0L) {
            if (message.getSendingStatus() == BaseMessage.SendingStatus.PENDING) {
                this.removePendingMessage(message, null);
            } else if (SyncManagerUtils.getRequestState(message) == UserMessage.RequestState.FAILED) {
                this.removePendingMessage(message, new Runnable(){

                    @Override
                    public void run() {
                        SyncManagerDb.addTaskAndGet(new DBJobTask<List<String>>(){

                            @Override
                            public List<String> call(String userId) throws Exception {
                                return FailedMessageDispatcher.getInstance().removeMessages(userId, message);
                            }

                            @Override
                            public void onResult(List<String> result, SendBirdException e) {
                                MessageManager.getInstance().broadcastFailedMessagesDeleted(message.getChannelUrl(), result, FailedMessageEventActionReason.REMOVE_MANUAL_ACTION);
                            }
                        });
                    }
                });
            }
        } else {
            SyncManagerDb.addTaskAndGet(new DBJobTask<Void>(){

                @Override
                public Void call(String userId) throws Exception {
                    List<BaseMessage> deletedMessages = DatabaseController.getInstance().removeSucceededMessages(userId, Collections.singletonList(message.getMessageId()));
                    MessageManager.getInstance().updateMessageChunkForDeletedMessages(userId, deletedMessages);
                    return null;
                }

                @Override
                public void onResult(Void result, SendBirdException e) {
                    MessageManager.getInstance().broadcastSucceededMessageDeleted(MessageCollection.this.mChannel.getUrl(), new ArrayList<Long>(Collections.singletonList(message.getMessageId())));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFailedMessage(BaseMessage message) {
        if (this.containsFailedMessage(message)) {
            return;
        }
        Object object = this.mFailedMessagesLock;
        synchronized (object) {
            this.mFailedMessages.add(message);
        }
        this.onMessageEvent(Arrays.asList(message), MessageEventAction.INSERT);
        this.onFailedMessageEvent(Arrays.asList(message), MessageEventAction.INSERT, null);
    }

    private void addPendingMessage(final BaseMessage message) {
        Logger.d(message.getMessage());
        this.mPendingMessageManager.add(this.chunkMessageList, message, new Runnable(){

            @Override
            public void run() {
                MessageCollection.this.sendPendingMessageAddedEvents(Arrays.asList(message));
            }
        });
    }

    void sendPendingMessageAddedEvents(List<BaseMessage> element) {
        this.onMessageEvent(element, MessageEventAction.INSERT);
        this.onPendingMessageEvent(element, MessageEventAction.INSERT);
    }

    public GroupChannel getChannel() {
        return this.mChannel;
    }

    public int getMessageCount() {
        return this.chunkMessageList.size() + this.tempMessageList.size();
    }

    public boolean contains(BaseMessage message) {
        if (message == null || message.getMessageId() == 0L) {
            return false;
        }
        List<BaseMessage> succeededMessages = this.getSucceededMessages();
        for (BaseMessage succeededMessage : succeededMessages) {
            if (succeededMessage.getMessageId() != message.getMessageId()) continue;
            return true;
        }
        return false;
    }

    public void handleSendMessageResponse(BaseMessage message, SendBirdException e) {
        if (message == null) {
            Logger.d("handleSendMessageResponse(). given message is null");
            return;
        }
        if (e != null) {
            switch (SendBirdSyncManager.getInstance().getOptions().getMessageResendPolicy()) {
                case NONE: {
                    this.deleteMessage(message);
                    break;
                }
                case MANUAL: 
                case AUTOMATIC: {
                    if (message instanceof UserMessage) {
                        this.appendMessage(message);
                        break;
                    }
                    this.deleteMessage(message);
                }
            }
            return;
        }
        this.appendMessage(message);
    }

    String getChannelUrl() {
        return this.mChannel.getUrl();
    }

    MessageFilter getFilter() {
        return this.mFilter;
    }

    long getViewpointTimestamp() {
        return this.mViewpointTimestamp;
    }

    List<BaseMessage> getSucceededMessages() {
        ArrayList<BaseMessage> succeededMessages = new ArrayList<BaseMessage>();
        succeededMessages.addAll(this.chunkMessageList);
        succeededMessages.addAll(this.tempMessageList);
        return succeededMessages;
    }

    void onSucceededMessagesInserted(final BaseMessage insertedMessage) {
        Logger.d("inserting : " + insertedMessage);
        if (insertedMessage.getMessageId() == 0L || this.isMessageInLoadedChunkMessage(insertedMessage.getMessageId())) {
            return;
        }
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                boolean isViewEmpty;
                ArrayList<BaseMessage> insertedMessageList = new ArrayList<BaseMessage>();
                insertedMessageList.add(insertedMessage);
                boolean bl = isViewEmpty = MessageCollection.this.chunkMessageList.isEmpty() && MessageCollection.this.tempMessageList.isEmpty();
                if (isViewEmpty) {
                    MessageCollection.this.addToTempMessages(insertedMessageList);
                    MessageCollection.this.onMessageEvent(insertedMessageList, MessageEventAction.INSERT);
                    MessageCollection.this.onSucceededMessageEvent(insertedMessageList, MessageEventAction.INSERT);
                } else {
                    MessageChunk currentChunk = MessageManager.getInstance().getMessageChunkContainer().getCurrentChunk(MessageCollection.this.mChannel.getUrl(), MessageCollection.this.mFilter, MessageCollection.this.mViewpointTimestamp, MessageCollection.this.mSynchronizer.isSyncedOnce(), true);
                    BackgroundSyncThread.SyncState syncState = MessageCollection.this.mSynchronizer.getSyncState(true);
                    Logger.d("currentChunk : " + (currentChunk == null ? null : currentChunk.getRangeAsString()) + ", syncState : " + (Object)((Object)syncState));
                    if (currentChunk == null) {
                        if (syncState != BackgroundSyncThread.SyncState.RUNNING) {
                            MessageCollection.this.addToTempMessages(insertedMessageList);
                            MessageCollection.this.onMessageEvent(insertedMessageList, MessageEventAction.INSERT);
                            MessageCollection.this.onSucceededMessageEvent(insertedMessageList, MessageEventAction.INSERT);
                        }
                    } else {
                        MessageCollection.this.reSortTempMessages(currentChunk);
                        BaseMessage latestChunkMessage = MessageCollection.this.chunkMessageList.size() > 0 ? (BaseMessage)MessageCollection.this.chunkMessageList.get(MessageCollection.this.chunkMessageList.size() - 1) : null;
                        boolean isLatestChunkMessagesSyncedWithChunk = latestChunkMessage != null && latestChunkMessage.getCreatedAt() >= currentChunk.getEndAt();
                        Logger.d("syncState : " + (Object)((Object)syncState) + ", latestChunk : " + (latestChunkMessage == null ? -1L : latestChunkMessage.getCreatedAt()) + ", chunk : " + currentChunk + ", isLatestChunkMessagesSyncedWithChunk: " + isLatestChunkMessagesSyncedWithChunk + ", chunkSize : " + MessageCollection.this.chunkMessageList.size());
                        if (syncState == BackgroundSyncThread.SyncState.FINISHED && isLatestChunkMessagesSyncedWithChunk) {
                            MessageCollection.this.addToTempMessages(insertedMessageList);
                            MessageCollection.this.onMessageEvent(insertedMessageList, MessageEventAction.INSERT);
                            MessageCollection.this.onSucceededMessageEvent(insertedMessageList, MessageEventAction.INSERT);
                        }
                    }
                }
                MessageCollection.this.checkCapacity(true);
                MessageCollection.this.onNewMessage(insertedMessage);
            }
        });
    }

    void onSucceededMessagesUpdated(final List<BaseMessage> updatedMessages) {
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                ArrayList<BaseMessage> updatedMessageList = new ArrayList<BaseMessage>();
                block0: for (BaseMessage updatedMessage : updatedMessages) {
                    int i;
                    boolean isMessageFound = false;
                    for (i = 0; i < MessageCollection.this.chunkMessageList.size(); ++i) {
                        if (((BaseMessage)MessageCollection.this.chunkMessageList.get(i)).getMessageId() != updatedMessage.getMessageId()) continue;
                        updatedMessageList.add(updatedMessage);
                        MessageCollection.this.chunkMessageList.set(i, updatedMessage);
                        isMessageFound = true;
                        break;
                    }
                    if (isMessageFound) continue;
                    for (i = 0; i < MessageCollection.this.tempMessageList.size(); ++i) {
                        if (((BaseMessage)MessageCollection.this.tempMessageList.get(i)).getMessageId() != updatedMessage.getMessageId()) continue;
                        updatedMessageList.add(updatedMessage);
                        MessageCollection.this.tempMessageList.set(i, updatedMessage);
                        continue block0;
                    }
                }
                MessageCollection.this.onMessageEvent(updatedMessageList, MessageEventAction.UPDATE);
                MessageCollection.this.onSucceededMessageEvent(updatedMessageList, MessageEventAction.UPDATE);
            }
        });
    }

    void removeMessagesBeforeOffset(final long offset) {
        Logger.d("offset : " + offset);
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                BaseMessage message;
                boolean messagesRemoved = false;
                Iterator it = MessageCollection.this.chunkMessageList.iterator();
                while (it.hasNext()) {
                    message = (BaseMessage)it.next();
                    if (message.getCreatedAt() > offset) continue;
                    it.remove();
                    messagesRemoved = true;
                }
                it = MessageCollection.this.tempMessageList.iterator();
                while (it.hasNext()) {
                    message = (BaseMessage)it.next();
                    if (message.getCreatedAt() > offset) continue;
                    it.remove();
                    messagesRemoved = true;
                }
                if (messagesRemoved) {
                    MessageCollection.this.onMessageEvent(new ArrayList(), MessageEventAction.CLEAR);
                    MessageCollection.this.onSucceededMessageEvent(new ArrayList(), MessageEventAction.CLEAR);
                    List<BaseMessage> succeededMessages = MessageCollection.this.getSucceededMessages();
                    SyncManagerUtils.sortMessages(succeededMessages);
                    MessageCollection.this.onMessageEvent(succeededMessages, MessageEventAction.INSERT);
                    MessageCollection.this.onSucceededMessageEvent(succeededMessages, MessageEventAction.INSERT);
                }
            }
        });
    }

    void onSucceededMessagesDeleted(final List<Long> removedMessageIds) {
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                ArrayList<BaseMessage> deletedMessages = new ArrayList<BaseMessage>();
                block0: for (Long messageId : removedMessageIds) {
                    BaseMessage message;
                    boolean isMessageFound = false;
                    Iterator it = MessageCollection.this.chunkMessageList.iterator();
                    while (it.hasNext()) {
                        message = (BaseMessage)it.next();
                        if (message.getMessageId() != messageId.longValue()) continue;
                        deletedMessages.add(message);
                        it.remove();
                        isMessageFound = true;
                        break;
                    }
                    if (isMessageFound) continue;
                    it = MessageCollection.this.tempMessageList.iterator();
                    while (it.hasNext()) {
                        message = (BaseMessage)it.next();
                        if (message.getMessageId() != messageId.longValue()) continue;
                        deletedMessages.add(message);
                        it.remove();
                        continue block0;
                    }
                }
                MessageCollection.this.onMessageEvent(deletedMessages, MessageEventAction.REMOVE);
                MessageCollection.this.onSucceededMessageEvent(deletedMessages, MessageEventAction.REMOVE);
            }
        });
    }

    void onChannelUpdated(final GroupChannel channel) {
        this.mChannel = channel;
        SendBirdSyncManager.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (MessageCollection.this.mMessageCollectionHandler != null) {
                    MessageCollection.this.mMessageCollectionHandler.onChannelUpdated(MessageCollection.this, channel);
                }
            }
        });
    }

    void onChannelRemoved() {
        Logger.d("onChannelRemoved");
        this.runOnSingleThreadPool(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Logger.d("onChannelRemoved - running");
                MessageCollection.this.chunkMessageList.clear();
                MessageCollection.this.tempMessageList.clear();
                MessageCollection.this.mPendingMessageManager.onChannelRemoved();
                Object object = MessageCollection.this.mFailedMessagesLock;
                synchronized (object) {
                    MessageCollection.this.mFailedMessages.clear();
                }
                SendBirdSyncManager.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (MessageCollection.this.mMessageCollectionHandler != null) {
                            MessageCollection.this.mMessageCollectionHandler.onChannelRemoved(MessageCollection.this, MessageCollection.this.mChannel);
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<BaseMessage> getFailedMessages() {
        Object object = this.mFailedMessagesLock;
        synchronized (object) {
            return new ArrayList<BaseMessage>(this.mFailedMessages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFailedMessagesInserted(Collection<BaseMessage> insertedMessages) {
        ArrayList<BaseMessage> insertedFailedMessageList = new ArrayList<BaseMessage>();
        for (BaseMessage insertedMessage : insertedMessages) {
            if (insertedMessage.getMessageId() != 0L || this.containsFailedMessage(insertedMessage)) continue;
            insertedFailedMessageList.add(insertedMessage);
        }
        this.mPendingMessageManager.removeMultiple(insertedFailedMessageList, (Consumer<? super List<BaseMessage>>)new Consumer<List<BaseMessage>>(){

            @Override
            public void accept(List<BaseMessage> messages) {
                MessageCollection.this.onPendingMessagesRemoved(messages);
            }
        });
        Object object = this.mFailedMessagesLock;
        synchronized (object) {
            this.mFailedMessages.addAll(insertedFailedMessageList);
        }
        this.onFailedMessageEvent(insertedFailedMessageList, MessageEventAction.INSERT, FailedMessageEventActionReason.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFailedMessagesUpdated(List<BaseMessage> updatedMessages, FailedMessageEventActionReason reason) {
        ArrayList<BaseMessage> updatedFailedMessageList = new ArrayList<BaseMessage>();
        for (BaseMessage updatedMessage : updatedMessages) {
            Integer index = this.getFailedMessageIndex(updatedMessage);
            if (index == null) continue;
            updatedFailedMessageList.add(updatedMessage);
            Object object = this.mFailedMessagesLock;
            synchronized (object) {
                this.mFailedMessages.set(index, updatedMessage);
            }
        }
        this.onFailedMessageEvent(updatedFailedMessageList, MessageEventAction.UPDATE, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFailedMessagesDeleted(List<String> removedRequestIds, FailedMessageEventActionReason reason) {
        ArrayList<BaseMessage> deletedFailedMessageList = new ArrayList<BaseMessage>();
        Object object = this.mFailedMessagesLock;
        synchronized (object) {
            block3: for (String requestId : removedRequestIds) {
                Iterator<BaseMessage> it = this.mFailedMessages.iterator();
                while (it.hasNext()) {
                    BaseMessage message = it.next();
                    if (requestId == null || requestId.length() <= 0 || !requestId.equals(SyncManagerUtils.getRequestId(message))) continue;
                    deletedFailedMessageList.add(message);
                    it.remove();
                    continue block3;
                }
            }
        }
        this.onFailedMessageEvent(deletedFailedMessageList, MessageEventAction.REMOVE, reason);
    }

    final void onChunkUpserted(MessageChunk messageChunk, List<? extends BaseMessage> chunkMessages) {
        this.mPendingMessageManager.onChunkUpserted(chunkMessages, PmManager.SyncFinished.from(messageChunk));
    }

    final void onEmptyChunkCreated(long timestamp, PmManager.SyncFinished syncFinished) {
        this.mPendingMessageManager.onEmptyChunkCreated(timestamp, syncFinished);
    }

    void resumeSync() {
        this.resumeSync(null);
    }

    void resumeSync(final MessageSynchronizer.MessageBackgroundSyncEventListener eventListener) {
        Logger.d("resumeSync(). eventListener : " + eventListener);
        if (this.mChannel == null) {
            if (eventListener != null) {
                eventListener.onSyncAndWait(this.mSynchronizer.getSyncState(true), null);
            }
            return;
        }
        if (this.mIsApplyingChangeLog) {
            if (eventListener != null) {
                this.mSynchronizer.subscribe(true, eventListener);
            }
            SyncManagerError.getException(810210).printStackTrace();
            return;
        }
        this.applyChangeLog(new CompletionHandler(){

            @Override
            public void onCompleted(SendBirdException e) {
                Logger.d("applyChangeLog onCompleted(). paused : " + SendBirdSyncManager.getInstance().isPaused() + ", e : " + (Object)((Object)e));
                if (!SendBirdSyncManager.getInstance().isPaused()) {
                    if (eventListener != null) {
                        MessageCollection.this.mSynchronizer.subscribe(true, new MessageSynchronizer.MessageBackgroundSyncEventListener(){

                            @Override
                            public void onSyncAndWait(BackgroundSyncThread.SyncState syncState, SendBirdException e) {
                                Logger.d("resumeSync. state : " + (Object)((Object)syncState) + ", e : " + (Object)((Object)e));
                                if (syncState == BackgroundSyncThread.SyncState.FINISHED) {
                                    eventListener.onSyncAndWait(syncState, e);
                                } else if (syncState == BackgroundSyncThread.SyncState.RUNNING) {
                                    MessageCollection.this.mSynchronizer.subscribe(true, this);
                                }
                            }
                        });
                    }
                    MessageCollection.this.mSynchronizer.start();
                }
            }
        });
    }

    void pauseSync() {
        Logger.d("pauseSync()");
        this.mIsApplyingChangeLog = false;
        this.mSynchronizer.stop();
    }

    private void applyChangeLog(final CompletionHandler completionHandler) {
        Logger.d("applyChangeLog()");
        this.mIsApplyingChangeLog = true;
        String token = SharedPreferencesManager.getInstance().getMessageChangeLogToken(this.mChannel.getUrl());
        BaseChannel.GetMessageChangeLogsByTokenHandler handler = new BaseChannel.GetMessageChangeLogsByTokenHandler(){

            public void onResult(final List<BaseMessage> updatedMessages, final List<Long> deletedMessageIds, boolean hasMore, String token, SendBirdException e) {
                Logger.d("updatedMessages = [" + updatedMessages + "], deletedMessageIds = [" + deletedMessageIds + "], hasMore = [" + hasMore + "], token = [" + token + "], e = [" + (Object)((Object)e) + "]");
                if (e != null) {
                    e.printStackTrace();
                    MessageCollection.this.mIsApplyingChangeLog = false;
                    if (completionHandler != null) {
                        completionHandler.onCompleted(e);
                    }
                    return;
                }
                final AtomicReference dbException = new AtomicReference();
                SyncManagerDb.addTaskAndGet(new DBJobTask<Void>(){

                    @Override
                    public Void call(String userId) throws Exception {
                        DatabaseController.getInstance().upsertSucceededMessages(userId, updatedMessages, false);
                        List<BaseMessage> deletedMessages = DatabaseController.getInstance().removeSucceededMessages(userId, deletedMessageIds);
                        MessageManager.getInstance().updateMessageChunkForDeletedMessages(userId, deletedMessages);
                        return null;
                    }

                    @Override
                    public void onResult(Void result, SendBirdException e) {
                        if (e != null) {
                            Logger.d(e);
                            dbException.set(e);
                            return;
                        }
                        MessageManager.getInstance().broadcastSucceededMessageUpdated(MessageCollection.this.mChannel.getUrl(), updatedMessages);
                        MessageManager.getInstance().broadcastSucceededMessageDeleted(MessageCollection.this.mChannel.getUrl(), deletedMessageIds);
                    }
                });
                if (dbException.get() != null) {
                    if (completionHandler != null) {
                        completionHandler.onCompleted((SendBirdException)((Object)dbException.get()));
                    }
                } else {
                    SharedPreferencesManager.getInstance().setMessageChangeLogToken(MessageCollection.this.mChannel.getUrl(), token);
                    if (hasMore) {
                        MessageCollection.this.mChannel.getMessageChangeLogsByToken(token, (BaseChannel.GetMessageChangeLogsByTokenHandler)this);
                    } else {
                        MessageCollection.this.mIsApplyingChangeLog = false;
                        if (completionHandler != null) {
                            completionHandler.onCompleted(null);
                        }
                    }
                }
            }
        };
        if (token == null) {
            this.mChannel.getMessageChangeLogsByTimestamp(0L, true, (BaseChannel.GetMessageChangeLogsHandler)handler);
        } else {
            this.mChannel.getMessageChangeLogsByToken(token, true, handler);
        }
    }

    private synchronized void load(boolean isNext, int limit, BackgroundSyncThread.SyncState initialSyncState, final FetchCompletionHandler handler) {
        Logger.d("isNext = " + isNext + ", limit = " + limit + ", handler : " + handler + ", initialSyncState : " + (Object)((Object)initialSyncState));
        if (this.mSynchronizer.getSyncState(isNext) == BackgroundSyncThread.SyncState.PAUSED) {
            this.mSynchronizer.start();
        }
        List<BaseMessage> messages = null;
        try {
            messages = this.fetchMessagesFromDb(isNext, limit);
            Logger.d("isNext : " + isNext + ", messages : " + messages.size());
        }
        catch (SendBirdException e) {
            Logger.d(e);
            SendBirdSyncManager.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onCompleted(false, e);
                    }
                }
            });
            return;
        }
        int chunkMessageCount = this.separateMessagesByChunk(messages);
        ArrayList<BaseMessage> finalMessages = new ArrayList<BaseMessage>(messages);
        Logger.d("chunkMessageCount : " + chunkMessageCount);
        if (chunkMessageCount < limit) {
            this.needsToLoadMore(isNext, limit, finalMessages, initialSyncState, handler);
        } else {
            this.onFetchFinished(isNext, finalMessages, null, null, true);
            SendBirdSyncManager.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onCompleted(true, null);
                    }
                }
            });
        }
    }

    private void needsToLoadMore(boolean isNext, int limit, List<BaseMessage> insertedMessages, BackgroundSyncThread.SyncState initialSyncState, final FetchCompletionHandler handler) {
        boolean isSyncPaused = SendBirdSyncManager.getInstance().isPaused() || !this.mIsApplyingChangeLog && this.mSynchronizer.getSyncState(isNext) == BackgroundSyncThread.SyncState.PAUSED;
        Logger.d("isNext : %b, paused : %b, applyingChangelog : %b, isSyncPaused : %b. initialState : %s, currentState : %s.", new Object[]{isNext, SendBirdSyncManager.getInstance().isPaused(), this.mIsApplyingChangeLog, isSyncPaused, initialSyncState, this.mSynchronizer.getSyncState(isNext)});
        if (isSyncPaused || initialSyncState == BackgroundSyncThread.SyncState.FINISHED && insertedMessages.isEmpty()) {
            this.onFetchFinished(isNext, insertedMessages, null, null, true);
            SendBirdSyncManager.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onCompleted(false, null);
                    }
                }
            });
        } else {
            this.onFetchFinished(isNext, insertedMessages, null, null, false);
            int remainingFetchCount = limit - insertedMessages.size();
            BackgroundSyncThread.SyncState syncState = this.mSynchronizer.getSyncState(isNext);
            Logger.d("isNext : " + isNext + ", syncState : " + (Object)((Object)syncState) + ", limit : " + limit + ", remainingFetchLimit : " + remainingFetchCount);
            if (syncState != BackgroundSyncThread.SyncState.PAUSED && syncState != BackgroundSyncThread.SyncState.FINISHED) {
                this.mSynchronizer.subscribe(isNext, new MessageBackgroundSyncEventListenerImpl(isNext, limit, remainingFetchCount, handler));
            } else {
                this.load(isNext, remainingFetchCount, syncState, handler);
            }
        }
    }

    private int separateMessagesByChunk(List<BaseMessage> messages) {
        ArrayList<BaseMessage> chunkMessages = new ArrayList<BaseMessage>();
        ArrayList<BaseMessage> tempMessages = new ArrayList<BaseMessage>();
        MessageChunk currentChunk = MessageManager.getInstance().getMessageChunkContainer().getCurrentChunk(this.mChannel.getUrl(), this.mFilter, this.mViewpointTimestamp, this.mSynchronizer.isSyncedOnce(), true);
        Logger.d("currentChunk : " + currentChunk);
        if (currentChunk == null) {
            tempMessages.addAll(messages);
        } else {
            for (BaseMessage message : messages) {
                if (currentChunk.isMessageInChunk(message)) {
                    chunkMessages.add(message);
                    continue;
                }
                tempMessages.add(message);
            }
        }
        this.addToChunkMessages(chunkMessages);
        this.addToTempMessages(tempMessages);
        this.reSortTempMessages(currentChunk);
        return chunkMessages.size();
    }

    private List<BaseMessage> fetchMessagesFromDb(final boolean isNext, final int limit) throws SendBirdException {
        final BaseMessage offset = this.getOffset(isNext);
        final long ts = offset == null ? this.mViewpointTimestamp : offset.getCreatedAt();
        Logger.d("load(), isNext : " + isNext + ", offset : " + offset + ", ts ; " + ts);
        final AtomicReference dbException = new AtomicReference();
        List<BaseMessage> messages = SyncManagerDb.addTaskAndGet(new DBJobTask<List<BaseMessage>>(){

            @Override
            public List<BaseMessage> call(String userId) throws Exception {
                return MessageManager.getInstance().getMessageContainer().getSucceededMessagesByTimestamp(userId, MessageCollection.this.mChannel.getUrl(), ts, MessageCollection.this.mFilter, limit, isNext, offset == null);
            }

            @Override
            public void onResult(List<BaseMessage> result, SendBirdException e) {
                dbException.set(e);
            }
        });
        if (dbException.get() != null) {
            throw (SendBirdException)((Object)dbException.get());
        }
        if (messages == null) {
            messages = new ArrayList<BaseMessage>();
        }
        return messages;
    }

    void onFetchFinished(boolean isNext, List<BaseMessage> insertedMessages, List<BaseMessage> updatedMessages, List<BaseMessage> removedMessages, boolean isFinished) {
        Logger.d("isNext: %b, insertedMessages : %d, updatedMessages : %d, removedMessages: %d, isFinished : %b", isNext, insertedMessages == null ? -1 : insertedMessages.size(), updatedMessages == null ? -1 : updatedMessages.size(), removedMessages == null ? -1 : removedMessages.size(), isFinished);
        if (isFinished) {
            if (isNext) {
                this.mIsNextLoading = false;
            } else {
                this.mIsPrevLoading = false;
            }
        }
        if (removedMessages != null && !removedMessages.isEmpty()) {
            this.onMessageEvent(removedMessages, MessageEventAction.REMOVE);
            this.onSucceededMessageEvent(removedMessages, MessageEventAction.REMOVE);
        }
        if (updatedMessages != null && !updatedMessages.isEmpty()) {
            this.onMessageEvent(updatedMessages, MessageEventAction.UPDATE);
            this.onSucceededMessageEvent(updatedMessages, MessageEventAction.UPDATE);
        }
        if (insertedMessages != null && !insertedMessages.isEmpty()) {
            this.onMessageEvent(insertedMessages, MessageEventAction.INSERT);
            this.onSucceededMessageEvent(insertedMessages, MessageEventAction.INSERT);
        }
        this.checkCapacity(isNext);
    }

    private BaseMessage getOffset(boolean isNext) {
        BaseMessage chunkMessageOffset = this.getChunkMessageOffset(isNext);
        BaseMessage tempMessageOffset = this.getTempMessageOffset(isNext);
        Logger.d("chunkMessageOffset : " + chunkMessageOffset);
        Logger.d("tempMessageOffset : " + tempMessageOffset);
        if (chunkMessageOffset == null && tempMessageOffset == null) {
            return null;
        }
        if (chunkMessageOffset != null && tempMessageOffset == null) {
            return chunkMessageOffset;
        }
        if (chunkMessageOffset == null && tempMessageOffset != null) {
            return tempMessageOffset;
        }
        if (isNext) {
            return chunkMessageOffset.getCreatedAt() > tempMessageOffset.getCreatedAt() ? chunkMessageOffset : tempMessageOffset;
        }
        return chunkMessageOffset.getCreatedAt() < tempMessageOffset.getCreatedAt() ? chunkMessageOffset : tempMessageOffset;
    }

    private BaseMessage getChunkMessageOffset(boolean isNext) {
        Logger.d("chunkMessageSize : " + this.chunkMessageList.size() + ", isNext : " + isNext);
        if (this.chunkMessageList.size() == 0) {
            return null;
        }
        return isNext ? this.chunkMessageList.get(this.chunkMessageList.size() - 1) : this.chunkMessageList.get(0);
    }

    private BaseMessage getTempMessageOffset(boolean isNext) {
        Logger.d("temp size : " + this.tempMessageList.size() + ", isNext : " + isNext);
        if (this.tempMessageList.isEmpty()) {
            return null;
        }
        if (isNext) {
            return this.tempMessageList.get(this.tempMessageList.size() - 1);
        }
        return this.tempMessageList.get(0);
    }

    private void addToChunkMessages(List<BaseMessage> messages) {
        Logger.d("addToChunkMessages : " + (messages == null ? -1 : messages.size()));
        if (messages == null || messages.isEmpty()) {
            return;
        }
        this.removeFromTempMessages(messages);
        Iterator<BaseMessage> it = messages.iterator();
        block0: while (it.hasNext()) {
            BaseMessage message = it.next();
            for (BaseMessage chunkMessage : this.chunkMessageList) {
                if (chunkMessage.getMessageId() != message.getMessageId()) continue;
                Logger.d("already exists in chunkMessage. id : " + message.getMessageId() + ", message : " + message.getMessage());
                it.remove();
                continue block0;
            }
        }
        Logger.d("adding : " + messages.size());
        this.chunkMessageList.addAll(messages);
        SyncManagerUtils.sortMessages(this.chunkMessageList);
    }

    private void addToTempMessages(List<BaseMessage> tempMessages) {
        Logger.d("addToTempMessages : " + (tempMessages == null ? -1 : tempMessages.size()));
        if (tempMessages == null || tempMessages.isEmpty()) {
            return;
        }
        Iterator<BaseMessage> itTemp = tempMessages.iterator();
        block0: while (itTemp.hasNext()) {
            BaseMessage tempMessage = itTemp.next();
            for (BaseMessage chunkMessage : this.chunkMessageList) {
                if (tempMessage.getMessageId() != chunkMessage.getMessageId()) continue;
                Logger.d("message exists in chunk message (prevent from adding to temp). id : " + tempMessage.getMessageId() + ", message : " + tempMessage.getMessage());
                itTemp.remove();
                continue block0;
            }
        }
        block2: for (BaseMessage currentTempMessage : this.tempMessageList) {
            Iterator<BaseMessage> itTemp2 = tempMessages.iterator();
            while (itTemp2.hasNext()) {
                BaseMessage tempMessage = itTemp2.next();
                if (tempMessage.getMessageId() != currentTempMessage.getMessageId()) continue;
                Logger.d("already exists in tempMessage. id : " + tempMessage.getMessageId() + ", message : " + tempMessage.getMessage());
                itTemp2.remove();
                continue block2;
            }
        }
        Logger.d("adding : " + tempMessages.size());
        this.tempMessageList.addAll(tempMessages);
        SyncManagerUtils.sortMessages(this.tempMessageList);
    }

    private void removeFromTempMessages(List<BaseMessage> messagesToRemove) {
        Logger.d("messages to remove : " + (messagesToRemove == null ? -1 : messagesToRemove.size()));
        if (messagesToRemove == null || messagesToRemove.isEmpty()) {
            return;
        }
        for (BaseMessage messageToRemove : messagesToRemove) {
            Iterator<BaseMessage> itTemp = this.tempMessageList.iterator();
            while (itTemp.hasNext()) {
                BaseMessage tempMessage = itTemp.next();
                if (messageToRemove.getMessageId() != tempMessage.getMessageId()) continue;
                Logger.d("removing from temp. id : " + tempMessage.getMessageId() + ", message : " + tempMessage.getMessage());
                itTemp.remove();
            }
        }
    }

    private List<BaseMessage> getFilteredTempMessages(boolean isNext) {
        Logger.d("chunk size : " + this.chunkMessageList.size() + ", temp size : " + this.tempMessageList.size() + ", isNext : " + isNext);
        ArrayList<BaseMessage> tempMessages = new ArrayList<BaseMessage>();
        if (this.chunkMessageList.isEmpty()) {
            tempMessages.addAll(this.tempMessageList);
        } else {
            for (BaseMessage tempMessage : this.tempMessageList) {
                if (isNext) {
                    if (tempMessage.getCreatedAt() < this.chunkMessageList.get(this.chunkMessageList.size() - 1).getCreatedAt()) continue;
                    tempMessages.add(tempMessage);
                    continue;
                }
                if (tempMessage.getCreatedAt() > this.chunkMessageList.get(0).getCreatedAt()) continue;
                tempMessages.add(tempMessage);
            }
        }
        return tempMessages;
    }

    private void reSortTempMessages(MessageChunk currentChunk) {
        Logger.d("currentChunk : " + currentChunk);
        if (currentChunk == null) {
            return;
        }
        ArrayList<BaseMessage> adjustedChunkTemp = new ArrayList<BaseMessage>();
        Iterator<BaseMessage> itTemp = this.tempMessageList.iterator();
        while (itTemp.hasNext()) {
            BaseMessage currentTempMessage = itTemp.next();
            if (currentTempMessage.getCreatedAt() < currentChunk.getStartAt() || currentTempMessage.getCreatedAt() > currentChunk.getEndAt()) continue;
            itTemp.remove();
            adjustedChunkTemp.add(currentTempMessage);
        }
        Logger.d("temp to chunk : " + adjustedChunkTemp.size());
        this.addToChunkMessages(adjustedChunkTemp);
    }

    private void removePendingMessage(BaseMessage message, final Runnable onComplete) {
        this.mPendingMessageManager.remove(message, new Consumer<BaseMessage>(){

            @Override
            public void accept(BaseMessage baseMessage) {
                if (baseMessage != null) {
                    MessageCollection.this.onPendingMessageRemoved(baseMessage);
                }
                onComplete.run();
            }
        });
    }

    private void onPendingMessageRemoved(BaseMessage message) {
        this.onMessageEvent(Arrays.asList(message), MessageEventAction.REMOVE);
        this.onPendingMessageEvent(Arrays.asList(message), MessageEventAction.REMOVE);
    }

    void onPendingMessagesRemoved(Collection<? extends BaseMessage> messages) {
        this.onMessageEvent(new ArrayList<BaseMessage>(messages), MessageEventAction.REMOVE);
        this.onPendingMessageEvent(new ArrayList<BaseMessage>(messages), MessageEventAction.REMOVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsFailedMessage(BaseMessage message) {
        if (message != null && message.getMessageId() == 0L) {
            Object object = this.mFailedMessagesLock;
            synchronized (object) {
                for (int i = 0; i < this.mFailedMessages.size(); ++i) {
                    String failedMessageRequestId = SyncManagerUtils.getRequestId(this.mFailedMessages.get(i));
                    if (failedMessageRequestId.length() <= 0 || !failedMessageRequestId.equals(SyncManagerUtils.getRequestId(message))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<BaseMessage> getNewFailedMessages(Collection<BaseMessage> messages) {
        if (null == messages || messages.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<BaseMessage> newFailedMessages = new HashSet<BaseMessage>();
        Object object = this.mFailedMessagesLock;
        synchronized (object) {
            for (BaseMessage message : messages) {
                String requestId = SyncManagerUtils.getRequestId(message);
                if (requestId.isEmpty()) {
                    newFailedMessages.add(message);
                    continue;
                }
                boolean found = false;
                for (BaseMessage failedMessage : this.mFailedMessages) {
                    if (!SyncManagerUtils.getRequestId(failedMessage).equals(message.getRequestId())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                newFailedMessages.add(message);
            }
        }
        return newFailedMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getFailedMessageIndex(BaseMessage message) {
        Integer index = null;
        if (message != null && message.getMessageId() == 0L) {
            Object object = this.mFailedMessagesLock;
            synchronized (object) {
                for (int i = 0; i < this.mFailedMessages.size(); ++i) {
                    String failedMessageRequestId = SyncManagerUtils.getRequestId(this.mFailedMessages.get(i));
                    if (failedMessageRequestId.length() <= 0 || !failedMessageRequestId.equals(SyncManagerUtils.getRequestId(message))) continue;
                    index = i;
                    break;
                }
            }
        }
        return index;
    }

    private void checkCapacity(boolean isInsertedToNextDirection) {
        int exceedingSize = this.getMessageCount() - SendBirdSyncManager.getInstance().getOptions().getMessageCollectionCapacity();
        if (exceedingSize > 0) {
            this.removeMessagesExceedingCapacity(exceedingSize, !isInsertedToNextDirection);
        }
    }

    private void removeMessagesExceedingCapacity(int count, boolean isNext) {
        BaseMessage message;
        ArrayList<BaseMessage> removedMessages = new ArrayList<BaseMessage>();
        for (int i = 0; i < count && (message = this.removeEdgeMessage(isNext)) != null; ++i) {
            removedMessages.add(message);
        }
        SyncManagerUtils.sortMessages(removedMessages);
        this.onMessageEvent(removedMessages, MessageEventAction.REMOVE);
        this.onSucceededMessageEvent(removedMessages, MessageEventAction.REMOVE);
    }

    private BaseMessage removeEdgeMessage(boolean isNext) {
        long tempMessageCreatedAt;
        long chunkMessageCreatedAt;
        BaseMessage chunkMessage = this.getChunkMessageOffset(isNext);
        BaseMessage tempMessage = null;
        if (!this.tempMessageList.isEmpty()) {
            BaseMessage baseMessage = tempMessage = isNext ? this.tempMessageList.get(this.tempMessageList.size() - 1) : this.tempMessageList.get(0);
        }
        if (chunkMessage == null && tempMessage == null) {
            return null;
        }
        long l = chunkMessage == null ? (isNext ? 0L : Long.MAX_VALUE) : (chunkMessageCreatedAt = chunkMessage.getCreatedAt());
        long l2 = tempMessage == null ? (isNext ? 0L : Long.MAX_VALUE) : (tempMessageCreatedAt = tempMessage.getCreatedAt());
        if (isNext && chunkMessageCreatedAt > tempMessageCreatedAt || !isNext && chunkMessageCreatedAt < tempMessageCreatedAt) {
            this.chunkMessageList.remove(chunkMessage);
            return chunkMessage;
        }
        if ((isNext && tempMessageCreatedAt > chunkMessageCreatedAt || !isNext && tempMessageCreatedAt < chunkMessageCreatedAt) && this.tempMessageList.remove(tempMessage)) {
            return tempMessage;
        }
        return null;
    }

    private void onMessageEvent(final List<BaseMessage> messages, final MessageEventAction action) {
        Logger.d("onMessageEvent. list size = " + messages.size() + ", action = " + (Object)((Object)action));
        if (action != MessageEventAction.CLEAR && messages.size() == 0) {
            return;
        }
        SendBirdSyncManager.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (MessageCollection.this.mMessageCollectionHandler != null) {
                    MessageCollection.this.mMessageCollectionHandler.onMessageEvent(MessageCollection.this, messages, action);
                }
            }
        });
    }

    private void onSucceededMessageEvent(final List<BaseMessage> messages, final MessageEventAction action) {
        Logger.d("onSucceededMessageEvent. list size = " + messages.size() + ", action = " + (Object)((Object)action));
        if (action != MessageEventAction.CLEAR && messages.size() == 0) {
            return;
        }
        SendBirdSyncManager.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (MessageCollection.this.mMessageCollectionHandler != null) {
                    MessageCollection.this.mMessageCollectionHandler.onSucceededMessageEvent(MessageCollection.this, messages, action);
                }
            }
        });
    }

    private void onPendingMessageEvent(final List<BaseMessage> messages, final MessageEventAction action) {
        Logger.d("onPendingMessageEvent. list size = " + messages.size() + ", action = " + (Object)((Object)action));
        if (action != MessageEventAction.CLEAR && messages.size() == 0) {
            return;
        }
        SendBirdSyncManager.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (MessageCollection.this.mMessageCollectionHandler != null) {
                    MessageCollection.this.mMessageCollectionHandler.onPendingMessageEvent(MessageCollection.this, messages, action);
                }
            }
        });
    }

    private void onFailedMessageEvent(final List<BaseMessage> messages, final MessageEventAction action, final FailedMessageEventActionReason reason) {
        Logger.d("onFailedMessageEvent. list size = " + messages.size() + ", action = " + (Object)((Object)action) + ", reason = " + (Object)((Object)reason));
        if (action != MessageEventAction.CLEAR && messages.size() == 0) {
            return;
        }
        SendBirdSyncManager.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (MessageCollection.this.mMessageCollectionHandler != null) {
                    MessageCollection.this.mMessageCollectionHandler.onFailedMessageEvent(MessageCollection.this, messages, action, reason);
                }
            }
        });
    }

    private void onNewMessage(final BaseMessage message) {
        Logger.d("onNewMessage. messageId = " + (message == null ? null : Long.valueOf(message.getMessageId())));
        if (message == null) {
            return;
        }
        SendBirdSyncManager.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (MessageCollection.this.mMessageCollectionHandler != null) {
                    MessageCollection.this.mMessageCollectionHandler.onNewMessage(MessageCollection.this, message);
                }
            }
        });
    }

    private Future<?> runOnSingleThreadPool(Runnable runnable) {
        Logger.d("shutDown : " + this.mExecutorService.isShutdown() + ", isRemoved : " + this.mIsCollectionRemoved);
        if (!this.mExecutorService.isShutdown() && !this.mIsCollectionRemoved) {
            return this.mExecutorService.submit(runnable);
        }
        return null;
    }

    private boolean isMessageInLoadedChunkMessage(long messageId) {
        for (int i = 0; i < this.chunkMessageList.size(); ++i) {
            if (this.chunkMessageList.get(i).getMessageId() != messageId) continue;
            return true;
        }
        return false;
    }

    private boolean isMyMessage(BaseMessage message) {
        if (message instanceof AdminMessage) {
            return false;
        }
        Sender sender = message instanceof UserMessage ? ((UserMessage)message).getSender() : ((FileMessage)message).getSender();
        User currentUser = SendBird.getCurrentUser();
        if (sender == null || sender.getUserId() == null || currentUser == null) {
            return message.getMessageId() <= 0L;
        }
        return currentUser.getUserId().equals(sender.getUserId());
    }

    private class MessageBackgroundSyncEventListenerImpl
    implements MessageSynchronizer.MessageBackgroundSyncEventListener {
        boolean mIsNext;
        int mFetchLimit;
        int mRemainingFetchCount;
        FetchCompletionHandler fetchCompletionHandler;

        MessageBackgroundSyncEventListenerImpl(boolean isNext, int fetchLimit, int remainingFetchCount, FetchCompletionHandler fetchCompletionHandler) {
            this.mIsNext = isNext;
            this.mFetchLimit = fetchLimit;
            this.mRemainingFetchCount = remainingFetchCount;
            this.fetchCompletionHandler = fetchCompletionHandler;
        }

        @Override
        public void onSyncAndWait(final BackgroundSyncThread.SyncState syncState, final SendBirdException e) {
            Logger.d("isNext = " + this.mIsNext + ", syncState : " + (Object)((Object)syncState) + ", e : " + (Object)((Object)e));
            Future future = MessageCollection.this.runOnSingleThreadPool(new Runnable(){

                @Override
                public void run() {
                    if (e != null) {
                        MessageCollection.this.onFetchFinished(MessageBackgroundSyncEventListenerImpl.this.mIsNext, null, null, null, true);
                        SendBirdSyncManager.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                if (MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler != null) {
                                    MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler.onCompleted(false, e);
                                }
                            }
                        });
                        return;
                    }
                    List tempMessages = MessageCollection.this.getFilteredTempMessages(MessageBackgroundSyncEventListenerImpl.this.mIsNext);
                    Logger.d("tempMessages size : " + tempMessages.size() + ", temp : " + tempMessages + ", remainingCount : " + MessageBackgroundSyncEventListenerImpl.this.mRemainingFetchCount);
                    if (tempMessages.size() == 0) {
                        MessageCollection.this.load(MessageBackgroundSyncEventListenerImpl.this.mIsNext, Math.max(MessageBackgroundSyncEventListenerImpl.this.mFetchLimit, MessageBackgroundSyncEventListenerImpl.this.mRemainingFetchCount), syncState, MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler);
                    } else {
                        boolean chunkContainsAnyTempMessages;
                        MessageChunk currentChunk = MessageManager.getInstance().getMessageChunkContainer().getCurrentChunk(MessageCollection.this.mChannel.getUrl(), MessageCollection.this.mFilter, MessageCollection.this.mViewpointTimestamp, MessageCollection.this.mSynchronizer.isSyncedOnce(), true);
                        if (currentChunk == null) {
                            Logger.d("There is no chunk.");
                            MessageCollection.this.onFetchFinished(MessageBackgroundSyncEventListenerImpl.this.mIsNext, null, null, null, true);
                            SendBirdSyncManager.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler != null) {
                                        MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler.onCompleted(false, null);
                                    }
                                }
                            });
                            return;
                        }
                        boolean bl = chunkContainsAnyTempMessages = currentChunk.isMessageInChunk((BaseMessage)tempMessages.get(0)) || currentChunk.isMessageInChunk((BaseMessage)tempMessages.get(tempMessages.size() - 1));
                        if (!chunkContainsAnyTempMessages) {
                            Logger.d("None in chunk. remainingFetchCount : " + MessageBackgroundSyncEventListenerImpl.this.mRemainingFetchCount);
                            MessageCollection.this.removeFromTempMessages(tempMessages);
                            ArrayList notChunkMessages = new ArrayList(tempMessages);
                            MessageCollection.this.onMessageEvent(notChunkMessages, MessageEventAction.REMOVE);
                            MessageCollection.this.onSucceededMessageEvent(notChunkMessages, MessageEventAction.REMOVE);
                            tempMessages.clear();
                            if (syncState == BackgroundSyncThread.SyncState.FINISHED) {
                                MessageCollection.this.mSynchronizer.start();
                                MessageCollection.this.mSynchronizer.subscribe(MessageBackgroundSyncEventListenerImpl.this.mIsNext, MessageBackgroundSyncEventListenerImpl.this);
                                return;
                            }
                        }
                        int limit = Math.max(MessageBackgroundSyncEventListenerImpl.this.mFetchLimit, tempMessages.size());
                        List chunkMessages = MessageBackgroundSyncEventListenerImpl.this.getMessagesInChunk(currentChunk, limit);
                        Logger.d("chunkMessages : " + (chunkMessages == null ? -1 : chunkMessages.size()) + ", messages : " + chunkMessages);
                        if (chunkMessages == null) {
                            return;
                        }
                        int chunkCount = chunkMessages.size();
                        MessageBackgroundSyncEventListenerImpl.this.mRemainingFetchCount -= chunkCount;
                        boolean hasFetchedToSyncLimit = chunkCount >= Math.min(limit, 100);
                        MessageBackgroundSyncEventListenerImpl.this.diffWithChunkMessages(hasFetchedToSyncLimit, syncState, chunkMessages, tempMessages);
                        MessageBackgroundSyncEventListenerImpl.this.checkPendingMessages();
                    }
                }
            });
            Logger.d("future : " + future);
            if (future != null) {
                try {
                    future.get();
                }
                catch (Exception ex) {
                    Logger.d(ex);
                }
            }
        }

        private List<BaseMessage> getMessagesInChunk(final MessageChunk currentChunk, final int limit) {
            long ts;
            Logger.d("isNext : " + this.mIsNext + ", current chunk : " + currentChunk + ", limit : " + limit);
            if (currentChunk == null) {
                return null;
            }
            BaseMessage chunkOffset = MessageCollection.this.getChunkMessageOffset(this.mIsNext);
            long l = ts = this.mIsNext ? currentChunk.getStartAt() : currentChunk.getEndAt();
            if (chunkOffset != null) {
                ts = chunkOffset.getCreatedAt();
            }
            final boolean isInclusive = chunkOffset == null;
            Logger.d("isNext : " + this.mIsNext + ", chunkOffset : " + chunkOffset + ", ts : " + ts + ", isInclusive : " + isInclusive);
            final AtomicReference dbException = new AtomicReference();
            final long finalTs = ts;
            List<BaseMessage> messages = SyncManagerDb.addTaskAndGet(new DBJobTask<List<BaseMessage>>(){

                @Override
                public List<BaseMessage> call(String userId) throws Exception {
                    return MessageManager.getInstance().getMessageContainer().getMessagesInChunk(userId, currentChunk, finalTs, MessageBackgroundSyncEventListenerImpl.this.mIsNext, limit, isInclusive);
                }

                @Override
                public void onResult(List<BaseMessage> result, SendBirdException e) {
                    dbException.set(e);
                }
            });
            if (dbException.get() != null) {
                MessageCollection.this.onFetchFinished(this.mIsNext, null, null, null, true);
                SendBirdSyncManager.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler != null) {
                            MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler.onCompleted(false, (SendBirdException)((Object)dbException.get()));
                        }
                    }
                });
                return null;
            }
            if (messages == null) {
                messages = new ArrayList<BaseMessage>();
            }
            return messages;
        }

        private void diffWithChunkMessages(boolean hasFetchedToSyncLimit, BackgroundSyncThread.SyncState syncState, List<BaseMessage> insertedMessages, List<BaseMessage> tempMessages) {
            Logger.d("hasFetchedToSyncLimit : " + hasFetchedToSyncLimit + ", isNext : " + this.mIsNext + ", remainingCount : " + this.mRemainingFetchCount + ", syncState : " + (Object)((Object)syncState));
            Logger.d("inserted : " + (insertedMessages == null ? -1 : insertedMessages.size()) + ", tempMessages : " + (tempMessages == null ? -1 : tempMessages.size()));
            if (insertedMessages == null || insertedMessages.isEmpty()) {
                return;
            }
            ArrayList<BaseMessage> removedMessages = new ArrayList<BaseMessage>();
            ArrayList<BaseMessage> updatedMessages = new ArrayList<BaseMessage>();
            ArrayList<BaseMessage> equalsMessages = new ArrayList<BaseMessage>();
            if (tempMessages != null) {
                for (BaseMessage tempMessage : tempMessages) {
                    boolean isMessageFound = false;
                    Iterator<BaseMessage> insertIt = insertedMessages.iterator();
                    while (insertIt.hasNext()) {
                        BaseMessage message = insertIt.next();
                        if (tempMessage.getMessageId() != message.getMessageId()) continue;
                        isMessageFound = true;
                        if (!tempMessage.equals((Object)message)) {
                            updatedMessages.add(message);
                        } else {
                            equalsMessages.add(message);
                        }
                        insertIt.remove();
                        break;
                    }
                    if (isMessageFound) continue;
                    removedMessages.add(tempMessage);
                }
            }
            MessageCollection.this.addToChunkMessages(insertedMessages);
            MessageCollection.this.addToChunkMessages(updatedMessages);
            MessageCollection.this.addToChunkMessages(equalsMessages);
            MessageCollection.this.removeFromTempMessages(removedMessages);
            if (hasFetchedToSyncLimit) {
                if (this.mRemainingFetchCount <= 0 || syncState == BackgroundSyncThread.SyncState.FINISHED) {
                    MessageCollection.this.onFetchFinished(this.mIsNext, insertedMessages, updatedMessages, removedMessages, true);
                    final boolean hasMore = syncState != BackgroundSyncThread.SyncState.FINISHED;
                    Logger.d("finished fetch. hasMore : " + hasMore);
                    SendBirdSyncManager.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler != null) {
                                MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler.onCompleted(hasMore, null);
                            }
                        }
                    });
                } else {
                    MessageCollection.this.onFetchFinished(this.mIsNext, insertedMessages, updatedMessages, removedMessages, false);
                    MessageCollection.this.mSynchronizer.subscribe(this.mIsNext, this);
                }
            } else if (this.mRemainingFetchCount > 0) {
                MessageCollection.this.onFetchFinished(this.mIsNext, insertedMessages, updatedMessages, removedMessages, false);
                MessageCollection.this.load(this.mIsNext, Math.max(this.mFetchLimit, this.mRemainingFetchCount), syncState, this.fetchCompletionHandler);
            } else {
                MessageCollection.this.onFetchFinished(this.mIsNext, insertedMessages, updatedMessages, removedMessages, true);
                SendBirdSyncManager.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler != null) {
                            MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler.onCompleted(false, null);
                        }
                    }
                });
            }
        }

        private void checkPendingMessages() {
            Logger.d("checkPendingMessages");
            MessageCollection.this.mPendingMessageManager.clear(MessageCollection.this, (Consumer<? super Collection<BaseMessage>>)new Consumer<Collection<BaseMessage>>(){

                @Override
                public void accept(Collection<BaseMessage> deletedMessages) {
                    Logger.d("checkPendingMessages. pendingMessages : " + deletedMessages.size());
                    MessageCollection.this.onMessageEvent(new ArrayList<BaseMessage>(deletedMessages), MessageEventAction.REMOVE);
                    MessageCollection.this.onPendingMessageEvent(new ArrayList<BaseMessage>(deletedMessages), MessageEventAction.REMOVE);
                }
            });
        }
    }

    public static enum Direction {
        PREVIOUS,
        NEXT;

    }
}

