/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.UserMessage;
import com.sendbird.syncmanager.ClearableScheduledExecutorService;
import com.sendbird.syncmanager.DBJobTask;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.FailedMessageDispatcher;
import com.sendbird.syncmanager.FailedMessageEventActionReason;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.SendBirdSyncManager;
import com.sendbird.syncmanager.SyncManagerDb;
import com.sendbird.syncmanager.SyncManagerUtils;
import com.sendbird.syncmanager.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

class FailedMessageQueue {
    private GroupChannel mChannel;
    private final List<BaseMessage> mAutomaticMessages;
    private final List<BaseMessage> mManualMessages;
    private final Object mMessageListLock = new Object();
    private Set<String> mRequestIdSet;
    private final ClearableScheduledExecutorService resendExecutor;
    private final AtomicLong mDelayTime;
    private final AtomicInteger mRetryCount;
    private final AtomicInteger mCollectionReferenceCount;
    private final AtomicBoolean mIsRunning;
    private final AtomicBoolean mIsResending;

    FailedMessageQueue(GroupChannel channel) {
        this.mChannel = channel;
        this.mAutomaticMessages = new ArrayList<BaseMessage>();
        this.mManualMessages = new ArrayList<BaseMessage>();
        this.mRequestIdSet = Collections.newSetFromMap(new ConcurrentHashMap());
        this.mDelayTime = new AtomicLong();
        this.mRetryCount = new AtomicInteger();
        this.mCollectionReferenceCount = new AtomicInteger(1);
        this.mIsRunning = new AtomicBoolean(true);
        this.mIsResending = new AtomicBoolean();
        this.resendExecutor = new ClearableScheduledExecutorService();
    }

    static boolean isResendableAutomatically(BaseMessage message) {
        if (message == null) {
            return false;
        }
        try {
            if (SyncManagerUtils.isCoreSDKVersionAbove("3.0.121")) {
                return message.getSendingStatus() == BaseMessage.SendingStatus.FAILED;
            }
        }
        catch (Throwable throwable) {
            Logger.d(throwable);
        }
        return true;
    }

    List<BaseMessage> getMessages() {
        return this.mAutomaticMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendMessages(List<BaseMessage> messages) {
        if (messages == null) {
            return;
        }
        SendBirdSyncManager.MessageResendPolicy policy = SendBirdSyncManager.getInstance().getOptions().getMessageResendPolicy();
        Logger.d("policy : " + (Object)((Object)policy));
        Object object = this.mMessageListLock;
        synchronized (object) {
            for (BaseMessage message : messages) {
                this.appendMessage(message, policy);
            }
            SyncManagerUtils.sortMessages(this.mAutomaticMessages);
            SyncManagerUtils.sortMessages(this.mManualMessages);
        }
        Logger.d("running : " + this.mIsRunning.get() + ", resending : " + this.mIsResending.get());
        if (this.mIsRunning.get() && !this.mIsResending.get()) {
            this.resendMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMessages(List<String> removedRequestIds) {
        if (removedRequestIds == null) {
            return;
        }
        Object object = this.mMessageListLock;
        synchronized (object) {
            for (String requestId : removedRequestIds) {
                this.removeMessage(requestId);
            }
        }
    }

    void resumeResending() {
        Logger.d("isResending : " + this.mIsResending.get());
        this.mIsRunning.set(true);
        this.mDelayTime.set(0L);
        if (!this.mIsResending.get()) {
            this.resendMessage();
        }
    }

    void pauseResending() {
        this.mIsRunning.set(false);
        this.mIsResending.set(false);
        this.cancelResending();
    }

    void increaseCount() {
        int count = this.mCollectionReferenceCount.incrementAndGet();
        Logger.d("refCount : " + count);
    }

    void decreaseCount() {
        int count = this.mCollectionReferenceCount.decrementAndGet();
        Logger.d("refCount : " + count);
        if (count == 0) {
            this.clear();
        }
    }

    int getCollectionReferenceCount() {
        return this.mCollectionReferenceCount.get();
    }

    private void appendMessage(BaseMessage message, SendBirdSyncManager.MessageResendPolicy policy) {
        String requestId = SyncManagerUtils.getRequestId(message);
        if (requestId == null || requestId.isEmpty()) {
            return;
        }
        if (message instanceof UserMessage && !this.mRequestIdSet.contains(requestId)) {
            if (policy == SendBirdSyncManager.MessageResendPolicy.MANUAL) {
                this.mManualMessages.add(message);
            } else if (policy == SendBirdSyncManager.MessageResendPolicy.AUTOMATIC) {
                this.mAutomaticMessages.add(message);
            }
            this.mRequestIdSet.add(requestId);
        }
    }

    private void removeMessage(String requestId) {
        if (requestId == null || requestId.isEmpty()) {
            return;
        }
        if (this.mRequestIdSet.contains(requestId)) {
            int i;
            for (i = 0; i < this.mAutomaticMessages.size(); ++i) {
                if (!requestId.equals(SyncManagerUtils.getRequestId(this.mAutomaticMessages.get(i)))) continue;
                this.mAutomaticMessages.remove(i);
                this.mRequestIdSet.remove(requestId);
                return;
            }
            for (i = 0; i < this.mManualMessages.size(); ++i) {
                if (!requestId.equals(SyncManagerUtils.getRequestId(this.mManualMessages.get(i)))) continue;
                this.mManualMessages.remove(i);
                this.mRequestIdSet.remove(requestId);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        Object object = this.mMessageListLock;
        synchronized (object) {
            this.mAutomaticMessages.clear();
            this.mManualMessages.clear();
        }
        this.cancelResending();
    }

    private void reset() {
        this.mDelayTime.set(0L);
        this.mRetryCount.set(0);
        this.mIsResending.set(false);
    }

    private void increaseDelayTime() {
        this.mDelayTime.set(Math.min(this.mDelayTime.addAndGet(2000L), 10000L));
    }

    private synchronized void resendMessage() {
        Logger.d("resendMessage. delay : " + this.mDelayTime.get());
        this.cancelResending();
        this.resendExecutor.schedule(new ResendingMessageTimerTask(), this.mDelayTime.get(), TimeUnit.MILLISECONDS);
    }

    private synchronized void cancelResending() {
        this.resendExecutor.cancelAllJobs();
    }

    private class ResendingMessageTimerTask
    extends TimerTask {
        private ResendingMessageTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (FailedMessageQueue.this.mAutomaticMessages.size() == 0) {
                FailedMessageQueue.this.reset();
                return;
            }
            int retryCount = FailedMessageQueue.this.mRetryCount.incrementAndGet();
            Logger.i("[resendingMessageRunnable] run(). retryCount : " + retryCount, new Object[0]);
            if (retryCount > SendBirdSyncManager.getInstance().getOptions().getAutomaticMessageResendRetryCount()) {
                ArrayList<BaseMessage> switchedMessages = new ArrayList<BaseMessage>();
                Object object = FailedMessageQueue.this.mMessageListLock;
                synchronized (object) {
                    switchedMessages.addAll(FailedMessageQueue.this.mAutomaticMessages);
                    FailedMessageQueue.this.mManualMessages.addAll(FailedMessageQueue.this.mAutomaticMessages);
                    FailedMessageQueue.this.mAutomaticMessages.clear();
                }
                MessageManager.getInstance().broadcastFailedMessagesUpdated(FailedMessageQueue.this.mChannel.getUrl(), switchedMessages, FailedMessageEventActionReason.UPDATE_RESEND_FAILED);
                FailedMessageQueue.this.reset();
                return;
            }
            FailedMessageQueue.this.mIsResending.set(true);
            final UserMessage message = (UserMessage)FailedMessageQueue.this.mAutomaticMessages.get(0);
            if (FailedMessageQueue.isResendableAutomatically((BaseMessage)message)) {
                FailedMessageQueue.this.mChannel.resendUserMessage(message, new BaseChannel.ResendUserMessageHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onSent(final UserMessage userMessage, SendBirdException e) {
                        if (e != null) {
                            Logger.d("resendUserMessage: message=%s, e=%s", new Object[]{message, e});
                            if (e.getCode() == 800110) {
                                FailedMessageQueue.this.removeMessage(SyncManagerUtils.getRequestId((BaseMessage)message));
                                SyncManagerDb.addTaskAndGet(new DBJobTask<List<String>>(){

                                    @Override
                                    public List<String> call(String userId) throws Exception {
                                        return FailedMessageDispatcher.getInstance().removeMessages(userId, (BaseMessage)message);
                                    }

                                    @Override
                                    public void onResult(List<String> result, SendBirdException e) {
                                        if (result != null) {
                                            MessageManager.getInstance().broadcastFailedMessagesDeleted(message.getChannelUrl(), result, FailedMessageEventActionReason.REMOVE_UNKNOWN);
                                        }
                                    }
                                });
                                return;
                            }
                            if (800400 == message.getErrorCode() && null != userMessage) {
                                FailedMessageQueue.this.removeMessage(SyncManagerUtils.getRequestId((BaseMessage)message));
                                SyncManagerDb.addTaskAndGet(new DBJobTask<Void>(){

                                    @Override
                                    public Void call(String userId) throws SendBirdException {
                                        FailedMessageDispatcher.getInstance().upsertMessages(userId, FailedMessageQueue.this.mChannel.getUrl(), Arrays.asList(userMessage));
                                        return null;
                                    }
                                });
                            }
                            FailedMessageQueue.this.mIsResending.set(false);
                            FailedMessageQueue.this.increaseDelayTime();
                        } else {
                            Object object = FailedMessageQueue.this.mMessageListLock;
                            synchronized (object) {
                                FailedMessageQueue.this.removeMessage(SyncManagerUtils.getRequestId((BaseMessage)message));
                            }
                            FailedMessageQueue.this.mDelayTime.set(0L);
                            FailedMessageQueue.this.mRetryCount.set(0);
                            SyncManagerDb.addTaskAndGet(new DBJobTask<List<String>>(){

                                @Override
                                public List<String> call(String userId) throws Exception {
                                    List<String> requestIds = FailedMessageDispatcher.getInstance().removeMessages(userId, (BaseMessage)message);
                                    DatabaseController.getInstance().upsertSucceededMessages(userId, Collections.singletonList(userMessage), true);
                                    return requestIds;
                                }

                                @Override
                                public void onResult(List<String> requestIds, SendBirdException e) {
                                    if (requestIds != null) {
                                        MessageManager.getInstance().broadcastFailedMessagesDeleted(userMessage.getChannelUrl(), requestIds, FailedMessageEventActionReason.REMOVE_RESEND_SUCCEEDED);
                                        MessageManager.getInstance().broadcastSucceededMessageInserted(userMessage.getChannelUrl(), (BaseMessage)userMessage);
                                    }
                                }
                            });
                        }
                        if (FailedMessageQueue.this.mAutomaticMessages.size() == 0) {
                            FailedMessageQueue.this.reset();
                        } else {
                            FailedMessageQueue.this.resendMessage();
                        }
                    }
                });
            } else {
                Object object = FailedMessageQueue.this.mMessageListLock;
                synchronized (object) {
                    Logger.d("removing : " + FailedMessageQueue.this.mAutomaticMessages.get(0));
                    FailedMessageQueue.this.mAutomaticMessages.remove(0);
                }
                FailedMessageQueue.this.resendMessage();
            }
        }
    }
}

