/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.util.Pair;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.SharedPreferencesManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class ChannelContainer {
    private Map<String, GroupChannel> mChannelMap;
    private final Object mChannelMapLock = new Object();

    ChannelContainer() {
        this.mChannelMap = new LinkedHashMap<String, GroupChannel>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setup(String userId) throws SendBirdException {
        this.mChannelMap.clear();
        List<GroupChannel> allChannelList = DatabaseController.getInstance().getAllChannels(userId);
        Object object = this.mChannelMapLock;
        synchronized (object) {
            this.mChannelMap.clear();
            for (GroupChannel channel : allChannelList) {
                this.mChannelMap.put(channel.getUrl(), channel);
            }
        }
    }

    List<GroupChannel> getChannels() {
        return this.convertChannelMapToList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GroupChannel getChannel(String userId, String channelUrl) throws SendBirdException {
        GroupChannel groupChannel = DatabaseController.getInstance().getChannel(userId, channelUrl);
        Object object = this.mChannelMapLock;
        synchronized (object) {
            if (!this.mChannelMap.containsKey(channelUrl)) {
                this.mChannelMap.put(channelUrl, groupChannel);
            }
        }
        return groupChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<List<GroupChannel>, List<GroupChannel>> upsertChannels(String userId, List<GroupChannel> channels) throws SendBirdException {
        Pair<List<GroupChannel>, List<GroupChannel>> result = DatabaseController.getInstance().upsertChannels(userId, channels);
        Object object = this.mChannelMapLock;
        synchronized (object) {
            for (GroupChannel channel : channels) {
                this.mChannelMap.put(channel.getUrl(), channel);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChannelUrl(String userId, String channelUrl) throws SendBirdException {
        DatabaseController.getInstance().deleteChannel(userId, channelUrl);
        Object object = this.mChannelMapLock;
        synchronized (object) {
            this.mChannelMap.remove(channelUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChannelUrls(String userId, List<String> channelUrls) throws SendBirdException {
        DatabaseController.getInstance().deleteChannels(userId, channelUrls);
        Object object = this.mChannelMapLock;
        synchronized (object) {
            for (String channelUrl : channelUrls) {
                this.mChannelMap.remove(channelUrl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GroupChannel> convertChannelMapToList() {
        ArrayList<GroupChannel> channels = new ArrayList<GroupChannel>();
        Object object = this.mChannelMapLock;
        synchronized (object) {
            if (this.mChannelMap != null) {
                channels.addAll(this.mChannelMap.values());
            }
        }
        return channels;
    }

    void clear() {
        this.mChannelMap.clear();
    }

    void clear(String userId) {
        for (GroupChannel groupChannel : this.mChannelMap.values()) {
            SharedPreferencesManager.getInstance().removeMessageChangeLogToken(groupChannel.getUrl());
        }
        this.mChannelMap.clear();
    }
}

