/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.content.ContentValues;
import android.database.Cursor;
import com.sendbird.android.BaseMessage;
import com.sendbird.syncmanager.MessageFilter;
import com.sendbird.syncmanager.log.Logger;
import java.util.UUID;

class MessageChunk {
    private String mChunkId;
    private String mChannelUrl;
    private long mStartAt;
    private long mEndAt;
    private MessageFilter mFilter;
    private boolean mIsStartSynced;
    private boolean mIsEndSynced;
    final boolean isFromDB;

    private MessageChunk(String chunkId, String channelUrl, long startAt, long endAt, MessageFilter filter, boolean isStartSynced, boolean isEndSynced) {
        this.mChunkId = chunkId;
        this.mChannelUrl = channelUrl;
        this.mStartAt = startAt;
        this.mEndAt = endAt;
        this.mFilter = filter;
        this.mIsStartSynced = isStartSynced;
        this.mIsEndSynced = isEndSynced;
        this.isFromDB = true;
    }

    public MessageChunk(String channelUrl, long startAt, long endAt, MessageFilter filter) {
        this.mChunkId = channelUrl + "_" + UUID.randomUUID().toString();
        this.mChannelUrl = channelUrl;
        this.mStartAt = startAt;
        this.mEndAt = endAt;
        this.mFilter = filter;
        this.mIsStartSynced = false;
        this.mIsEndSynced = false;
        this.isFromDB = false;
    }

    static MessageChunk newInstance(Cursor cursor) {
        String chunkId = cursor.getString(cursor.getColumnIndex("chunk_id"));
        String channelUrl = cursor.getString(cursor.getColumnIndex("channel_url"));
        long startAt = cursor.getLong(cursor.getColumnIndex("start_at"));
        long endAt = cursor.getLong(cursor.getColumnIndex("end_at"));
        String filter = cursor.getString(cursor.getColumnIndex("filter"));
        boolean isStartSynced = cursor.getInt(cursor.getColumnIndex("start_synced")) == 1;
        boolean isEndSynced = cursor.getInt(cursor.getColumnIndex("end_synced")) == 1;
        return new MessageChunk(chunkId, channelUrl, startAt, endAt, new MessageFilter(filter), isStartSynced, isEndSynced);
    }

    public String getChunkId() {
        return this.mChunkId;
    }

    public String getChannelUrl() {
        return this.mChannelUrl;
    }

    public void setStartAt(long startAt) {
        this.mStartAt = startAt;
    }

    public long getStartAt() {
        return this.mStartAt;
    }

    public void setEndAt(long endAt) {
        this.mEndAt = endAt;
    }

    public long getEndAt() {
        return this.mEndAt;
    }

    public MessageFilter getFilter() {
        return this.mFilter;
    }

    boolean isStartSynced() {
        if (this.isFromDB) {
            IllegalStateException error = new IllegalStateException("called when isFromDB is true.");
            Logger.e(error);
        }
        return this.mIsStartSynced;
    }

    boolean isEndSynced() {
        if (this.isFromDB) {
            IllegalStateException error = new IllegalStateException("called when isFromDB is true.");
            Logger.e(error);
        }
        return this.mIsEndSynced;
    }

    public void setStartSynced(boolean isStartSynced) {
        this.mIsStartSynced = isStartSynced;
    }

    public void setEndSynced(boolean isEndSynced) {
        this.mIsEndSynced = isEndSynced;
    }

    public boolean isParent() {
        return this.mFilter.isParent();
    }

    public boolean isMessageInChunk(BaseMessage message) {
        return message.getCreatedAt() >= this.mStartAt && message.getCreatedAt() <= this.mEndAt && this.mFilter.isValidMessage(message);
    }

    void merge(MessageChunk other, boolean otherIsNewer) {
        Logger.d("merge(). acquirer range = " + this.getRangeAsString() + ", merged = " + other.getRangeAsString());
        if (!this.isIntersectWith(other) || !this.mFilter.equals(other.getFilter())) {
            return;
        }
        if (!other.isFromDB && !this.isFromDB) {
            if (this.getEndAt() < other.getEndAt()) {
                this.setEndSynced(other.isEndSynced());
            } else if (this.getEndAt() == other.getEndAt() && otherIsNewer) {
                this.setEndSynced(other.isEndSynced());
            }
            if (other.getStartAt() < this.getStartAt()) {
                this.setStartSynced(other.isStartSynced());
            } else if (this.getStartAt() == other.getStartAt() && otherIsNewer) {
                this.setEndSynced(other.isStartSynced());
            }
        }
        this.mStartAt = Math.min(this.mStartAt, other.getStartAt());
        this.mEndAt = Math.max(this.mEndAt, other.getEndAt());
    }

    boolean isIntersectWith(MessageChunk chunk) {
        if (chunk == null) {
            return false;
        }
        if (this == chunk) {
            return false;
        }
        if (!chunk.getChannelUrl().equals(this.mChannelUrl)) {
            return false;
        }
        return this.getStartAt() <= chunk.getEndAt() && this.getEndAt() >= chunk.getStartAt();
    }

    String getRangeAsString() {
        return "[" + this.getStartAt() + " - " + this.getEndAt() + "]";
    }

    ContentValues toContentValues(String userId) {
        ContentValues values = new ContentValues();
        values.put("user_id", userId);
        values.put("chunk_id", this.getChunkId());
        values.put("channel_url", this.getChannelUrl());
        values.put("start_at", Long.valueOf(this.getStartAt()));
        values.put("end_at", Long.valueOf(this.getEndAt()));
        values.put("filter", this.getFilter().toJson());
        values.put("start_synced", Integer.valueOf(this.mIsStartSynced ? 1 : 0));
        values.put("end_synced", Integer.valueOf(this.mIsEndSynced ? 1 : 0));
        return values;
    }

    public String toString() {
        return "MessageChunk{range=" + this.getRangeAsString() + ", mIsStartSynced=" + this.mIsStartSynced + ", mIsEndSynced=" + this.mIsEndSynced + '}';
    }
}

