/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.BackgroundSyncThread;
import com.sendbird.syncmanager.DBJobTask;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.FailedMessageDispatcher;
import com.sendbird.syncmanager.FailedMessageEventActionReason;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageChunkContainer;
import com.sendbird.syncmanager.MessageCollection;
import com.sendbird.syncmanager.MessageContainer;
import com.sendbird.syncmanager.MessageSynchronizer;
import com.sendbird.syncmanager.SyncManagerDb;
import com.sendbird.syncmanager.SyncManagerError;
import com.sendbird.syncmanager.log.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;

class MessageManager {
    private static MessageManager sInstance;
    private String mIdentifier;
    private List<MessageCollection> mMessageCollections = new ArrayList<MessageCollection>();
    private MessageContainer mMessageContainer;
    private MessageChunkContainer mMessageChunkContainer;
    private SendBird.ChannelHandler mChannelHandler = new SendBird.ChannelHandler(){

        public void onMessageReceived(final BaseChannel channel, final BaseMessage message) {
            Logger.d("onMessageReceived, channelUrl = " + this.getChannelUrl(channel) + ", messageId = " + this.getMessageId(message));
            SyncManagerDb.addTask(new DBJobTask<Void>(){

                @Override
                public Void call(String userId) throws Exception {
                    DatabaseController.getInstance().upsertSucceededMessages(userId, Collections.singletonList(message), true);
                    return null;
                }

                @Override
                public void onResult(Void result, SendBirdException e) {
                    MessageManager.this.broadcastSucceededMessageInserted(this.getChannelUrl(channel), message);
                }
            });
        }

        public void onMessageDeleted(final BaseChannel channel, final long msgId) {
            Logger.d("onMessageDeleted, channelUrl = " + this.getChannelUrl(channel) + ", messageId = " + msgId);
            if (channel != null) {
                SyncManagerDb.addTask(new DBJobTask<Void>(){

                    @Override
                    public Void call(String userId) throws Exception {
                        List<BaseMessage> deletedMessages = DatabaseController.getInstance().removeSucceededMessages(userId, Collections.singletonList(msgId));
                        MessageManager.this.updateMessageChunkForDeletedMessages(userId, deletedMessages);
                        return null;
                    }

                    @Override
                    public void onResult(Void result, SendBirdException e) {
                        MessageManager.this.broadcastSucceededMessageDeleted(channel.getUrl(), new ArrayList<Long>(Collections.singletonList(msgId)));
                    }
                });
            }
        }

        public void onMessageUpdated(final BaseChannel channel, final BaseMessage message) {
            Logger.d("onMessageUpdated, channelUrl = " + this.getChannelUrl(channel) + ", messageId = " + this.getMessageId(message));
            SyncManagerDb.addTask(new DBJobTask<Void>(){

                @Override
                public Void call(String userId) throws Exception {
                    DatabaseController.getInstance().upsertSucceededMessages(userId, Collections.singletonList(message), true);
                    return null;
                }

                @Override
                public void onResult(Void result, SendBirdException e) {
                    MessageManager.this.broadcastSucceededMessageUpdated(this.getChannelUrl(channel), new ArrayList<BaseMessage>(Collections.singletonList(message)));
                }
            });
        }

        private String getChannelUrl(BaseChannel channel) {
            return channel == null ? "null" : channel.getUrl();
        }

        private String getMessageId(BaseMessage message) {
            return message == null ? "null" : String.valueOf(message.getMessageId());
        }
    };

    private MessageManager() {
        this.mIdentifier = UUID.randomUUID().toString();
        this.mMessageContainer = new MessageContainer();
        this.mMessageChunkContainer = new MessageChunkContainer();
        SendBird.addChannelHandler((String)this.mIdentifier, (SendBird.ChannelHandler)this.mChannelHandler);
    }

    public static MessageManager getInstance() {
        if (sInstance == null) {
            throw new RuntimeException(SyncManagerError.getException(810100));
        }
        return sInstance;
    }

    static void init() {
        if (sInstance == null) {
            sInstance = new MessageManager();
        }
    }

    static void deinit() {
        sInstance = null;
    }

    void setup(String userId) throws SendBirdException {
        this.mMessageChunkContainer.setup(userId);
    }

    void addMessageCollection(MessageCollection collection) {
        MessageManager.getInstance().mMessageCollections.add(collection);
    }

    void removeMessageCollection(MessageCollection collection) {
        MessageManager.getInstance().mMessageCollections.remove(collection);
    }

    void broadcastFailedMessagesInserted(String channelUrl, List<BaseMessage> messages) {
        if (messages == null || messages.size() == 0) {
            return;
        }
        for (MessageCollection collection : this.getMessageCollections()) {
            if (!collection.getChannelUrl().equals(channelUrl)) continue;
            collection.onFailedMessagesInserted(messages);
        }
    }

    void broadcastFailedMessagesUpdated(String channelUrl, List<BaseMessage> messages, FailedMessageEventActionReason reason) {
        if (messages == null || messages.size() == 0) {
            return;
        }
        for (MessageCollection collection : this.getMessageCollections()) {
            if (!collection.getChannelUrl().equals(channelUrl)) continue;
            collection.onFailedMessagesUpdated(messages, reason);
        }
    }

    void broadcastFailedMessagesDeleted(String channelUrl, List<String> requestIds, FailedMessageEventActionReason reason) {
        if (requestIds == null || requestIds.size() == 0) {
            return;
        }
        for (MessageCollection collection : this.getMessageCollections()) {
            if (!channelUrl.equals(collection.getChannelUrl())) continue;
            collection.onFailedMessagesDeleted(requestIds, reason);
        }
    }

    void broadcastSucceededMessageInserted(String channelUrl, BaseMessage message) {
        if (message == null) {
            return;
        }
        for (MessageCollection collection : this.getMessageCollections()) {
            if (!collection.getChannelUrl().equals(channelUrl)) continue;
            collection.onSucceededMessagesInserted(message);
        }
    }

    void broadcastSucceededMessageUpdated(String channelUrl, List<BaseMessage> messages) {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        for (MessageCollection collection : this.getMessageCollections()) {
            if (!collection.getChannelUrl().equals(channelUrl)) continue;
            collection.onSucceededMessagesUpdated(messages);
        }
    }

    void broadcastSucceededMessageDeleted(String channelUrl, List<Long> messageIds) {
        if (messageIds == null || messageIds.isEmpty()) {
            return;
        }
        for (MessageCollection collection : MessageManager.getInstance().getMessageCollections()) {
            if (!channelUrl.equals(collection.getChannelUrl())) continue;
            collection.onSucceededMessagesDeleted(messageIds);
        }
    }

    void updateMessageChunkForDeletedMessages(String userId, List<BaseMessage> deletedMessages) throws SendBirdException {
        if (deletedMessages == null || deletedMessages.isEmpty()) {
            return;
        }
        for (BaseMessage deletedMessage : deletedMessages) {
            List<MessageChunk> chunkList = this.mMessageChunkContainer.getChunksContainingMessageAsEdge(deletedMessage);
            if (chunkList == null || chunkList.size() == 0) continue;
            for (MessageChunk chunk : chunkList) {
                BaseMessage message = DatabaseController.getInstance().getPreviousSucceededMessageByTimestamp(userId, chunk.getChannelUrl(), chunk.getEndAt());
                if (message != null) {
                    chunk.setEndAt(message.getCreatedAt());
                    this.mMessageChunkContainer.upsertChunk(userId, chunk);
                    continue;
                }
                this.mMessageChunkContainer.deleteChunks(userId, Collections.singletonList(chunk));
            }
        }
    }

    void deleteMessagesBeforeOffset(String userId, String channelUrl, long offset) throws SendBirdException {
        Logger.d("deleteMessagesBeforeOffset: channelUrl : " + channelUrl + ", offset : " + offset);
        DatabaseController.getInstance().removeMessagesBeforeMessageOffset(userId, channelUrl, offset);
        List<MessageChunk> chunkList = this.mMessageChunkContainer.getChunksStartAtBeforeOffset(channelUrl, offset);
        for (MessageChunk chunk : chunkList) {
            if (chunk.getEndAt() > offset) {
                chunk.setStartAt(offset);
                this.mMessageChunkContainer.upsertChunk(userId, chunk);
                continue;
            }
            this.mMessageChunkContainer.deleteChunks(userId, Collections.singletonList(chunk));
        }
        for (MessageCollection collection : this.getMessageCollections()) {
            if (!collection.getChannelUrl().equals(channelUrl)) continue;
            collection.removeMessagesBeforeOffset(offset);
        }
    }

    void broadcastChannelUpdated(List<GroupChannel> updatedChannels) {
        Logger.d("broadcastChannelUpdated.");
        if (updatedChannels == null || updatedChannels.isEmpty()) {
            return;
        }
        for (GroupChannel updatedChannel : updatedChannels) {
            for (MessageCollection collection : this.getMessageCollections()) {
                if (!collection.getChannelUrl().equals(updatedChannel.getUrl())) continue;
                collection.onChannelUpdated(updatedChannel);
            }
        }
    }

    void broadcastChannelRemoved(List<String> removedChannelUrls) {
        Logger.d("broadcastChannelRemoved.");
        if (removedChannelUrls == null || removedChannelUrls.isEmpty()) {
            return;
        }
        for (String deletedChannelUrl : removedChannelUrls) {
            for (MessageCollection collection : this.getMessageCollections()) {
                if (!collection.getChannelUrl().equals(deletedChannelUrl)) continue;
                collection.onChannelRemoved();
            }
        }
    }

    void resumeSync() {
        FailedMessageDispatcher.getInstance().startFailedMessageRetentionChecker();
        List<MessageCollection> collections = this.getMessageCollections();
        Logger.d("resumeSync. count : " + collections.size());
        final CountDownLatch counter = new CountDownLatch(collections.size());
        for (MessageCollection collection : collections) {
            collection.resumeSync(new MessageSynchronizer.MessageBackgroundSyncEventListener(){

                @Override
                public void onSyncAndWait(BackgroundSyncThread.SyncState syncState, SendBirdException e) {
                    counter.countDown();
                    Logger.d("resumeSync onSynced. count : " + counter.getCount());
                    if (counter.getCount() <= 0L) {
                        FailedMessageDispatcher.getInstance().resumeAllQueues();
                    }
                }
            });
        }
    }

    void pauseSync() {
        FailedMessageDispatcher.getInstance().pause();
        for (MessageCollection collection : this.getMessageCollections()) {
            collection.pauseSync();
        }
    }

    MessageContainer getMessageContainer() {
        return this.mMessageContainer;
    }

    MessageChunkContainer getMessageChunkContainer() {
        return this.mMessageChunkContainer;
    }

    private List<MessageCollection> getMessageCollections() {
        return new ArrayList<MessageCollection>(this.mMessageCollections);
    }

    public void clearCache() {
        Iterator<MessageCollection> iterator = this.mMessageCollections.iterator();
        while (iterator.hasNext()) {
            MessageCollection messageCollection = iterator.next();
            iterator.remove();
            messageCollection.remove();
        }
        this.mMessageChunkContainer.clear();
    }
}

