/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseMessage;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageFilter;
import com.sendbird.syncmanager.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class MessageChunkContainer {
    private Map<String, MessageChunk> mMessageChunks;
    private final Object mMessageChunksLock = new Object();

    MessageChunkContainer() {
        this.mMessageChunks = new HashMap<String, MessageChunk>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setup(String userId) throws SendBirdException {
        Object object = this.mMessageChunksLock;
        synchronized (object) {
            this.mMessageChunks.clear();
        }
        this.getChunks(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MessageChunk> getChunks(String userId) throws SendBirdException {
        List<MessageChunk> messageChunks = DatabaseController.getInstance().getAllMessageChunks(userId);
        Object object = this.mMessageChunksLock;
        synchronized (object) {
            this.mMessageChunks.clear();
            for (MessageChunk chunk : messageChunks) {
                this.mMessageChunks.put(chunk.getChunkId(), chunk);
            }
        }
        return messageChunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeIntersectedChunks(String userId, MessageChunk chunk) throws SendBirdException {
        Object object;
        ArrayList<MessageChunk> deletedChunks = new ArrayList<MessageChunk>();
        MessageChunk intersectedChunk = this.getIntersectedChunk(chunk);
        while (intersectedChunk != null) {
            chunk.merge(intersectedChunk);
            deletedChunks.add(intersectedChunk);
            object = this.mMessageChunksLock;
            synchronized (object) {
                this.mMessageChunks.remove(intersectedChunk.getChunkId());
            }
            intersectedChunk = this.getIntersectedChunk(chunk);
        }
        this.deleteChunks(userId, deletedChunks);
        this.upsertChunk(userId, chunk);
        object = this.mMessageChunksLock;
        synchronized (object) {
            this.mMessageChunks.put(chunk.getChunkId(), chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void upsertChunk(String userId, MessageChunk chunk) throws SendBirdException {
        DatabaseController.getInstance().upsertChunk(userId, chunk);
        Object object = this.mMessageChunksLock;
        synchronized (object) {
            this.mMessageChunks.put(chunk.getChunkId(), chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteChunks(String userId, List<MessageChunk> chunks) throws SendBirdException {
        DatabaseController.getInstance().deleteChunks(userId, chunks);
        Object object = this.mMessageChunksLock;
        synchronized (object) {
            for (MessageChunk chunk : chunks) {
                this.mMessageChunks.remove(chunk.getChunkId());
            }
        }
    }

    MessageChunk getCurrentChunk(String channelUrl, MessageFilter filter, long viewpointTimestamp, boolean isSyncedOnce, boolean needParentChunk) {
        Logger.d("getCurrentChunk(). syncedOnce : " + isSyncedOnce + ", needParentChunk : " + needParentChunk);
        MessageChunk chunk = this.getChunkByTimestamp(channelUrl, filter, viewpointTimestamp, needParentChunk);
        if (chunk == null && isSyncedOnce) {
            chunk = this.getNearestChunk(channelUrl, filter, viewpointTimestamp);
        }
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageChunk getNearestChunk(String channelUrl, MessageFilter filter, long ts) {
        Logger.d("getNearestChunk(). channelUrl = " + channelUrl + ", filter = " + filter + ", ts = " + ts);
        long nearestTimeDiff = Long.MAX_VALUE;
        MessageChunk nearestChunk = this.getChunkByTimestamp(channelUrl, filter, ts, true);
        if (nearestChunk != null) {
            return nearestChunk;
        }
        Object object = this.mMessageChunksLock;
        synchronized (object) {
            long timeDiff;
            long timeDiffWithEndAt;
            long timeDiffWithStartAt;
            for (MessageChunk chunk : this.mMessageChunks.values()) {
                timeDiffWithStartAt = Math.abs(chunk.getStartAt() - ts);
                timeDiffWithEndAt = Math.abs(chunk.getEndAt() - ts);
                timeDiff = Math.min(timeDiffWithStartAt, timeDiffWithEndAt);
                if (!channelUrl.equals(chunk.getChannelUrl()) || !filter.isEquals(chunk.getFilter()) || nearestTimeDiff <= timeDiff) continue;
                nearestTimeDiff = timeDiff;
                nearestChunk = chunk;
            }
            if (nearestChunk != null) {
                return nearestChunk;
            }
            nearestTimeDiff = Long.MAX_VALUE;
            nearestChunk = null;
            for (MessageChunk chunk : this.mMessageChunks.values()) {
                timeDiffWithStartAt = Math.abs(chunk.getStartAt() - ts);
                timeDiffWithEndAt = Math.abs(chunk.getEndAt() - ts);
                timeDiff = Math.min(timeDiffWithStartAt, timeDiffWithEndAt);
                if (!channelUrl.equals(chunk.getChannelUrl()) || !filter.isParent() || nearestTimeDiff <= timeDiff) continue;
                nearestTimeDiff = timeDiff;
                nearestChunk = chunk;
            }
        }
        return nearestChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageChunk getChunkByTimestamp(String channelUrl, MessageFilter filter, long ts, boolean needParentChunk) {
        Logger.d("getChunkByTimestamp(). channelUrl = " + channelUrl + ", filter = " + filter + ", ts = " + ts);
        Object object = this.mMessageChunksLock;
        synchronized (object) {
            for (MessageChunk chunk : this.mMessageChunks.values()) {
                if (!channelUrl.equals(chunk.getChannelUrl()) || ts < chunk.getStartAt() || ts > chunk.getEndAt() || !filter.isEquals(chunk.getFilter())) continue;
                return chunk;
            }
            if (needParentChunk) {
                for (MessageChunk chunk : this.mMessageChunks.values()) {
                    if (!channelUrl.equals(chunk.getChannelUrl()) || ts < chunk.getStartAt() || ts > chunk.getEndAt() || !chunk.isParent()) continue;
                    return chunk;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageChunk getIntersectedChunk(MessageChunk chunk) {
        Logger.d("getIntersectedChunk(). chunk range = " + chunk.getRangeAsString());
        Object object = this.mMessageChunksLock;
        synchronized (object) {
            for (MessageChunk chk : this.mMessageChunks.values()) {
                if (!chk.getFilter().isEquals(chunk.getFilter()) || !chunk.isIntersectWith(chk)) continue;
                Logger.d("getIntersectedChunk(). Find! intersected chunk range = " + chk.getRangeAsString());
                return chk;
            }
        }
        return null;
    }

    List<MessageChunk> getChunksContainingMessageAsEdge(BaseMessage message) {
        ArrayList<MessageChunk> chunkList = new ArrayList<MessageChunk>();
        for (MessageChunk chunk : this.mMessageChunks.values()) {
            if (!message.getChannelUrl().equals(chunk.getChannelUrl()) || message.getCreatedAt() != chunk.getEndAt()) continue;
            chunkList.add(chunk);
        }
        return chunkList;
    }

    List<MessageChunk> getChunksStartAtBeforeOffset(String channelUrl, long offset) {
        ArrayList<MessageChunk> chunkList = new ArrayList<MessageChunk>();
        for (MessageChunk chunk : this.mMessageChunks.values()) {
            if (!channelUrl.equals(chunk.getChannelUrl()) || chunk.getStartAt() > offset) continue;
            chunkList.add(chunk);
        }
        return chunkList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mMessageChunksLock;
        synchronized (object) {
            this.mMessageChunks.clear();
        }
    }
}

