/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.syncmanager.ChannelChangeLogSync;
import com.sendbird.syncmanager.ChannelCollection;
import com.sendbird.syncmanager.ChannelContainer;
import com.sendbird.syncmanager.ChannelSynchronizer;
import com.sendbird.syncmanager.DBJobTask;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.SharedPreferencesManager;
import com.sendbird.syncmanager.SyncManagerDb;
import com.sendbird.syncmanager.SyncManagerError;
import com.sendbird.syncmanager.SyncManagerUtils;
import com.sendbird.syncmanager.log.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class ChannelManager {
    private static ChannelManager sInstance;
    private String mIdentifier;
    private List<ChannelCollection> mCollections;
    private ChannelContainer mContainer;
    private Map<String, Long> mMessageOffsetMap;
    private SendBird.ChannelHandler mChannelHandler = new SendBird.ChannelHandler(){

        public void onMessageReceived(BaseChannel channel, BaseMessage message) {
            Logger.d("onMessageReceived, channel url = " + this.getChannelUrl(channel) + ", messageId = " + this.getMessageId(message));
        }

        public void onReadReceiptUpdated(GroupChannel channel) {
            Logger.d("onReadReceiptUpdated, channel url = " + this.getChannelUrl((BaseChannel)channel));
            ChannelManager.getInstance().upsertChannel(channel);
        }

        public void onUserReceivedInvitation(GroupChannel channel, User inviter, List<User> invitees) {
            Logger.d("onUserReceivedInvitation, channel = " + this.getChannelUrl((BaseChannel)channel) + ", inviter = " + this.getUserId(inviter) + ", I am = " + this.getUserId(SendBird.getCurrentUser()));
            ChannelManager.getInstance().upsertChannel(channel);
        }

        public void onUserDeclinedInvitation(GroupChannel channel, User inviter, User invitee) {
            Logger.d("onUserDeclinedInvitation, channel = " + this.getChannelUrl((BaseChannel)channel) + ", inviter = " + this.getUserId(inviter) + ", invitee = " + this.getUserId(invitee));
            if (SendBird.getCurrentUser() != null && invitee.getUserId().equals(SendBird.getCurrentUser().getUserId()) && channel != null) {
                ChannelManager.getInstance().removeChannelUrl(channel.getUrl());
            } else {
                ChannelManager.getInstance().upsertChannel(channel);
            }
        }

        public void onUserJoined(GroupChannel channel, User user) {
            Logger.d("onUserJoined, channel = " + this.getChannelUrl((BaseChannel)channel) + ", user = " + this.getUserId(user));
            ChannelManager.getInstance().upsertChannel(channel);
        }

        public void onUserLeft(GroupChannel channel, User user) {
            Logger.d("onUserLeft, channel = " + this.getChannelUrl((BaseChannel)channel) + ", user = " + this.getUserId(user));
            if (SendBird.getCurrentUser() != null && user.getUserId().equals(SendBird.getCurrentUser().getUserId()) && channel != null) {
                ChannelManager.getInstance().removeChannelUrl(channel.getUrl());
            } else {
                ChannelManager.getInstance().upsertChannel(channel);
            }
        }

        public void onUserMuted(BaseChannel channel, User user) {
            Logger.d("onUserMuted, channel = " + this.getChannelUrl(channel) + ", user = " + this.getUserId(user));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onUserUnmuted(BaseChannel channel, User user) {
            Logger.d("onUserUnmuted, channel = " + this.getChannelUrl(channel) + ", user = " + this.getUserId(user));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onUserBanned(BaseChannel channel, User user) {
            Logger.d("onUserBanned, channel = " + this.getChannelUrl(channel) + ", user = " + this.getUserId(user));
            if (channel != null && channel.isGroupChannel()) {
                if (SendBird.getCurrentUser() != null && user.getUserId().equals(SendBird.getCurrentUser().getUserId())) {
                    ChannelManager.getInstance().removeChannelUrl(channel.getUrl());
                } else {
                    ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
                }
            }
        }

        public void onUserUnbanned(BaseChannel channel, User user) {
            Logger.d("onUserUnbanned, channel = " + this.getChannelUrl(channel) + ", user = " + this.getUserId(user));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onChannelFrozen(BaseChannel channel) {
            Logger.d("onChannelFrozen, channel = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onChannelUnfrozen(BaseChannel channel) {
            Logger.d("onChannelUnfrozen, channel = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onChannelChanged(BaseChannel channel) {
            Logger.d("onChannelChanged, channel = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onChannelDeleted(String channelUrl, BaseChannel.ChannelType channelType) {
            Logger.d("onChannelDeleted, channelUrl = " + channelUrl + ", channelType = " + channelType);
            ChannelManager.getInstance().removeChannelUrl(channelUrl);
        }

        public void onMetaDataCreated(BaseChannel channel, Map<String, String> metaDataMap) {
            Logger.d("onMetaDataCreated, channelUrl = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onMetaDataUpdated(BaseChannel channel, Map<String, String> metaDataMap) {
            Logger.d("onMetaDataUpdated, channelUrl = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onMetaDataDeleted(BaseChannel channel, List<String> keys) {
            Logger.d("onMetaDataDeleted, channelUrl = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onMetaCountersCreated(BaseChannel channel, Map<String, Integer> metaCounterMap) {
            Logger.d("onMetaCountersCreated, channelUrl = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onMetaCountersUpdated(BaseChannel channel, Map<String, Integer> metaCounterMap) {
            Logger.d("onMetaCountersUpdated, channelUrl = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onMetaCountersDeleted(BaseChannel channel, List<String> keys) {
            Logger.d("onMetaCountersDeleted, channelUrl = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onChannelHidden(GroupChannel channel) {
            Logger.d("onChannelHidden, channelUrl = " + this.getChannelUrl((BaseChannel)channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel(channel);
            }
        }

        public void onTypingStatusUpdated(GroupChannel channel) {
            Logger.d("onTypingStatusUpdated, channelUrl = " + this.getChannelUrl((BaseChannel)channel));
        }

        private String getChannelUrl(BaseChannel channel) {
            return channel == null ? "null" : channel.getUrl();
        }

        private String getUserId(User user) {
            return user == null ? "null" : user.getUserId();
        }

        private String getMessageId(BaseMessage message) {
            return message == null ? "null" : String.valueOf(message.getMessageId());
        }
    };

    private ChannelManager() {
        this.mIdentifier = UUID.randomUUID().toString();
        this.mCollections = new ArrayList<ChannelCollection>();
        this.mContainer = new ChannelContainer();
        this.mMessageOffsetMap = SharedPreferencesManager.getInstance().getMessageOffsetMap();
        SendBird.addChannelHandler((String)this.mIdentifier, (SendBird.ChannelHandler)this.mChannelHandler);
    }

    void setup(String userId) throws SendBirdException {
        this.mContainer.setup(userId);
        ChannelSynchronizer.getInstance().clear();
        ChannelChangeLogSync.getInstance().clear();
    }

    static void deinit() {
        sInstance = null;
    }

    static ChannelManager getInstance() {
        if (sInstance == null) {
            throw new RuntimeException((Throwable)SyncManagerError.getException(810100));
        }
        return sInstance;
    }

    static void init() {
        if (sInstance == null) {
            sInstance = new ChannelManager();
        }
    }

    void addChannelCollection(ChannelCollection collection) {
        ChannelManager.getInstance().mCollections.add(collection);
    }

    void removeChannelCollection(ChannelCollection collection) {
        ChannelManager.getInstance().mCollections.remove(collection);
    }

    void resumeSync() {
        this.broadcastResumeSync();
        ChannelChangeLogSync.getInstance().start(true);
        ChannelSynchronizer.getInstance().resumeSync();
    }

    void pauseSync() {
        this.broadcastPauseSync();
        ChannelChangeLogSync.getInstance().stop();
        ChannelSynchronizer.getInstance().pauseSync();
    }

    ChannelContainer getContainer() {
        return this.mContainer;
    }

    private void upsertChannel(final GroupChannel channel) {
        if (channel == null) {
            return;
        }
        SyncManagerDb.addTask(new DBJobTask<List<GroupChannel>>(){

            @Override
            public List<GroupChannel> call(String userId) throws Exception {
                ArrayList<GroupChannel> channels = new ArrayList<GroupChannel>();
                channels.add(channel);
                ChannelManager.getInstance().getContainer().upsertChannels(userId, channels);
                ChannelManager.getInstance().checkMessageOffset(userId, channel);
                return channels;
            }

            @Override
            public void onResult(List<GroupChannel> result, SendBirdException e) {
                if (result != null) {
                    MessageManager.getInstance().broadcastChannelUpdated(result);
                    ChannelManager.getInstance().broadcastChannelUpserted(result);
                }
            }
        });
    }

    void checkMessageOffset(String userId, GroupChannel groupChannel) throws SendBirdException {
        boolean offsetChanged;
        long messageOffset = 0L;
        try {
            if (SyncManagerUtils.isCoreSDKVersionAbove("3.0.107")) {
                messageOffset = groupChannel.getMessageOffsetTimestamp();
            }
        }
        catch (Exception e) {
            Logger.d(e);
        }
        if (messageOffset == 0L) {
            return;
        }
        Long savedOffset = this.mMessageOffsetMap.get(groupChannel.getUrl());
        Logger.d("checkMessageOffset: savedOffset : " + savedOffset + ", channelOffset : " + messageOffset);
        boolean bl = offsetChanged = savedOffset == null || messageOffset > savedOffset;
        if (offsetChanged) {
            MessageManager.getInstance().deleteMessagesBeforeOffset(userId, groupChannel.getUrl(), messageOffset);
            this.mMessageOffsetMap.put(groupChannel.getUrl(), messageOffset);
            SharedPreferencesManager.getInstance().setMessageOffsetMap(this.mMessageOffsetMap);
        }
    }

    private void removeChannelUrl(final String channelUrl) {
        SyncManagerDb.addTask(new DBJobTask<List<String>>(){

            @Override
            public List<String> call(String userId) throws Exception {
                ChannelManager.getInstance().getContainer().removeChannelUrl(userId, channelUrl);
                ArrayList<String> channelUrls = new ArrayList<String>();
                channelUrls.add(channelUrl);
                DatabaseController.getInstance().removeAllMessagesInChannels(userId, channelUrls);
                return channelUrls;
            }

            @Override
            public void onResult(List<String> result, SendBirdException e) {
                if (result != null) {
                    MessageManager.getInstance().broadcastChannelRemoved(result);
                    ChannelManager.getInstance().broadcastChannelRemoved(result);
                }
            }
        });
    }

    private List<ChannelCollection> getCollections() {
        return new ArrayList<ChannelCollection>(this.mCollections);
    }

    private void broadcastResumeSync() {
        List<ChannelCollection> collections = this.getCollections();
        for (ChannelCollection collection : collections) {
            collection.resumeSync();
        }
    }

    private void broadcastPauseSync() {
        List<ChannelCollection> collections = this.getCollections();
        for (ChannelCollection collection : collections) {
            collection.pauseSync();
        }
    }

    void broadcastChannelUpserted(List<GroupChannel> channelList) {
        if (channelList == null || channelList.isEmpty()) {
            return;
        }
        for (GroupChannel channel : channelList) {
            List<ChannelCollection> collections = this.getCollections();
            for (ChannelCollection collection : collections) {
                if (collection == null) continue;
                collection.upsertChannel(channel);
            }
        }
    }

    void broadcastChannelRemoved(List<String> channelUrlList) {
        if (channelUrlList == null || channelUrlList.isEmpty()) {
            return;
        }
        List<ChannelCollection> collections = this.getCollections();
        for (ChannelCollection collection : collections) {
            collection.removeChannelUrls(channelUrlList);
        }
    }

    void clearCache() {
        this.mContainer.clear();
        this.mCollections.clear();
        this.mMessageOffsetMap.clear();
    }

    void clearCache(String userId) {
        this.mContainer.clear(userId);
        this.mCollections.clear();
        this.mMessageOffsetMap.clear();
    }

    static void getChannel(String channelUrl, final GroupChannel.GroupChannelGetHandler handler) {
        GroupChannel.getChannel((String)channelUrl, (GroupChannel.GroupChannelGetHandler)new GroupChannel.GroupChannelGetHandler(){

            public void onResult(GroupChannel groupChannel, SendBirdException e) {
                if (groupChannel != null) {
                    ChannelManager.getInstance().upsertChannel(groupChannel);
                }
                if (handler != null) {
                    handler.onResult(groupChannel, e);
                }
            }
        });
    }
}

