/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.BackgroundSyncThread;
import com.sendbird.syncmanager.DBJobTask;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.MessageSynchronizer;
import com.sendbird.syncmanager.SyncManagerDb;
import com.sendbird.syncmanager.log.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

class MessageBackgroundSyncThread
extends BackgroundSyncThread {
    public static final int MESSAGE_QUERY_RESULT_SIZE = 100;
    private BaseChannel mChannel;
    private MessageChunk mChunk;
    private boolean mIsNext;
    private MessageSynchronizer.MessageBackgroundSyncEventListener mEventListener;
    private int mRetryCounter = 0;
    private boolean mIsApiCallRequired;

    MessageBackgroundSyncThread(BaseChannel channel, MessageChunk chunk, boolean isNext, boolean isApiCallRequired) {
        this.mChannel = channel;
        this.mChunk = chunk;
        this.mIsNext = isNext;
        this.mIsApiCallRequired = isApiCallRequired;
    }

    void setEventListener(MessageSynchronizer.MessageBackgroundSyncEventListener listener) {
        this.mEventListener = listener;
    }

    void stopSync() {
        this.mEventListener = null;
        this.mSyncState = BackgroundSyncThread.SyncState.PAUSED;
    }

    @Override
    public void run() {
        Logger.d("run(). channelUrl = " + this.mChannel.getUrl() + ", isNext = " + this.mIsNext + ", chunk : " + this.mChunk);
        this.mSyncState = BackgroundSyncThread.SyncState.RUNNING;
        if (this.mChunk == null || !this.mIsApiCallRequired) {
            this.mSyncState = BackgroundSyncThread.SyncState.FINISHED;
        }
        while (this.mSyncState != BackgroundSyncThread.SyncState.FINISHED && this.mSyncState != BackgroundSyncThread.SyncState.PAUSED) {
            this.mRetryCounter = 0;
            final CountDownLatch loopLatch = new CountDownLatch(1);
            final long timestamp = this.mIsNext ? this.mChunk.getEndAt() : this.mChunk.getStartAt();
            this.getMessagesByTimestamp(timestamp, new BaseChannel.GetMessagesHandler(){

                public void onResult(List<BaseMessage> list, SendBirdException e) {
                    Logger.d("getSucceededMessagesByTimestamp. list size = " + (list == null ? "null" : Integer.valueOf(list.size())) + ", e = " + (Object)((Object)e));
                    1 retryHandler = this;
                    if (e != null) {
                        if (MessageBackgroundSyncThread.this.mRetryCounter < 3) {
                            MessageBackgroundSyncThread.this.mRetryCounter++;
                            MessageBackgroundSyncThread.this.getMessagesByTimestamp(timestamp, retryHandler);
                        } else {
                            MessageBackgroundSyncThread.this.mSyncState = BackgroundSyncThread.SyncState.PAUSED;
                            loopLatch.countDown();
                        }
                        return;
                    }
                    final ArrayList<BaseMessage> fetchedList = new ArrayList<BaseMessage>();
                    if (list != null) {
                        fetchedList.addAll(list);
                    }
                    SyncManagerDb.addTask(new DBJobTask<Void>(){

                        @Override
                        public Void call(String userId) throws Exception {
                            if (!fetchedList.isEmpty()) {
                                DatabaseController.getInstance().upsertSucceededMessages(userId, fetchedList, true);
                                long startAt = ((BaseMessage)fetchedList.get(0)).getCreatedAt();
                                long endAt = ((BaseMessage)fetchedList.get(fetchedList.size() - 1)).getCreatedAt();
                                MessageChunk newChunk = new MessageChunk(MessageBackgroundSyncThread.this.mChannel.getUrl(), startAt, endAt, MessageBackgroundSyncThread.this.mChunk.getFilter());
                                MessageBackgroundSyncThread.this.mChunk.merge(newChunk);
                                MessageManager.getInstance().getMessageChunkContainer().mergeIntersectedChunks(userId, MessageBackgroundSyncThread.this.mChunk);
                            }
                            return null;
                        }

                        @Override
                        public void onResult(Void result, SendBirdException e) {
                            if (fetchedList.size() < 100) {
                                MessageBackgroundSyncThread.this.mSyncState = BackgroundSyncThread.SyncState.FINISHED;
                                if (MessageBackgroundSyncThread.this.mIsNext) {
                                    MessageBackgroundSyncThread.this.mChunk.setEndSynced(true);
                                } else {
                                    MessageBackgroundSyncThread.this.mChunk.setStartSynced(true);
                                }
                            }
                            MessageBackgroundSyncThread.this.onSyncAndAwait(e);
                            loopLatch.countDown();
                        }
                    });
                }
            });
            try {
                loopLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Logger.d("sync finished. channel url = " + this.mChannel.getUrl() + ", isNext = " + this.mIsNext);
    }

    private void onSyncAndAwait(SendBirdException e) {
        if (this.mEventListener != null) {
            this.mEventListener.onSyncAndWait(this.mSyncState, e);
        }
    }

    private void getMessagesByTimestamp(long ts, BaseChannel.GetMessagesHandler handler) {
        if (this.mIsNext) {
            this.mChannel.getNextMessagesByTimestamp(ts, true, 100, false, this.mChunk.getFilter().getMessageTypeFilter(), this.mChunk.getFilter().getCustomType(), this.mChunk.getFilter().getSenderUserIds(), true, handler);
        } else {
            this.mChannel.getPreviousMessagesByTimestamp(ts, true, 100, false, this.mChunk.getFilter().getMessageTypeFilter(), this.mChunk.getFilter().getCustomType(), this.mChunk.getFilter().getSenderUserIds(), true, handler);
        }
    }

    @Override
    public String toString() {
        return "MessageBackgroundSyncThread{mChannel=" + this.mChannel.getUrl() + ", mChunk=" + this.mChunk + ", mIsNext=" + this.mIsNext + ", mEventListener=" + this.mEventListener + ", mRetryCounter=" + this.mRetryCounter + ", mIsApiCallRequired=" + this.mIsApiCallRequired + '}';
    }
}

