/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelListQuery;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.BackgroundSyncThread;
import com.sendbird.syncmanager.ChannelContainer;
import com.sendbird.syncmanager.ChannelManager;
import com.sendbird.syncmanager.ChannelSynchronizer;
import com.sendbird.syncmanager.SyncManagerUtils;
import com.sendbird.syncmanager.handler.CompletionHandler;
import com.sendbird.syncmanager.log.Logger;
import java.util.List;
import java.util.concurrent.CountDownLatch;

class ChannelBackgroundSync {
    private static final int QUERY_RESULT_SIZE = 100;
    private ChannelBackgroundSyncThread mThread;
    private GroupChannelListQuery mQuery;
    private ChannelSynchronizer.ChannelSynchronizerEventListener mListener;
    private int mReferenceCounter = 0;
    private int mRetryCounter = 0;

    ChannelBackgroundSync(GroupChannelListQuery query, ChannelSynchronizer.ChannelSynchronizerEventListener listener) {
        this.mQuery = query;
        this.mListener = listener;
    }

    void start() {
        ++this.mReferenceCounter;
        if (this.mReferenceCounter == 1 && this.mThread == null) {
            ChannelManager.getInstance().getContainer().getGroupChannelListQuery(this.mQuery.getCustomTypesFilter(), this.mQuery.isIncludeEmpty(), this.mQuery.getOrder(), new ChannelContainer.GetGroupChannelListQueryHandler(){

                @Override
                public void onResult(GroupChannelListQuery query, String savePoint, SendBirdException e) {
                    if (e != null) {
                        e.printStackTrace();
                        return;
                    }
                    if (query == null) {
                        query = GroupChannel.createMyGroupChannelListQuery();
                        query.setIncludeEmpty(ChannelBackgroundSync.this.mQuery.isIncludeEmpty());
                        query.setCustomTypesFilter(ChannelBackgroundSync.this.mQuery.getCustomTypesFilter());
                        query.setOrder(ChannelBackgroundSync.this.mQuery.getOrder());
                    }
                    ChannelBackgroundSync.this.mQuery = query;
                    ChannelBackgroundSync.this.clearQuery(ChannelBackgroundSync.this.mQuery);
                    ChannelBackgroundSync.this.mThread = new ChannelBackgroundSyncThread();
                    ChannelBackgroundSync.this.mThread.start();
                }
            });
        }
    }

    void stop() {
        --this.mReferenceCounter;
        if (this.mReferenceCounter == 0 && this.mThread != null) {
            this.mThread.stopSync();
            this.mThread = null;
        }
    }

    private void clearQuery(GroupChannelListQuery query) {
        query.setLimit(100);
        if (query.getChannelUrlsFilter() != null) {
            query.getChannelUrlsFilter().clear();
        }
        query.setNicknameContainsFilter(null);
        query.setMetaDataOrderKeyFilter(null);
        query.setHiddenChannelFilter(GroupChannelListQuery.HiddenChannelFilter.UNHIDDEN);
        query.setMemberStateFilter(GroupChannelListQuery.MemberStateFilter.ALL);
        query.setSuperChannelFilter(GroupChannelListQuery.SuperChannelFilter.ALL);
        query.setPublicChannelFilter(GroupChannelListQuery.PublicChannelFilter.ALL);
        query.setUnreadChannelFilter(GroupChannelListQuery.UnreadChannelFilter.ALL);
    }

    class ChannelBackgroundSyncThread
    extends BackgroundSyncThread {
        boolean mIsStopped = false;

        ChannelBackgroundSyncThread() {
        }

        @Override
        public void run() {
            Logger.d("ChannelBackgroundSyncThread run()");
            boolean bl = this.mIsStopped = !ChannelBackgroundSync.this.mQuery.hasNext();
            if (this.mIsStopped && ChannelBackgroundSync.this.mListener != null) {
                ChannelBackgroundSync.this.mListener.onSynced(null);
            }
            this.mSyncState = BackgroundSyncThread.SyncState.RUNNING;
            while (!this.mIsStopped) {
                ChannelBackgroundSync.this.mRetryCounter = 0;
                final CountDownLatch lock = new CountDownLatch(1);
                ChannelBackgroundSync.this.mQuery.next(new GroupChannelListQuery.GroupChannelListQueryResultHandler(){

                    public void onResult(final List<GroupChannel> queryResult, final SendBirdException e) {
                        final 1 retryHandler = this;
                        Logger.d("ChannelBackgroundSyncThread onResult(). queryResult = " + (queryResult == null ? "null" : Integer.valueOf(queryResult.size())) + ", e = " + e + ", hasNext = " + ChannelBackgroundSync.this.mQuery.hasNext());
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                if (e != null) {
                                    e.printStackTrace();
                                    if (ChannelBackgroundSync.this.mRetryCounter < 3) {
                                        ChannelBackgroundSync.this.mRetryCounter++;
                                        ChannelBackgroundSync.this.mQuery.next(retryHandler);
                                    } else {
                                        ChannelBackgroundSyncThread.this.mIsStopped = true;
                                        ChannelBackgroundSyncThread.this.mSyncState = BackgroundSyncThread.SyncState.PAUSED;
                                        lock.countDown();
                                    }
                                    return;
                                }
                                if (queryResult == null || queryResult.size() == 0) {
                                    ChannelManager.getInstance().getContainer().upsertGroupChannelListQuery(ChannelBackgroundSync.this.mQuery, "", null);
                                    ChannelBackgroundSyncThread.this.mIsStopped = true;
                                    if (ChannelBackgroundSync.this.mListener != null) {
                                        ChannelBackgroundSync.this.mListener.onSynced(null);
                                    }
                                    lock.countDown();
                                    return;
                                }
                                String savePoint = SyncManagerUtils.getOffset((GroupChannel)queryResult.get(queryResult.size() - 1), ChannelBackgroundSync.this.mQuery);
                                ChannelManager.getInstance().getContainer().upsertGroupChannelListQuery(ChannelBackgroundSync.this.mQuery, savePoint, new CompletionHandler(){

                                    @Override
                                    public void onCompleted(SendBirdException e) {
                                        if (e != null) {
                                            e.printStackTrace();
                                        }
                                        ChannelManager.getInstance().getContainer().upsertChannels(queryResult, new ChannelContainer.UpsertChannelHandler(){

                                            @Override
                                            public void onResult(List<GroupChannel> insertedChannels, List<GroupChannel> updatedChannels, SendBirdException e) {
                                                if (ChannelBackgroundSync.this.mListener != null) {
                                                    ChannelBackgroundSync.this.mListener.onSynced(e);
                                                }
                                                if (!ChannelBackgroundSync.this.mQuery.hasNext()) {
                                                    ChannelBackgroundSyncThread.this.mIsStopped = true;
                                                }
                                                lock.countDown();
                                            }
                                        });
                                    }
                                });
                            }
                        }).start();
                    }
                });
                try {
                    lock.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.mSyncState = BackgroundSyncThread.SyncState.FINISHED;
        }

        void stopSync() {
            this.mIsStopped = true;
        }
    }
}

