/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.content.Context;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.ChannelManager;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.SharedPreferencesManager;
import com.sendbird.syncmanager.SyncManagerError;
import com.sendbird.syncmanager.handler.CompletionHandler;

public class SendBirdSyncManager {
    private static final String TAG = SendBirdSyncManager.class.getSimpleName();
    private static final String VERSION = "1.1.2";
    private static SendBirdSyncManager sInstance;
    private static String mCurrentUserId;
    boolean mIsPaused = false;
    private Options mOptions;
    public static final int LOGGER_NONE = 0;
    public static final int LOGGER_INFO = 1;

    public static String getSDKVersion() {
        return VERSION;
    }

    private SendBirdSyncManager(Options options) {
        this.mOptions = options;
    }

    public static void setup(Context context, String userId, CompletionHandler handler) {
        SendBirdSyncManager.setup(context, userId, new Options(), handler);
    }

    public static void setup(Context context, String userId, Options options, final CompletionHandler handler) {
        if (context == null || userId == null) {
            if (handler != null) {
                handler.onCompleted(SyncManagerError.getException(810300));
            }
            return;
        }
        if (sInstance == null) {
            sInstance = new SendBirdSyncManager(options);
        }
        mCurrentUserId = userId;
        SharedPreferencesManager.init(context);
        DatabaseController.init(context);
        ChannelManager.init();
        MessageManager.init();
        ChannelManager.getInstance().setup(new CompletionHandler(){

            @Override
            public void onCompleted(SendBirdException e) {
                MessageManager.getInstance().setup(new CompletionHandler(){

                    @Override
                    public void onCompleted(SendBirdException e) {
                        if (handler != null) {
                            handler.onCompleted(e);
                        }
                    }
                });
            }
        });
    }

    public static SendBirdSyncManager getInstance() {
        if (sInstance == null) {
            throw new RuntimeException((Throwable)SyncManagerError.getException(810100));
        }
        return sInstance;
    }

    public void resumeSync() {
        Logger.d(TAG, "resumeSync");
        this.mIsPaused = false;
        MessageManager.getInstance().resumeSync();
        ChannelManager.getInstance().resumeSync();
    }

    public void pauseSync() {
        Logger.d(TAG, "pauseSync");
        this.mIsPaused = true;
        MessageManager.getInstance().pauseSync();
        ChannelManager.getInstance().pauseSync();
    }

    public void clearCache() {
        Logger.d(TAG, "clearCache");
        ChannelManager.getInstance().clearCache();
        MessageManager.getInstance().clearCache();
        DatabaseController.getInstance().clearCache();
        SharedPreferencesManager.getInstance().clearCache();
    }

    public void clearCache(String userId) {
        Logger.d(TAG, "clearCache. userId = " + userId);
        ChannelManager.getInstance().clearCache(userId);
        MessageManager.getInstance().clearCache();
        DatabaseController.getInstance().clearCache(userId);
    }

    public Options getOptions() {
        return this.mOptions;
    }

    String getUserId() {
        return mCurrentUserId;
    }

    boolean isPaused() {
        return this.mIsPaused;
    }

    void reset() {
        mCurrentUserId = "";
        this.mIsPaused = false;
    }

    void setMessageCollectionCapacity(int capacity) {
        if (this.mOptions != null) {
            this.mOptions.mMessageCollectionCapacity = capacity;
        }
    }

    public static void setLoggerLevel(int level) {
        Logger.sLevel = level;
    }

    public static class Options {
        private int mMessageCollectionCapacity = 1000;
        private MessageResendPolicy mMessageResendPolicy = MessageResendPolicy.NONE;

        public int getMessageCollectionCapacity() {
            return this.mMessageCollectionCapacity;
        }

        public void setMessageCollectionCapacity(int capacity) {
            if (capacity < 200) {
                Logger.e(TAG, "setMessageCollectionCapacity. input value should be larger than 200. your input is " + capacity);
                return;
            }
            this.mMessageCollectionCapacity = capacity;
        }

        public MessageResendPolicy getMessageResendPolicy() {
            return this.mMessageResendPolicy;
        }

        public void setMessageResendPolicy(MessageResendPolicy messageResendPolicy) {
            this.mMessageResendPolicy = messageResendPolicy;
        }
    }

    public static enum MessageResendPolicy {
        NONE;

    }
}

