/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.support.annotation.NonNull;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.Sender;
import com.sendbird.android.User;
import com.sendbird.android.UserMessage;
import com.sendbird.syncmanager.BackgroundSyncThread;
import com.sendbird.syncmanager.ChannelContainer;
import com.sendbird.syncmanager.ChannelManager;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageContainer;
import com.sendbird.syncmanager.MessageEventAction;
import com.sendbird.syncmanager.MessageFilter;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.MessageSynchronizer;
import com.sendbird.syncmanager.SendBirdSyncManager;
import com.sendbird.syncmanager.SharedPreferencesManager;
import com.sendbird.syncmanager.SyncManagerError;
import com.sendbird.syncmanager.handler.CompletionHandler;
import com.sendbird.syncmanager.handler.MessageCollectionCreateHandler;
import com.sendbird.syncmanager.handler.MessageCollectionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MessageCollection {
    private static final String TAG = MessageCollection.class.getSimpleName();
    private GroupChannel mChannel;
    private MessageFilter mFilter;
    private long mViewpointTimestamp;
    private int mLimit = 20;
    private List<BaseMessage> mChunkMessages;
    private List<BaseMessage> mPrevTempMessages;
    private List<BaseMessage> mNextTempMessages;
    private List<BaseMessage> mPreviewMessages;
    private MessageCollectionHandler mMessageCollectionHandler;
    private ExecutorService mExecutorService;
    private ExecutorService mEventExecutorService;
    private MessageSynchronizer mSynchronizer;
    private boolean mIsNextLoading = false;
    private boolean mIsPrevLoading = false;
    private boolean mIsApplyingChangeLog = false;
    private boolean mIsCollectionRemoved = false;
    private final Object mPreviewMessagesLock = new Object();

    public MessageCollection(@NonNull GroupChannel channel, @NonNull MessageFilter filter, long viewpointTimestamp) {
        this.mChannel = channel;
        this.mFilter = filter;
        this.mViewpointTimestamp = viewpointTimestamp;
        this.mChunkMessages = new ArrayList<BaseMessage>();
        this.mPrevTempMessages = new ArrayList<BaseMessage>();
        this.mNextTempMessages = new ArrayList<BaseMessage>();
        this.mPreviewMessages = new ArrayList<BaseMessage>();
        this.mSynchronizer = new MessageSynchronizer((BaseChannel)channel, filter, viewpointTimestamp);
        this.mExecutorService = Executors.newSingleThreadExecutor();
        this.mEventExecutorService = Executors.newSingleThreadExecutor();
        MessageManager.getInstance().addMessageCollection(this);
        this.resumeSync();
    }

    public static void create(final String channelUrl, final @NonNull MessageFilter filter, final long viewpointTimestamp, final MessageCollectionCreateHandler handler) {
        Logger.d(TAG, "create(). channelUrl = " + channelUrl + ", filter = " + filter + ", viewpointTimestamp = " + viewpointTimestamp);
        ChannelManager.getInstance().getContainer().getChannel(channelUrl, new ChannelContainer.GetChannelHandler(){

            @Override
            public void onResult(GroupChannel channel, SendBirdException e) {
                if (channel == null) {
                    Logger.d(TAG, "create(). failed to get local channel");
                    GroupChannel.getChannel((String)channelUrl, (GroupChannel.GroupChannelGetHandler)new GroupChannel.GroupChannelGetHandler(){

                        public void onResult(GroupChannel groupChannel, SendBirdException e) {
                            if (e != null) {
                                if (handler != null) {
                                    handler.onResult(null, e);
                                }
                                return;
                            }
                            if (handler != null) {
                                handler.onResult(new MessageCollection(groupChannel, filter, viewpointTimestamp), null);
                            }
                        }
                    });
                    return;
                }
                if (handler != null) {
                    handler.onResult(new MessageCollection(channel, filter, viewpointTimestamp), null);
                }
            }
        });
    }

    public void remove() {
        Logger.d(TAG, "remove(), channel url = " + this.mChannel.getUrl());
        this.mIsCollectionRemoved = true;
        MessageManager.getInstance().removeMessageCollection(this);
        this.mSynchronizer.stop();
        this.mExecutorService.shutdownNow();
        this.mEventExecutorService.shutdownNow();
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public void setCollectionHandler(MessageCollectionHandler handler) {
        this.mMessageCollectionHandler = handler;
    }

    public void fetch(Direction direction, CompletionHandler handler) {
        Logger.d(TAG, "fetch(). direction = " + (Object)((Object)direction));
        if (direction == Direction.PREVIOUS) {
            if (this.mIsPrevLoading) {
                if (handler != null) {
                    handler.onCompleted(SyncManagerError.getException(810200));
                }
                return;
            }
            this.mIsPrevLoading = true;
            this.load(false, handler);
        } else if (direction == Direction.NEXT) {
            if (this.mIsNextLoading) {
                if (handler != null) {
                    handler.onCompleted(SyncManagerError.getException(810200));
                }
                return;
            }
            this.mIsNextLoading = true;
            this.load(true, handler);
        }
    }

    public void resetViewpointTimestamp(long viewpointTimestamp) {
        Logger.d(TAG, "resetViewpointTimestamp(). viewpointTimestamp = " + viewpointTimestamp);
        this.mViewpointTimestamp = viewpointTimestamp;
        this.mSynchronizer.stop();
        this.mSynchronizer = new MessageSynchronizer((BaseChannel)this.mChannel, this.mFilter, this.mViewpointTimestamp);
        this.mSynchronizer.start();
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                MessageCollection.this.mPrevTempMessages.clear();
                MessageCollection.this.mNextTempMessages.clear();
                MessageCollection.this.mChunkMessages.clear();
            }
        });
        if (this.mMessageCollectionHandler != null) {
            this.mMessageCollectionHandler.onMessageEvent(this, new ArrayList<BaseMessage>(), MessageEventAction.CLEAR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMessage(BaseMessage message) {
        if (message == null) {
            Logger.d(TAG, "appendMessage(). given message is null");
            return;
        }
        if (!this.isMyMessage(message)) {
            Logger.d(TAG, "deleteMessage(). given message is not my message");
            return;
        }
        Logger.d(TAG, "appendMessage(). message id = " + message.getMessageId());
        if (message.getMessageId() == 0L) {
            Object object = this.mPreviewMessagesLock;
            synchronized (object) {
                this.mPreviewMessages.add(message);
            }
            this.onMessageEvent(Arrays.asList(message), MessageEventAction.INSERT);
            this.checkCapacity(true);
            return;
        }
        BaseMessage removedMessage = null;
        Object object = this.mPreviewMessagesLock;
        synchronized (object) {
            for (int i = 0; i < this.mPreviewMessages.size(); ++i) {
                BaseMessage previewMessage = this.mPreviewMessages.get(i);
                if (!this.getRequestId(previewMessage).equals(this.getRequestId(message))) continue;
                removedMessage = this.mPreviewMessages.remove(i);
                break;
            }
        }
        if (removedMessage != null) {
            this.onMessageEvent(Arrays.asList(removedMessage), MessageEventAction.REMOVE);
        }
        MessageManager.getInstance().appendMessage(message);
    }

    public void updateMessage(BaseMessage message) {
        if (message == null) {
            Logger.d(TAG, "updateMessage(). given message is null");
            return;
        }
        if (!this.isMyMessage(message)) {
            Logger.d(TAG, "deleteMessage(). given message is not my message");
            return;
        }
        Logger.d(TAG, "updateMessage. message id = " + message.getMessageId());
        if (message.getMessageId() == 0L) {
            return;
        }
        MessageManager.getInstance().updateMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessage(BaseMessage message) {
        if (message == null) {
            Logger.d(TAG, "deleteMessage(). given message is null");
            return;
        }
        if (!this.isMyMessage(message)) {
            Logger.d(TAG, "deleteMessage(). given message is not my message");
            return;
        }
        Logger.d(TAG, "deleteMessage. message id = " + message.getMessageId());
        if (message.getMessageId() == 0L) {
            BaseMessage removedMessage = null;
            Object object = this.mPreviewMessagesLock;
            synchronized (object) {
                for (int i = 0; i < this.mPreviewMessages.size(); ++i) {
                    BaseMessage previewMessage = this.mPreviewMessages.get(i);
                    if (!this.getRequestId(previewMessage).equals(this.getRequestId(message))) continue;
                    removedMessage = this.mPreviewMessages.remove(i);
                    break;
                }
            }
            if (removedMessage != null) {
                this.onMessageEvent(Arrays.asList(removedMessage), MessageEventAction.REMOVE);
            }
            return;
        }
        MessageManager.getInstance().deleteMessage(this.mChannel.getUrl(), message.getMessageId());
    }

    public GroupChannel getChannel() {
        return this.mChannel;
    }

    public int getMessageCount() {
        return this.mChunkMessages.size() + this.mNextTempMessages.size() + this.mPrevTempMessages.size();
    }

    public void handleSendMessageResponse(BaseMessage message, SendBirdException e) {
        if (e != null) {
            switch (SendBirdSyncManager.getInstance().getOptions().getMessageResendPolicy()) {
                case NONE: {
                    this.deleteMessage(message);
                }
            }
            return;
        }
        this.appendMessage(message);
    }

    String getChannelUrl() {
        return this.mChannel.getUrl();
    }

    void onInsertedMessagesReceived(final List<BaseMessage> messages) {
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                boolean isViewEmpty;
                ArrayList<BaseMessage> insertedMessages = new ArrayList<BaseMessage>();
                for (BaseMessage message : messages) {
                    if (MessageCollection.this.isMessageInLoadedChunkMessage(message.getMessageId())) continue;
                    insertedMessages.add(message);
                }
                boolean bl = isViewEmpty = MessageCollection.this.mChunkMessages.isEmpty() && MessageCollection.this.mPrevTempMessages.isEmpty() && MessageCollection.this.mNextTempMessages.isEmpty();
                if (isViewEmpty) {
                    MessageCollection.this.addToTempMessages(insertedMessages, true);
                    MessageCollection.this.onMessageEvent(insertedMessages, MessageEventAction.INSERT);
                } else {
                    MessageChunk currentChunk = MessageCollection.this.getCurrentChunk(MessageCollection.this.mSynchronizer.isSyncedOnce());
                    boolean isBackSyncFinished = MessageCollection.this.mSynchronizer.isSyncFinished(true);
                    if (currentChunk == null) {
                        if (isBackSyncFinished) {
                            MessageCollection.this.addToTempMessages(insertedMessages, true);
                            MessageCollection.this.onMessageEvent(insertedMessages, MessageEventAction.INSERT);
                        }
                    } else {
                        BaseMessage latestChunkMessage;
                        long chunkTs = currentChunk.getEndAt();
                        BaseMessage baseMessage = latestChunkMessage = MessageCollection.this.mChunkMessages.size() > 0 ? (BaseMessage)MessageCollection.this.mChunkMessages.get(MessageCollection.this.mChunkMessages.size() - 1) : null;
                        if (isBackSyncFinished && latestChunkMessage != null && latestChunkMessage.getCreatedAt() >= chunkTs) {
                            MessageCollection.this.addToTempMessages(insertedMessages, true);
                            MessageCollection.this.onMessageEvent(insertedMessages, MessageEventAction.INSERT);
                        }
                    }
                }
                MessageCollection.this.checkCapacity(true);
            }
        });
    }

    void onUpdatedMessagesReceived(final List<BaseMessage> messages) {
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                ArrayList<BaseMessage> updatedMessages = new ArrayList<BaseMessage>();
                block0: for (BaseMessage message : messages) {
                    int i;
                    boolean isMessageFound = false;
                    for (i = 0; i < MessageCollection.this.mChunkMessages.size(); ++i) {
                        if (((BaseMessage)MessageCollection.this.mChunkMessages.get(i)).getMessageId() != message.getMessageId()) continue;
                        updatedMessages.add(message);
                        MessageCollection.this.mChunkMessages.set(i, message);
                        isMessageFound = true;
                        break;
                    }
                    if (!isMessageFound) {
                        for (i = 0; i < MessageCollection.this.mPrevTempMessages.size(); ++i) {
                            if (((BaseMessage)MessageCollection.this.mPrevTempMessages.get(i)).getMessageId() != message.getMessageId()) continue;
                            updatedMessages.add(message);
                            MessageCollection.this.mPrevTempMessages.set(i, message);
                            isMessageFound = true;
                            break;
                        }
                    }
                    if (isMessageFound) continue;
                    for (i = 0; i < MessageCollection.this.mNextTempMessages.size(); ++i) {
                        if (((BaseMessage)MessageCollection.this.mNextTempMessages.get(i)).getMessageId() != message.getMessageId()) continue;
                        updatedMessages.add(message);
                        MessageCollection.this.mNextTempMessages.set(i, message);
                        continue block0;
                    }
                }
                MessageCollection.this.onMessageEvent(updatedMessages, MessageEventAction.UPDATE);
            }
        });
    }

    void onRemovedMessageReceived(final List<Long> messageIds) {
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                ArrayList<BaseMessage> deletedMessages = new ArrayList<BaseMessage>();
                block0: for (Long messageId : messageIds) {
                    BaseMessage message;
                    boolean isMessageFound = false;
                    Iterator it = MessageCollection.this.mChunkMessages.iterator();
                    while (it.hasNext()) {
                        message = (BaseMessage)it.next();
                        if (message.getMessageId() != messageId.longValue()) continue;
                        deletedMessages.add(message);
                        it.remove();
                        isMessageFound = true;
                        break;
                    }
                    if (!isMessageFound) {
                        it = MessageCollection.this.mPrevTempMessages.iterator();
                        while (it.hasNext()) {
                            message = (BaseMessage)it.next();
                            if (message.getMessageId() != messageId.longValue()) continue;
                            deletedMessages.add(message);
                            it.remove();
                            isMessageFound = true;
                            break;
                        }
                    }
                    if (isMessageFound) continue;
                    it = MessageCollection.this.mNextTempMessages.iterator();
                    while (it.hasNext()) {
                        message = (BaseMessage)it.next();
                        if (message.getMessageId() != messageId.longValue()) continue;
                        deletedMessages.add(message);
                        it.remove();
                        continue block0;
                    }
                }
                MessageCollection.this.onMessageEvent(deletedMessages, MessageEventAction.REMOVE);
            }
        });
    }

    void resumeSync() {
        Logger.d(TAG, "resumeSync()");
        if (this.mChannel == null) {
            return;
        }
        if (this.mIsApplyingChangeLog) {
            SyncManagerError.getException(810210).printStackTrace();
            return;
        }
        this.mIsApplyingChangeLog = true;
        String token = SharedPreferencesManager.getInstance().getMessageChangeLogToken(this.mChannel.getUrl());
        BaseChannel.GetMessageChangeLogsByTokenHandler handler = new BaseChannel.GetMessageChangeLogsByTokenHandler(){

            public void onResult(final List<BaseMessage> updatedMessages, final List<Long> deletedMessageIds, final boolean hasMore, final String token, SendBirdException e) {
                Logger.d(TAG, "updatedMessages = [" + updatedMessages + "], deletedMessageIds = [" + deletedMessageIds + "], hasMore = [" + hasMore + "], token = [" + token + "], e = [" + e + "]");
                if (e != null) {
                    e.printStackTrace();
                    return;
                }
                SharedPreferencesManager.getInstance().setMessageChangeLogToken(MessageCollection.this.mChannel.getUrl(), token);
                final 6 self = this;
                MessageCollection.this.runOnSingleThreadPool(new Runnable(){

                    @Override
                    public void run() {
                        MessageManager.getInstance().updateMessages(MessageCollection.this.mChannel.getUrl(), false, updatedMessages);
                        MessageManager.getInstance().deleteMessages(MessageCollection.this.mChannel.getUrl(), deletedMessageIds);
                        if (hasMore) {
                            MessageCollection.this.mChannel.getMessageChangeLogsByToken(token, self);
                        } else {
                            MessageCollection.this.mIsApplyingChangeLog = false;
                            if (!SendBirdSyncManager.getInstance().isPaused()) {
                                MessageCollection.this.mSynchronizer.start();
                            }
                        }
                    }
                });
            }
        };
        if (token == null) {
            this.mChannel.getMessageChangeLogsByTimestamp(0L, (BaseChannel.GetMessageChangeLogsHandler)handler);
        } else {
            this.mChannel.getMessageChangeLogsByToken(token, handler);
        }
    }

    void pauseSync() {
        Logger.d(TAG, "pauseSync()");
        this.mSynchronizer.stop();
    }

    private synchronized void load(final boolean isNext, final CompletionHandler handler) {
        Logger.d(TAG, "load(). channel url = " + this.mChannel.getUrl() + ", isNext = " + isNext);
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                final MessageChunk currentChunk = MessageCollection.this.getCurrentChunk(MessageCollection.this.mSynchronizer.isSyncedOnce());
                BaseMessage offset = MessageCollection.this.getOffset(isNext);
                long ts = offset == null ? MessageCollection.this.mViewpointTimestamp : offset.getCreatedAt();
                MessageManager.getInstance().getMessageContainer().getMessagesByTimestamp(MessageCollection.this.mChannel.getUrl(), ts, MessageCollection.this.mFilter, MessageCollection.this.mLimit, isNext, offset == null, new MessageContainer.GetMessagesHandler(){

                    @Override
                    public void onResult(final List<BaseMessage> messages, SendBirdException e) {
                        if (e != null) {
                            if (handler != null) {
                                handler.onCompleted(e);
                            }
                            return;
                        }
                        MessageCollection.this.runOnSingleThreadPool(new Runnable(){

                            @Override
                            public void run() {
                                ArrayList<BaseMessage> chunkMessages = new ArrayList<BaseMessage>();
                                ArrayList<BaseMessage> tempMessages = new ArrayList<BaseMessage>();
                                if (currentChunk == null) {
                                    tempMessages.addAll(messages);
                                } else {
                                    for (BaseMessage message : messages) {
                                        if (currentChunk.isMessageInChunk(message)) {
                                            chunkMessages.add(message);
                                            continue;
                                        }
                                        tempMessages.add(message);
                                    }
                                }
                                if (chunkMessages.size() < MessageCollection.this.mLimit) {
                                    MessageCollection.this.mSynchronizer.subscribe(isNext, new MessageBackgroundSyncEventListenerImpl(isNext));
                                }
                                MessageCollection.this.addToTempMessages(tempMessages, isNext);
                                MessageCollection.this.addToChunkMessages(chunkMessages);
                                ArrayList<BaseMessage> finalEventMessages = new ArrayList<BaseMessage>();
                                finalEventMessages.addAll(tempMessages);
                                finalEventMessages.addAll(chunkMessages);
                                MessageCollection.this.sortMessages(finalEventMessages);
                                if (isNext) {
                                    MessageCollection.this.mIsNextLoading = false;
                                } else {
                                    MessageCollection.this.mIsPrevLoading = false;
                                }
                                MessageCollection.this.onMessageEvent(finalEventMessages, MessageEventAction.INSERT);
                                if (handler != null) {
                                    handler.onCompleted(null);
                                }
                                MessageCollection.this.checkCapacity(isNext);
                            }
                        });
                    }
                });
                if (MessageCollection.this.mSynchronizer.getSyncState(isNext) == BackgroundSyncThread.SyncState.PAUSED) {
                    MessageCollection.this.mSynchronizer.start();
                }
            }
        });
    }

    private MessageChunk getCurrentChunk(boolean isSyncedOnce) {
        MessageChunk chunk = MessageManager.getInstance().getMessageChunkContainer().getChunkByTimestamp(this.mChannel.getUrl(), this.mFilter, this.mViewpointTimestamp, true);
        if (chunk == null && isSyncedOnce) {
            chunk = MessageManager.getInstance().getMessageChunkContainer().getNearestChunk(this.mChannel.getUrl(), this.mFilter, this.mViewpointTimestamp);
        }
        return chunk;
    }

    private BaseMessage getOffset(boolean isNext) {
        BaseMessage chunkMessageOffset = this.getChunkMessageOffset(isNext);
        BaseMessage tempMessageOffset = this.getTempMessageOffset(isNext);
        if (chunkMessageOffset == null && tempMessageOffset == null) {
            return null;
        }
        if (chunkMessageOffset != null && tempMessageOffset == null) {
            return chunkMessageOffset;
        }
        if (chunkMessageOffset == null && tempMessageOffset != null) {
            return tempMessageOffset;
        }
        if (isNext) {
            return chunkMessageOffset.getCreatedAt() > tempMessageOffset.getCreatedAt() ? chunkMessageOffset : tempMessageOffset;
        }
        return chunkMessageOffset.getCreatedAt() < tempMessageOffset.getCreatedAt() ? chunkMessageOffset : tempMessageOffset;
    }

    private BaseMessage getChunkMessageOffset(boolean isNext) {
        if (this.mChunkMessages.size() == 0) {
            return null;
        }
        return isNext ? this.mChunkMessages.get(this.mChunkMessages.size() - 1) : this.mChunkMessages.get(0);
    }

    private BaseMessage getTempMessageOffset(boolean isNext) {
        List<BaseMessage> tempMessages;
        List<BaseMessage> list = tempMessages = isNext ? this.mNextTempMessages : this.mPrevTempMessages;
        if (tempMessages.size() == 0) {
            return null;
        }
        return isNext ? tempMessages.get(tempMessages.size() - 1) : tempMessages.get(0);
    }

    private void addToChunkMessages(List<BaseMessage> messages) {
        Iterator<BaseMessage> it = messages.iterator();
        block0: while (it.hasNext()) {
            BaseMessage message = it.next();
            for (BaseMessage chunkMessage : this.mChunkMessages) {
                if (chunkMessage.getMessageId() != message.getMessageId()) continue;
                it.remove();
                continue block0;
            }
        }
        this.mChunkMessages.addAll(messages);
        this.sortMessages(this.mChunkMessages);
    }

    private void addToTempMessages(List<BaseMessage> messages, boolean isNext) {
        Iterator<BaseMessage> it = messages.iterator();
        block0: while (it.hasNext()) {
            BaseMessage message = it.next();
            boolean isRemoved = false;
            for (BaseMessage prevMessage : this.mPrevTempMessages) {
                if (message.getMessageId() != prevMessage.getMessageId()) continue;
                it.remove();
                isRemoved = true;
                break;
            }
            if (isRemoved) continue;
            for (BaseMessage nextMessage : this.mNextTempMessages) {
                if (message.getMessageId() != nextMessage.getMessageId()) continue;
                it.remove();
                continue block0;
            }
        }
        if (isNext) {
            this.mNextTempMessages.addAll(messages);
            this.sortMessages(this.mNextTempMessages);
        } else {
            this.mPrevTempMessages.addAll(messages);
            this.sortMessages(this.mPrevTempMessages);
        }
    }

    private void checkCapacity(final boolean isInsertedToNextDirection) {
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                int exceedingSize = MessageCollection.this.getMessageCount() - SendBirdSyncManager.getInstance().getOptions().getMessageCollectionCapacity();
                if (exceedingSize > 0) {
                    MessageCollection.this.removeMessagesExceedingCapacity(exceedingSize, !isInsertedToNextDirection);
                }
            }
        });
    }

    private void removeMessagesExceedingCapacity(int count, boolean isNext) {
        BaseMessage message;
        ArrayList<BaseMessage> removedMessages = new ArrayList<BaseMessage>();
        for (int i = 0; i < count && (message = this.removeEdgeMessage(isNext)) != null; ++i) {
            removedMessages.add(message);
        }
        this.sortMessages(removedMessages);
        this.onMessageEvent(removedMessages, MessageEventAction.REMOVE);
    }

    private BaseMessage removeEdgeMessage(boolean isNext) {
        long tempMessageCreatedAt;
        long chunkMessageCreatedAt;
        List<BaseMessage> tempMessages;
        BaseMessage chunkMessage = this.getChunkMessageOffset(isNext);
        BaseMessage tempMessage = null;
        List<BaseMessage> list = tempMessages = isNext ? this.mNextTempMessages : this.mPrevTempMessages;
        if (tempMessages.size() == 0) {
            List<BaseMessage> list2 = tempMessages = isNext ? this.mPrevTempMessages : this.mNextTempMessages;
        }
        if (tempMessages.size() > 0) {
            BaseMessage baseMessage = tempMessage = isNext ? tempMessages.get(tempMessages.size() - 1) : tempMessages.get(0);
        }
        if (chunkMessage == null && tempMessage == null) {
            return null;
        }
        long l = chunkMessage == null ? (isNext ? 0L : Long.MAX_VALUE) : (chunkMessageCreatedAt = chunkMessage.getCreatedAt());
        long l2 = tempMessage == null ? (isNext ? 0L : Long.MAX_VALUE) : (tempMessageCreatedAt = tempMessage.getCreatedAt());
        if (isNext && chunkMessageCreatedAt > tempMessageCreatedAt || !isNext && chunkMessageCreatedAt < tempMessageCreatedAt) {
            this.mChunkMessages.remove(chunkMessage);
            return chunkMessage;
        }
        if (isNext && tempMessageCreatedAt > chunkMessageCreatedAt || !isNext && tempMessageCreatedAt < chunkMessageCreatedAt) {
            if (this.mNextTempMessages.remove(tempMessage)) {
                return tempMessage;
            }
            this.mPrevTempMessages.remove(tempMessage);
            return tempMessage;
        }
        return null;
    }

    private void onMessageEvent(final List<BaseMessage> messages, final MessageEventAction action) {
        if (this.mMessageCollectionHandler == null || messages.size() == 0) {
            return;
        }
        Logger.d(TAG, "onMessageEvent. list size = " + messages.size() + ", action = " + (Object)((Object)action));
        this.runOnEventSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                MessageCollection.this.mMessageCollectionHandler.onMessageEvent(MessageCollection.this, messages, action);
            }
        });
    }

    private void runOnSingleThreadPool(Runnable runnable) {
        if (!this.mExecutorService.isShutdown() && !this.mIsCollectionRemoved) {
            this.mExecutorService.execute(runnable);
        }
    }

    private void runOnEventSingleThreadPool(Runnable runnable) {
        if (!this.mEventExecutorService.isShutdown() && !this.mIsCollectionRemoved) {
            this.mEventExecutorService.execute(runnable);
        }
    }

    private boolean isMessageInLoadedChunkMessage(long messageId) {
        for (int i = 0; i < this.mChunkMessages.size(); ++i) {
            if (this.mChunkMessages.get(i).getMessageId() != messageId) continue;
            return true;
        }
        return false;
    }

    private void sortMessages(List<BaseMessage> messages) {
        Collections.sort(messages, new Comparator<BaseMessage>(){

            @Override
            public int compare(BaseMessage m1, BaseMessage m2) {
                long y;
                long x = m1.getCreatedAt();
                return x < (y = m2.getCreatedAt()) ? -1 : (x == y ? 0 : 1);
            }
        });
    }

    private String getRequestId(BaseMessage message) {
        if (message instanceof AdminMessage) {
            return "";
        }
        if (message instanceof UserMessage) {
            return ((UserMessage)message).getRequestId();
        }
        if (message instanceof FileMessage) {
            return ((FileMessage)message).getRequestId();
        }
        return "";
    }

    private boolean isMyMessage(BaseMessage message) {
        if (message instanceof AdminMessage) {
            return false;
        }
        Sender sender = message instanceof UserMessage ? ((UserMessage)message).getSender() : ((FileMessage)message).getSender();
        User currentUser = SendBird.getCurrentUser();
        if (sender == null || currentUser == null) {
            return message.getMessageId() <= 0L;
        }
        return sender.getUserId().equals(currentUser.getUserId());
    }

    private class MessageBackgroundSyncEventListenerImpl
    implements MessageSynchronizer.MessageBackgroundSyncEventListener {
        boolean mIsNext;

        MessageBackgroundSyncEventListenerImpl(boolean isNext) {
            this.mIsNext = isNext;
        }

        @Override
        public void onSynced(final SendBirdException e) {
            Logger.d(TAG, "onSynced(). channel url = " + MessageCollection.this.mChannel.getUrl() + ", isNext = " + this.mIsNext);
            MessageCollection.this.runOnSingleThreadPool(new Runnable(){

                @Override
                public void run() {
                    List tempMessages;
                    List list = tempMessages = MessageBackgroundSyncEventListenerImpl.this.mIsNext ? MessageCollection.this.mNextTempMessages : MessageCollection.this.mPrevTempMessages;
                    if (e == null) {
                        if (tempMessages.size() == 0) {
                            MessageCollection.this.load(MessageBackgroundSyncEventListenerImpl.this.mIsNext, null);
                        } else {
                            Logger.d(TAG, "onSynced(). diff with previous messages");
                            final MessageChunk currentChunk = MessageCollection.this.getCurrentChunk(MessageCollection.this.mSynchronizer.isSyncedOnce());
                            if (!currentChunk.isMessageInChunk((BaseMessage)tempMessages.get(0)) && !currentChunk.isMessageInChunk((BaseMessage)tempMessages.get(tempMessages.size() - 1))) {
                                MessageCollection.this.onMessageEvent(tempMessages, MessageEventAction.CLEAR);
                                tempMessages.clear();
                                MessageCollection.this.load(MessageBackgroundSyncEventListenerImpl.this.mIsNext, null);
                            } else {
                                MessageCollection.this.runOnSingleThreadPool(new Runnable(){

                                    @Override
                                    public void run() {
                                        BaseMessage offset = MessageCollection.this.getChunkMessageOffset(MessageBackgroundSyncEventListenerImpl.this.mIsNext);
                                        long ts = offset == null ? MessageCollection.this.mViewpointTimestamp : offset.getCreatedAt();
                                        int limit = Math.max(MessageCollection.this.mLimit, tempMessages.size());
                                        MessageManager.getInstance().getMessageContainer().getMessagesInChunk(currentChunk, ts, MessageBackgroundSyncEventListenerImpl.this.mIsNext, limit, true, new MessageContainer.GetMessagesHandler(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            @Override
                                            public void onResult(List<BaseMessage> messages, SendBirdException e) {
                                                if (e != null) {
                                                    e.printStackTrace();
                                                    return;
                                                }
                                                ArrayList<BaseMessage> insertedMessages = new ArrayList<BaseMessage>(messages);
                                                ArrayList<BaseMessage> removedMessages = new ArrayList<BaseMessage>();
                                                ArrayList<BaseMessage> updatedMessages = new ArrayList<BaseMessage>();
                                                ArrayList<BaseMessage> equalMessages = new ArrayList<BaseMessage>();
                                                Iterator tempIt = tempMessages.iterator();
                                                while (tempIt.hasNext()) {
                                                    BaseMessage tempMessage = (BaseMessage)tempIt.next();
                                                    boolean isMessageFound = false;
                                                    Iterator insertIt = insertedMessages.iterator();
                                                    while (insertIt.hasNext()) {
                                                        BaseMessage message = (BaseMessage)insertIt.next();
                                                        if (tempMessage.getMessageId() != message.getMessageId()) continue;
                                                        isMessageFound = true;
                                                        if (!tempMessage.equals((Object)message)) {
                                                            updatedMessages.add(message);
                                                        } else {
                                                            equalMessages.add(message);
                                                        }
                                                        tempIt.remove();
                                                        insertIt.remove();
                                                        break;
                                                    }
                                                    if (isMessageFound) continue;
                                                    removedMessages.add(tempMessage);
                                                    tempIt.remove();
                                                }
                                                MessageCollection.this.addToChunkMessages(insertedMessages);
                                                MessageCollection.this.addToChunkMessages(updatedMessages);
                                                MessageCollection.this.addToChunkMessages(equalMessages);
                                                MessageCollection.this.onMessageEvent(removedMessages, MessageEventAction.REMOVE);
                                                MessageCollection.this.onMessageEvent(updatedMessages, MessageEventAction.UPDATE);
                                                MessageCollection.this.onMessageEvent(insertedMessages, MessageEventAction.INSERT);
                                                if (!MessageCollection.this.mPreviewMessages.isEmpty()) {
                                                    MessageCollection.this.onMessageEvent(new ArrayList(MessageCollection.this.mPreviewMessages), MessageEventAction.REMOVE);
                                                    Object object = MessageCollection.this.mPreviewMessagesLock;
                                                    synchronized (object) {
                                                        MessageCollection.this.mPreviewMessages.clear();
                                                    }
                                                }
                                                MessageCollection.this.checkCapacity(MessageBackgroundSyncEventListenerImpl.this.mIsNext);
                                            }
                                        });
                                    }
                                });
                            }
                        }
                    }
                }
            });
        }
    }

    public static enum Direction {
        PREVIOUS,
        NEXT;

    }
}

