/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.AdminMessage;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelListQuery;
import com.sendbird.android.UserMessage;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class SyncManagerUtils {
    private static final String CUSTOM_TYPE_DELIMITER = "_CT_DELIMITER_";
    static final long ONE_DAY_IN_MILLIS = 86400000L;

    SyncManagerUtils() {
    }

    static String concatenateCustomTypes(List<String> customTypes) {
        if (customTypes == null) {
            return "";
        }
        Collections.sort(customTypes);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < customTypes.size(); ++i) {
            result.append(customTypes.get(i));
            if (i == customTypes.size() - 1) continue;
            result.append(CUSTOM_TYPE_DELIMITER);
        }
        return result.toString();
    }

    static int orderToCode(GroupChannelListQuery.Order order) {
        switch (order) {
            case CHRONOLOGICAL: {
                return 0;
            }
            case CHANNEL_NAME_ALPHABETICAL: {
                return 1;
            }
            case METADATA_VALUE_ALPHABETICAL: {
                return 2;
            }
        }
        return 3;
    }

    static String getOffset(GroupChannel channel, GroupChannelListQuery query) {
        if (channel == null || query == null) {
            return "";
        }
        switch (query.getOrder()) {
            case CHANNEL_NAME_ALPHABETICAL: {
                return channel.getName();
            }
            case CHRONOLOGICAL: {
                return String.valueOf(channel.getCreatedAt());
            }
            case LATEST_LAST_MESSAGE: {
                return String.valueOf(channel.getLastMessage() == null ? channel.getCreatedAt() : channel.getLastMessage().getCreatedAt());
            }
        }
        return "";
    }

    static void sortMessages(List<BaseMessage> messages) {
        Collections.sort(messages, new Comparator<BaseMessage>(){

            @Override
            public int compare(BaseMessage m1, BaseMessage m2) {
                long y;
                long x = m1.getCreatedAt();
                return x < (y = m2.getCreatedAt()) ? -1 : (x == y ? 0 : 1);
            }
        });
    }

    static String getRequestId(BaseMessage message) {
        if (message instanceof AdminMessage) {
            return "";
        }
        if (message instanceof UserMessage) {
            return ((UserMessage)message).getRequestId();
        }
        if (message instanceof FileMessage) {
            return ((FileMessage)message).getRequestId();
        }
        return "";
    }

    static UserMessage.RequestState getRequestState(BaseMessage message) {
        if (message instanceof AdminMessage) {
            return UserMessage.RequestState.NONE;
        }
        if (message instanceof UserMessage) {
            return ((UserMessage)message).getRequestState();
        }
        if (message instanceof FileMessage) {
            switch (((FileMessage)message).getRequestState()) {
                case NONE: {
                    return UserMessage.RequestState.NONE;
                }
                case FAILED: {
                    return UserMessage.RequestState.FAILED;
                }
                case PENDING: {
                    return UserMessage.RequestState.PENDING;
                }
                case SUCCEEDED: {
                    return UserMessage.RequestState.SUCCEEDED;
                }
            }
            return UserMessage.RequestState.NONE;
        }
        return UserMessage.RequestState.NONE;
    }

    static int compareVersionStrings(String v1, String v2) {
        String[] s1 = v1.split("\\.");
        String[] s2 = v2.split("\\.");
        int maxCount = Math.max(s1.length, s2.length);
        for (int i = 0; i < maxCount; ++i) {
            int num1 = -1;
            int num2 = -1;
            try {
                num1 = i < s1.length ? Integer.parseInt(s1[i]) : -1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                num2 = i < s2.length ? Integer.parseInt(s2[i]) : -1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (num1 == num2) continue;
            return num1 < num2 ? -1 : 1;
        }
        return 0;
    }
}

