/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.content.Context;
import android.content.SharedPreferences;
import com.sendbird.syncmanager.SendBirdSyncManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class SharedPreferencesManager {
    private static final String SYNC_MANAGER_SHARED_PREFERENCE_NAME = "sendbird_syncmanager";
    private static final String KEY_PREVIOUS_USER_ID = "previous_user_id";
    private static final String KEY_CHANNEL_CHANGE_LOG_TOKEN = "channel_change_log_token";
    private static final String KEY_MESSAGE_OFFSET_MAP = "message_offset_map";
    private SharedPreferences mSharedPreferences;
    private static SharedPreferencesManager sInstance;

    private SharedPreferencesManager(Context context) {
        this.mSharedPreferences = context.getSharedPreferences(SYNC_MANAGER_SHARED_PREFERENCE_NAME, 0);
    }

    public static void init(Context context) {
        if (sInstance == null) {
            sInstance = new SharedPreferencesManager(context);
        }
    }

    static SharedPreferencesManager getInstance() {
        if (sInstance == null) {
            throw new RuntimeException("SharedPreferencesManager hans't been initialized. Try SharedPreferencesManager.init first");
        }
        return sInstance;
    }

    void setMessageChangeLogToken(String channelUrl, String token) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(SendBirdSyncManager.getInstance().getUserId() + "_delimiter_" + channelUrl, token).apply();
    }

    String getMessageChangeLogToken(String channelUrl) {
        return this.mSharedPreferences.getString(SendBirdSyncManager.getInstance().getUserId() + "_delimiter_" + channelUrl, null);
    }

    void removeMessageChangeLogToken(String channelUrl) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.remove(SendBirdSyncManager.getInstance().getUserId() + "_delimiter_" + channelUrl).apply();
    }

    void setChannelChangeLogToken(String token) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString("channel_change_log_token_" + SendBirdSyncManager.getInstance().getUserId(), token).apply();
    }

    String getChannelChangeLogToken() {
        return this.mSharedPreferences.getString("channel_change_log_token_" + SendBirdSyncManager.getInstance().getUserId(), null);
    }

    void setPreviousUserId(String userId) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(KEY_PREVIOUS_USER_ID, userId).apply();
    }

    String getPreviousUserId() {
        return this.mSharedPreferences.getString(KEY_PREVIOUS_USER_ID, null);
    }

    void setMessageOffsetMap(Map<String, Long> messageOffsetMap) {
        JSONObject jsonObject = new JSONObject(messageOffsetMap);
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(KEY_MESSAGE_OFFSET_MAP, jsonObject.toString()).apply();
    }

    Map<String, Long> getMessageOffsetMap() {
        String jsonString = this.mSharedPreferences.getString(KEY_MESSAGE_OFFSET_MAP, "");
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(jsonString);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        HashMap<String, Long> messageOffsetMap = new HashMap<String, Long>();
        if (jsonObject != null) {
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                messageOffsetMap.put(key, jsonObject.optLong(key, 0L));
            }
        }
        return messageOffsetMap;
    }

    void clearCache() {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.clear().apply();
    }
}

