/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.UserMessage;
import com.sendbird.syncmanager.FailedMessageDispatcher;
import com.sendbird.syncmanager.FailedMessageEventActionReason;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.SendBirdSyncManager;
import com.sendbird.syncmanager.SyncManagerUtils;
import com.sendbird.syncmanager.log.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

class FailedMessageQueue {
    private GroupChannel mChannel;
    private final List<BaseMessage> mAutomaticMessages;
    private final List<BaseMessage> mManualMessages;
    private final Object mMessageListLock = new Object();
    private Set<String> mRequestIdSet;
    private Timer mTimer;
    private long mDelayTime;
    private boolean mIsRunning;
    private boolean mIsResending;
    private int mCollectionReferenceCount;
    private int mRetryCount;

    FailedMessageQueue(GroupChannel channel) {
        this.mChannel = channel;
        this.mAutomaticMessages = new ArrayList<BaseMessage>();
        this.mManualMessages = new ArrayList<BaseMessage>();
        this.mRequestIdSet = Collections.newSetFromMap(new ConcurrentHashMap());
        this.mDelayTime = 0L;
        this.mIsRunning = true;
        this.mIsResending = false;
        this.mCollectionReferenceCount = 1;
        this.mRetryCount = 0;
    }

    static boolean isResendableAutomatically(BaseMessage message) {
        if (message == null) {
            return false;
        }
        try {
            if (SyncManagerUtils.compareVersionStrings(SendBird.getSDKVersion(), "3.0.121") >= 0) {
                return message.getSendingStatus() == BaseMessage.SendingStatus.FAILED;
            }
        }
        catch (Throwable throwable) {
            Logger.d(throwable);
        }
        return true;
    }

    List<BaseMessage> getMessages() {
        return this.mAutomaticMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendMessages(List<BaseMessage> messages) {
        if (messages == null) {
            return;
        }
        SendBirdSyncManager.MessageResendPolicy policy = SendBirdSyncManager.getInstance().getOptions().getMessageResendPolicy();
        Object object = this.mMessageListLock;
        synchronized (object) {
            for (BaseMessage message : messages) {
                this.appendMessage(message, policy);
            }
            SyncManagerUtils.sortMessages(this.mAutomaticMessages);
            SyncManagerUtils.sortMessages(this.mManualMessages);
        }
        if (this.mIsRunning && !this.mIsResending) {
            this.resendMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMessages(List<String> removedRequestIds) {
        if (removedRequestIds == null) {
            return;
        }
        Object object = this.mMessageListLock;
        synchronized (object) {
            for (String requestId : removedRequestIds) {
                this.removeMessage(requestId);
            }
        }
    }

    void resumeResending() {
        this.mIsRunning = true;
        this.mDelayTime = 0L;
        if (!this.mIsResending) {
            this.resendMessage();
        }
    }

    void pauseResending() {
        this.mIsRunning = false;
        this.mIsResending = false;
        this.cancelResending();
    }

    void increaseCount() {
        ++this.mCollectionReferenceCount;
    }

    void decreaseCount() {
        --this.mCollectionReferenceCount;
        if (this.mCollectionReferenceCount == 0) {
            this.clear();
        }
    }

    int getCollectionReferenceCount() {
        return this.mCollectionReferenceCount;
    }

    private void appendMessage(BaseMessage message, SendBirdSyncManager.MessageResendPolicy policy) {
        String requestId = SyncManagerUtils.getRequestId(message);
        if (requestId == null || requestId.isEmpty()) {
            return;
        }
        if (message instanceof UserMessage && !this.mRequestIdSet.contains(requestId)) {
            if (policy == SendBirdSyncManager.MessageResendPolicy.MANUAL) {
                this.mManualMessages.add(message);
            } else if (policy == SendBirdSyncManager.MessageResendPolicy.AUTOMATIC) {
                this.mAutomaticMessages.add(message);
            }
            this.mRequestIdSet.add(requestId);
        }
    }

    private void removeMessage(String requestId) {
        if (requestId == null || requestId.isEmpty()) {
            return;
        }
        if (this.mRequestIdSet.contains(requestId)) {
            int i;
            for (i = 0; i < this.mAutomaticMessages.size(); ++i) {
                if (!requestId.equals(SyncManagerUtils.getRequestId(this.mAutomaticMessages.get(i)))) continue;
                this.mAutomaticMessages.remove(i);
                this.mRequestIdSet.remove(requestId);
                return;
            }
            for (i = 0; i < this.mManualMessages.size(); ++i) {
                if (!requestId.equals(SyncManagerUtils.getRequestId(this.mManualMessages.get(i)))) continue;
                this.mManualMessages.remove(i);
                this.mRequestIdSet.remove(requestId);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        Object object = this.mMessageListLock;
        synchronized (object) {
            this.mAutomaticMessages.clear();
            this.mManualMessages.clear();
        }
        this.cancelResending();
    }

    private void reset() {
        this.mDelayTime = 0L;
        this.mRetryCount = 0;
        this.mIsResending = false;
    }

    private void increaseDelayTime() {
        this.mDelayTime = this.mDelayTime < 10000L ? (this.mDelayTime += 2000L) : 10000L;
    }

    private void resendMessage() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mTimer = new Timer();
        this.mTimer.schedule((TimerTask)new ResendingMessageTimerTask(), this.mDelayTime);
    }

    private void cancelResending() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mTimer = null;
    }

    private class ResendingMessageTimerTask
    extends TimerTask {
        private ResendingMessageTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (FailedMessageQueue.this.mAutomaticMessages.size() == 0) {
                FailedMessageQueue.this.reset();
                return;
            }
            Logger.i("[resendingMessageRunnable] run(). retryCount : " + FailedMessageQueue.this.mRetryCount, new Object[0]);
            FailedMessageQueue.this.mRetryCount++;
            if (FailedMessageQueue.this.mRetryCount > SendBirdSyncManager.getInstance().getOptions().getAutomaticMessageResendRetryCount()) {
                ArrayList<BaseMessage> switchedMessages = new ArrayList<BaseMessage>();
                Object object = FailedMessageQueue.this.mMessageListLock;
                synchronized (object) {
                    switchedMessages.addAll(FailedMessageQueue.this.mAutomaticMessages);
                    FailedMessageQueue.this.mManualMessages.addAll(FailedMessageQueue.this.mAutomaticMessages);
                    FailedMessageQueue.this.mAutomaticMessages.clear();
                }
                MessageManager.getInstance().broadcastFailedMessagesUpdated(FailedMessageQueue.this.mChannel.getUrl(), switchedMessages, FailedMessageEventActionReason.UPDATE_RESEND_FAILED);
                FailedMessageQueue.this.reset();
                return;
            }
            FailedMessageQueue.this.mIsResending = true;
            final UserMessage message = (UserMessage)FailedMessageQueue.this.mAutomaticMessages.get(0);
            if (FailedMessageQueue.isResendableAutomatically((BaseMessage)message)) {
                FailedMessageQueue.this.mChannel.resendUserMessage(message, new BaseChannel.ResendUserMessageHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onSent(UserMessage userMessage, SendBirdException e) {
                        if (e != null) {
                            Logger.d(e.getMessage());
                            if (e.getCode() == 800110) {
                                FailedMessageQueue.this.removeMessage(SyncManagerUtils.getRequestId((BaseMessage)message));
                                FailedMessageDispatcher.getInstance().removeMessages(message.getChannelUrl(), Collections.singletonList(message), FailedMessageEventActionReason.REMOVE_UNKNOWN, null);
                            } else {
                                FailedMessageQueue.this.increaseDelayTime();
                            }
                        } else {
                            Object object = FailedMessageQueue.this.mMessageListLock;
                            synchronized (object) {
                                FailedMessageQueue.this.removeMessage(SyncManagerUtils.getRequestId((BaseMessage)message));
                            }
                            FailedMessageQueue.this.mDelayTime = 0L;
                            FailedMessageQueue.this.mRetryCount = 0;
                            FailedMessageDispatcher.getInstance().removeMessages(message.getChannelUrl(), Collections.singletonList(message), FailedMessageEventActionReason.REMOVE_RESEND_SUCCEEDED, null);
                            MessageManager.getInstance().appendSucceededMessages(userMessage.getChannelUrl(), Collections.singletonList(userMessage));
                        }
                        if (FailedMessageQueue.this.mAutomaticMessages.size() == 0) {
                            FailedMessageQueue.this.reset();
                        } else {
                            FailedMessageQueue.this.resendMessage();
                        }
                    }
                });
            } else {
                FailedMessageQueue.this.mAutomaticMessages.remove(0);
                FailedMessageQueue.this.resendMessage();
            }
        }
    }
}

