/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.util.Log;
import java.util.Locale;

class Logger {
    public static final int NONE = 0;
    public static final int INFO = 1;
    public static final int DEBUG = 98765;
    public static int sLevel = 0;
    private static final String LOGGER_TAG = "SendBirdSyncManager";
    private static final int STACK_TRACE_IDX = 5;

    Logger() {
    }

    public static void i(String message) {
        if (message == null) {
            message = "(null)";
        }
        Logger.info(message);
    }

    public static void i(String message, Object ... args) {
        Logger.info(String.format(message, args));
    }

    public static void e(Exception e) {
        if (e != null) {
            Logger.error(Log.getStackTraceString((Throwable)e));
        }
    }

    public static void e(String message) {
        if (message == null) {
            message = "(null)";
        }
        Logger.error(message);
    }

    public static void e(String message, Object ... args) {
        Logger.error(String.format(message, args));
    }

    public static void d(String message) {
        if (message == null) {
            message = "(null)";
        }
        Logger.debug(message);
    }

    public static void d(Exception e) {
        if (e != null) {
            Logger.debug(Log.getStackTraceString((Throwable)e));
        }
    }

    public static void d(String message, Object ... args) {
        Logger.debug(String.format(message, args));
    }

    private static void error(String message) {
        if (sLevel >= 1) {
            Log.e((String)LOGGER_TAG, (String)String.format("%s\t%s", Logger.syncManagerTag(), message));
        }
    }

    private static void info(String message) {
        if (sLevel >= 1) {
            Log.i((String)LOGGER_TAG, (String)String.format("%s\t%s", Logger.syncManagerTag(), message));
        }
    }

    private static void debug(String message) {
        if (sLevel >= 98765) {
            Log.d((String)LOGGER_TAG, (String)String.format("%s\t%s", Logger.syncManagerTag(), message));
        }
    }

    private static String syncManagerTag() {
        StackTraceElement[] elementList = Thread.currentThread().getStackTrace();
        StackTraceElement element = null;
        if (elementList.length >= 5) {
            element = elementList[5];
        }
        if (element != null) {
            return String.format(Locale.US, "%s[%d]", element.getFileName().split("\\.")[0], element.getLineNumber());
        }
        return LOGGER_TAG;
    }
}

