/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.GroupChannelListQuery;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.ChannelBackgroundSync;
import com.sendbird.syncmanager.ChannelCollection;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.SendBirdSyncManager;
import com.sendbird.syncmanager.SyncManagerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ChannelSynchronizer {
    private static ChannelSynchronizer sInstance;
    private final Map<String, ChannelBackgroundSync> mBackgroundSyncMap = new ConcurrentHashMap<String, ChannelBackgroundSync>();
    private final Map<String, List<Subscriber>> mSubscriberMap = new ConcurrentHashMap<String, List<Subscriber>>();

    private ChannelSynchronizer() {
    }

    static ChannelSynchronizer getInstance() {
        if (sInstance == null) {
            sInstance = new ChannelSynchronizer();
        }
        return sInstance;
    }

    void clear() {
        for (ChannelBackgroundSync sync : this.mBackgroundSyncMap.values()) {
            sync.stop();
        }
        this.mBackgroundSyncMap.clear();
        this.mSubscriberMap.clear();
    }

    void pauseSync() {
        for (ChannelBackgroundSync backgroundSync : this.mBackgroundSyncMap.values()) {
            backgroundSync.stop();
        }
    }

    void resumeSync() {
        if (!SendBirdSyncManager.getInstance().isPaused()) {
            for (ChannelBackgroundSync backgroundSync : this.mBackgroundSyncMap.values()) {
                backgroundSync.start();
            }
        }
    }

    void startSync(GroupChannelListQuery query) {
        ChannelBackgroundSync backgroundSync;
        final String identifier = this.getQueryIdentifier(query);
        if (!this.mBackgroundSyncMap.containsKey(identifier)) {
            this.mBackgroundSyncMap.put(identifier, new ChannelBackgroundSync(query, new ChannelSynchronizerEventListener(){

                @Override
                public void onSynced(SendBirdException e) {
                    ChannelSynchronizer.this.publish(identifier, e);
                }
            }));
        }
        if ((backgroundSync = this.mBackgroundSyncMap.get(identifier)) != null) {
            backgroundSync.start();
        }
    }

    void stopSync(GroupChannelListQuery query) {
        String identifier = this.getQueryIdentifier(query);
        ChannelBackgroundSync backgroundSync = this.mBackgroundSyncMap.remove(identifier);
        if (backgroundSync != null) {
            backgroundSync.stop();
        }
    }

    synchronized void subscribe(ChannelCollection collection, ChannelSynchronizerEventListener listener) {
        String identifier = this.getQueryIdentifier(collection.getQuery());
        Logger.d("subscribe. identifier = " + identifier);
        List<Subscriber> subscribers = this.mSubscriberMap.get(identifier);
        if (subscribers != null) {
            boolean isCollectionExists = false;
            for (Subscriber subscriber : subscribers) {
                if (subscriber.mChannelCollection != collection) continue;
                subscriber.mListener = listener;
                isCollectionExists = true;
                break;
            }
            if (!isCollectionExists) {
                subscribers.add(new Subscriber(collection, listener));
            }
        } else {
            ArrayList<Subscriber> list = new ArrayList<Subscriber>();
            list.add(new Subscriber(collection, listener));
            this.mSubscriberMap.put(identifier, list);
        }
    }

    private void publish(String identifier, SendBirdException e) {
        Logger.d("publish. identifier = " + identifier);
        List<Subscriber> subscribers = this.mSubscriberMap.remove(identifier);
        if (subscribers != null && subscribers.size() > 0) {
            ArrayList<Subscriber> tempSubscribers = new ArrayList<Subscriber>(subscribers);
            for (Subscriber subscriber : tempSubscribers) {
                if (subscriber.mListener == null) continue;
                subscriber.mListener.onSynced(e);
            }
        }
    }

    private String getQueryIdentifier(GroupChannelListQuery query) {
        return SyncManagerUtils.concatenateCustomTypes(query.getCustomTypesFilter()) + "_" + query.isIncludeEmpty() + "_" + SyncManagerUtils.orderToCode(query.getOrder());
    }

    static interface ChannelSynchronizerEventListener {
        public void onSynced(SendBirdException var1);
    }

    class Subscriber {
        ChannelCollection mChannelCollection;
        ChannelSynchronizerEventListener mListener;

        Subscriber(ChannelCollection channelCollection, ChannelSynchronizerEventListener listener) {
            this.mChannelCollection = channelCollection;
            this.mListener = listener;
        }
    }
}

