/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseMessage;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageFilter;
import com.sendbird.syncmanager.SendBirdSyncManager;
import com.sendbird.syncmanager.SyncManagerError;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class MessageContainer {
    private static final String TAG = MessageContainer.class.getSimpleName();

    MessageContainer() {
    }

    void setup(CompletionHandler handler) {
        if (handler != null) {
            handler.onCompleted(null);
        }
    }

    List<BaseMessage> getMessagesInChunk(MessageChunk chunk, long ts, boolean isNext, int limit, boolean isInclusive) {
        Logger.d(TAG, "getMessagesInChunk(). chunkId = " + chunk.getChunkId() + ", ts = " + ts + ", inclusive : " + isInclusive + ", isNext = " + isNext);
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            return null;
        }
        List<BaseMessage> messages = DatabaseController.getInstance().getMessagesByChunk(userId, chunk);
        if (messages == null) {
            return null;
        }
        ArrayList<BaseMessage> result = new ArrayList<BaseMessage>();
        if (isNext) {
            for (int i = 0; i < messages.size(); ++i) {
                BaseMessage message = messages.get(i);
                if (message.getCreatedAt() <= ts && (!isInclusive || message.getCreatedAt() != ts) || !chunk.isMessageInChunk(message)) continue;
                result.add(message);
                if (result.size() < limit || message.getCreatedAt() == ts) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = messages.size() - 1; i >= 0; --i) {
                BaseMessage message = messages.get(i);
                if (message.getCreatedAt() >= ts && (!isInclusive || message.getCreatedAt() != ts) || !chunk.isMessageInChunk(message)) continue;
                result.add(message);
                if (result.size() >= limit && message.getCreatedAt() != ts) break;
            }
            Collections.reverse(result);
        }
        return result;
    }

    List<BaseMessage> getSucceededMessagesByTimestamp(String channelUrl, long ts, MessageFilter filter, int limit, boolean isNext, boolean isInclusive) {
        Logger.d(TAG, "getSucceededMessagesByTimestamp(). ts = " + ts + ", isNext = " + isNext);
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            return null;
        }
        List<BaseMessage> messages = DatabaseController.getInstance().getSucceededMessagesByTimestamp(userId, channelUrl, ts, isNext);
        if (messages == null) {
            return null;
        }
        ArrayList<BaseMessage> result = new ArrayList<BaseMessage>();
        if (isNext) {
            for (int i = 0; i < messages.size(); ++i) {
                BaseMessage message = messages.get(i);
                if (message.getCreatedAt() <= ts && (!isInclusive || message.getCreatedAt() != ts) || !filter.isValidMessage(message)) continue;
                if (result.size() < limit || message.getCreatedAt() == ts) {
                    result.add(message);
                    continue;
                }
                break;
            }
        } else {
            for (int i = messages.size() - 1; i >= 0; --i) {
                BaseMessage message = messages.get(i);
                if (message.getCreatedAt() >= ts && (!isInclusive || message.getCreatedAt() != ts) || !filter.isValidMessage(message)) continue;
                if (result.size() >= limit && message.getCreatedAt() != ts) break;
                result.add(message);
            }
            Collections.reverse(result);
        }
        return result;
    }

    void loadFailedMessages(String channelUrl, GetMessagesHandler handler) {
        Logger.d(TAG, "loadFailedMessages(). channelUrl = " + channelUrl);
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onResult(null, SyncManagerError.getException(810100));
            }
            return;
        }
        DatabaseController.getInstance().getFailedMessages(userId, channelUrl, handler);
    }

    void upsertSucceededMessages(List<BaseMessage> messages, boolean isVisible, UpsertMessageHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onResult(null, null, SyncManagerError.getException(810100));
            }
            return;
        }
        DatabaseController.getInstance().upsertSucceededMessages(userId, messages, isVisible, handler);
    }

    void removeSucceededMessages(List<Long> messageIds, DeleteMessageHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onResult(null, SyncManagerError.getException(810100));
            }
            return;
        }
        DatabaseController.getInstance().removeSucceededMessages(userId, messageIds, handler);
    }

    void removeAllMessagesInChannel(String channelUrl, CompletionHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onCompleted(SyncManagerError.getException(810100));
            }
            return;
        }
        DatabaseController.getInstance().removeAllMessagesInChannel(userId, channelUrl, handler);
    }

    void removeMessagesBeforeOffset(String channelUrl, long offset, CompletionHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onCompleted(SyncManagerError.getException(810100));
            }
            return;
        }
        DatabaseController.getInstance().removeMessagesBeforeMessageOffset(userId, channelUrl, offset, handler);
    }

    void upsertFailedMessages(String channelUrl, List<BaseMessage> messages, UpsertMessageHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onResult(null, null, SyncManagerError.getException(810100));
            }
            return;
        }
        DatabaseController.getInstance().upsertFailedMessages(channelUrl, userId, messages, handler);
    }

    void removeFailedMessages(List<String> requestIds, CompletionHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onCompleted(SyncManagerError.getException(810100));
            }
            return;
        }
        DatabaseController.getInstance().removeFailedMessages(userId, requestIds, handler);
    }

    void removeExpiredFailedMessages(RemoveExpiredMessagesHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onResult(null, null, SyncManagerError.getException(810100));
            }
            return;
        }
        DatabaseController.getInstance().removeExpiredFailedMessages(userId, handler);
    }

    void removeExceedingMaxCountFailedMessages(String channelUrl, RemoveExceedingMessagesHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onResult(null, SyncManagerError.getException(810100));
            }
            return;
        }
        DatabaseController.getInstance().removeExceedingMaxCountFailedMessages(userId, channelUrl, handler);
    }

    static interface DeleteMessageHandler {
        public void onResult(List<BaseMessage> var1, SendBirdException var2);
    }

    static interface RemoveExceedingMessagesHandler {
        public void onResult(List<String> var1, SendBirdException var2);
    }

    static interface RemoveExpiredMessagesHandler {
        public void onResult(Map<String, List<String>> var1, Long var2, SendBirdException var3);
    }

    static interface UpsertMessageHandler {
        public void onResult(List<BaseMessage> var1, List<BaseMessage> var2, SendBirdException var3);
    }

    static interface GetMessagesHandler {
        public void onResult(List<BaseMessage> var1, SendBirdException var2);
    }

    static interface GetSingleMessageHandler {
        public void onResult(BaseMessage var1, SendBirdException var2);
    }
}

