/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.support.annotation.NonNull;
import android.util.Log;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.Sender;
import com.sendbird.android.User;
import com.sendbird.android.UserMessage;
import com.sendbird.syncmanager.BackgroundSyncThread;
import com.sendbird.syncmanager.ChannelContainer;
import com.sendbird.syncmanager.ChannelManager;
import com.sendbird.syncmanager.FailedMessageDispatcher;
import com.sendbird.syncmanager.FailedMessageEventActionReason;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageContainer;
import com.sendbird.syncmanager.MessageEventAction;
import com.sendbird.syncmanager.MessageFilter;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.MessageSynchronizer;
import com.sendbird.syncmanager.SendBirdSyncManager;
import com.sendbird.syncmanager.SharedPreferencesManager;
import com.sendbird.syncmanager.SyncManagerError;
import com.sendbird.syncmanager.SyncManagerUtils;
import com.sendbird.syncmanager.handler.CompletionHandler;
import com.sendbird.syncmanager.handler.FetchCompletionHandler;
import com.sendbird.syncmanager.handler.MessageCollectionCreateHandler;
import com.sendbird.syncmanager.handler.MessageCollectionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class MessageCollection {
    private static final String TAG = MessageCollection.class.getSimpleName();
    private GroupChannel mChannel;
    private MessageFilter mFilter;
    private long mViewpointTimestamp;
    private int mLimit = 20;
    private List<BaseMessage> mChunkMessages;
    private List<BaseMessage> mPrevTempMessages;
    private List<BaseMessage> mNextTempMessages;
    private List<BaseMessage> mPendingMessages;
    private List<BaseMessage> mFailedMessages;
    private MessageCollectionHandler mMessageCollectionHandler;
    private ExecutorService mExecutorService;
    private MessageSynchronizer mSynchronizer;
    private boolean mIsNextLoading = false;
    private boolean mIsPrevLoading = false;
    private boolean mIsApplyingChangeLog = false;
    private boolean mIsCollectionRemoved = false;
    private final Object mPendingMessagesLock = new Object();
    private final Object mFailedMessagesLock = new Object();

    public MessageCollection(@NonNull GroupChannel channel, @NonNull MessageFilter filter, long viewpointTimestamp) {
        this.mChannel = channel;
        this.mFilter = filter;
        this.mViewpointTimestamp = viewpointTimestamp;
        this.mChunkMessages = new ArrayList<BaseMessage>();
        this.mPrevTempMessages = new ArrayList<BaseMessage>();
        this.mNextTempMessages = new ArrayList<BaseMessage>();
        this.mPendingMessages = new ArrayList<BaseMessage>();
        this.mFailedMessages = new ArrayList<BaseMessage>();
        this.mSynchronizer = new MessageSynchronizer((BaseChannel)channel, filter, viewpointTimestamp);
        this.mExecutorService = Executors.newSingleThreadExecutor();
        MessageManager.getInstance().addMessageCollection(this);
        FailedMessageDispatcher.getInstance().createQueue(this.mChannel);
        this.resumeSync();
    }

    public static void create(final String channelUrl, final @NonNull MessageFilter filter, final long viewpointTimestamp, final MessageCollectionCreateHandler handler) {
        Logger.d(TAG, "create(). channelUrl = " + channelUrl + ", filter = " + filter + ", viewpointTimestamp = " + viewpointTimestamp);
        ChannelManager.getInstance().getContainer().getChannel(channelUrl, new ChannelContainer.GetChannelHandler(){

            @Override
            public void onResult(final GroupChannel channel, SendBirdException e) {
                if (channel == null) {
                    Logger.d(TAG, "create(). failed to get local channel");
                    GroupChannel.getChannel((String)channelUrl, (GroupChannel.GroupChannelGetHandler)new GroupChannel.GroupChannelGetHandler(){

                        public void onResult(final GroupChannel groupChannel, final SendBirdException e) {
                            if (e != null) {
                                SendBirdSyncManager.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (handler != null) {
                                            handler.onResult(null, e);
                                        }
                                    }
                                });
                                return;
                            }
                            SendBirdSyncManager.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (handler != null) {
                                        handler.onResult(new MessageCollection(groupChannel, filter, viewpointTimestamp), null);
                                    }
                                }
                            });
                        }
                    });
                    return;
                }
                SendBirdSyncManager.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (handler != null) {
                            handler.onResult(new MessageCollection(channel, filter, viewpointTimestamp), null);
                        }
                    }
                });
            }
        });
    }

    public void remove() {
        Logger.d(TAG, "remove(), channel url = " + this.mChannel.getUrl());
        this.mIsCollectionRemoved = true;
        MessageManager.getInstance().removeMessageCollection(this);
        FailedMessageDispatcher.getInstance().removeQueue(this.mChannel.getUrl());
        this.mSynchronizer.stop();
        this.mExecutorService.shutdownNow();
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public void setCollectionHandler(MessageCollectionHandler handler) {
        this.mMessageCollectionHandler = handler;
    }

    public void fetch(final Direction direction, final CompletionHandler handler) {
        Logger.d(TAG, "fetch(). direction = " + (Object)((Object)direction));
        this.fetchSucceededMessages(direction, new FetchCompletionHandler(){

            @Override
            public void onCompleted(boolean hasMore, SendBirdException e) {
                Logger.d(TAG, "fetch onCompleted(). direction = " + (Object)((Object)direction) + ", hasMore : " + hasMore);
                if (handler != null) {
                    handler.onCompleted(e);
                }
            }
        });
    }

    public void fetchSucceededMessages(Direction direction, final FetchCompletionHandler handler) {
        if (direction == Direction.PREVIOUS) {
            if (this.mIsPrevLoading) {
                SendBirdSyncManager.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (handler != null) {
                            handler.onCompleted(false, SyncManagerError.getException(810200));
                        }
                    }
                });
                return;
            }
            this.mIsPrevLoading = true;
            this.load(false, this.mLimit, handler);
        } else if (direction == Direction.NEXT) {
            if (this.mIsNextLoading) {
                SendBirdSyncManager.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (handler != null) {
                            handler.onCompleted(false, SyncManagerError.getException(810200));
                        }
                    }
                });
                return;
            }
            this.mIsNextLoading = true;
            this.load(true, this.mLimit, handler);
        }
    }

    public void fetchAllNextMessages(FetchCompletionHandler completionHandler) {
        Logger.d(TAG, "fetchAllNextMessages()");
        this.mIsNextLoading = true;
        this.load(true, Integer.MAX_VALUE, completionHandler);
    }

    public void fetchFailedMessages(final CompletionHandler handler) {
        Logger.d(TAG, "fetchFailedMessages().");
        FailedMessageDispatcher.getInstance().loadFailedMessages(this.mChannel.getUrl(), this.mFilter, new MessageContainer.GetMessagesHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(List<BaseMessage> failedMessages, final SendBirdException e) {
                if (e != null) {
                    SendBirdSyncManager.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (handler != null) {
                                handler.onCompleted(e);
                            }
                        }
                    });
                    return;
                }
                if (failedMessages != null && failedMessages.size() > 0) {
                    ArrayList<BaseMessage> insertedFailedMessageList = new ArrayList<BaseMessage>(failedMessages);
                    ArrayList<BaseMessage> deletedFailedMessageList = new ArrayList<BaseMessage>();
                    Object object = MessageCollection.this.mFailedMessagesLock;
                    synchronized (object) {
                        Iterator fmIt = MessageCollection.this.mFailedMessages.iterator();
                        while (fmIt.hasNext()) {
                            BaseMessage prevFailedMessage = (BaseMessage)fmIt.next();
                            String prevRequestId = SyncManagerUtils.getRequestId(prevFailedMessage);
                            boolean found = false;
                            Iterator it = insertedFailedMessageList.iterator();
                            while (it.hasNext()) {
                                BaseMessage insertedFailedMessage = (BaseMessage)it.next();
                                if (prevRequestId.length() <= 0 || !prevRequestId.equals(SyncManagerUtils.getRequestId(insertedFailedMessage))) continue;
                                it.remove();
                                found = true;
                                break;
                            }
                            if (found) continue;
                            deletedFailedMessageList.add(prevFailedMessage);
                            fmIt.remove();
                        }
                        MessageCollection.this.mFailedMessages.addAll(insertedFailedMessageList);
                    }
                    MessageCollection.this.onFailedMessageEvent(deletedFailedMessageList, MessageEventAction.REMOVE, FailedMessageEventActionReason.REMOVE_UNKNOWN);
                    MessageCollection.this.onFailedMessageEvent(insertedFailedMessageList, MessageEventAction.INSERT, null);
                }
                SendBirdSyncManager.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (handler != null) {
                            handler.onCompleted(e);
                        }
                    }
                });
            }
        });
    }

    public void resetViewpointTimestamp(long viewpointTimestamp) {
        Logger.d(TAG, "resetViewpointTimestamp(). viewpointTimestamp = " + viewpointTimestamp);
        this.mViewpointTimestamp = viewpointTimestamp;
        this.mSynchronizer.stop();
        this.mSynchronizer = new MessageSynchronizer((BaseChannel)this.mChannel, this.mFilter, this.mViewpointTimestamp);
        this.mSynchronizer.start();
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                MessageCollection.this.mPrevTempMessages.clear();
                MessageCollection.this.mNextTempMessages.clear();
                MessageCollection.this.mChunkMessages.clear();
            }
        });
        this.onMessageEvent(new ArrayList<BaseMessage>(), MessageEventAction.CLEAR);
        this.onSucceededMessageEvent(new ArrayList<BaseMessage>(), MessageEventAction.CLEAR);
    }

    public void appendMessage(BaseMessage message) {
        if (message == null) {
            Logger.d(TAG, "appendMessage(). given message is null");
            return;
        }
        if (!this.isMyMessage(message)) {
            Logger.d(TAG, "appendMessage(). given message is not my message");
            return;
        }
        Logger.d(TAG, "appendMessage(). message id = " + message.getMessageId());
        if (message.getMessageId() == 0L) {
            if (message instanceof UserMessage) {
                if (((UserMessage)message).getRequestState() == UserMessage.RequestState.PENDING) {
                    this.addPendingMessage(message);
                } else if (((UserMessage)message).getRequestState() == UserMessage.RequestState.FAILED && !this.containsFailedMessage(message)) {
                    this.removePendingMessage(message);
                    FailedMessageDispatcher.getInstance().upsertMessages(message.getChannelUrl(), Collections.singletonList(message), null);
                }
            } else {
                this.addPendingMessage(message);
            }
            return;
        }
        this.removePendingMessage(message);
        FailedMessageDispatcher.getInstance().removeMessages(this.mChannel.getUrl(), Arrays.asList(message), FailedMessageEventActionReason.REMOVE_RESEND_SUCCEEDED, null);
        MessageManager.getInstance().appendSucceededMessages(message.getChannelUrl(), Collections.singletonList(message));
    }

    public void updateMessage(BaseMessage message) {
        if (message == null) {
            Logger.d(TAG, "updateMessage(). given message is null");
            return;
        }
        if (!this.isMyMessage(message)) {
            Logger.d(TAG, "deleteMessage(). given message is not my message");
            return;
        }
        Logger.d(TAG, "updateMessage. message id = " + message.getMessageId());
        if (message.getMessageId() == 0L) {
            return;
        }
        MessageManager.getInstance().updateSucceededMessages(message.getChannelUrl(), true, Collections.singletonList(message));
    }

    public void deleteMessage(BaseMessage message) {
        if (message == null) {
            Logger.d(TAG, "deleteMessage(). given message is null");
            return;
        }
        if (!this.isMyMessage(message)) {
            Logger.d(TAG, "deleteMessage(). given message is not my message");
            return;
        }
        Logger.d(TAG, "deleteMessage. message id = " + message.getMessageId());
        if (message.getMessageId() == 0L) {
            if (SyncManagerUtils.getRequestState(message) == UserMessage.RequestState.PENDING) {
                this.removePendingMessage(message);
            } else if (SyncManagerUtils.getRequestState(message) == UserMessage.RequestState.FAILED) {
                this.removePendingMessage(message);
                FailedMessageDispatcher.getInstance().removeMessages(this.mChannel.getUrl(), Collections.singletonList(message), FailedMessageEventActionReason.REMOVE_MANUAL_ACTION, null);
            }
            return;
        }
        MessageManager.getInstance().deleteSucceededMessages(this.mChannel.getUrl(), Collections.singletonList(message.getMessageId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFailedMessage(BaseMessage message) {
        if (this.containsFailedMessage(message)) {
            return;
        }
        Object object = this.mFailedMessagesLock;
        synchronized (object) {
            this.mFailedMessages.add(message);
        }
        this.onMessageEvent(Arrays.asList(message), MessageEventAction.INSERT);
        this.onFailedMessageEvent(Arrays.asList(message), MessageEventAction.INSERT, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingMessage(BaseMessage message) {
        if (this.containsPendingMessage(message)) {
            return;
        }
        Object object = this.mPendingMessagesLock;
        synchronized (object) {
            this.mPendingMessages.add(message);
        }
        this.onMessageEvent(Arrays.asList(message), MessageEventAction.INSERT);
        this.onPendingMessageEvent(Arrays.asList(message), MessageEventAction.INSERT);
    }

    public GroupChannel getChannel() {
        return this.mChannel;
    }

    public int getMessageCount() {
        return this.mChunkMessages.size() + this.mNextTempMessages.size() + this.mPrevTempMessages.size();
    }

    public boolean contains(BaseMessage message) {
        if (message == null || message.getMessageId() == 0L) {
            return false;
        }
        List<BaseMessage> succeededMessages = this.getSucceededMessages();
        for (BaseMessage succeededMessage : succeededMessages) {
            if (succeededMessage.getMessageId() != message.getMessageId()) continue;
            return true;
        }
        return false;
    }

    public void handleSendMessageResponse(BaseMessage message, SendBirdException e) {
        if (message == null) {
            Logger.d(TAG, "handleSendMessageResponse(). given message is null");
            return;
        }
        if (e != null) {
            switch (SendBirdSyncManager.getInstance().getOptions().getMessageResendPolicy()) {
                case NONE: {
                    this.deleteMessage(message);
                    break;
                }
                case MANUAL: 
                case AUTOMATIC: {
                    if (message instanceof UserMessage) {
                        this.appendMessage(message);
                        break;
                    }
                    this.deleteMessage(message);
                }
            }
            return;
        }
        this.appendMessage(message);
    }

    String getChannelUrl() {
        return this.mChannel.getUrl();
    }

    List<BaseMessage> getSucceededMessages() {
        ArrayList<BaseMessage> succeededMessages = new ArrayList<BaseMessage>();
        succeededMessages.addAll(this.mChunkMessages);
        succeededMessages.addAll(this.mNextTempMessages);
        succeededMessages.addAll(this.mPrevTempMessages);
        return succeededMessages;
    }

    void onSucceededMessagesInserted(final List<BaseMessage> insertedMessages) {
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                ArrayList<BaseMessage> insertedMessageList = new ArrayList<BaseMessage>();
                for (BaseMessage insertedMessage : insertedMessages) {
                    if (insertedMessage.getMessageId() == 0L || MessageCollection.this.isMessageInLoadedChunkMessage(insertedMessage.getMessageId())) continue;
                    insertedMessageList.add(insertedMessage);
                }
                boolean isViewEmpty = MessageCollection.this.mChunkMessages.isEmpty() && MessageCollection.this.mPrevTempMessages.isEmpty() && MessageCollection.this.mNextTempMessages.isEmpty();
                ArrayList<BaseMessage> nextTempMessages = new ArrayList<BaseMessage>();
                ArrayList<BaseMessage> prevTempMessages = new ArrayList<BaseMessage>();
                long baseTs = MessageCollection.this.mChunkMessages.isEmpty() ? MessageCollection.this.mViewpointTimestamp : ((BaseMessage)MessageCollection.this.mChunkMessages.get(0)).getCreatedAt();
                Logger.d(TAG, "chuckMessage isEmpty : " + MessageCollection.this.mChunkMessages.isEmpty() + ", baseTs : " + baseTs);
                for (BaseMessage message : insertedMessageList) {
                    if (message.getCreatedAt() < baseTs) {
                        prevTempMessages.add(message);
                        continue;
                    }
                    nextTempMessages.add(message);
                }
                if (isViewEmpty) {
                    MessageCollection.this.addToTempMessages(prevTempMessages, false);
                    MessageCollection.this.addToTempMessages(nextTempMessages, true);
                    MessageCollection.this.onMessageEvent(insertedMessageList, MessageEventAction.INSERT);
                    MessageCollection.this.onSucceededMessageEvent(insertedMessageList, MessageEventAction.INSERT);
                } else {
                    MessageChunk currentChunk = MessageManager.getInstance().getMessageChunkContainer().getCurrentChunk(MessageCollection.this.mChannel.getUrl(), MessageCollection.this.mFilter, MessageCollection.this.mViewpointTimestamp, MessageCollection.this.mSynchronizer.isSyncedOnce(), true);
                    boolean isBackSyncFinished = MessageCollection.this.mSynchronizer.isSyncFinished(true);
                    Logger.d(TAG, "currentChunk : " + (currentChunk == null ? null : currentChunk.getRangeAsString()) + ", isBack : " + isBackSyncFinished);
                    if (currentChunk == null) {
                        if (isBackSyncFinished) {
                            MessageCollection.this.addToTempMessages(prevTempMessages, false);
                            MessageCollection.this.addToTempMessages(nextTempMessages, true);
                            MessageCollection.this.onMessageEvent(insertedMessageList, MessageEventAction.INSERT);
                            MessageCollection.this.onSucceededMessageEvent(insertedMessageList, MessageEventAction.INSERT);
                        }
                    } else {
                        long chunkTs = currentChunk.getEndAt();
                        BaseMessage latestChunkMessage = MessageCollection.this.mChunkMessages.size() > 0 ? (BaseMessage)MessageCollection.this.mChunkMessages.get(MessageCollection.this.mChunkMessages.size() - 1) : null;
                        Logger.d(TAG, "backSyncFinished : " + isBackSyncFinished + ", latestChunk : " + (latestChunkMessage == null ? -1L : latestChunkMessage.getCreatedAt()) + ", chunk : " + currentChunk.getRangeAsString() + ", chunkTx : " + chunkTs);
                        if (isBackSyncFinished && (latestChunkMessage == null || latestChunkMessage.getCreatedAt() >= chunkTs)) {
                            MessageCollection.this.addToTempMessages(prevTempMessages, false);
                            MessageCollection.this.addToTempMessages(nextTempMessages, true);
                            MessageCollection.this.onMessageEvent(insertedMessageList, MessageEventAction.INSERT);
                            MessageCollection.this.onSucceededMessageEvent(insertedMessageList, MessageEventAction.INSERT);
                        }
                    }
                }
                MessageCollection.this.checkCapacity(true);
                for (BaseMessage message : insertedMessageList) {
                    MessageCollection.this.onNewMessage(message);
                }
            }
        });
    }

    void onSucceededMessagesUpdated(final List<BaseMessage> updatedMessages) {
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                ArrayList<BaseMessage> updatedMessageList = new ArrayList<BaseMessage>();
                block0: for (BaseMessage updatedMessage : updatedMessages) {
                    int i;
                    boolean isMessageFound = false;
                    for (i = 0; i < MessageCollection.this.mChunkMessages.size(); ++i) {
                        if (((BaseMessage)MessageCollection.this.mChunkMessages.get(i)).getMessageId() != updatedMessage.getMessageId()) continue;
                        updatedMessageList.add(updatedMessage);
                        MessageCollection.this.mChunkMessages.set(i, updatedMessage);
                        isMessageFound = true;
                        break;
                    }
                    if (!isMessageFound) {
                        for (i = 0; i < MessageCollection.this.mPrevTempMessages.size(); ++i) {
                            if (((BaseMessage)MessageCollection.this.mPrevTempMessages.get(i)).getMessageId() != updatedMessage.getMessageId()) continue;
                            updatedMessageList.add(updatedMessage);
                            MessageCollection.this.mPrevTempMessages.set(i, updatedMessage);
                            isMessageFound = true;
                            break;
                        }
                    }
                    if (isMessageFound) continue;
                    for (i = 0; i < MessageCollection.this.mNextTempMessages.size(); ++i) {
                        if (((BaseMessage)MessageCollection.this.mNextTempMessages.get(i)).getMessageId() != updatedMessage.getMessageId()) continue;
                        updatedMessageList.add(updatedMessage);
                        MessageCollection.this.mNextTempMessages.set(i, updatedMessage);
                        continue block0;
                    }
                }
                MessageCollection.this.onMessageEvent(updatedMessageList, MessageEventAction.UPDATE);
                MessageCollection.this.onSucceededMessageEvent(updatedMessageList, MessageEventAction.UPDATE);
            }
        });
    }

    void removeMessagesBeforeOffset(final long offset) {
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                BaseMessage message;
                boolean messagesRemoved = false;
                Iterator it = MessageCollection.this.mChunkMessages.iterator();
                while (it.hasNext()) {
                    message = (BaseMessage)it.next();
                    if (message.getCreatedAt() > offset) continue;
                    it.remove();
                    messagesRemoved = true;
                }
                it = MessageCollection.this.mPrevTempMessages.iterator();
                while (it.hasNext()) {
                    message = (BaseMessage)it.next();
                    if (message.getCreatedAt() > offset) continue;
                    it.remove();
                    messagesRemoved = true;
                }
                it = MessageCollection.this.mNextTempMessages.iterator();
                while (it.hasNext()) {
                    message = (BaseMessage)it.next();
                    if (message.getCreatedAt() > offset) continue;
                    it.remove();
                    messagesRemoved = true;
                }
                if (messagesRemoved) {
                    MessageCollection.this.onMessageEvent(new ArrayList(), MessageEventAction.CLEAR);
                    MessageCollection.this.onSucceededMessageEvent(new ArrayList(), MessageEventAction.CLEAR);
                    List<BaseMessage> succeededMessages = MessageCollection.this.getSucceededMessages();
                    SyncManagerUtils.sortMessages(succeededMessages);
                    MessageCollection.this.onMessageEvent(succeededMessages, MessageEventAction.INSERT);
                    MessageCollection.this.onSucceededMessageEvent(succeededMessages, MessageEventAction.INSERT);
                }
            }
        });
    }

    void onSucceededMessagesDeleted(final List<Long> removedMessageIds) {
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                ArrayList<BaseMessage> deletedMessages = new ArrayList<BaseMessage>();
                block0: for (Long messageId : removedMessageIds) {
                    BaseMessage message;
                    boolean isMessageFound = false;
                    Iterator it = MessageCollection.this.mChunkMessages.iterator();
                    while (it.hasNext()) {
                        message = (BaseMessage)it.next();
                        if (message.getMessageId() != messageId.longValue()) continue;
                        deletedMessages.add(message);
                        it.remove();
                        isMessageFound = true;
                        break;
                    }
                    if (!isMessageFound) {
                        it = MessageCollection.this.mPrevTempMessages.iterator();
                        while (it.hasNext()) {
                            message = (BaseMessage)it.next();
                            if (message.getMessageId() != messageId.longValue()) continue;
                            deletedMessages.add(message);
                            it.remove();
                            isMessageFound = true;
                            break;
                        }
                    }
                    if (isMessageFound) continue;
                    it = MessageCollection.this.mNextTempMessages.iterator();
                    while (it.hasNext()) {
                        message = (BaseMessage)it.next();
                        if (message.getMessageId() != messageId.longValue()) continue;
                        deletedMessages.add(message);
                        it.remove();
                        continue block0;
                    }
                }
                MessageCollection.this.onMessageEvent(deletedMessages, MessageEventAction.REMOVE);
                MessageCollection.this.onSucceededMessageEvent(deletedMessages, MessageEventAction.REMOVE);
            }
        });
    }

    void onChannelUpdated(final GroupChannel channel) {
        this.mChannel = channel;
        SendBirdSyncManager.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (MessageCollection.this.mMessageCollectionHandler != null) {
                    MessageCollection.this.mMessageCollectionHandler.onChannelUpdated(MessageCollection.this, channel);
                }
            }
        });
    }

    void onChannelRemoved() {
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                MessageCollection.this.mChunkMessages.clear();
                MessageCollection.this.mPrevTempMessages.clear();
                MessageCollection.this.mNextTempMessages.clear();
                MessageCollection.this.mPendingMessages.clear();
                MessageCollection.this.mFailedMessages.clear();
                SendBirdSyncManager.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (MessageCollection.this.mMessageCollectionHandler != null) {
                            MessageCollection.this.mMessageCollectionHandler.onChannelRemoved(MessageCollection.this, MessageCollection.this.mChannel);
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<BaseMessage> getFailedMessages() {
        Object object = this.mFailedMessagesLock;
        synchronized (object) {
            return new ArrayList<BaseMessage>(this.mFailedMessages);
        }
    }

    void onFailedMessagesInserted(final List<BaseMessage> insertedMessages) {
        this.runOnSingleThreadPool(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<BaseMessage> insertedFailedMessageList = new ArrayList<BaseMessage>();
                for (BaseMessage insertedMessage : insertedMessages) {
                    if (insertedMessage.getMessageId() != 0L || MessageCollection.this.containsFailedMessage(insertedMessage)) continue;
                    insertedFailedMessageList.add(insertedMessage);
                }
                Object object = MessageCollection.this.mFailedMessagesLock;
                synchronized (object) {
                    MessageCollection.this.mFailedMessages.addAll(insertedFailedMessageList);
                }
                MessageCollection.this.onFailedMessageEvent(insertedFailedMessageList, MessageEventAction.INSERT, FailedMessageEventActionReason.NONE);
            }
        });
    }

    void onFailedMessagesUpdated(final List<BaseMessage> updatedMessages, final FailedMessageEventActionReason reason) {
        this.runOnSingleThreadPool(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<BaseMessage> updatedFailedMessageList = new ArrayList<BaseMessage>();
                for (BaseMessage updatedMessage : updatedMessages) {
                    Integer index = MessageCollection.this.getFailedMessageIndex(updatedMessage);
                    if (index == null) continue;
                    updatedFailedMessageList.add(updatedMessage);
                    Object object = MessageCollection.this.mFailedMessagesLock;
                    synchronized (object) {
                        MessageCollection.this.mFailedMessages.set(index, updatedMessage);
                    }
                }
                MessageCollection.this.onFailedMessageEvent(updatedFailedMessageList, MessageEventAction.UPDATE, reason);
            }
        });
    }

    void onFailedMessagesDeleted(final List<String> removedRequestIds, final FailedMessageEventActionReason reason) {
        this.runOnSingleThreadPool(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<BaseMessage> deletedFailedMessageList = new ArrayList<BaseMessage>();
                Object object = MessageCollection.this.mFailedMessagesLock;
                synchronized (object) {
                    block3: for (String requestId : removedRequestIds) {
                        Iterator it = MessageCollection.this.mFailedMessages.iterator();
                        while (it.hasNext()) {
                            BaseMessage message = (BaseMessage)it.next();
                            if (requestId == null || requestId.length() <= 0 || !requestId.equals(SyncManagerUtils.getRequestId(message))) continue;
                            deletedFailedMessageList.add(message);
                            it.remove();
                            continue block3;
                        }
                    }
                }
                MessageCollection.this.onFailedMessageEvent(deletedFailedMessageList, MessageEventAction.REMOVE, reason);
            }
        });
    }

    void resumeSync() {
        this.resumeSync(true, null);
    }

    void resumeSync(final boolean isNext, final MessageSynchronizer.MessageBackgroundSyncEventListener eventListener) {
        Logger.d(TAG, "resumeSync(). isNext : " + isNext + ", eventListener : " + eventListener);
        if (this.mChannel == null) {
            if (eventListener != null) {
                eventListener.onSynced(null);
            }
            return;
        }
        if (this.mIsApplyingChangeLog) {
            if (eventListener != null) {
                this.mSynchronizer.subscribe(isNext, eventListener);
            }
            SyncManagerError.getException(810210).printStackTrace();
            return;
        }
        this.applyChangeLog(new CompletionHandler(){

            @Override
            public void onCompleted(SendBirdException e) {
                Logger.d(TAG, "applyChangeLog onCompleted(). e : " + e);
                if (!SendBirdSyncManager.getInstance().isPaused()) {
                    if (eventListener != null) {
                        MessageCollection.this.mSynchronizer.subscribe(isNext, eventListener);
                    }
                    MessageCollection.this.mSynchronizer.start();
                }
            }
        });
    }

    void pauseSync() {
        Logger.d(TAG, "pauseSync()");
        this.mIsApplyingChangeLog = false;
        this.mSynchronizer.stop();
    }

    private void applyChangeLog(final CompletionHandler completionHandler) {
        Logger.d(TAG, "applyChangeLog()");
        this.mIsApplyingChangeLog = true;
        String token = SharedPreferencesManager.getInstance().getMessageChangeLogToken(this.mChannel.getUrl());
        BaseChannel.GetMessageChangeLogsByTokenHandler handler = new BaseChannel.GetMessageChangeLogsByTokenHandler(){

            public void onResult(final List<BaseMessage> updatedMessages, final List<Long> deletedMessageIds, final boolean hasMore, final String token, SendBirdException e) {
                Logger.d(TAG, "updatedMessages = [" + updatedMessages + "], deletedMessageIds = [" + deletedMessageIds + "], hasMore = [" + hasMore + "], token = [" + token + "], e = [" + e + "]");
                if (e != null) {
                    e.printStackTrace();
                    MessageCollection.this.mIsApplyingChangeLog = false;
                    if (completionHandler != null) {
                        completionHandler.onCompleted(e);
                    }
                    return;
                }
                SharedPreferencesManager.getInstance().setMessageChangeLogToken(MessageCollection.this.mChannel.getUrl(), token);
                final 17 self = this;
                MessageCollection.this.runOnSingleThreadPool(new Runnable(){

                    @Override
                    public void run() {
                        MessageManager.getInstance().updateSucceededMessages(MessageCollection.this.mChannel.getUrl(), false, updatedMessages);
                        MessageManager.getInstance().deleteSucceededMessages(MessageCollection.this.mChannel.getUrl(), deletedMessageIds);
                        if (hasMore) {
                            MessageCollection.this.mChannel.getMessageChangeLogsByToken(token, self);
                        } else {
                            MessageCollection.this.mIsApplyingChangeLog = false;
                            if (completionHandler != null) {
                                completionHandler.onCompleted(null);
                            }
                        }
                    }
                });
            }
        };
        if (token == null) {
            this.mChannel.getMessageChangeLogsByTimestamp(0L, (BaseChannel.GetMessageChangeLogsHandler)handler);
        } else {
            this.mChannel.getMessageChangeLogsByToken(token, handler);
        }
    }

    private synchronized void load(final boolean isNext, final int limit, final FetchCompletionHandler handler) {
        Logger.d(TAG, "load(). channel url = " + this.mChannel.getUrl() + ", isNext = " + isNext + ", limit = " + limit + ", handler : " + handler);
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                final MessageChunk currentChunk = MessageManager.getInstance().getMessageChunkContainer().getCurrentChunk(MessageCollection.this.mChannel.getUrl(), MessageCollection.this.mFilter, MessageCollection.this.mViewpointTimestamp, MessageCollection.this.mSynchronizer.isSyncedOnce(), true);
                BaseMessage offset = MessageCollection.this.getOffset(isNext);
                long ts = offset == null ? MessageCollection.this.mViewpointTimestamp : offset.getCreatedAt();
                Logger.d(TAG, "load(), isNext : " + isNext + ", currentChunk : " + (currentChunk == null ? null : currentChunk.getRangeAsString()) + ", offset : " + offset + ", ts ; " + ts);
                MessageManager.getInstance().getMessageContainer().getSucceededMessagesByTimestamp(MessageCollection.this.mChannel.getUrl(), ts, MessageCollection.this.mFilter, limit, isNext, offset == null, new MessageContainer.GetMessagesHandler(){

                    @Override
                    public void onResult(final List<BaseMessage> messages, final SendBirdException e) {
                        if (e != null) {
                            SendBirdSyncManager.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (handler != null) {
                                        handler.onCompleted(false, e);
                                    }
                                }
                            });
                            return;
                        }
                        MessageCollection.this.runOnSingleThreadPool(new Runnable(){

                            @Override
                            public void run() {
                                ArrayList<BaseMessage> chunkMessages = new ArrayList<BaseMessage>();
                                ArrayList<BaseMessage> tempMessages = new ArrayList<BaseMessage>();
                                if (currentChunk == null) {
                                    tempMessages.addAll(messages);
                                } else {
                                    for (BaseMessage message : messages) {
                                        if (currentChunk.isMessageInChunk(message)) {
                                            chunkMessages.add(message);
                                            continue;
                                        }
                                        tempMessages.add(message);
                                    }
                                }
                                MessageCollection.this.addToTempMessages(tempMessages, isNext);
                                MessageCollection.this.addToChunkMessages(chunkMessages);
                                ArrayList<BaseMessage> finalEventMessages = new ArrayList<BaseMessage>();
                                finalEventMessages.addAll(tempMessages);
                                finalEventMessages.addAll(chunkMessages);
                                SyncManagerUtils.sortMessages(finalEventMessages);
                                if (isNext) {
                                    MessageCollection.this.mIsNextLoading = false;
                                } else {
                                    MessageCollection.this.mIsPrevLoading = false;
                                }
                                MessageCollection.this.onMessageEvent(finalEventMessages, MessageEventAction.INSERT);
                                MessageCollection.this.onSucceededMessageEvent(finalEventMessages, MessageEventAction.INSERT);
                                MessageCollection.this.checkCapacity(isNext);
                                Log.d((String)TAG, (String)("load, isNext : " + isNext + ", chunkSize : " + chunkMessages.size() + ", limit : " + limit));
                                if (chunkMessages.size() < limit) {
                                    Log.d((String)TAG, (String)("isPaused : " + SendBirdSyncManager.getInstance().isPaused() + ", syncState : " + (Object)((Object)MessageCollection.this.mSynchronizer.getSyncState(isNext))));
                                    MessageCollection.this.mSynchronizer.subscribe(isNext, new MessageBackgroundSyncEventListenerImpl(isNext, limit, limit - chunkMessages.size(), handler));
                                    if (SendBirdSyncManager.getInstance().isPaused() || MessageCollection.this.mSynchronizer.getSyncState(isNext) == BackgroundSyncThread.SyncState.FINISHED) {
                                        SendBirdSyncManager.runOnUIThread(new Runnable(){

                                            @Override
                                            public void run() {
                                                if (handler != null) {
                                                    handler.onCompleted(false, null);
                                                }
                                            }
                                        });
                                    }
                                } else {
                                    SendBirdSyncManager.runOnUIThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (handler != null) {
                                                handler.onCompleted(true, null);
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
                if (MessageCollection.this.mSynchronizer.getSyncState(isNext) == BackgroundSyncThread.SyncState.PAUSED) {
                    MessageCollection.this.mSynchronizer.start();
                }
            }
        });
    }

    private BaseMessage getOffset(boolean isNext) {
        BaseMessage chunkMessageOffset = this.getChunkMessageOffset(isNext);
        BaseMessage tempMessageOffset = this.getTempMessageOffset(isNext);
        if (chunkMessageOffset == null && tempMessageOffset == null) {
            return null;
        }
        if (chunkMessageOffset != null && tempMessageOffset == null) {
            return chunkMessageOffset;
        }
        if (chunkMessageOffset == null && tempMessageOffset != null) {
            return tempMessageOffset;
        }
        if (isNext) {
            return chunkMessageOffset.getCreatedAt() > tempMessageOffset.getCreatedAt() ? chunkMessageOffset : tempMessageOffset;
        }
        return chunkMessageOffset.getCreatedAt() < tempMessageOffset.getCreatedAt() ? chunkMessageOffset : tempMessageOffset;
    }

    private BaseMessage getChunkMessageOffset(boolean isNext) {
        if (this.mChunkMessages.size() == 0) {
            return null;
        }
        return isNext ? this.mChunkMessages.get(this.mChunkMessages.size() - 1) : this.mChunkMessages.get(0);
    }

    private BaseMessage getTempMessageOffset(boolean isNext) {
        if (this.mNextTempMessages.isEmpty() && this.mPrevTempMessages.isEmpty()) {
            return null;
        }
        if (isNext) {
            if (this.mNextTempMessages.isEmpty()) {
                return this.mPrevTempMessages.get(this.mPrevTempMessages.size() - 1);
            }
            return this.mNextTempMessages.get(this.mNextTempMessages.size() - 1);
        }
        if (this.mPrevTempMessages.isEmpty()) {
            return this.mNextTempMessages.get(0);
        }
        return this.mPrevTempMessages.get(0);
    }

    private void addToChunkMessages(List<BaseMessage> messages) {
        Log.d((String)TAG, (String)"addToChunkMessages");
        Iterator<BaseMessage> it = messages.iterator();
        block0: while (it.hasNext()) {
            BaseMessage message = it.next();
            for (BaseMessage chunkMessage : this.mChunkMessages) {
                if (chunkMessage.getMessageId() != message.getMessageId()) continue;
                it.remove();
                continue block0;
            }
        }
        this.mChunkMessages.addAll(messages);
        SyncManagerUtils.sortMessages(this.mChunkMessages);
    }

    private void addToTempMessages(List<BaseMessage> messages, boolean isNext) {
        Log.d((String)TAG, (String)"addToTempMessages");
        Iterator<BaseMessage> it = messages.iterator();
        block0: while (it.hasNext()) {
            BaseMessage message = it.next();
            boolean isRemoved = false;
            for (BaseMessage prevMessage : this.mPrevTempMessages) {
                if (message.getMessageId() != prevMessage.getMessageId()) continue;
                it.remove();
                isRemoved = true;
                break;
            }
            if (isRemoved) continue;
            for (BaseMessage nextMessage : this.mNextTempMessages) {
                if (message.getMessageId() != nextMessage.getMessageId()) continue;
                it.remove();
                continue block0;
            }
        }
        if (isNext) {
            this.mNextTempMessages.addAll(messages);
            SyncManagerUtils.sortMessages(this.mNextTempMessages);
        } else {
            this.mPrevTempMessages.addAll(messages);
            SyncManagerUtils.sortMessages(this.mPrevTempMessages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePendingMessage(BaseMessage message) {
        BaseMessage removedMessage = null;
        Object object = this.mPendingMessagesLock;
        synchronized (object) {
            for (int i = 0; i < this.mPendingMessages.size(); ++i) {
                BaseMessage pendingMessage = this.mPendingMessages.get(i);
                if (!SyncManagerUtils.getRequestId(pendingMessage).equals(SyncManagerUtils.getRequestId(message))) continue;
                removedMessage = this.mPendingMessages.remove(i);
                break;
            }
        }
        if (removedMessage != null) {
            this.onMessageEvent(Arrays.asList(removedMessage), MessageEventAction.REMOVE);
            this.onPendingMessageEvent(Arrays.asList(removedMessage), MessageEventAction.REMOVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsPendingMessage(BaseMessage message) {
        if (message != null && message.getMessageId() == 0L) {
            Object object = this.mPendingMessagesLock;
            synchronized (object) {
                for (int i = 0; i < this.mPendingMessages.size(); ++i) {
                    String pendingMessageRequestId = SyncManagerUtils.getRequestId(this.mPendingMessages.get(i));
                    if (pendingMessageRequestId.length() <= 0 || !pendingMessageRequestId.equals(SyncManagerUtils.getRequestId(message))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsFailedMessage(BaseMessage message) {
        if (message != null && message.getMessageId() == 0L) {
            Object object = this.mFailedMessagesLock;
            synchronized (object) {
                for (int i = 0; i < this.mFailedMessages.size(); ++i) {
                    String failedMessageRequestId = SyncManagerUtils.getRequestId(this.mFailedMessages.get(i));
                    if (failedMessageRequestId.length() <= 0 || !failedMessageRequestId.equals(SyncManagerUtils.getRequestId(message))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getFailedMessageIndex(BaseMessage message) {
        Integer index = null;
        if (message != null && message.getMessageId() == 0L) {
            Object object = this.mFailedMessagesLock;
            synchronized (object) {
                for (int i = 0; i < this.mFailedMessages.size(); ++i) {
                    String failedMessageRequestId = SyncManagerUtils.getRequestId(this.mFailedMessages.get(i));
                    if (failedMessageRequestId.length() <= 0 || !failedMessageRequestId.equals(SyncManagerUtils.getRequestId(message))) continue;
                    index = i;
                    break;
                }
            }
        }
        return index;
    }

    private void checkCapacity(final boolean isInsertedToNextDirection) {
        this.runOnSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                int exceedingSize = MessageCollection.this.getMessageCount() - SendBirdSyncManager.getInstance().getOptions().getMessageCollectionCapacity();
                if (exceedingSize > 0) {
                    MessageCollection.this.removeMessagesExceedingCapacity(exceedingSize, !isInsertedToNextDirection);
                }
            }
        });
    }

    private void removeMessagesExceedingCapacity(int count, boolean isNext) {
        BaseMessage message;
        ArrayList<BaseMessage> removedMessages = new ArrayList<BaseMessage>();
        for (int i = 0; i < count && (message = this.removeEdgeMessage(isNext)) != null; ++i) {
            removedMessages.add(message);
        }
        SyncManagerUtils.sortMessages(removedMessages);
        this.onMessageEvent(removedMessages, MessageEventAction.REMOVE);
        this.onSucceededMessageEvent(removedMessages, MessageEventAction.REMOVE);
    }

    private BaseMessage removeEdgeMessage(boolean isNext) {
        long tempMessageCreatedAt;
        long chunkMessageCreatedAt;
        List<BaseMessage> tempMessages;
        BaseMessage chunkMessage = this.getChunkMessageOffset(isNext);
        BaseMessage tempMessage = null;
        List<BaseMessage> list = tempMessages = isNext ? this.mNextTempMessages : this.mPrevTempMessages;
        if (tempMessages.size() == 0) {
            List<BaseMessage> list2 = tempMessages = isNext ? this.mPrevTempMessages : this.mNextTempMessages;
        }
        if (tempMessages.size() > 0) {
            BaseMessage baseMessage = tempMessage = isNext ? tempMessages.get(tempMessages.size() - 1) : tempMessages.get(0);
        }
        if (chunkMessage == null && tempMessage == null) {
            return null;
        }
        long l = chunkMessage == null ? (isNext ? 0L : Long.MAX_VALUE) : (chunkMessageCreatedAt = chunkMessage.getCreatedAt());
        long l2 = tempMessage == null ? (isNext ? 0L : Long.MAX_VALUE) : (tempMessageCreatedAt = tempMessage.getCreatedAt());
        if (isNext && chunkMessageCreatedAt > tempMessageCreatedAt || !isNext && chunkMessageCreatedAt < tempMessageCreatedAt) {
            this.mChunkMessages.remove(chunkMessage);
            return chunkMessage;
        }
        if (isNext && tempMessageCreatedAt > chunkMessageCreatedAt || !isNext && tempMessageCreatedAt < chunkMessageCreatedAt) {
            if (this.mNextTempMessages.remove(tempMessage)) {
                return tempMessage;
            }
            this.mPrevTempMessages.remove(tempMessage);
            return tempMessage;
        }
        return null;
    }

    private void onMessageEvent(final List<BaseMessage> messages, final MessageEventAction action) {
        Logger.d(TAG, "onMessageEvent. list size = " + messages.size() + ", action = " + (Object)((Object)action));
        if (action != MessageEventAction.CLEAR && messages.size() == 0) {
            return;
        }
        SendBirdSyncManager.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (MessageCollection.this.mMessageCollectionHandler != null) {
                    MessageCollection.this.mMessageCollectionHandler.onMessageEvent(MessageCollection.this, messages, action);
                }
            }
        });
    }

    private void onSucceededMessageEvent(final List<BaseMessage> messages, final MessageEventAction action) {
        Logger.d(TAG, "onSucceededMessageEvent. list size = " + messages.size() + ", action = " + (Object)((Object)action));
        if (action != MessageEventAction.CLEAR && messages.size() == 0) {
            return;
        }
        SendBirdSyncManager.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (MessageCollection.this.mMessageCollectionHandler != null) {
                    MessageCollection.this.mMessageCollectionHandler.onSucceededMessageEvent(MessageCollection.this, messages, action);
                }
            }
        });
    }

    private void onPendingMessageEvent(final List<BaseMessage> messages, final MessageEventAction action) {
        Logger.d(TAG, "onPendingMessageEvent. list size = " + messages.size() + ", action = " + (Object)((Object)action));
        if (action != MessageEventAction.CLEAR && messages.size() == 0) {
            return;
        }
        SendBirdSyncManager.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (MessageCollection.this.mMessageCollectionHandler != null) {
                    MessageCollection.this.mMessageCollectionHandler.onPendingMessageEvent(MessageCollection.this, messages, action);
                }
            }
        });
    }

    private void onFailedMessageEvent(final List<BaseMessage> messages, final MessageEventAction action, final FailedMessageEventActionReason reason) {
        Logger.d(TAG, "onFailedMessageEvent. list size = " + messages.size() + ", action = " + (Object)((Object)action));
        if (action != MessageEventAction.CLEAR && messages.size() == 0) {
            return;
        }
        SendBirdSyncManager.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (MessageCollection.this.mMessageCollectionHandler != null) {
                    MessageCollection.this.mMessageCollectionHandler.onFailedMessageEvent(MessageCollection.this, messages, action, reason);
                }
            }
        });
    }

    private void onNewMessage(final BaseMessage message) {
        Logger.d(TAG, "onNewMessage. messageId = " + (message == null ? null : Long.valueOf(message.getMessageId())));
        if (message == null) {
            return;
        }
        SendBirdSyncManager.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (MessageCollection.this.mMessageCollectionHandler != null) {
                    MessageCollection.this.mMessageCollectionHandler.onNewMessage(MessageCollection.this, message);
                }
            }
        });
    }

    private void runOnSingleThreadPool(Runnable runnable) {
        if (!this.mExecutorService.isShutdown() && !this.mIsCollectionRemoved) {
            this.mExecutorService.execute(runnable);
        }
    }

    private boolean isMessageInLoadedChunkMessage(long messageId) {
        for (int i = 0; i < this.mChunkMessages.size(); ++i) {
            if (this.mChunkMessages.get(i).getMessageId() != messageId) continue;
            return true;
        }
        return false;
    }

    private boolean isMyMessage(BaseMessage message) {
        if (message instanceof AdminMessage) {
            return false;
        }
        Sender sender = message instanceof UserMessage ? ((UserMessage)message).getSender() : ((FileMessage)message).getSender();
        User currentUser = SendBird.getCurrentUser();
        if (sender == null || sender.getUserId() == null || currentUser == null) {
            return message.getMessageId() <= 0L;
        }
        return currentUser.getUserId().equals(sender.getUserId());
    }

    private class MessageBackgroundSyncEventListenerImpl
    implements MessageSynchronizer.MessageBackgroundSyncEventListener {
        boolean mIsNext;
        int mFetchLimit;
        int mRemainingFetchCount;
        FetchCompletionHandler fetchCompletionHandler;

        MessageBackgroundSyncEventListenerImpl(boolean isNext, int fetchLimit, int remainingFetchCount, FetchCompletionHandler fetchCompletionHandler) {
            this.mIsNext = isNext;
            this.mFetchLimit = fetchLimit;
            this.mRemainingFetchCount = remainingFetchCount;
            this.fetchCompletionHandler = fetchCompletionHandler;
        }

        @Override
        public void onSynced(final SendBirdException e) {
            Logger.d(TAG, "onSynced(). channel url = " + MessageCollection.this.mChannel.getUrl() + ", isNext = " + this.mIsNext);
            MessageCollection.this.runOnSingleThreadPool(new Runnable(){

                @Override
                public void run() {
                    List tempMessages;
                    if (e != null) {
                        SendBirdSyncManager.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                if (MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler != null) {
                                    MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler.onCompleted(false, e);
                                }
                            }
                        });
                        return;
                    }
                    List list = tempMessages = MessageBackgroundSyncEventListenerImpl.this.mIsNext ? MessageCollection.this.mNextTempMessages : MessageCollection.this.mPrevTempMessages;
                    if (tempMessages.size() == 0) {
                        MessageCollection.this.load(MessageBackgroundSyncEventListenerImpl.this.mIsNext, Math.max(MessageBackgroundSyncEventListenerImpl.this.mFetchLimit, MessageBackgroundSyncEventListenerImpl.this.mRemainingFetchCount), MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler);
                    } else {
                        Logger.d(TAG, "onSynced(). diff with previous messages");
                        MessageChunk currentChunk = MessageManager.getInstance().getMessageChunkContainer().getCurrentChunk(MessageCollection.this.mChannel.getUrl(), MessageCollection.this.mFilter, MessageCollection.this.mViewpointTimestamp, MessageCollection.this.mSynchronizer.isSyncedOnce(), true);
                        if (currentChunk == null) {
                            Logger.d(TAG, "onSynced(). There is no chunk.");
                            SendBirdSyncManager.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler != null) {
                                        MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler.onCompleted(false, null);
                                    }
                                }
                            });
                            return;
                        }
                        if (!currentChunk.isMessageInChunk((BaseMessage)tempMessages.get(0)) && !currentChunk.isMessageInChunk((BaseMessage)tempMessages.get(tempMessages.size() - 1))) {
                            Logger.d(TAG, "none in chunk");
                            MessageCollection.this.onMessageEvent(tempMessages, MessageEventAction.REMOVE);
                            MessageCollection.this.onSucceededMessageEvent(tempMessages, MessageEventAction.REMOVE);
                            tempMessages.clear();
                            MessageCollection.this.load(MessageBackgroundSyncEventListenerImpl.this.mIsNext, Math.max(MessageBackgroundSyncEventListenerImpl.this.mFetchLimit, MessageBackgroundSyncEventListenerImpl.this.mRemainingFetchCount), MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler);
                        } else {
                            BaseMessage offset = MessageCollection.this.getChunkMessageOffset(MessageBackgroundSyncEventListenerImpl.this.mIsNext);
                            long ts = offset == null ? MessageCollection.this.mViewpointTimestamp : offset.getCreatedAt();
                            boolean isInclusive = offset == null;
                            final int limit = Math.max(MessageBackgroundSyncEventListenerImpl.this.mFetchLimit, tempMessages.size());
                            Logger.d(TAG, "onSynced() next : " + MessageBackgroundSyncEventListenerImpl.this.mIsNext + ", currentChunk : " + currentChunk.getRangeAsString() + ", offset : " + offset + ", ts : " + ts + ", isInclusive : " + isInclusive + ", fetchLimit : " + MessageBackgroundSyncEventListenerImpl.this.mFetchLimit + ", limit : " + limit);
                            final CountDownLatch countDownLatch = new CountDownLatch(1);
                            MessageManager.getInstance().getMessageContainer().getMessagesInChunk(currentChunk, ts, MessageBackgroundSyncEventListenerImpl.this.mIsNext, limit, isInclusive, new MessageContainer.GetMessagesHandler(){

                                @Override
                                public void onResult(List<BaseMessage> messages, final SendBirdException e) {
                                    if (e != null) {
                                        SendBirdSyncManager.runOnUIThread(new Runnable(){

                                            @Override
                                            public void run() {
                                                if (MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler != null) {
                                                    MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler.onCompleted(false, e);
                                                }
                                            }
                                        });
                                        countDownLatch.countDown();
                                        e.printStackTrace();
                                        return;
                                    }
                                    Logger.d(TAG, "handleChunkMessages(). messages : " + (messages == null ? -1 : messages.size()) + ", temp messages : " + tempMessages.size());
                                    ArrayList<BaseMessage> insertedMessages = new ArrayList<BaseMessage>();
                                    if (messages != null) {
                                        insertedMessages.addAll(messages);
                                    }
                                    MessageBackgroundSyncEventListenerImpl.this.diffWithChunkMessages(insertedMessages, tempMessages);
                                    MessageBackgroundSyncEventListenerImpl.this.checkPendingMessages();
                                    MessageCollection.this.checkCapacity(MessageBackgroundSyncEventListenerImpl.this.mIsNext);
                                    int chunkCount = messages == null ? 0 : messages.size();
                                    MessageBackgroundSyncEventListenerImpl.this.mRemainingFetchCount -= chunkCount;
                                    MessageBackgroundSyncEventListenerImpl.this.handleFetchedResult(chunkCount >= Math.min(limit, 100));
                                    countDownLatch.countDown();
                                }
                            });
                            try {
                                countDownLatch.await(10L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException ex) {
                                Logger.e(TAG, Log.getStackTraceString((Throwable)ex));
                            }
                        }
                    }
                }
            });
        }

        private void diffWithChunkMessages(@NonNull List<BaseMessage> insertedMessages, @NonNull List<BaseMessage> tempMessages) {
            Logger.d(TAG, "diffWithChunkMessages. inserted : " + insertedMessages.size() + ", tempMessages : " + tempMessages.size());
            ArrayList<BaseMessage> removedMessages = new ArrayList<BaseMessage>();
            ArrayList<BaseMessage> updatedMessages = new ArrayList<BaseMessage>();
            Iterator<BaseMessage> tempIt = tempMessages.iterator();
            while (tempIt.hasNext()) {
                BaseMessage tempMessage = tempIt.next();
                boolean isMessageFound = false;
                Iterator<BaseMessage> insertIt = insertedMessages.iterator();
                while (insertIt.hasNext()) {
                    BaseMessage message = insertIt.next();
                    if (tempMessage.getMessageId() != message.getMessageId()) continue;
                    isMessageFound = true;
                    if (!tempMessage.equals((Object)message)) {
                        updatedMessages.add(message);
                    }
                    tempIt.remove();
                    insertIt.remove();
                    break;
                }
                if (isMessageFound) continue;
                removedMessages.add(tempMessage);
                tempIt.remove();
            }
            MessageCollection.this.addToChunkMessages(updatedMessages);
            MessageCollection.this.onMessageEvent(removedMessages, MessageEventAction.REMOVE);
            MessageCollection.this.onSucceededMessageEvent(removedMessages, MessageEventAction.REMOVE);
            MessageCollection.this.onMessageEvent(updatedMessages, MessageEventAction.UPDATE);
            MessageCollection.this.onSucceededMessageEvent(updatedMessages, MessageEventAction.UPDATE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkPendingMessages() {
            Logger.d(TAG, "checkPendingMessages. pendingMessages : " + MessageCollection.this.mPendingMessages.size());
            if (!MessageCollection.this.mPendingMessages.isEmpty()) {
                MessageCollection.this.onMessageEvent(new ArrayList(MessageCollection.this.mPendingMessages), MessageEventAction.REMOVE);
                MessageCollection.this.onPendingMessageEvent(new ArrayList(MessageCollection.this.mPendingMessages), MessageEventAction.REMOVE);
                Object object = MessageCollection.this.mPendingMessagesLock;
                synchronized (object) {
                    MessageCollection.this.mPendingMessages.clear();
                }
            }
        }

        private void handleFetchedResult(boolean hasFetchedToLimit) {
            Logger.d(TAG, "handleFetchedResult. hasFetchedToLimit : " + hasFetchedToLimit);
            if (hasFetchedToLimit) {
                if (this.mRemainingFetchCount > 0) {
                    MessageCollection.this.mSynchronizer.subscribe(true, this);
                } else {
                    SendBirdSyncManager.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler != null) {
                                MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler.onCompleted(true, null);
                            }
                        }
                    });
                }
            } else if (this.mRemainingFetchCount > 0) {
                MessageCollection.this.load(this.mIsNext, Math.max(this.mFetchLimit, this.mRemainingFetchCount), this.fetchCompletionHandler);
            } else {
                SendBirdSyncManager.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler != null) {
                            MessageBackgroundSyncEventListenerImpl.this.fetchCompletionHandler.onCompleted(false, null);
                        }
                    }
                });
            }
        }
    }

    public static enum Direction {
        PREVIOUS,
        NEXT;

    }
}

