/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.BackgroundSyncThread;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageBackgroundSyncThread;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageContainer;
import com.sendbird.syncmanager.MessageFilter;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.ArrayList;
import java.util.List;

class MessageSynchronizer {
    private static final String TAG = MessageSynchronizer.class.getSimpleName();
    private static final int MESSAGE_QUERY_INITIAL_RESULT_SIZE = 30;
    private MessageBackgroundSyncThread mNextThread;
    private MessageBackgroundSyncThread mPrevThread;
    private boolean mIsSyncedOnce = false;
    private BaseChannel mChannel;
    private MessageFilter mFilter;
    private long mViewpointTimestamp;
    private int mRetryCounter = 0;
    private final List<MessageBackgroundSyncEventListener> mPrevEventListeners = new ArrayList<MessageBackgroundSyncEventListener>();
    private final List<MessageBackgroundSyncEventListener> mNextEventListeners = new ArrayList<MessageBackgroundSyncEventListener>();
    private BackgroundSyncThread.SyncState mSyncState = BackgroundSyncThread.SyncState.INIT;

    MessageSynchronizer(BaseChannel channel, MessageFilter filter, long viewpointTimestamp) {
        this.mChannel = channel;
        this.mFilter = filter;
        this.mViewpointTimestamp = viewpointTimestamp;
    }

    BackgroundSyncThread.SyncState getSyncState(boolean isNext) {
        MessageBackgroundSyncThread thread;
        MessageBackgroundSyncThread messageBackgroundSyncThread = thread = isNext ? this.mNextThread : this.mPrevThread;
        if (thread == null) {
            return this.mSyncState;
        }
        return thread.getSyncState();
    }

    boolean isSyncFinished(boolean isNext) {
        if (isNext) {
            if (this.mNextThread == null) {
                return false;
            }
            return this.mNextThread.getSyncState() == BackgroundSyncThread.SyncState.FINISHED;
        }
        if (this.mPrevThread == null) {
            return false;
        }
        return this.mPrevThread.getSyncState() == BackgroundSyncThread.SyncState.FINISHED;
    }

    void start() {
        Logger.i(TAG, "start()");
        if (this.mSyncState == BackgroundSyncThread.SyncState.RUNNING || this.getSyncState(true) == BackgroundSyncThread.SyncState.RUNNING || this.getSyncState(false) == BackgroundSyncThread.SyncState.RUNNING) {
            Logger.e(TAG, "RUNNING ALREADY");
            return;
        }
        this.mSyncState = BackgroundSyncThread.SyncState.RUNNING;
        new Thread(new Runnable(){

            @Override
            public void run() {
                MessageChunk chunk = MessageManager.getInstance().getMessageChunkContainer().getCurrentChunk(MessageSynchronizer.this.mChannel.getUrl(), MessageSynchronizer.this.mFilter, MessageSynchronizer.this.mViewpointTimestamp, MessageSynchronizer.this.mIsSyncedOnce, false);
                if (chunk == null) {
                    MessageSynchronizer.this.mRetryCounter = 0;
                    MessageSynchronizer.this.mChannel.getPreviousAndNextMessagesByTimestamp(MessageSynchronizer.this.mViewpointTimestamp, 30, 30, false, MessageSynchronizer.this.mFilter.getMessageTypeFilter(), MessageSynchronizer.this.mFilter.getCustomType(), MessageSynchronizer.this.mFilter.getSenderUserIds(), true, new BaseChannel.GetMessagesHandler(){

                        public void onResult(final List<BaseMessage> list, final SendBirdException e) {
                            Logger.d(TAG, "getPreviousAndNextMessagesByTimestamp. list size = " + (list == null ? "null" : Integer.valueOf(list.size())) + ", e = " + e);
                            final 1 retryHandler = this;
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    if (e != null) {
                                        if (MessageSynchronizer.this.mRetryCounter < 3) {
                                            MessageSynchronizer.this.mRetryCounter++;
                                            MessageSynchronizer.this.mChannel.getPreviousAndNextMessagesByTimestamp(MessageSynchronizer.this.mViewpointTimestamp, 30, 30, false, MessageSynchronizer.this.mFilter.getMessageTypeFilter(), MessageSynchronizer.this.mFilter.getCustomType(), MessageSynchronizer.this.mFilter.getSenderUserIds(), true, retryHandler);
                                        } else {
                                            MessageSynchronizer.this.mSyncState = BackgroundSyncThread.SyncState.PAUSED;
                                        }
                                        e.printStackTrace();
                                        return;
                                    }
                                    MessageSynchronizer.this.mSyncState = BackgroundSyncThread.SyncState.FINISHED;
                                    MessageSynchronizer.this.mIsSyncedOnce = true;
                                    if (list == null || list.size() == 0) {
                                        MessageSynchronizer.this.onSynced(true, null);
                                        MessageSynchronizer.this.onSynced(false, null);
                                        MessageSynchronizer.this.startPrev(null, false);
                                        MessageSynchronizer.this.startNext(null, false);
                                    } else {
                                        MessageManager.getInstance().getMessageContainer().upsertSucceededMessages(list, true, new MessageContainer.UpsertMessageHandler(){

                                            @Override
                                            public void onResult(List<BaseMessage> insertedMessages, List<BaseMessage> updatedMessages, SendBirdException e) {
                                                Logger.d(TAG, "upsertSucceededMessages. insertedMessage list size = " + insertedMessages.size() + " updatedMessage list size = " + updatedMessages.size() + ", e = " + e);
                                                final boolean isApiCallRequired = list.size() >= 30;
                                                long startAt = ((BaseMessage)list.get(0)).getCreatedAt();
                                                long endAt = ((BaseMessage)list.get(list.size() - 1)).getCreatedAt();
                                                final MessageChunk newChunk = new MessageChunk(MessageSynchronizer.this.mChannel.getUrl(), startAt, endAt, MessageSynchronizer.this.mFilter);
                                                newChunk.setStartSynced(!isApiCallRequired);
                                                newChunk.setEndSynced(!isApiCallRequired);
                                                MessageManager.getInstance().getMessageChunkContainer().mergeIntersectedChunks(newChunk, new CompletionHandler(){

                                                    @Override
                                                    public void onCompleted(SendBirdException e) {
                                                        Logger.d(TAG, "mergeIntersectedChunks. e = " + e);
                                                        MessageSynchronizer.this.onSynced(true, e);
                                                        MessageSynchronizer.this.onSynced(false, e);
                                                        MessageSynchronizer.this.startPrev(newChunk, isApiCallRequired);
                                                        MessageSynchronizer.this.startNext(newChunk, isApiCallRequired);
                                                    }
                                                });
                                            }
                                        });
                                    }
                                }
                            }).start();
                        }
                    });
                } else {
                    MessageSynchronizer.this.mSyncState = BackgroundSyncThread.SyncState.FINISHED;
                    MessageSynchronizer.this.mIsSyncedOnce = true;
                    MessageSynchronizer.this.startPrev(chunk, true);
                    MessageSynchronizer.this.startNext(chunk, true);
                }
            }
        }).start();
    }

    void stop() {
        if (this.mNextThread != null) {
            this.mNextThread.stopSync();
            this.mNextThread = null;
        }
        if (this.mPrevThread != null) {
            this.mPrevThread.stopSync();
            this.mPrevThread = null;
        }
        this.mNextEventListeners.clear();
        this.mPrevEventListeners.clear();
        this.mSyncState = BackgroundSyncThread.SyncState.PAUSED;
    }

    private void startNext(MessageChunk chunk, boolean isApiCallRequired) {
        Logger.e(TAG, "startNext");
        if (this.mNextThread == null) {
            this.mNextThread = new MessageBackgroundSyncThread(this.mChannel, chunk, true, isApiCallRequired);
            this.mNextThread.setEventListener(new MessageBackgroundSyncEventListener(){

                @Override
                public void onSynced(SendBirdException e) {
                    MessageSynchronizer.this.onSynced(true, e);
                }
            });
            this.mNextThread.start();
        }
    }

    private void startPrev(MessageChunk chunk, boolean isApiCallRequired) {
        Logger.e(TAG, "startPrev");
        if (this.mPrevThread == null) {
            this.mPrevThread = new MessageBackgroundSyncThread(this.mChannel, chunk, false, isApiCallRequired);
            this.mPrevThread.setEventListener(new MessageBackgroundSyncEventListener(){

                @Override
                public void onSynced(SendBirdException e) {
                    MessageSynchronizer.this.onSynced(false, e);
                }
            });
            this.mPrevThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subscribe(boolean isNext, MessageBackgroundSyncEventListener listener) {
        Logger.e(TAG, "subscribe. isNext : " + isNext);
        if (isNext) {
            List<MessageBackgroundSyncEventListener> list = this.mNextEventListeners;
            synchronized (list) {
                if (!this.mNextEventListeners.contains(listener)) {
                    this.mNextEventListeners.add(listener);
                }
            }
        }
        List<MessageBackgroundSyncEventListener> list = this.mPrevEventListeners;
        synchronized (list) {
            if (!this.mPrevEventListeners.contains(listener)) {
                this.mPrevEventListeners.add(listener);
            }
        }
    }

    boolean isSyncedOnce() {
        return this.mIsSyncedOnce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSynced(boolean isNext, SendBirdException e) {
        Logger.e(TAG, "onSynced. isNext : " + isNext);
        if (isNext) {
            List<MessageBackgroundSyncEventListener> list = this.mNextEventListeners;
            synchronized (list) {
                if (!this.mNextEventListeners.isEmpty()) {
                    for (MessageBackgroundSyncEventListener eventListener : this.mNextEventListeners) {
                        eventListener.onSynced(e);
                    }
                    this.mNextEventListeners.clear();
                }
            }
        }
        List<MessageBackgroundSyncEventListener> list = this.mPrevEventListeners;
        synchronized (list) {
            if (!this.mPrevEventListeners.isEmpty()) {
                for (MessageBackgroundSyncEventListener eventListener : this.mPrevEventListeners) {
                    eventListener.onSynced(e);
                }
                this.mPrevEventListeners.clear();
            }
        }
    }

    static interface MessageBackgroundSyncEventListener {
        public void onSynced(SendBirdException var1);
    }
}

