/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.support.annotation.NonNull;
import com.sendbird.android.BaseMessage;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageFilter;
import java.util.UUID;

class MessageChunk {
    private static final String TAG = MessageChunk.class.getSimpleName();
    private String mChunkId;
    private String mChannelUrl;
    private long mStartAt;
    private long mEndAt;
    private MessageFilter mFilter;
    private boolean mIsStartSynced;
    private boolean mIsEndSynced;

    public MessageChunk(@NonNull String chunkId, @NonNull String channelUrl, long startAt, long endAt, @NonNull MessageFilter filter, boolean isStartSynced, boolean isEndSynced) {
        this.mChunkId = chunkId;
        this.mChannelUrl = channelUrl;
        this.mStartAt = startAt;
        this.mEndAt = endAt;
        this.mFilter = filter;
        this.mIsStartSynced = isStartSynced;
        this.mIsEndSynced = isEndSynced;
    }

    public MessageChunk(@NonNull String channelUrl, long startAt, long endAt, @NonNull MessageFilter filter) {
        this.mChunkId = channelUrl + "_" + UUID.randomUUID().toString();
        this.mChannelUrl = channelUrl;
        this.mStartAt = startAt;
        this.mEndAt = endAt;
        this.mFilter = filter;
        this.mIsStartSynced = false;
        this.mIsEndSynced = false;
    }

    public String getChunkId() {
        return this.mChunkId;
    }

    public String getChannelUrl() {
        return this.mChannelUrl;
    }

    public void setStartAt(long startAt) {
        this.mStartAt = startAt;
    }

    public long getStartAt() {
        return this.mStartAt;
    }

    public void setEndAt(long endAt) {
        this.mEndAt = endAt;
    }

    public long getEndAt() {
        return this.mEndAt;
    }

    public MessageFilter getFilter() {
        return this.mFilter;
    }

    public boolean isStartSynced() {
        return this.mIsStartSynced;
    }

    public boolean isEndSynced() {
        return this.mIsEndSynced;
    }

    public void setStartSynced(boolean isStartSynced) {
        this.mIsStartSynced = isStartSynced;
    }

    public void setEndSynced(boolean isEndSynced) {
        this.mIsEndSynced = isEndSynced;
    }

    public boolean isParent() {
        return this.mFilter.isParent();
    }

    public boolean isMessageInChunk(BaseMessage message) {
        return message.getCreatedAt() >= this.mStartAt && message.getCreatedAt() <= this.mEndAt && this.mFilter.isValidMessage(message);
    }

    void merge(MessageChunk chunk) {
        Logger.d(TAG, "merge(). acquirer range = " + this.getRangeAsString() + ", merged = " + chunk.getRangeAsString());
        if (!this.isIntersectWith(chunk) || !this.mFilter.isEquals(chunk.getFilter())) {
            return;
        }
        this.mStartAt = this.mStartAt <= chunk.getStartAt() ? this.mStartAt : chunk.getStartAt();
        this.mEndAt = this.mEndAt >= chunk.getEndAt() ? this.mEndAt : chunk.getEndAt();
    }

    boolean isIntersectWith(MessageChunk chunk) {
        if (chunk == null) {
            return false;
        }
        if (this == chunk) {
            return false;
        }
        if (!chunk.getChannelUrl().equals(this.mChannelUrl)) {
            return false;
        }
        return this.getStartAt() <= chunk.getEndAt() && this.getEndAt() >= chunk.getStartAt();
    }

    String getRangeAsString() {
        return "[" + this.getStartAt() + " - " + this.getEndAt() + "]";
    }
}

