/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.ChannelManager;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.FailedMessageDispatcher;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.SharedPreferencesManager;
import com.sendbird.syncmanager.SyncManagerError;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SendBirdSyncManager {
    private static final String TAG = SendBirdSyncManager.class.getSimpleName();
    private static final String VERSION = "1.1.12";
    protected static boolean TEST_MODE = false;
    private static SendBirdSyncManager sInstance;
    private static String mCurrentUserId;
    boolean mIsPaused = false;
    private Options mOptions;
    private static final Handler sUIThreadHandler;
    private ExecutorService mEventExecutorService;
    public static final int LOGGER_NONE = 0;
    public static final int LOGGER_INFO = 1;

    public static String getSDKVersion() {
        return VERSION;
    }

    static void runOnUIThread(Runnable runnable) {
        block13: {
            block12: {
                if (runnable == null) {
                    return;
                }
                Options options = null;
                if (SendBirdSyncManager.getInstance() != null) {
                    options = SendBirdSyncManager.getInstance().getOptions();
                }
                if (options == null || options.mThreadOption == null) break block12;
                switch (options.mThreadOption) {
                    case UI_THREAD: {
                        if (sUIThreadHandler != null) {
                            sUIThreadHandler.post(runnable);
                            break;
                        }
                        break block13;
                    }
                    case SINGLE_THREAD: {
                        ExecutorService executorService;
                        if (SendBirdSyncManager.getInstance() != null && !(executorService = SendBirdSyncManager.getInstance().mEventExecutorService).isShutdown()) {
                            executorService.execute(runnable);
                            break;
                        }
                        break block13;
                    }
                    case HANDLER: {
                        if (options.mHandlerForThreadOption != null) {
                            options.mHandlerForThreadOption.post(runnable);
                            break;
                        }
                        break block13;
                    }
                    default: {
                        if (sUIThreadHandler != null) {
                            sUIThreadHandler.post(runnable);
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            if (sUIThreadHandler != null) {
                sUIThreadHandler.post(runnable);
            }
        }
    }

    private SendBirdSyncManager(Options options) {
        this.mOptions = options;
        this.mEventExecutorService = Executors.newSingleThreadExecutor();
    }

    public static void setup(Context context, String userId, CompletionHandler handler) {
        SendBirdSyncManager.setup(context, userId, new Options.Builder().build(), handler);
    }

    public static void setup(Context context, String userId, Options options, final CompletionHandler handler) {
        if (context == null || userId == null) {
            SendBirdSyncManager.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (handler != null) {
                        handler.onCompleted(SyncManagerError.getException(810300));
                    }
                }
            });
            return;
        }
        if (sInstance == null) {
            sInstance = new SendBirdSyncManager(options);
        } else {
            SendBirdSyncManager.sInstance.mOptions = options;
        }
        SendBirdSyncManager.sInstance.mOptions.setSetup(true);
        mCurrentUserId = userId;
        SharedPreferencesManager.init(context);
        DatabaseController.init(context);
        ChannelManager.init();
        MessageManager.init();
        ChannelManager.getInstance().setup(new CompletionHandler(){

            @Override
            public void onCompleted(SendBirdException e) {
                MessageManager.getInstance().setup(new CompletionHandler(){

                    @Override
                    public void onCompleted(SendBirdException e) {
                        FailedMessageDispatcher.getInstance().setup(new CompletionHandler(){

                            @Override
                            public void onCompleted(final SendBirdException e) {
                                SendBirdSyncManager.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (handler != null) {
                                            handler.onCompleted(e);
                                        }
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    public static SendBirdSyncManager getInstance() {
        if (sInstance == null) {
            throw new RuntimeException((Throwable)SyncManagerError.getException(810100));
        }
        return sInstance;
    }

    public void resumeSync() {
        Logger.d(TAG, "resumeSync. isPaused : " + this.mIsPaused);
        if (!this.mIsPaused) {
            this.pauseSync();
        }
        this.mIsPaused = false;
        MessageManager.getInstance().resumeSync();
        ChannelManager.getInstance().resumeSync();
    }

    public void pauseSync() {
        Logger.d(TAG, "pauseSync");
        this.mIsPaused = true;
        MessageManager.getInstance().pauseSync();
        ChannelManager.getInstance().pauseSync();
    }

    public void clearCache() {
        Logger.d(TAG, "clearCache");
        ChannelManager.getInstance().clearCache();
        MessageManager.getInstance().clearCache();
        DatabaseController.getInstance().clearCache();
        SharedPreferencesManager.getInstance().clearCache();
        FailedMessageDispatcher.getInstance().clearCache();
    }

    public void clearCache(String userId) {
        Logger.d(TAG, "clearCache. userId = " + userId);
        ChannelManager.getInstance().clearCache(userId);
        MessageManager.getInstance().clearCache();
        DatabaseController.getInstance().clearCache(userId);
    }

    public Options getOptions() {
        return this.mOptions;
    }

    String getUserId() {
        return mCurrentUserId;
    }

    boolean isPaused() {
        return this.mIsPaused;
    }

    void reset() {
        mCurrentUserId = "";
        this.mIsPaused = false;
    }

    void setMessageCollectionCapacity(int capacity) {
        if (this.mOptions != null) {
            this.mOptions.mMessageCollectionCapacity = capacity;
        }
    }

    public static void setLoggerLevel(int level) {
        Logger.sLevel = level;
    }

    static {
        sUIThreadHandler = new Handler(Looper.getMainLooper());
    }

    public static class Options {
        public static final int INFINITE = Integer.MAX_VALUE;
        private int mMessageCollectionCapacity;
        private MessageResendPolicy mMessageResendPolicy;
        private ThreadOption mThreadOption;
        private Handler mHandlerForThreadOption;
        private int mMaxFailedMessageCountPerChannel;
        private int mFailedMessageRetentionDays;
        private int mAutomaticMessageResendRetryCount;
        private boolean mIsSetup = false;

        public Options() {
            this.mMessageCollectionCapacity = Integer.MAX_VALUE;
            this.mMessageResendPolicy = MessageResendPolicy.NONE;
            this.mThreadOption = ThreadOption.UI_THREAD;
        }

        private Options(int messageCollectionCapacity, MessageResendPolicy messageResendPolicy, ThreadOption threadOption, Handler handlerForThreadOption, int maxFailedMessageCountPerChannel, int failedMessageRetentionDays, int automaticMessageResendRetryCount) {
            this.mMessageCollectionCapacity = messageCollectionCapacity;
            this.mMessageResendPolicy = messageResendPolicy;
            this.mThreadOption = threadOption;
            this.mHandlerForThreadOption = handlerForThreadOption;
            this.mMaxFailedMessageCountPerChannel = maxFailedMessageCountPerChannel;
            this.mFailedMessageRetentionDays = failedMessageRetentionDays;
            this.mAutomaticMessageResendRetryCount = automaticMessageResendRetryCount;
        }

        public int getMessageCollectionCapacity() {
            return this.mMessageCollectionCapacity;
        }

        public void setMessageCollectionCapacity(int capacity) {
            if (this.mIsSetup) {
                return;
            }
            if (capacity < 200) {
                Logger.e(TAG, "setMessageCollectionCapacity. input value should be larger than 200. your input is " + capacity);
                return;
            }
            this.mMessageCollectionCapacity = capacity;
        }

        public MessageResendPolicy getMessageResendPolicy() {
            return this.mMessageResendPolicy;
        }

        public void setMessageResendPolicy(MessageResendPolicy messageResendPolicy) {
            if (this.mIsSetup) {
                return;
            }
            this.mMessageResendPolicy = messageResendPolicy;
        }

        public int getMaxFailedMessageCountPerChannel() {
            return this.mMaxFailedMessageCountPerChannel;
        }

        public int getFailedMessageRetentionDays() {
            return this.mFailedMessageRetentionDays;
        }

        public int getAutomaticMessageResendRetryCount() {
            return this.mAutomaticMessageResendRetryCount;
        }

        public void setThreadOption(ThreadOption threadOption, Handler handler) {
            if (threadOption != null) {
                this.mThreadOption = threadOption;
                if (threadOption == ThreadOption.HANDLER) {
                    this.mHandlerForThreadOption = handler;
                }
            }
        }

        public ThreadOption getThreadOption() {
            return this.mThreadOption;
        }

        void setSetup(boolean isSetup) {
            this.mIsSetup = isSetup;
        }

        public static class Builder {
            private int mMessageCollectionCapacity = Integer.MAX_VALUE;
            private MessageResendPolicy mMessageResendPolicy = MessageResendPolicy.NONE;
            private ThreadOption mThreadOption = ThreadOption.UI_THREAD;
            private Handler mHandlerForThreadOption;
            private int mMaxFailedMessageCountPerChannel = 20;
            private int mFailedMessageRetentionDays = 7;
            private int mAutomaticMessageResendRetryCount = Integer.MAX_VALUE;

            public Builder setMessageCollectionCapacity(int capacity) {
                if (capacity < 200) {
                    Logger.e(TAG, "setMessageCollectionCapacity. input value should be larger than 200. your input is " + capacity);
                } else {
                    this.mMessageCollectionCapacity = capacity;
                }
                return this;
            }

            public Builder setMessageResendPolicy(MessageResendPolicy messageResendPolicy) {
                this.mMessageResendPolicy = messageResendPolicy;
                return this;
            }

            public Builder setThreadOption(ThreadOption threadOption, Handler handler) {
                if (threadOption != null) {
                    this.mThreadOption = threadOption;
                    if (threadOption == ThreadOption.HANDLER) {
                        this.mHandlerForThreadOption = handler;
                    }
                }
                return this;
            }

            public Builder setMaxFailedMessageCountPerChannel(int count) {
                if (TEST_MODE || count > 0) {
                    this.mMaxFailedMessageCountPerChannel = count;
                }
                return this;
            }

            public Builder setFailedMessageRetentionDays(int retentionDays) {
                if (TEST_MODE || retentionDays > 0) {
                    this.mFailedMessageRetentionDays = retentionDays;
                }
                return this;
            }

            public Builder setAutomaticMessageResendRetryCount(int count) {
                if (TEST_MODE || count > 0) {
                    this.mAutomaticMessageResendRetryCount = count;
                }
                return this;
            }

            public Options build() {
                return new Options(this.mMessageCollectionCapacity, this.mMessageResendPolicy, this.mThreadOption, this.mHandlerForThreadOption, this.mMaxFailedMessageCountPerChannel, this.mFailedMessageRetentionDays, this.mAutomaticMessageResendRetryCount);
            }
        }

        public static enum ThreadOption {
            UI_THREAD,
            SINGLE_THREAD,
            HANDLER;

        }
    }

    public static enum MessageResendPolicy {
        NONE,
        MANUAL,
        AUTOMATIC;

    }
}

