/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.support.annotation.NonNull;
import android.util.Log;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.FailedMessageEventActionReason;
import com.sendbird.syncmanager.FailedMessageQueue;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageContainer;
import com.sendbird.syncmanager.MessageFilter;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.SendBirdSyncManager;
import com.sendbird.syncmanager.SyncManagerUtils;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

class FailedMessageDispatcher {
    private static final String TAG = FailedMessageQueue.class.getSimpleName();
    private static FailedMessageDispatcher sInstance;
    private Map<String, FailedMessageQueue> mQueueMap = new ConcurrentHashMap<String, FailedMessageQueue>();
    private long mOldestFailedMessageTs = 0L;
    private Timer mFailedMessageRetentionChecker;

    private FailedMessageDispatcher() {
    }

    static FailedMessageDispatcher getInstance() {
        if (sInstance == null) {
            sInstance = new FailedMessageDispatcher();
        }
        return sInstance;
    }

    void setup(final CompletionHandler handler) {
        this.removeExpiredMessages(new CompletionHandler(){

            @Override
            public void onCompleted(SendBirdException e) {
                FailedMessageDispatcher.this.startFailedMessageRetentionChecker();
                if (handler != null) {
                    handler.onCompleted(e);
                }
            }
        });
    }

    List<BaseMessage> getMessages(String channelUrl) {
        FailedMessageQueue fmq = this.mQueueMap.get(channelUrl);
        if (fmq != null) {
            return new ArrayList<BaseMessage>(fmq.getMessages());
        }
        return new ArrayList<BaseMessage>();
    }

    void loadFailedMessages(final String channelUrl, final MessageFilter messageFilter, final MessageContainer.GetMessagesHandler handler) {
        MessageManager.getInstance().getMessageContainer().loadFailedMessages(channelUrl, new MessageContainer.GetMessagesHandler(){

            @Override
            public void onResult(List<BaseMessage> messages, SendBirdException e) {
                if (e != null) {
                    Log.e((String)TAG, (String)("loadFailedMessages. " + e.getMessage()));
                } else {
                    FailedMessageQueue fmq = (FailedMessageQueue)FailedMessageDispatcher.this.mQueueMap.get(channelUrl);
                    if (fmq != null) {
                        fmq.appendMessages(messages);
                    }
                    Iterator<BaseMessage> iterator = messages.iterator();
                    while (iterator.hasNext()) {
                        BaseMessage message = iterator.next();
                        if (messageFilter.isValidMessage(message)) continue;
                        iterator.remove();
                    }
                }
                if (handler != null) {
                    handler.onResult(messages, e);
                }
            }
        });
    }

    void upsertMessages(final String channelUrl, List<BaseMessage> messages, final MessageContainer.UpsertMessageHandler handler) {
        MessageManager.getInstance().getMessageContainer().upsertFailedMessages(channelUrl, messages, new MessageContainer.UpsertMessageHandler(){

            @Override
            public void onResult(List<BaseMessage> insertedMessages, List<BaseMessage> updatedMessages, SendBirdException e) {
                if (e != null) {
                    Log.e((String)TAG, (String)("upsertFailedMessages. " + e.getMessage()));
                } else {
                    FailedMessageQueue fmq = (FailedMessageQueue)FailedMessageDispatcher.this.mQueueMap.get(channelUrl);
                    if (fmq != null) {
                        fmq.appendMessages(insertedMessages);
                    }
                    MessageManager.getInstance().broadcastFailedMessagesInserted(channelUrl, insertedMessages);
                    MessageManager.getInstance().broadcastFailedMessagesUpdated(channelUrl, updatedMessages, FailedMessageEventActionReason.NONE);
                    FailedMessageDispatcher.this.removeExceedingMaxCount(channelUrl);
                }
                if (handler != null) {
                    handler.onResult(insertedMessages, updatedMessages, e);
                }
            }
        });
    }

    void removeMessages(final String channelUrl, List<BaseMessage> messages, final FailedMessageEventActionReason reason, final CompletionHandler handler) {
        final ArrayList<String> requestIds = new ArrayList<String>();
        for (BaseMessage message : messages) {
            String requestId;
            if (SyncManagerUtils.getRequestId(message).isEmpty() || (requestId = SyncManagerUtils.getRequestId(message)) == null || requestId.isEmpty()) continue;
            requestIds.add(requestId);
        }
        MessageManager.getInstance().getMessageContainer().removeFailedMessages(requestIds, new CompletionHandler(){

            @Override
            public void onCompleted(SendBirdException e) {
                if (e != null) {
                    Log.e((String)TAG, (String)("removeFailedMessages. " + e.getMessage()));
                } else {
                    FailedMessageQueue fmq = (FailedMessageQueue)FailedMessageDispatcher.this.mQueueMap.get(channelUrl);
                    if (fmq != null) {
                        fmq.removeMessages(requestIds);
                    }
                    MessageManager.getInstance().broadcastFailedMessagesDeleted(channelUrl, requestIds, reason);
                }
                if (handler != null) {
                    handler.onCompleted(e);
                }
            }
        });
    }

    void removeExpiredMessages(final CompletionHandler handler) {
        MessageManager.getInstance().getMessageContainer().removeExpiredFailedMessages(new MessageContainer.RemoveExpiredMessagesHandler(){

            @Override
            public void onResult(Map<String, List<String>> removedRequestIds, Long oldestFailedMessageTs, SendBirdException e) {
                if (e != null) {
                    Logger.d(TAG, Log.getStackTraceString((Throwable)e));
                } else {
                    if (oldestFailedMessageTs != null) {
                        FailedMessageDispatcher.this.mOldestFailedMessageTs = oldestFailedMessageTs;
                    }
                    if (removedRequestIds != null) {
                        for (Map.Entry<String, List<String>> entry : removedRequestIds.entrySet()) {
                            String channelUrl = entry.getKey();
                            List<String> requestIds = entry.getValue();
                            FailedMessageQueue fmq = (FailedMessageQueue)FailedMessageDispatcher.this.mQueueMap.get(channelUrl);
                            if (fmq != null) {
                                fmq.removeMessages(requestIds);
                            }
                            MessageManager.getInstance().broadcastFailedMessagesDeleted(channelUrl, requestIds, FailedMessageEventActionReason.REMOVE_RETENTION_EXPIRED);
                        }
                    }
                }
                if (handler != null) {
                    handler.onCompleted(e);
                }
            }
        });
    }

    void removeExceedingMaxCount(final String channelUrl) {
        MessageManager.getInstance().getMessageContainer().removeExceedingMaxCountFailedMessages(channelUrl, new MessageContainer.RemoveExceedingMessagesHandler(){

            @Override
            public void onResult(List<String> removedRequestIds, SendBirdException e) {
                if (e == null) {
                    FailedMessageQueue fmq = (FailedMessageQueue)FailedMessageDispatcher.this.mQueueMap.get(channelUrl);
                    if (fmq != null) {
                        fmq.removeMessages(removedRequestIds);
                    }
                    MessageManager.getInstance().broadcastFailedMessagesDeleted(channelUrl, removedRequestIds, FailedMessageEventActionReason.REMOVE_EXCEEDED_MAX_COUNT);
                }
            }
        });
    }

    void pause() {
        this.stopFailedMessageRetentionChecker();
        this.pauseAllQueues();
    }

    void createQueue(@NonNull GroupChannel channel) {
        FailedMessageQueue fmq = this.mQueueMap.get(channel.getUrl());
        if (fmq != null) {
            fmq.increaseCount();
        } else {
            this.mQueueMap.put(channel.getUrl(), new FailedMessageQueue(channel));
        }
    }

    void removeQueue(String channelUrl) {
        FailedMessageQueue fmq = this.mQueueMap.get(channelUrl);
        if (fmq != null) {
            fmq.decreaseCount();
            if (fmq.getCollectionReferenceCount() == 0) {
                this.mQueueMap.remove(channelUrl);
            }
        }
    }

    void clearCache() {
        this.pauseAllQueues();
        this.mQueueMap.clear();
    }

    void startFailedMessageRetentionChecker() {
        long retentionTimerInterval = SendBirdSyncManager.TEST_MODE ? 5000L : 43200000L;
        this.stopFailedMessageRetentionChecker();
        this.mFailedMessageRetentionChecker = new Timer();
        this.mFailedMessageRetentionChecker.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                int retentionDays = SendBirdSyncManager.getInstance().getOptions().getFailedMessageRetentionDays();
                long expirationTs = System.currentTimeMillis() - (long)retentionDays * 86400000L;
                if (expirationTs > FailedMessageDispatcher.this.mOldestFailedMessageTs) {
                    FailedMessageDispatcher.getInstance().removeExpiredMessages(null);
                }
            }
        }, 0L, retentionTimerInterval);
    }

    private void stopFailedMessageRetentionChecker() {
        if (this.mFailedMessageRetentionChecker != null) {
            this.mFailedMessageRetentionChecker.cancel();
        }
        this.mFailedMessageRetentionChecker = null;
    }

    void resumeAllQueues() {
        for (FailedMessageQueue queue : this.mQueueMap.values()) {
            if (queue == null) continue;
            queue.resumeResending();
        }
    }

    private void pauseAllQueues() {
        for (FailedMessageQueue queue : this.mQueueMap.values()) {
            if (queue == null) continue;
            queue.pauseResending();
        }
    }
}

