/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.support.annotation.NonNull;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelListQuery;
import java.util.Collections;
import java.util.List;

class SyncManagerUtils {
    private static final String CUSTOM_TYPE_DELIMITER = "_CT_DELIMITER_";

    SyncManagerUtils() {
    }

    static String concatenateCustomTypes(List<String> customTypes) {
        if (customTypes == null) {
            return "";
        }
        Collections.sort(customTypes);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < customTypes.size(); ++i) {
            result.append(customTypes.get(i));
            if (i == customTypes.size() - 1) continue;
            result.append(CUSTOM_TYPE_DELIMITER);
        }
        return result.toString();
    }

    static int orderToCode(GroupChannelListQuery.Order order) {
        switch (order) {
            case CHRONOLOGICAL: {
                return 0;
            }
            case CHANNEL_NAME_ALPHABETICAL: {
                return 1;
            }
            case METADATA_VALUE_ALPHABETICAL: {
                return 2;
            }
        }
        return 3;
    }

    static String getOffset(@NonNull GroupChannel channel, GroupChannelListQuery query) {
        if (query.getOrder() == GroupChannelListQuery.Order.CHANNEL_NAME_ALPHABETICAL) {
            return channel.getName();
        }
        if (query.getOrder() == GroupChannelListQuery.Order.CHRONOLOGICAL) {
            return String.valueOf(channel.getCreatedAt());
        }
        if (query.getOrder() == GroupChannelListQuery.Order.LATEST_LAST_MESSAGE) {
            return String.valueOf(channel.getLastMessage() == null ? channel.getCreatedAt() : channel.getLastMessage().getCreatedAt());
        }
        return "";
    }
}

