/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.SendBirdException;

class SyncManagerError {
    static final int ERR_CODE_DATABASE_IO_ERROR = 810001;
    static final int ERR_CODE_DATABASE_NOT_INITIALIZED = 810002;
    static final int ERR_CODE_SETUP_NOT_CALLED = 810100;
    static final int ERR_CODE_FETCH_IN_PROGRESS = 810200;
    static final int ERR_CODE_SYNC_IN_PROGRESS = 810210;
    static final int ERR_CODE_INVALID_PARAMETER = 810300;
    private static final String ERR_MESSAGE_DATABASE_IO_ERROR = "Database I/O operation failed.";
    private static final String ERR_MESSAGE_DATABASE_NOT_INITIALIZED = "Database is not initialized.";
    private static final String ERR_MESSAGE_SETUP_NOT_CALLED = "SendBirdSyncManager.clear() not called.";
    private static final String ERR_MESSAGE_FETCH_IN_PROGRESS = "Fetch is in progress.";
    private static final String ERR_MESSAGE_SYNC_IN_PROGRESS = "Sync is in progress.";
    private static final String ERR_MESSAGE_INVALID_PARAMETER = "Invalid parameter";

    SyncManagerError() {
    }

    static SendBirdException getException(int code) {
        switch (code) {
            case 810001: {
                return new SendBirdException(ERR_MESSAGE_DATABASE_IO_ERROR, 810001);
            }
            case 810002: {
                return new SendBirdException(ERR_MESSAGE_DATABASE_NOT_INITIALIZED, 810002);
            }
            case 810100: {
                return new SendBirdException(ERR_MESSAGE_SETUP_NOT_CALLED, 810100);
            }
            case 810200: {
                return new SendBirdException(ERR_MESSAGE_FETCH_IN_PROGRESS, 810200);
            }
            case 810210: {
                return new SendBirdException(ERR_MESSAGE_SYNC_IN_PROGRESS, 810210);
            }
            case 810300: {
                return new SendBirdException(ERR_MESSAGE_INVALID_PARAMETER, 810300);
            }
        }
        return new SendBirdException("");
    }
}

