/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.content.Context;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.ChannelManager;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.SharedPreferencesManager;
import com.sendbird.syncmanager.SyncManagerError;
import com.sendbird.syncmanager.handler.CompletionHandler;

public class SendBirdSyncManager {
    private static final String TAG = SendBirdSyncManager.class.getSimpleName();
    private static final String VERSION = "1.1.1";
    private static SendBirdSyncManager sInstance;
    private static String mCurrentUserId;
    boolean mIsPaused = false;
    public static final int LOGGER_NONE = 0;
    public static final int LOGGER_INFO = 1;

    public static String getSDKVersion() {
        return VERSION;
    }

    private SendBirdSyncManager() {
    }

    public static void setup(Context context, String userId, final CompletionHandler handler) {
        if (context == null || userId == null) {
            if (handler != null) {
                handler.onCompleted(SyncManagerError.getException(810300));
            }
            return;
        }
        if (sInstance == null) {
            sInstance = new SendBirdSyncManager();
        }
        mCurrentUserId = userId;
        SharedPreferencesManager.init(context);
        DatabaseController.init(context);
        ChannelManager.init();
        MessageManager.init();
        ChannelManager.getInstance().setup(new CompletionHandler(){

            @Override
            public void onCompleted(SendBirdException e) {
                MessageManager.getInstance().setup(new CompletionHandler(){

                    @Override
                    public void onCompleted(SendBirdException e) {
                        if (handler != null) {
                            handler.onCompleted(e);
                        }
                    }
                });
            }
        });
    }

    public static SendBirdSyncManager getInstance() {
        if (sInstance == null) {
            throw new RuntimeException((Throwable)SyncManagerError.getException(810100));
        }
        return sInstance;
    }

    public void resumeSync() {
        Logger.d(TAG, "resumeSync");
        this.mIsPaused = false;
        MessageManager.getInstance().resumeSync();
        ChannelManager.getInstance().resumeSync();
    }

    public void pauseSync() {
        Logger.d(TAG, "pauseSync");
        this.mIsPaused = true;
        MessageManager.getInstance().pauseSync();
        ChannelManager.getInstance().pauseSync();
    }

    public void clearCache() {
        Logger.d(TAG, "clearCache");
        ChannelManager.getInstance().clearCache();
        MessageManager.getInstance().clearCache();
        DatabaseController.getInstance().clearCache();
        SharedPreferencesManager.getInstance().clearCache();
    }

    public void clearCache(String userId) {
        Logger.d(TAG, "clearCache. userId = " + userId);
        ChannelManager.getInstance().clearCache(userId);
        MessageManager.getInstance().clearCache();
        DatabaseController.getInstance().clearCache(userId);
    }

    String getUserId() {
        return mCurrentUserId;
    }

    boolean isPaused() {
        return this.mIsPaused;
    }

    void reset() {
        mCurrentUserId = "";
        this.mIsPaused = false;
    }

    public static void setLoggerLevel(int level) {
        Logger.sLevel = level;
    }
}

