/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.BackgroundSyncThread;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageBackgroundSyncThread;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageContainer;
import com.sendbird.syncmanager.MessageFilter;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.List;

class MessageSynchronizer {
    private static final String TAG = MessageSynchronizer.class.getSimpleName();
    private static final int MESSAGE_QUERY_INITIAL_RESULT_SIZE = 30;
    private MessageBackgroundSyncThread mNextThread;
    private MessageBackgroundSyncThread mPrevThread;
    private boolean mIsSyncedOnce = false;
    private BaseChannel mChannel;
    private MessageFilter mFilter;
    private long mViewpointTimestamp;
    private MessageBackgroundSyncEventListener mPrevEventListener;
    private MessageBackgroundSyncEventListener mNextEventListener;
    private BackgroundSyncThread.SyncState mSyncState = BackgroundSyncThread.SyncState.INIT;

    MessageSynchronizer(BaseChannel channel, MessageFilter filter, long viewpointTimestamp) {
        this.mChannel = channel;
        this.mFilter = filter;
        this.mViewpointTimestamp = viewpointTimestamp;
    }

    BackgroundSyncThread.SyncState getSyncState(boolean isNext) {
        MessageBackgroundSyncThread thread;
        MessageBackgroundSyncThread messageBackgroundSyncThread = thread = isNext ? this.mNextThread : this.mPrevThread;
        if (thread == null) {
            return this.mSyncState;
        }
        return thread.getSyncState();
    }

    boolean isSyncFinished(boolean isNext) {
        if (isNext) {
            if (this.mNextThread == null) {
                return false;
            }
            return this.mNextThread.isFinished();
        }
        if (this.mPrevThread == null) {
            return false;
        }
        return this.mPrevThread.isFinished();
    }

    void start() {
        Logger.i(TAG, "start()");
        new Thread(new Runnable(){

            @Override
            public void run() {
                MessageChunk chunk = MessageManager.getInstance().getMessageChunkContainer().getChunkByTimestamp(MessageSynchronizer.this.mChannel.getUrl(), MessageSynchronizer.this.mFilter, MessageSynchronizer.this.mViewpointTimestamp, false);
                if (chunk == null) {
                    MessageSynchronizer.this.mChannel.getPreviousAndNextMessagesByTimestamp(MessageSynchronizer.this.mViewpointTimestamp, 30, 30, false, MessageSynchronizer.this.mFilter.getMessageTypeFilter(), MessageSynchronizer.this.mFilter.getCustomType(), MessageSynchronizer.this.mFilter.getSenderUserIds(), new BaseChannel.GetMessagesHandler(){

                        public void onResult(final List<BaseMessage> list, SendBirdException e) {
                            Logger.d(TAG, "getPreviousAndNextMessagesByTimestamp. list size = " + (list == null ? "null" : Integer.valueOf(list.size())) + ", e = " + e);
                            if (e != null) {
                                MessageSynchronizer.this.mSyncState = BackgroundSyncThread.SyncState.PAUSED;
                                e.printStackTrace();
                                return;
                            }
                            MessageSynchronizer.this.mIsSyncedOnce = true;
                            if (list.size() == 0) {
                                MessageSynchronizer.this.onSynced(true, null);
                                MessageSynchronizer.this.onSynced(false, null);
                            } else {
                                MessageManager.getInstance().getMessageContainer().upsertMessages(list, true, new MessageContainer.UpsertMessageHandler(){

                                    @Override
                                    public void onResult(List<BaseMessage> insertedMessages, List<BaseMessage> updatedMessages, SendBirdException e) {
                                        Logger.d(TAG, "upsertMessages. insertedMessage list size = " + insertedMessages.size() + " updatedMessage list size = " + updatedMessages.size() + ", e = " + e);
                                        long startAt = ((BaseMessage)list.get(0)).getCreatedAt();
                                        long endAt = ((BaseMessage)list.get(list.size() - 1)).getCreatedAt();
                                        final MessageChunk newChunk = new MessageChunk(MessageSynchronizer.this.mChannel.getUrl(), startAt, endAt, MessageSynchronizer.this.mFilter);
                                        MessageManager.getInstance().getMessageChunkContainer().mergeIntersectedChunks(newChunk, new CompletionHandler(){

                                            @Override
                                            public void onCompleted(SendBirdException e) {
                                                Logger.d(TAG, "mergeIntersectedChunks. e = " + e);
                                                MessageSynchronizer.this.onSynced(true, e);
                                                MessageSynchronizer.this.onSynced(false, e);
                                                MessageSynchronizer.this.startPrev(newChunk);
                                                MessageSynchronizer.this.startNext(newChunk);
                                            }
                                        });
                                    }
                                });
                            }
                        }
                    });
                } else {
                    MessageSynchronizer.this.mIsSyncedOnce = true;
                    MessageSynchronizer.this.startPrev(chunk);
                    MessageSynchronizer.this.startNext(chunk);
                }
            }
        }).start();
    }

    void stop() {
        if (this.mNextThread != null) {
            this.mNextThread.stopSync();
            this.mNextThread = null;
        }
        if (this.mPrevThread != null) {
            this.mPrevThread.stopSync();
            this.mPrevThread = null;
        }
        this.mSyncState = BackgroundSyncThread.SyncState.PAUSED;
    }

    private void startNext(MessageChunk chunk) {
        if (this.mNextThread == null) {
            this.mNextThread = new MessageBackgroundSyncThread(this.mChannel, chunk, true);
            this.mNextThread.setEventListener(new MessageBackgroundSyncEventListener(){

                @Override
                public void onSynced(SendBirdException e) {
                    MessageSynchronizer.this.onSynced(true, e);
                }
            });
            this.mNextThread.start();
        }
    }

    private void startPrev(MessageChunk chunk) {
        if (this.mPrevThread == null) {
            this.mPrevThread = new MessageBackgroundSyncThread(this.mChannel, chunk, false);
            this.mPrevThread.setEventListener(new MessageBackgroundSyncEventListener(){

                @Override
                public void onSynced(SendBirdException e) {
                    MessageSynchronizer.this.onSynced(false, e);
                }
            });
            this.mPrevThread.start();
        }
    }

    void subscribe(boolean isNext, MessageBackgroundSyncEventListener listener) {
        if (isNext) {
            this.mNextEventListener = listener;
        } else {
            this.mPrevEventListener = listener;
        }
    }

    boolean isSyncedOnce() {
        return this.mIsSyncedOnce;
    }

    private void onSynced(boolean isNext, SendBirdException e) {
        if (isNext) {
            if (this.mNextEventListener != null) {
                this.mNextEventListener.onSynced(e);
                this.mNextEventListener = null;
            }
        } else if (this.mPrevEventListener != null) {
            this.mPrevEventListener.onSynced(e);
            this.mPrevEventListener = null;
        }
    }

    static interface MessageBackgroundSyncEventListener {
        public void onSynced(SendBirdException var1);
    }
}

