/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.support.annotation.Nullable;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageFilter;
import com.sendbird.syncmanager.SendBirdSyncManager;
import com.sendbird.syncmanager.SyncManagerError;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class MessageChunkContainer {
    private static final String TAG = MessageChunkContainer.class.getSimpleName();
    private Map<String, MessageChunk> mMessageChunks;
    private final Object mMessageChunksLock = new Object();

    MessageChunkContainer() {
        this.mMessageChunks = new HashMap<String, MessageChunk>();
    }

    void setup(final CompletionHandler handler) {
        this.mMessageChunks.clear();
        this.getChunks(new GetMessageChunksHandler(){

            @Override
            public void onResult(List<MessageChunk> messageChunks, SendBirdException e) {
                if (handler != null) {
                    handler.onCompleted(e);
                }
            }
        });
    }

    void getChunks(final GetMessageChunksHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onResult(null, SyncManagerError.getException(810100));
            }
            return;
        }
        DatabaseController.getInstance().getAllMessageChunks(userId, new GetMessageChunksHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(List<MessageChunk> messageChunks, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                Object object = MessageChunkContainer.this.mMessageChunksLock;
                synchronized (object) {
                    MessageChunkContainer.this.mMessageChunks.clear();
                    for (MessageChunk chunk : messageChunks) {
                        MessageChunkContainer.this.mMessageChunks.put(chunk.getChunkId(), chunk);
                    }
                }
                if (handler != null) {
                    handler.onResult(messageChunks, e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeIntersectedChunks(final MessageChunk chunk, final CompletionHandler handler) {
        ArrayList<MessageChunk> deletedChunks = new ArrayList<MessageChunk>();
        MessageChunk intersectedChunk = this.getIntersectedChunk(chunk);
        while (intersectedChunk != null) {
            chunk.merge(intersectedChunk);
            deletedChunks.add(intersectedChunk);
            Object object = this.mMessageChunksLock;
            synchronized (object) {
                this.mMessageChunks.remove(intersectedChunk.getChunkId());
            }
            intersectedChunk = this.getIntersectedChunk(chunk);
        }
        this.deleteChunks(deletedChunks, new CompletionHandler(){

            @Override
            public void onCompleted(SendBirdException e) {
                MessageChunkContainer.this.upsertChunk(chunk, new CompletionHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onCompleted(SendBirdException e) {
                        if (e == null) {
                            Object object = MessageChunkContainer.this.mMessageChunksLock;
                            synchronized (object) {
                                MessageChunkContainer.this.mMessageChunks.put(chunk.getChunkId(), chunk);
                            }
                        }
                        if (handler != null) {
                            handler.onCompleted(e);
                        }
                    }
                });
            }
        });
    }

    void upsertChunk(final MessageChunk chunk, final CompletionHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onCompleted(SyncManagerError.getException(810100));
            }
            return;
        }
        DatabaseController.getInstance().upsertChunk(userId, chunk, new CompletionHandler(){

            @Override
            public void onCompleted(SendBirdException e) {
                if (e == null) {
                    MessageChunkContainer.this.mMessageChunks.put(chunk.getChunkId(), chunk);
                }
                if (handler != null) {
                    handler.onCompleted(e);
                }
            }
        });
    }

    void deleteChunks(final List<MessageChunk> chunks, final CompletionHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onCompleted(SyncManagerError.getException(810100));
            }
            return;
        }
        DatabaseController.getInstance().deleteChunks(userId, chunks, new CompletionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted(SendBirdException e) {
                if (e == null) {
                    Object object = MessageChunkContainer.this.mMessageChunksLock;
                    synchronized (object) {
                        for (MessageChunk chunk : chunks) {
                            MessageChunkContainer.this.mMessageChunks.remove(chunk.getChunkId());
                        }
                    }
                }
                if (handler != null) {
                    handler.onCompleted(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    MessageChunk getNearestChunk(String channelUrl, MessageFilter filter, long ts) {
        Logger.d(TAG, "getNearestChunk(). channelUrl = " + channelUrl + ", filter = " + filter + ", ts = " + ts);
        long nearestTimeDiff = Long.MAX_VALUE;
        MessageChunk nearestChunk = this.getChunkByTimestamp(channelUrl, filter, ts, true);
        if (nearestChunk != null) {
            return nearestChunk;
        }
        Object object = this.mMessageChunksLock;
        synchronized (object) {
            long timeDiffWithEndAt;
            long timeDiff;
            long timeDiffWithStartAt;
            for (MessageChunk chunk : this.mMessageChunks.values()) {
                timeDiffWithStartAt = Math.abs(chunk.getStartAt() - ts);
                long l = timeDiff = timeDiffWithStartAt > (timeDiffWithEndAt = Math.abs(chunk.getEndAt() - ts)) ? timeDiffWithEndAt : timeDiffWithStartAt;
                if (!channelUrl.equals(chunk.getChannelUrl()) || !filter.isEquals(chunk.getFilter()) || nearestTimeDiff <= timeDiff) continue;
                nearestTimeDiff = timeDiff;
                nearestChunk = chunk;
            }
            if (nearestChunk != null) {
                return nearestChunk;
            }
            nearestTimeDiff = Long.MAX_VALUE;
            nearestChunk = null;
            for (MessageChunk chunk : this.mMessageChunks.values()) {
                timeDiffWithStartAt = Math.abs(chunk.getStartAt() - ts);
                long l = timeDiff = timeDiffWithStartAt > (timeDiffWithEndAt = Math.abs(chunk.getEndAt() - ts)) ? timeDiffWithEndAt : timeDiffWithStartAt;
                if (!channelUrl.equals(chunk.getChannelUrl()) || !filter.isParent() || nearestTimeDiff <= timeDiff) continue;
                nearestTimeDiff = timeDiff;
                nearestChunk = chunk;
            }
        }
        return nearestChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    MessageChunk getChunkByTimestamp(String channelUrl, MessageFilter filter, long ts, boolean needParentChunk) {
        Logger.d(TAG, "getChunkByTimestamp(). channelUrl = " + channelUrl + ", filter = " + filter + ", ts = " + ts);
        Object object = this.mMessageChunksLock;
        synchronized (object) {
            for (MessageChunk chunk : this.mMessageChunks.values()) {
                if (!channelUrl.equals(chunk.getChannelUrl()) || ts < chunk.getStartAt() || ts > chunk.getEndAt() || !filter.isEquals(chunk.getFilter())) continue;
                return chunk;
            }
            if (needParentChunk) {
                for (MessageChunk chunk : this.mMessageChunks.values()) {
                    if (!channelUrl.equals(chunk.getChannelUrl()) || ts < chunk.getStartAt() || ts > chunk.getEndAt() || !chunk.isParent()) continue;
                    return chunk;
                }
            }
        }
        return null;
    }

    @Nullable
    MessageChunk getIntersectedChunk(MessageChunk chunk) {
        Logger.d(TAG, "getIntersectedChunk(). chunk range = " + chunk.getRangeAsString());
        for (MessageChunk chk : this.mMessageChunks.values()) {
            if (!chk.getFilter().isEquals(chunk.getFilter()) || !chunk.isIntersectWith(chk)) continue;
            Logger.d(TAG, "getIntersectedChunk(). Find! intersected chunk range = " + chk.getRangeAsString());
            return chk;
        }
        return null;
    }

    public void clear() {
        this.mMessageChunks.clear();
    }

    static interface GetMessageChunksHandler {
        public void onResult(List<MessageChunk> var1, SendBirdException var2);
    }
}

