/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.content.Context;
import android.content.SharedPreferences;
import com.sendbird.syncmanager.SendBirdSyncManager;

class SharedPreferencesManager {
    private static final String SYNC_MANAGER_SHARED_PREFERENCE_NAME = "sendbird_syncmanager";
    private static final String KEY_PREVIOUS_USER_ID = "previous_user_id";
    private SharedPreferences mSharedPreferences;
    private static SharedPreferencesManager sInstance;

    private SharedPreferencesManager(Context context) {
        this.mSharedPreferences = context.getSharedPreferences(SYNC_MANAGER_SHARED_PREFERENCE_NAME, 0);
    }

    public static void init(Context context) {
        if (sInstance == null) {
            sInstance = new SharedPreferencesManager(context);
        }
    }

    static SharedPreferencesManager getInstance() {
        if (sInstance == null) {
            throw new RuntimeException("SharedPreferencesManager hans't been initialized. Try SharedPreferencesManager.init first");
        }
        return sInstance;
    }

    void setMessageChangeLogToken(String channelUrl, String token) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(SendBirdSyncManager.getInstance().getUserId() + "_delimiter_" + channelUrl, token).apply();
    }

    String getMessageChangeLogToken(String channelUrl) {
        return this.mSharedPreferences.getString(SendBirdSyncManager.getInstance().getUserId() + "_delimiter_" + channelUrl, null);
    }

    void removeMessageChangeLogToken(String channelUrl) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.remove(SendBirdSyncManager.getInstance().getUserId() + "_delimiter_" + channelUrl).apply();
    }

    void setPreviousUserId(String userId) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(KEY_PREVIOUS_USER_ID, userId).apply();
    }

    String getPreviousUserId() {
        return this.mSharedPreferences.getString(KEY_PREVIOUS_USER_ID, null);
    }

    void clearCache() {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.clear().apply();
    }
}

