/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageChunkContainer;
import com.sendbird.syncmanager.MessageCollection;
import com.sendbird.syncmanager.MessageContainer;
import com.sendbird.syncmanager.SyncManagerError;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

class MessageManager {
    private static final String TAG = MessageManager.class.getSimpleName();
    private static MessageManager sInstance;
    private String mIdentifier;
    public List<MessageCollection> mMessageCollections = new ArrayList<MessageCollection>();
    private MessageContainer mMessageContainer;
    private MessageChunkContainer mMessageChunkContainer;
    private SendBird.ChannelHandler mChannelHandler = new SendBird.ChannelHandler(){

        public void onMessageReceived(BaseChannel channel, BaseMessage message) {
            Logger.d(TAG, "onMessageReceived, channelUrl = " + this.getChannelUrl(channel) + ", messageId = " + this.getMessageId(message));
            MessageManager.this.appendMessage(message);
        }

        public void onMessageDeleted(BaseChannel channel, long msgId) {
            Logger.d(TAG, "onMessageDeleted, channelUrl = " + this.getChannelUrl(channel) + ", messageId = " + msgId);
            MessageManager.this.deleteMessage(channel.getUrl(), msgId);
        }

        public void onMessageUpdated(BaseChannel channel, BaseMessage message) {
            Logger.d(TAG, "onMessageUpdated, channelUrl = " + this.getChannelUrl(channel) + ", messageId = " + this.getMessageId(message));
            MessageManager.this.updateMessage(message);
        }

        private String getChannelUrl(BaseChannel channel) {
            return channel == null ? "null" : channel.getUrl();
        }

        private String getMessageId(BaseMessage message) {
            return message == null ? "null" : String.valueOf(message.getMessageId());
        }
    };

    private MessageManager() {
        this.mIdentifier = UUID.randomUUID().toString();
        this.mMessageContainer = new MessageContainer();
        this.mMessageChunkContainer = new MessageChunkContainer();
        SendBird.addChannelHandler((String)this.mIdentifier, (SendBird.ChannelHandler)this.mChannelHandler);
    }

    public static MessageManager getInstance() {
        if (sInstance == null) {
            throw new RuntimeException((Throwable)SyncManagerError.getException(810100));
        }
        return sInstance;
    }

    static void init() {
        if (sInstance == null) {
            sInstance = new MessageManager();
        }
    }

    static void deinit() {
        sInstance = null;
    }

    void setup(final CompletionHandler handler) {
        this.mMessageContainer.setup(new CompletionHandler(){

            @Override
            public void onCompleted(SendBirdException e) {
                MessageManager.this.mMessageChunkContainer.setup(new CompletionHandler(){

                    @Override
                    public void onCompleted(SendBirdException e) {
                        if (handler != null) {
                            handler.onCompleted(e);
                        }
                    }
                });
            }
        });
    }

    void addMessageCollection(MessageCollection collection) {
        MessageManager.getInstance().mMessageCollections.add(collection);
    }

    void removeMessageCollection(MessageCollection collection) {
        MessageManager.getInstance().mMessageCollections.remove(collection);
    }

    public void appendMessage(final BaseMessage message) {
        MessageManager.getInstance().getMessageContainer().upsertMessages(Arrays.asList(message), true, new MessageContainer.UpsertMessageHandler(){

            @Override
            public void onResult(List<BaseMessage> insertedMessages, List<BaseMessage> updatedMessages, SendBirdException e) {
                if (insertedMessages.size() > 0) {
                    for (MessageCollection collection : MessageManager.getInstance().getMessageCollections()) {
                        if (!message.getChannelUrl().equals(collection.getChannelUrl())) continue;
                        collection.onInsertedMessagesReceived(insertedMessages);
                    }
                }
                if (updatedMessages.size() > 0) {
                    for (MessageCollection collection : MessageManager.getInstance().getMessageCollections()) {
                        if (!message.getChannelUrl().equals(collection.getChannelUrl())) continue;
                        collection.onUpdatedMessagesReceived(updatedMessages);
                    }
                }
            }
        });
    }

    public void updateMessage(BaseMessage message) {
        this.updateMessages(message.getChannelUrl(), true, Arrays.asList(message));
    }

    void updateMessages(final String channelUrl, boolean isVisible, List<BaseMessage> messages) {
        MessageManager.getInstance().getMessageContainer().upsertMessages(messages, isVisible, new MessageContainer.UpsertMessageHandler(){

            @Override
            public void onResult(List<BaseMessage> insertedMessages, List<BaseMessage> updatedMessages, SendBirdException e) {
                if (insertedMessages.size() > 0) {
                    for (MessageCollection collection : MessageManager.getInstance().getMessageCollections()) {
                        if (!channelUrl.equals(collection.getChannelUrl())) continue;
                        collection.onInsertedMessagesReceived(insertedMessages);
                    }
                }
                if (updatedMessages.size() > 0) {
                    for (MessageCollection collection : MessageManager.getInstance().getMessageCollections()) {
                        if (!channelUrl.equals(collection.getChannelUrl())) continue;
                        collection.onUpdatedMessagesReceived(updatedMessages);
                    }
                }
            }
        });
    }

    void deleteMessage(String channelUrl, long messageId) {
        this.deleteMessages(channelUrl, Arrays.asList(messageId));
    }

    void deleteMessages(final String channelUrl, final List<Long> messageIds) {
        MessageManager.getInstance().getMessageContainer().removeMessages(messageIds, new CompletionHandler(){

            @Override
            public void onCompleted(SendBirdException e) {
                for (MessageCollection collection : MessageManager.getInstance().getMessageCollections()) {
                    if (!channelUrl.equals(collection.getChannelUrl())) continue;
                    collection.onRemovedMessageReceived(messageIds);
                }
            }
        });
    }

    void resumeSync() {
        for (MessageCollection collection : this.getMessageCollections()) {
            collection.resumeSync();
        }
    }

    void pauseSync() {
        for (MessageCollection collection : this.getMessageCollections()) {
            collection.pauseSync();
        }
    }

    MessageContainer getMessageContainer() {
        return this.mMessageContainer;
    }

    MessageChunkContainer getMessageChunkContainer() {
        return this.mMessageChunkContainer;
    }

    List<MessageCollection> getMessageCollections() {
        return new ArrayList<MessageCollection>(this.mMessageCollections);
    }

    public void clearCache() {
        Iterator<MessageCollection> iterator = this.mMessageCollections.iterator();
        while (iterator.hasNext()) {
            MessageCollection messageCollection = iterator.next();
            iterator.remove();
            messageCollection.remove();
        }
        this.mMessageChunkContainer.clear();
    }
}

