/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.SendBirdSyncManager;
import com.sendbird.syncmanager.SharedPreferencesManager;
import com.sendbird.syncmanager.SyncManagerError;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class ChannelContainer {
    private Map<String, GroupChannel> mChannelMap;
    private final Object mChannelMapLock = new Object();

    ChannelContainer() {
        this.mChannelMap = new LinkedHashMap<String, GroupChannel>();
    }

    void setup(final CompletionHandler handler) {
        this.mChannelMap.clear();
        this.getChannels(new GetChannelsHandler(){

            @Override
            public void onResult(List<GroupChannel> channels, SendBirdException e) {
                if (e != null) {
                    e.printStackTrace();
                }
                if (handler != null) {
                    handler.onCompleted(e);
                }
            }
        });
    }

    List<GroupChannel> getChannels() {
        return this.convertChannelMapToList();
    }

    void getChannel(final String channelUrl, final GetChannelHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onResult(null, SyncManagerError.getException(810100));
            }
            return;
        }
        DatabaseController.getInstance().getChannel(userId, channelUrl, new GetChannelHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(GroupChannel channel, SendBirdException e) {
                Object object = ChannelContainer.this.mChannelMapLock;
                synchronized (object) {
                    if (!ChannelContainer.this.mChannelMap.containsKey(channelUrl)) {
                        ChannelContainer.this.mChannelMap.put(channelUrl, channel);
                    }
                }
                handler.onResult(channel, e);
            }
        });
    }

    void getChannels(final GetChannelsHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onResult(null, SyncManagerError.getException(810100));
            }
            return;
        }
        DatabaseController.getInstance().getAllChannels(userId, new GetChannelsHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(List<GroupChannel> channels, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                Object object = ChannelContainer.this.mChannelMapLock;
                synchronized (object) {
                    ChannelContainer.this.mChannelMap.clear();
                    for (GroupChannel channel : channels) {
                        ChannelContainer.this.mChannelMap.put(channel.getUrl(), channel);
                    }
                }
                if (handler != null) {
                    handler.onResult(channels, e);
                }
            }
        });
    }

    void upsertChannels(final List<GroupChannel> channels, final UpdateChannelHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onResult(null, SyncManagerError.getException(810100));
            }
            return;
        }
        DatabaseController.getInstance().upsertChannels(userId, channels, new UpdateChannelHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(List<GroupChannel> updatedChannels, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                Object object = ChannelContainer.this.mChannelMapLock;
                synchronized (object) {
                    for (GroupChannel channel : channels) {
                        ChannelContainer.this.mChannelMap.put(channel.getUrl(), channel);
                    }
                }
                if (handler != null) {
                    handler.onResult(updatedChannels, e);
                }
            }
        });
    }

    void removeChannelUrl(final String channelUrl, final CompletionHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onCompleted(SyncManagerError.getException(810100));
            }
            return;
        }
        DatabaseController.getInstance().deleteChannel(userId, channelUrl, new CompletionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted(SendBirdException e) {
                if (e == null) {
                    Object object = ChannelContainer.this.mChannelMapLock;
                    synchronized (object) {
                        ChannelContainer.this.mChannelMap.remove(channelUrl);
                    }
                }
                if (handler != null) {
                    handler.onCompleted(e);
                }
            }
        });
    }

    void removeChannelUrls(final List<String> channelUrls, final CompletionHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onCompleted(SyncManagerError.getException(810100));
            }
            return;
        }
        DatabaseController.getInstance().deleteChannels(userId, channelUrls, new CompletionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted(SendBirdException e) {
                if (e == null) {
                    Object object = ChannelContainer.this.mChannelMapLock;
                    synchronized (object) {
                        for (String channelUrl : channelUrls) {
                            ChannelContainer.this.mChannelMap.remove(channelUrl);
                        }
                    }
                }
                if (handler != null) {
                    handler.onCompleted(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GroupChannel> convertChannelMapToList() {
        ArrayList<GroupChannel> channels = new ArrayList<GroupChannel>();
        Object object = this.mChannelMapLock;
        synchronized (object) {
            if (this.mChannelMap != null) {
                channels.addAll(this.mChannelMap.values());
            }
        }
        return channels;
    }

    void clear() {
        this.mChannelMap.clear();
    }

    void clear(String userId) {
        for (GroupChannel groupChannel : this.mChannelMap.values()) {
            SharedPreferencesManager.getInstance().removeMessageChangeLogToken(groupChannel.getUrl());
        }
        this.mChannelMap.clear();
    }

    static interface UpdateChannelHandler {
        public void onResult(List<GroupChannel> var1, SendBirdException var2);
    }

    static interface GetChannelsHandler {
        public void onResult(List<GroupChannel> var1, SendBirdException var2);
    }

    static interface GetChannelHandler {
        public void onResult(GroupChannel var1, SendBirdException var2);
    }
}

