/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.support.annotation.NonNull;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.BackgroundSync;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageContainer;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.List;
import java.util.concurrent.CountDownLatch;

class BackgroundSyncThread
extends Thread {
    private static final String TAG = BackgroundSyncThread.class.getSimpleName();
    private static final int MESSAGE_QUERY_RESULT_SIZE = 100;
    private BaseChannel mChannel;
    private MessageChunk mChunk;
    private boolean mIsNext;
    private boolean mIsFinished;
    private BackgroundSync.BackgroundSyncEventListener mEventListener;
    private BackgroundSync.BackgroundSyncFinishedListener mFinishedListener;
    private boolean mIsStopped = false;

    BackgroundSyncThread(@NonNull BaseChannel channel, MessageChunk chunk, boolean isNext, BackgroundSync.BackgroundSyncFinishedListener listener) {
        this.mChannel = channel;
        this.mChunk = chunk;
        this.mIsNext = isNext;
        this.mIsFinished = false;
        this.mFinishedListener = listener;
    }

    void setEventListener(BackgroundSync.BackgroundSyncEventListener listener) {
        this.mEventListener = listener;
    }

    void stopSync() {
        this.mIsStopped = true;
    }

    boolean isFinished() {
        return this.mIsFinished;
    }

    @Override
    public void run() {
        Logger.d(TAG, "run(). channelUrl = " + this.mChannel.getUrl() + ", isNext = " + this.mIsNext);
        while (!this.mIsFinished && !this.mIsStopped) {
            final CountDownLatch loopLatch = new CountDownLatch(1);
            long timestamp = this.mIsNext ? this.mChunk.getEndAt() : this.mChunk.getStartAt();
            this.getMessagesByTimestamp(timestamp, new BaseChannel.GetMessagesHandler(){

                public void onResult(final List<BaseMessage> list, SendBirdException e) {
                    Logger.d(TAG, "getMessagesByTimestamp. list size = " + (list == null ? "null" : Integer.valueOf(list.size())) + ", e = " + e);
                    if (e != null) {
                        BackgroundSyncThread.this.mIsFinished = true;
                        loopLatch.countDown();
                        return;
                    }
                    if (list.size() <= 1) {
                        BackgroundSyncThread.this.mIsFinished = true;
                        if (BackgroundSyncThread.this.mIsNext) {
                            BackgroundSyncThread.this.mChunk.setEndSynced(true);
                        } else {
                            BackgroundSyncThread.this.mChunk.setStartSynced(true);
                        }
                        MessageManager.getInstance().getMessageChunkContainer().upsertChunk(BackgroundSyncThread.this.mChunk, new CompletionHandler(){

                            @Override
                            public void onCompleted(SendBirdException e) {
                                BackgroundSyncThread.this.onSynced(e);
                                loopLatch.countDown();
                            }
                        });
                    } else {
                        MessageManager.getInstance().getMessageContainer().upsertMessages(list, true, new MessageContainer.UpsertMessageHandler(){

                            @Override
                            public void onResult(List<BaseMessage> insertedMessages, List<BaseMessage> updatedMessages, SendBirdException e) {
                                long startAt = ((BaseMessage)list.get(0)).getCreatedAt();
                                long endAt = ((BaseMessage)list.get(list.size() - 1)).getCreatedAt();
                                MessageChunk newChunk = new MessageChunk(BackgroundSyncThread.this.mChannel.getUrl(), startAt, endAt, BackgroundSyncThread.this.mChunk.getFilter());
                                BackgroundSyncThread.this.mChunk.merge(newChunk);
                                MessageManager.getInstance().getMessageChunkContainer().mergeIntersectedChunks(BackgroundSyncThread.this.mChunk, new CompletionHandler(){

                                    @Override
                                    public void onCompleted(SendBirdException e) {
                                        BackgroundSyncThread.this.onSynced(e);
                                        loopLatch.countDown();
                                    }
                                });
                            }
                        });
                    }
                }
            });
            try {
                loopLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.mFinishedListener != null) {
            this.mFinishedListener.onFinished();
        }
        Logger.d(TAG, "sync finished. channel url = " + this.mChannel.getUrl() + ", isNext = " + this.mIsNext);
    }

    private void onSynced(SendBirdException e) {
        if (this.mEventListener != null) {
            this.mEventListener.onSynced(e);
        }
    }

    private void getMessagesByTimestamp(long ts, BaseChannel.GetMessagesHandler handler) {
        if (this.mIsNext) {
            this.mChannel.getNextMessagesByTimestamp(ts, true, 100, false, this.mChunk.getFilter().getMessageTypeFilter(), this.mChunk.getFilter().getCustomType(), this.mChunk.getFilter().getSenderUserIds(), handler);
        } else {
            this.mChannel.getPreviousMessagesByTimestamp(ts, true, 100, false, this.mChunk.getFilter().getMessageTypeFilter(), this.mChunk.getFilter().getCustomType(), this.mChunk.getFilter().getSenderUserIds(), handler);
        }
    }
}

