/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseMessage;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.DatabaseController;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageFilter;
import com.sendbird.syncmanager.SendBirdSyncManager;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class MessageContainer {
    private static final String TAG = MessageContainer.class.getSimpleName();

    MessageContainer() {
    }

    void setup(CompletionHandler handler) {
        if (handler != null) {
            handler.onCompleted(null);
        }
    }

    void getAllMessagesInChunk(MessageChunk chunk, GetMessagesHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("User ID does not exist."));
            }
            return;
        }
        DatabaseController.getInstance().getMessagesByChunk(userId, chunk, handler);
    }

    void getMessagesInChunk(final MessageChunk chunk, final long ts, final boolean isNext, final int limit, final boolean isInclusive, final GetMessagesHandler handler) {
        Logger.d(TAG, "getMessagesInChunk(). chunkId = " + chunk.getChunkId() + ", ts = " + ts + ", isNext = " + isNext);
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("User ID does not exist."));
            }
            return;
        }
        DatabaseController.getInstance().getMessagesByChunk(userId, chunk, new GetMessagesHandler(){

            @Override
            public void onResult(List<BaseMessage> messages, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(messages, e);
                    }
                    return;
                }
                ArrayList<BaseMessage> result = new ArrayList<BaseMessage>();
                if (isNext) {
                    for (int i = 0; i < messages.size(); ++i) {
                        BaseMessage message = messages.get(i);
                        if (message.getCreatedAt() <= ts && (!isInclusive || message.getCreatedAt() != ts) || !chunk.isMessageInChunk(message)) continue;
                        result.add(message);
                        if (result.size() < limit || message.getCreatedAt() == ts) {
                            continue;
                        }
                        break;
                    }
                } else {
                    for (int i = messages.size() - 1; i >= 0; --i) {
                        BaseMessage message = messages.get(i);
                        if (message.getCreatedAt() >= ts && (!isInclusive || message.getCreatedAt() != ts) || !chunk.isMessageInChunk(message)) continue;
                        result.add(message);
                        if (result.size() >= limit && message.getCreatedAt() != ts) break;
                    }
                    Collections.reverse(result);
                }
                if (handler != null) {
                    handler.onResult(result, null);
                }
            }
        });
    }

    void getMessagesByTimestamp(String channelUrl, final long ts, final MessageFilter filter, final int limit, final boolean isNext, final boolean isInclusive, final GetMessagesHandler handler) {
        Logger.d(TAG, "getMessagesByTimestamp(). ts = " + ts + ", isNext = " + isNext);
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("User ID does not exist."));
            }
            return;
        }
        DatabaseController.getInstance().getMessagesByTimestamp(userId, channelUrl, ts, isNext, new GetMessagesHandler(){

            @Override
            public void onResult(List<BaseMessage> messages, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(messages, e);
                    }
                    return;
                }
                ArrayList<BaseMessage> result = new ArrayList<BaseMessage>();
                if (isNext) {
                    for (int i = 0; i < messages.size(); ++i) {
                        BaseMessage message = messages.get(i);
                        if (message.getCreatedAt() <= ts && (!isInclusive || message.getCreatedAt() != ts) || !filter.isValidMessage(message)) continue;
                        if (result.size() < limit || message.getCreatedAt() == ts) {
                            result.add(message);
                            continue;
                        }
                        break;
                    }
                } else {
                    for (int i = messages.size() - 1; i >= 0; --i) {
                        BaseMessage message = messages.get(i);
                        if (message.getCreatedAt() >= ts && (!isInclusive || message.getCreatedAt() != ts) || !filter.isValidMessage(message)) continue;
                        if (result.size() >= limit && message.getCreatedAt() != ts) break;
                        result.add(message);
                    }
                    Collections.reverse(result);
                }
                if (handler != null) {
                    handler.onResult(result, null);
                }
            }
        });
    }

    void upsertMessages(List<BaseMessage> messages, boolean isVisible, UpsertMessageHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        if (userId == null) {
            if (handler != null) {
                handler.onResult(null, null, new SendBirdException("User ID does not exist."));
            }
            return;
        }
        DatabaseController.getInstance().upsertMessages(userId, messages, isVisible, handler);
    }

    void removeMessages(List<Long> messageIds, CompletionHandler handler) {
        String userId = SendBirdSyncManager.getInstance().getUserId();
        DatabaseController.getInstance().removeMessages(userId, messageIds, handler);
    }

    public static interface UpsertMessageHandler {
        public void onResult(List<BaseMessage> var1, List<BaseMessage> var2, SendBirdException var3);
    }

    static interface GetMessagesHandler {
        public void onResult(List<BaseMessage> var1, SendBirdException var2);
    }
}

