/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.ChannelContainer;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageChunkContainer;
import com.sendbird.syncmanager.MessageContainer;
import com.sendbird.syncmanager.MessageFilter;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.ArrayList;
import java.util.List;

class DatabaseController
extends SQLiteOpenHelper {
    private static final String TAG = DatabaseController.class.getSimpleName();
    private static DatabaseController sInstance;
    private static final String DATABASE_NAME = "sync_manager.db";
    private static final int DATABASE_VERSION = 1;

    private DatabaseController(Context context) {
        super(context, DATABASE_NAME, null, 1);
    }

    static DatabaseController getInstance() {
        if (sInstance == null) {
            throw new RuntimeException("DatabaseController hans't been initialized. Try DatabaseController.init first");
        }
        return sInstance;
    }

    static synchronized void init(Context context) {
        if (sInstance == null) {
            sInstance = new DatabaseController(context);
        }
    }

    static void deinit() {
        sInstance = null;
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS group_channel (channel_url TEXT, user_id TEXT, serialized_data BLOB, PRIMARY KEY (channel_url, user_id))");
        db.execSQL("CREATE TABLE IF NOT EXISTS message (message_id INTEGER, user_id TEXT, created_at INTEGER, channel_url TEXT, serialized_data BLOB, is_deleted INTEGER, is_visible INTEGER,PRIMARY KEY (message_id, user_id))");
        db.execSQL("CREATE TABLE IF NOT EXISTS message_chunk (chunk_id TEXT, user_id TEXT, channel_url TEXT, start_at INTEGER, end_at INTEGER, filter TEXT, start_synced INTEGER DEFAULT 0, end_synced INTEGER DEFAULT 0, PRIMARY KEY (chunk_id, user_id))");
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    void getAllChannels(final String userId, final ChannelContainer.GetChannelsHandler handler) {
        Logger.d(TAG, "getAllChannels. userId = " + userId);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Cursor cursor = DatabaseController.this.getAllChannelsFromDb(userId);
                if (cursor == null || cursor.getCount() == 0) {
                    if (handler != null) {
                        handler.onResult(new ArrayList<GroupChannel>(), null);
                    }
                    if (cursor != null) {
                        cursor.close();
                    }
                    return;
                }
                try {
                    ArrayList<GroupChannel> channels = new ArrayList<GroupChannel>();
                    while (cursor.moveToNext()) {
                        BaseChannel baseChannel;
                        byte[] serializedData = cursor.getBlob(cursor.getColumnIndex("serialized_data"));
                        if (serializedData == null || !((baseChannel = BaseChannel.buildFromSerializedData((byte[])serializedData)) instanceof GroupChannel)) continue;
                        channels.add((GroupChannel)baseChannel);
                    }
                    if (handler != null) {
                        handler.onResult(channels, null);
                    }
                }
                catch (Exception e) {
                    if (handler != null) {
                        handler.onResult(null, new SendBirdException(e.getMessage()));
                    }
                }
                finally {
                    cursor.close();
                }
            }
        }).start();
    }

    void getChannel(final String userId, final String channelUrl, final ChannelContainer.GetChannelHandler handler) {
        Logger.d(TAG, "getChannel. userId = " + userId + " , channelUrl = " + channelUrl);
        new Thread(new Runnable(){

            @Override
            public void run() {
                Cursor cursor = DatabaseController.this.getChannelFromDb(userId, channelUrl);
                if (cursor == null || cursor.getCount() == 0) {
                    if (handler != null) {
                        handler.onResult(null, null);
                    }
                    if (cursor != null) {
                        cursor.close();
                    }
                    return;
                }
                try {
                    cursor.moveToNext();
                    byte[] serializedData = cursor.getBlob(cursor.getColumnIndex("serialized_data"));
                    if (handler != null) {
                        handler.onResult((GroupChannel)BaseChannel.buildFromSerializedData((byte[])serializedData), null);
                    }
                }
                catch (Exception e) {
                    if (handler != null) {
                        handler.onResult(null, new SendBirdException(e.getMessage()));
                    }
                }
                finally {
                    cursor.close();
                }
            }
        }).start();
    }

    void upsertChannels(final String userId, final List<GroupChannel> channels, final ChannelContainer.UpdateChannelHandler handler) {
        Logger.d(TAG, "upsertChannels. userId = " + userId + " , channel list size = " + channels.size());
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayList<GroupChannel> updatedChannels = new ArrayList<GroupChannel>();
                for (GroupChannel channel : channels) {
                    long rowId = DatabaseController.this.insertChannelToDb(userId, channel);
                    if (rowId == -1L) {
                        int nAffectedRow = DatabaseController.this.updateChannelToDb(userId, channel);
                        if (nAffectedRow <= 0) continue;
                        updatedChannels.add(channel);
                        continue;
                    }
                    updatedChannels.add(channel);
                }
                if (handler != null) {
                    handler.onResult(updatedChannels, null);
                }
            }
        }).start();
    }

    void deleteChannel(final String userId, final String channelUrl, final CompletionHandler handler) {
        Logger.d(TAG, "deleteChannel. userId = " + userId + " , channel url = " + channelUrl);
        new Thread(new Runnable(){

            @Override
            public void run() {
                int nAffectedRow = DatabaseController.this.deleteChannelFromDb(userId, channelUrl);
                if (handler != null) {
                    if (nAffectedRow > 0) {
                        handler.onCompleted(null);
                    } else {
                        handler.onCompleted(new SendBirdException("Failed to delete item. channelUrl = " + channelUrl));
                    }
                }
            }
        }).start();
    }

    void deleteChannels(final String userId, final List<String> channelUrls, final CompletionHandler handler) {
        Logger.d(TAG, "deleteChannels. userId = " + userId + " , channel url list size = " + channelUrls.size());
        new Thread(new Runnable(){

            @Override
            public void run() {
                int totalNumberOfAffectedRow = 0;
                for (String channelUrl : channelUrls) {
                    totalNumberOfAffectedRow += DatabaseController.this.deleteChannelFromDb(userId, channelUrl);
                }
                if (handler != null) {
                    if (totalNumberOfAffectedRow != channelUrls.size()) {
                        handler.onCompleted(new SendBirdException("Failed to delete some items. updated = " + totalNumberOfAffectedRow + ", requested = " + channelUrls.size()));
                    } else {
                        handler.onCompleted(null);
                    }
                }
            }
        }).start();
    }

    private synchronized Cursor getAllChannelsFromDb(String userId) {
        SQLiteDatabase db = this.getReadableDatabase();
        String selection = "user_id = ?";
        String[] selectionArgs = new String[]{userId};
        return db.query("group_channel", null, selection, selectionArgs, null, null, null);
    }

    private synchronized Cursor getChannelFromDb(String userId, String channelUrl) {
        SQLiteDatabase db = this.getReadableDatabase();
        String selection = "channel_url = ? AND user_id = ?";
        String[] selectionArgs = new String[]{channelUrl, userId};
        return db.query("group_channel", null, selection, selectionArgs, null, null, null, "1");
    }

    private synchronized long insertChannelToDb(String userId, GroupChannel channel) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("user_id", userId);
        values.put("channel_url", channel.getUrl());
        values.put("serialized_data", channel.serialize());
        try {
            return db.insertOrThrow("group_channel", null, values);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private synchronized int updateChannelToDb(String userId, GroupChannel channel) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("serialized_data", channel.serialize());
        String selection = "channel_url = ? AND user_id = ?";
        String[] selectionArgs = new String[]{channel.getUrl(), userId};
        return db.update("group_channel", values, selection, selectionArgs);
    }

    private synchronized int deleteChannelFromDb(String userId, String channelUrl) {
        SQLiteDatabase db = this.getWritableDatabase();
        String selection = "channel_url = ? AND user_id = ?";
        String[] selectionArgs = new String[]{channelUrl, userId};
        return db.delete("group_channel", selection, selectionArgs);
    }

    void getMessagesByChunk(final String userId, final MessageChunk chunk, final MessageContainer.GetMessagesHandler handler) {
        Logger.d(TAG, "getMessagesByChunk. userId = " + userId + " , channelUrl = " + chunk.getChannelUrl());
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Cursor cursor = DatabaseController.this.getMessagesBetweenTimestampFromDb(userId, chunk.getChannelUrl(), chunk.getStartAt(), chunk.getEndAt());
                if (cursor == null || cursor.getCount() == 0) {
                    if (handler != null) {
                        handler.onResult(new ArrayList<BaseMessage>(), null);
                    }
                    if (cursor != null) {
                        cursor.close();
                    }
                    return;
                }
                try {
                    ArrayList<BaseMessage> messages = new ArrayList<BaseMessage>();
                    while (cursor.moveToNext()) {
                        byte[] serializedData = cursor.getBlob(cursor.getColumnIndex("serialized_data"));
                        if (serializedData == null) continue;
                        messages.add(BaseMessage.buildFromSerializedData((byte[])serializedData));
                    }
                    if (handler != null) {
                        handler.onResult(messages, null);
                    }
                }
                catch (Exception e) {
                    if (handler != null) {
                        handler.onResult(null, new SendBirdException(e.getMessage()));
                    }
                }
                finally {
                    cursor.close();
                }
            }
        }).start();
    }

    void getMessagesByTimestamp(final String userId, final String channelUrl, final long ts, final boolean isNext, final MessageContainer.GetMessagesHandler handler) {
        Logger.d(TAG, "getMessagesByTimestamp. userId = " + userId + " , channelUrl = " + channelUrl);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Cursor cursor = DatabaseController.this.getMessagesByTimestampFromDb(userId, channelUrl, ts, isNext);
                if (cursor == null || cursor.getCount() == 0) {
                    if (handler != null) {
                        handler.onResult(new ArrayList<BaseMessage>(), null);
                    }
                    if (cursor != null) {
                        cursor.close();
                    }
                    return;
                }
                try {
                    ArrayList<BaseMessage> messages = new ArrayList<BaseMessage>();
                    while (cursor.moveToNext()) {
                        byte[] serializedData = cursor.getBlob(cursor.getColumnIndex("serialized_data"));
                        if (serializedData == null) continue;
                        messages.add(BaseMessage.buildFromSerializedData((byte[])serializedData));
                    }
                    if (handler != null) {
                        handler.onResult(messages, null);
                    }
                }
                catch (Exception e) {
                    if (handler != null) {
                        handler.onResult(null, new SendBirdException(e.getMessage()));
                    }
                }
                finally {
                    cursor.close();
                }
            }
        }).start();
    }

    void upsertMessages(final String userId, final List<BaseMessage> messages, final boolean isVisible, final MessageContainer.UpsertMessageHandler handler) {
        Logger.d(TAG, "upsertMessages. userId = " + userId + " , message list size = " + messages.size() + " , isVisible = " + isVisible);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayList<BaseMessage> insertedMessages = new ArrayList<BaseMessage>();
                ArrayList<BaseMessage> updatedMessages = new ArrayList<BaseMessage>();
                for (BaseMessage message : messages) {
                    if (message.getMessageId() == 0L) continue;
                    long rowId = DatabaseController.this.insertMessageToDb(userId, message, isVisible);
                    if (rowId == -1L) {
                        int nAffectedRow = DatabaseController.this.updateMessageToDb(userId, message, isVisible);
                        if (nAffectedRow <= 0) continue;
                        updatedMessages.add(message);
                        continue;
                    }
                    insertedMessages.add(message);
                }
                if (handler != null) {
                    handler.onResult(insertedMessages, updatedMessages, null);
                }
            }
        }).start();
    }

    void removeMessages(final String userId, final List<Long> messageIds, final CompletionHandler handler) {
        Logger.d(TAG, "removeMessages. userId = " + userId + " , message list size = " + messageIds.size());
        new Thread(new Runnable(){

            @Override
            public void run() {
                int resultCount = 0;
                for (Long messageId : messageIds) {
                    resultCount += DatabaseController.this.removeMessageFromDb(userId, messageId);
                }
                if (handler != null) {
                    handler.onCompleted(null);
                }
            }
        }).start();
    }

    private synchronized Cursor getMessagesBetweenTimestampFromDb(String userId, String channelUrl, long startAt, long endAt) {
        SQLiteDatabase db = this.getReadableDatabase();
        String selection = "channel_url = ? AND user_id = ? AND created_at >= ? AND created_at <= ? AND is_deleted = 0 AND is_visible = 1";
        String[] selectionArgs = new String[]{channelUrl, userId, String.valueOf(startAt), String.valueOf(endAt)};
        return db.query("message", null, selection, selectionArgs, null, null, "created_at ASC");
    }

    private synchronized Cursor getMessagesByTimestampFromDb(String userId, String channelUrl, long ts, boolean isNext) {
        SQLiteDatabase db = this.getReadableDatabase();
        String selection = "channel_url = ? AND user_id = ? AND is_deleted = 0 AND is_visible = 1 AND " + (isNext ? "created_at >= ?" : "created_at <= ?");
        String[] selectionArgs = new String[]{channelUrl, userId, String.valueOf(ts)};
        return db.query("message", null, selection, selectionArgs, null, null, "created_at ASC");
    }

    private synchronized long insertMessageToDb(String userId, BaseMessage message, boolean isVisible) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("channel_url", message.getChannelUrl());
        values.put("user_id", userId);
        values.put("message_id", Long.valueOf(message.getMessageId()));
        values.put("created_at", Long.valueOf(message.getCreatedAt()));
        values.put("serialized_data", message.serialize());
        values.put("is_deleted", Integer.valueOf(0));
        values.put("is_visible", Integer.valueOf(isVisible ? 1 : 0));
        try {
            return db.insertOrThrow("message", null, values);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private synchronized int updateMessageToDb(String userId, BaseMessage message, boolean isVisible) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("channel_url", message.getChannelUrl());
        values.put("message_id", Long.valueOf(message.getMessageId()));
        values.put("created_at", Long.valueOf(message.getCreatedAt()));
        values.put("serialized_data", message.serialize());
        if (isVisible) {
            values.put("is_visible", Integer.valueOf(1));
        }
        String selection = "message_id = ? AND user_id = ?";
        String[] selectionArgs = new String[]{String.valueOf(message.getMessageId()), userId};
        return db.update("message", values, selection, selectionArgs);
    }

    private synchronized int removeMessageFromDb(String userId, Long messageId) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("is_deleted", Integer.valueOf(1));
        String selection = "message_id = ? AND user_id = ?";
        String[] selectionArgs = new String[]{String.valueOf(messageId), userId};
        return db.update("message", values, selection, selectionArgs);
    }

    void getAllMessageChunks(final String userId, final MessageChunkContainer.GetMessageChunksHandler handler) {
        Logger.d(TAG, "getAllMessageChunks. userId = " + userId);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Cursor cursor = DatabaseController.this.getAllMessageChunksFromDb(userId);
                if (cursor == null || cursor.getCount() == 0) {
                    if (handler != null) {
                        handler.onResult(new ArrayList<MessageChunk>(), null);
                    }
                    if (cursor != null) {
                        cursor.close();
                    }
                    return;
                }
                try {
                    ArrayList<MessageChunk> messageChunks = new ArrayList<MessageChunk>();
                    while (cursor.moveToNext()) {
                        String chunkId = cursor.getString(cursor.getColumnIndex("chunk_id"));
                        String channelUrl = cursor.getString(cursor.getColumnIndex("channel_url"));
                        long startAt = cursor.getLong(cursor.getColumnIndex("start_at"));
                        long endAt = cursor.getLong(cursor.getColumnIndex("end_at"));
                        String filter = cursor.getString(cursor.getColumnIndex("filter"));
                        boolean isStartSynced = cursor.getInt(cursor.getColumnIndex("start_synced")) == 1;
                        boolean isEndSynced = cursor.getInt(cursor.getColumnIndex("end_synced")) == 1;
                        messageChunks.add(new MessageChunk(chunkId, channelUrl, startAt, endAt, new MessageFilter(filter), isStartSynced, isEndSynced));
                    }
                    if (handler != null) {
                        handler.onResult(messageChunks, null);
                    }
                }
                catch (Exception e) {
                    if (handler != null) {
                        handler.onResult(null, new SendBirdException(e.getMessage()));
                    }
                }
                finally {
                    cursor.close();
                }
            }
        }).start();
    }

    void upsertChunk(final String userId, final MessageChunk chunk, final CompletionHandler handler) {
        Logger.d(TAG, "upsertChunk. userId = " + userId + " , channelUrl = " + chunk.getChannelUrl());
        new Thread(new Runnable(){

            @Override
            public void run() {
                long rowId = DatabaseController.this.insertChunkToDb(userId, chunk);
                if (rowId == -1L) {
                    int nAffectedRow = DatabaseController.this.updateChunkToDb(userId, chunk);
                    if (nAffectedRow > 0) {
                        if (handler != null) {
                            handler.onCompleted(null);
                        }
                    } else if (handler != null) {
                        handler.onCompleted(new SendBirdException("Chunk not exists. chunk id = " + chunk.getChunkId()));
                    }
                } else if (handler != null) {
                    handler.onCompleted(null);
                }
            }
        }).start();
    }

    void deleteChunk(final String userId, final MessageChunk chunk, final CompletionHandler handler) {
        Logger.d(TAG, "deleteChunk. userId = " + userId + " , channelUrl = " + chunk.getChannelUrl());
        new Thread(new Runnable(){

            @Override
            public void run() {
                int nAffectedRow = DatabaseController.this.deleteChunkFromDb(userId, chunk);
                if (handler != null) {
                    if (nAffectedRow > 0) {
                        handler.onCompleted(null);
                    } else {
                        handler.onCompleted(new SendBirdException("Failed to delete item. chunkId = " + chunk.getChunkId()));
                    }
                }
            }
        }).start();
    }

    void deleteChunks(final String userId, final List<MessageChunk> chunks, final CompletionHandler handler) {
        Logger.d(TAG, "deleteChunks. userId = " + userId + " , chunk list size = " + chunks.size());
        new Thread(new Runnable(){

            @Override
            public void run() {
                int nAffectedRow = 0;
                for (MessageChunk chunk : chunks) {
                    nAffectedRow += DatabaseController.this.deleteChunkFromDb(userId, chunk);
                }
                if (handler != null) {
                    handler.onCompleted(null);
                }
            }
        }).start();
    }

    private synchronized Cursor getAllMessageChunksFromDb(String userId) {
        SQLiteDatabase db = this.getReadableDatabase();
        String selection = "user_id = ?";
        String[] selectionArgs = new String[]{userId};
        return db.query("message_chunk", null, selection, selectionArgs, null, null, null);
    }

    private synchronized long insertChunkToDb(String userId, MessageChunk chunk) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("user_id", userId);
        values.put("chunk_id", chunk.getChunkId());
        values.put("channel_url", chunk.getChannelUrl());
        values.put("start_at", Long.valueOf(chunk.getStartAt()));
        values.put("end_at", Long.valueOf(chunk.getEndAt()));
        values.put("filter", chunk.getFilter().toJson());
        values.put("start_synced", Integer.valueOf(chunk.isStartSynced() ? 1 : 0));
        values.put("end_synced", Integer.valueOf(chunk.isEndSynced() ? 1 : 0));
        try {
            return db.insertOrThrow("message_chunk", null, values);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private synchronized int updateChunkToDb(String userId, MessageChunk chunk) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("user_id", userId);
        values.put("chunk_id", chunk.getChunkId());
        values.put("channel_url", chunk.getChannelUrl());
        values.put("start_at", Long.valueOf(chunk.getStartAt()));
        values.put("end_at", Long.valueOf(chunk.getEndAt()));
        values.put("filter", chunk.getFilter().toJson());
        values.put("start_synced", Integer.valueOf(chunk.isStartSynced() ? 1 : 0));
        values.put("end_synced", Integer.valueOf(chunk.isEndSynced() ? 1 : 0));
        String selection = "chunk_id = ? AND user_id = ?";
        String[] selectionArgs = new String[]{chunk.getChunkId(), userId};
        return db.update("message_chunk", values, selection, selectionArgs);
    }

    private synchronized int deleteChunkFromDb(String userId, MessageChunk chunk) {
        SQLiteDatabase db = this.getWritableDatabase();
        String selection = "chunk_id = ? AND user_id = ?";
        String[] selectionArgs = new String[]{chunk.getChunkId(), userId};
        return db.delete("message_chunk", selection, selectionArgs);
    }

    synchronized void clearCache() {
        SQLiteDatabase db = this.getWritableDatabase();
        db.delete("group_channel", null, null);
        db.delete("message", null, null);
        db.delete("message_chunk", null, null);
    }

    synchronized void clearCache(String userId) {
        SQLiteDatabase db = this.getWritableDatabase();
        String[] selectionArgs = new String[]{userId};
        String groupChannelTableSelection = "user_id = ?";
        String messageTableSelection = "user_id = ?";
        String chunkTableChannelSelection = "user_id = ?";
        db.delete("group_channel", groupChannelTableSelection, selectionArgs);
        db.delete("message", messageTableSelection, selectionArgs);
        db.delete("message_chunk", chunkTableChannelSelection, selectionArgs);
    }
}

