/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelListQuery;
import com.sendbird.android.Member;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.ChannelContainer;
import com.sendbird.syncmanager.ChannelEventAction;
import com.sendbird.syncmanager.ChannelManager;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.handler.ChannelCollectionHandler;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ChannelCollection {
    private static final String TAG = ChannelCollection.class.getSimpleName();
    private GroupChannelListQuery mQuery;
    private ChannelCollectionHandler mCollectionHandler;
    private List<GroupChannel> mChannels = new ArrayList<GroupChannel>();
    private boolean mIsLoading = false;
    private boolean mIsSynced = false;
    private Comparator<GroupChannel> mChannelComparator = new Comparator<GroupChannel>(){

        @Override
        public int compare(GroupChannel c1, GroupChannel c2) {
            if (ChannelCollection.this.mQuery != null) {
                switch (ChannelCollection.this.mQuery.getOrder()) {
                    case CHRONOLOGICAL: {
                        if (c1.getCreatedAt() > c2.getCreatedAt()) {
                            return -1;
                        }
                        if (c1.getCreatedAt() < c2.getCreatedAt()) {
                            return 1;
                        }
                        return 0;
                    }
                    case LATEST_LAST_MESSAGE: {
                        long createdAt2;
                        if (!(c1 instanceof GroupChannel) || !(c2 instanceof GroupChannel)) {
                            return 0;
                        }
                        BaseMessage m1 = c1.getLastMessage();
                        BaseMessage m2 = c2.getLastMessage();
                        long createdAt1 = m1 != null ? m1.getCreatedAt() : c1.getCreatedAt();
                        long l = createdAt2 = m2 != null ? m2.getCreatedAt() : c2.getCreatedAt();
                        if (createdAt1 > createdAt2) {
                            return -1;
                        }
                        if (createdAt1 < createdAt2) {
                            return 1;
                        }
                        return 0;
                    }
                    case CHANNEL_NAME_ALPHABETICAL: {
                        return c1.getName().compareTo(c2.getName());
                    }
                }
                return 0;
            }
            return 0;
        }
    };

    public ChannelCollection(GroupChannelListQuery query) {
        this.mQuery = query;
        ChannelManager.getInstance().addChannelCollection(this);
    }

    public void setCollectionHandler(ChannelCollectionHandler handler) {
        this.mCollectionHandler = handler;
    }

    public GroupChannelListQuery getQuery() {
        return this.mQuery;
    }

    public void remove() {
        Logger.d(TAG, "remove()");
        ChannelManager.getInstance().removeChannelCollection(this);
    }

    public synchronized void fetch(final CompletionHandler handler) {
        Logger.d(TAG, "fetch()");
        if (this.mIsLoading) {
            Logger.d(TAG, "Loading is already in progress. Finish fetch");
            if (handler != null) {
                handler.onCompleted(new SendBirdException("Fetch is in progress."));
            }
            return;
        }
        this.mIsLoading = true;
        if (this.mChannels.size() == 0 || !this.mIsSynced) {
            List<GroupChannel> channels = ChannelManager.getInstance().getContainer().getChannels();
            List<GroupChannel> filteredChannels = this.filterChannels(channels);
            for (GroupChannel channel : this.mChannels) {
                Iterator<GroupChannel> iterator = filteredChannels.iterator();
                while (iterator.hasNext()) {
                    GroupChannel groupChannel = iterator.next();
                    if (!channel.getUrl().equals(groupChannel.getUrl())) continue;
                    iterator.remove();
                }
            }
            Collections.sort(filteredChannels, this.mChannelComparator);
            int startIndex = 0;
            int endIndex = Math.min(this.mQuery.getLimit(), filteredChannels.size());
            List<GroupChannel> newChannels = filteredChannels.subList(startIndex, endIndex);
            this.mChannels.addAll(newChannels);
            this.onChannelEvent(newChannels, ChannelEventAction.INSERT);
        }
        if (this.mQuery != null) {
            if (!this.mQuery.hasNext()) {
                this.mIsLoading = false;
                if (handler != null) {
                    handler.onCompleted(null);
                }
            } else {
                this.mQuery.next(new GroupChannelListQuery.GroupChannelListQueryResultHandler(){

                    public void onResult(List<GroupChannel> queryResult, SendBirdException e) {
                        if (e != null || queryResult.size() == 0) {
                            ChannelCollection.this.mIsLoading = false;
                            if (handler != null) {
                                handler.onCompleted(e);
                            }
                            return;
                        }
                        final ArrayList<String> removedChannelUrls = new ArrayList<String>();
                        if (!ChannelCollection.this.mIsSynced) {
                            for (GroupChannel prevChannel : ChannelCollection.this.mChannels) {
                                boolean isExists = false;
                                for (GroupChannel newChannel : queryResult) {
                                    if (!newChannel.getUrl().equals(prevChannel.getUrl())) continue;
                                    isExists = true;
                                    break;
                                }
                                if (isExists) continue;
                                removedChannelUrls.add(prevChannel.getUrl());
                            }
                            ChannelCollection.this.mIsSynced = true;
                        }
                        final ArrayList<GroupChannel> newChannels = new ArrayList<GroupChannel>(queryResult);
                        ChannelManager.getInstance().getContainer().upsertChannels(newChannels, new ChannelContainer.UpdateChannelHandler(){

                            @Override
                            public void onResult(List<GroupChannel> updatedChannels, SendBirdException e) {
                                if (e != null) {
                                    ChannelCollection.this.mIsLoading = false;
                                    if (handler != null) {
                                        handler.onCompleted(e);
                                    }
                                    return;
                                }
                                ChannelManager.getInstance().getContainer().removeChannelUrls(removedChannelUrls, new CompletionHandler(){

                                    @Override
                                    public void onCompleted(SendBirdException e) {
                                        ChannelCollection.this.mIsLoading = false;
                                        ChannelCollection.this.upsertChannels(newChannels);
                                        ChannelCollection.this.removeChannelUrls(removedChannelUrls);
                                        if (handler != null) {
                                            handler.onCompleted(e);
                                        }
                                    }
                                });
                            }
                        });
                    }
                });
            }
        }
    }

    void pause() {
        this.mIsSynced = false;
    }

    void resume() {
        if (this.mIsSynced) {
            this.pause();
        }
        this.fetch(null);
    }

    synchronized void upsertChannels(List<GroupChannel> channels) {
        Logger.d(TAG, "upsertChannel. size = " + channels.size());
        List<GroupChannel> filteredChannels = this.filterChannels(channels);
        if (filteredChannels.size() == 0) {
            return;
        }
        ArrayList<GroupChannel> insertedChannels = new ArrayList<GroupChannel>();
        ArrayList<GroupChannel> existingChannels = new ArrayList<GroupChannel>();
        ArrayList<GroupChannel> changedChannels = new ArrayList<GroupChannel>();
        for (GroupChannel groupChannel : filteredChannels) {
            boolean isInsertedChannel = true;
            for (GroupChannel existingChannel : this.mChannels) {
                if (!groupChannel.getUrl().equals(existingChannel.getUrl())) continue;
                existingChannels.add(existingChannel);
                changedChannels.add(groupChannel);
                isInsertedChannel = false;
                break;
            }
            if (!isInsertedChannel) continue;
            insertedChannels.add(groupChannel);
        }
        if (existingChannels.size() > 0) {
            HashMap<String, Integer> prevIndexes = new HashMap<String, Integer>();
            for (GroupChannel channel : existingChannels) {
                int index = this.getIndexOfChannel(channel);
                if (index == -1) continue;
                prevIndexes.put(channel.getUrl(), index);
            }
            this.mChannels.removeAll(existingChannels);
            this.mChannels.addAll(changedChannels);
            Collections.sort(this.mChannels, this.mChannelComparator);
            ArrayList<GroupChannel> arrayList = new ArrayList<GroupChannel>();
            ArrayList<GroupChannel> updatedChannels = new ArrayList<GroupChannel>();
            for (GroupChannel channel : existingChannels) {
                int currentIndex;
                if (!prevIndexes.containsKey(channel.getUrl()) || prevIndexes.get(channel.getUrl()) == null) {
                    insertedChannels.add(channel);
                    continue;
                }
                int prevIndex = (Integer)prevIndexes.get(channel.getUrl());
                if (prevIndex != (currentIndex = this.getIndexOfChannel(channel))) {
                    arrayList.add(channel);
                    continue;
                }
                updatedChannels.add(channel);
            }
            if (updatedChannels.size() > 0) {
                this.onChannelEvent(updatedChannels, ChannelEventAction.UPDATE);
            }
            if (arrayList.size() > 0) {
                this.onChannelEvent(arrayList, ChannelEventAction.MOVE);
            }
        }
        this.mChannels.addAll(insertedChannels);
        Collections.sort(this.mChannels, this.mChannelComparator);
        this.onChannelEvent(insertedChannels, ChannelEventAction.INSERT);
    }

    synchronized void removeChannelUrls(List<String> channelUrls) {
        Logger.d(TAG, "removechannelUrls. size = " + channelUrls.size());
        ArrayList<GroupChannel> deletedChannels = new ArrayList<GroupChannel>();
        Iterator<GroupChannel> it = this.mChannels.iterator();
        block0: while (it.hasNext()) {
            GroupChannel channel = it.next();
            for (String channelUrl : channelUrls) {
                if (!channel.getUrl().equals(channelUrl)) continue;
                deletedChannels.add(channel);
                it.remove();
                continue block0;
            }
        }
        this.onChannelEvent(deletedChannels, ChannelEventAction.REMOVE);
    }

    private int getIndexOfChannel(GroupChannel channel) {
        if (this.mChannels == null || this.mChannels.size() == 0) {
            return -1;
        }
        for (int i = 0; i < this.mChannels.size(); ++i) {
            if (!this.mChannels.get(i).getUrl().equals(channel.getUrl())) continue;
            return i;
        }
        return -1;
    }

    private void onChannelEvent(List<GroupChannel> list, ChannelEventAction action) {
        if (list == null || list.size() == 0) {
            return;
        }
        if (this.mCollectionHandler != null) {
            this.mCollectionHandler.onChannelEvent(this, list, action);
        }
    }

    private List<GroupChannel> filterChannels(List<GroupChannel> channels) {
        ArrayList<GroupChannel> filteredChannels = new ArrayList<GroupChannel>();
        for (GroupChannel groupChannel : channels) {
            String nicknameContainsFilter;
            List userIdsIncludeFilter;
            List userIdsExactFilters;
            String customTypeStartsWith;
            if (!this.mQuery.isIncludeEmpty() && groupChannel.getLastMessage() == null || this.mQuery.getSuperChannelFilter() == GroupChannelListQuery.SuperChannelFilter.SUPER_CHANNEL_ONLY && !groupChannel.isSuper() || this.mQuery.getSuperChannelFilter() == GroupChannelListQuery.SuperChannelFilter.NONSUPER_CHANNEL_ONLY && groupChannel.isSuper() || this.mQuery.getPublicChannelFilter() == GroupChannelListQuery.PublicChannelFilter.PUBLIC && !groupChannel.isPublic() || this.mQuery.getPublicChannelFilter() == GroupChannelListQuery.PublicChannelFilter.PRIVATE && groupChannel.isPublic()) continue;
            List channelUrlsFilter = this.mQuery.getChannelUrlsFilter();
            if (channelUrlsFilter != null) {
                boolean isExists = false;
                for (String url : channelUrlsFilter) {
                    if (!groupChannel.getUrl().contains(url)) continue;
                    isExists = true;
                    break;
                }
                if (!isExists) continue;
            }
            if ((customTypeStartsWith = this.mQuery.getCustomTypeStartsWithFilter()) != null && !groupChannel.getCustomType().startsWith(customTypeStartsWith)) continue;
            List customTypes = this.mQuery.getCustomTypesFilter();
            if (customTypes != null) {
                boolean isExists = false;
                for (Object customType : customTypes) {
                    if (!groupChannel.getCustomType().equals(customType)) continue;
                    isExists = true;
                    break;
                }
                if (!isExists) continue;
            }
            if ((userIdsExactFilters = this.mQuery.getUserIdsExactFilter()) != null) {
                Object customType;
                if (groupChannel.getMembers().size() != userIdsExactFilters.size()) continue;
                boolean isMembersExactlyIn = true;
                customType = groupChannel.getMembers().iterator();
                while (customType.hasNext()) {
                    Member member = (Member)customType.next();
                    boolean isExists = false;
                    for (String userId : userIdsExactFilters) {
                        if (!userId.equals(member.getUserId())) continue;
                        isExists = true;
                        break;
                    }
                    if (isExists) continue;
                    isMembersExactlyIn = false;
                    break;
                }
                if (!isMembersExactlyIn) continue;
            }
            if ((userIdsIncludeFilter = this.mQuery.getUserIdsIncludeFilter()) != null) {
                boolean isMembersInclude = true;
                for (String userIdFilter : userIdsIncludeFilter) {
                    boolean isUserIdExists = false;
                    for (Member member : groupChannel.getMembers()) {
                        if (!member.getUserId().equals(userIdFilter)) continue;
                        isUserIdExists = true;
                        break;
                    }
                    if (isUserIdExists) continue;
                    isMembersInclude = false;
                    break;
                }
                if (!isMembersInclude) continue;
            }
            if ((nicknameContainsFilter = this.mQuery.getNicknameContainsFilter()) != null) {
                boolean isExists = false;
                for (Member member : groupChannel.getMembers()) {
                    if (!member.getNickname().contains(nicknameContainsFilter)) continue;
                    isExists = true;
                    break;
                }
                if (!isExists) continue;
            }
            if (this.mQuery.getChannelNameContainsFilter() != null && !groupChannel.getName().contains(this.mQuery.getChannelNameContainsFilter()) || this.mQuery.getMemberStateFilter() != GroupChannelListQuery.MemberStateFilter.ALL && (this.mQuery.getMemberStateFilter() == GroupChannelListQuery.MemberStateFilter.JOINED && !groupChannel.getMyMemberState().equals((Object)Member.MemberState.JOINED) || groupChannel.getMyMemberState() != Member.MemberState.INVITED)) continue;
            filteredChannels.add(groupChannel);
        }
        return filteredChannels;
    }
}

